package graphics;

import javax.media.opengl.GL2;

/**
 * This class represents a simple material, as loaded from a wavefront mtllib.
 * I won't rule out the possibility that I have to learn to write GLSL shaders at a later time.
 */
public class Material
	{
	public String mtllib;
	public String name;
	public int index;//1-indexed!
	public float[] ambientColor;
	public float[] diffuseColor;
	public float[] specularColor;
	public float[] emitColor;
	public int specularWeight;
	public float alpha;//Not used directly
	/**If true, diffuse color defaults to white. The texture determines the color.*/
	public boolean textureOverride = true;
	/*
	 * Illumination mode, not used.
	0. Color on and Ambient off
	1. Color on and Ambient on
	2. Highlight on
	3. Reflection on and Ray trace on
	4. Transparency: Glass on, Reflection: Ray trace on
	5. Reflection: Fresnel on and Ray trace on
	6. Transparency: Refraction on, Reflection: Fresnel off and Ray trace on
	7. Transparency: Refraction on, Reflection: Fresnel on and Ray trace on
	8. Reflection on and Ray trace off
	9. Transparency: Glass on, Reflection: Ray trace off
	10. Casts shadows onto invisible surfaces
	*/
	Tex diffuseTex;//Only use diffuse texture for now.
	
	public Material(String mtllib, String name, int index)
		{
		this.mtllib = mtllib;
		this.name= name;
		this.index= index;
		this.ambientColor = GFX.WHITE;
		this.diffuseColor = GFX.WHITE;
		this.specularColor= GFX.BLACK;
		this.emitColor    = GFX.BLACK;
		this.specularWeight = 32;//openGL takes the range 0-128.
		this.diffuseTex = null;
		this.alpha=1;
		}
	
	public Material(String mtllib, String name, int index, float[] ambientColor, float[] diffuseColor, float[] specularColor, float specularWeight, float alpha, String diffuseTextureName)
		{
		this.mtllib = mtllib;
		this.name=name;
		this.index=index;
		this.ambientColor = GFX.alpha(ambientColor, 1);
		this.diffuseColor = GFX.alpha(diffuseColor, alpha);
		this.specularColor= GFX.alpha(specularColor,1);
		this.emitColor    = GFX.alpha(emitColor,    1);
		this.specularWeight = (int)(specularWeight*128/1000);//openGL takes the range 0-128.
		this.diffuseTex = GFX.tex(diffuseTextureName);
		this.alpha=alpha;
		}

	public void setAlpha(float alpha)
		{
		diffuseColor = GFX.alpha(diffuseColor,alpha);
		this.alpha=alpha;
		}
	/**Enable the material with the given subimage for the texture, if any. Remember to disable.*/
	public void enable(int texSubImage)
		{
		GL2 gl = GFX.gl;
		
		//gl.glEnable(GL2.GL_LIGHTING);
		if (!textureOverride || diffuseTex==null)
			{
		    //gl.glColorMaterial(GL.GL_FRONT_AND_BACK, GL2.GL_DIFFUSE );
		    gl.glColor4fv(diffuseColor,0);
		    //gl.glMaterialfv(GL.GL_FRONT_AND_BACK, GL2.GL_AMBIENT, ambientColor,0);
			}
		else
			{
			gl.glColor4fv(GFX.WHITE,0);
			}
        //gl.glMaterialfv(GL.GL_FRONT_AND_BACK, GL2.GL_EMISSION, emitColor,0);
        //gl.glMaterialfv(GL.GL_FRONT_AND_BACK, GL2.GL_SPECULAR, specularColor,0);
        //gl.glMateriali(GL.GL_FRONT_AND_BACK,GL2.GL_SHININESS,specularWeight);
		
        if(diffuseTex!=null)
        	{
        	diffuseTex.enable(texSubImage);
        	}
		}
	public void disable()
		{
		GL2 gl = GFX.gl;
		//This is important:
		if(diffuseTex!=null)
			diffuseTex.disable();
		//Reset this because it's likely that you'll want it back the way it was
		//gl.glColorMaterial(GL.GL_FRONT_AND_BACK, GL2.GL_AMBIENT_AND_DIFFUSE );
		//gl.glMaterialfv(GL.GL_FRONT_AND_BACK, GL2.GL_EMISSION, GFX.emitColor,0);
        //gl.glMaterialfv(GL.GL_FRONT_AND_BACK, GL2.GL_SPECULAR, GFX.specularColor,0);
        //gl.glMateriali(GL.GL_FRONT_AND_BACK,GL2.GL_SHININESS,GFX.specularWeight);
        gl.glColor4fv(GFX.WHITE,0);
		}
	}
