package graphics;

import javax.media.opengl.GL;

import calc.V3D;


/**
 * A high performance renderable. Can either be a Vertex Buffer Object or a Vertex Array.
 * */
public interface HPR
	{

	/**Add a vertex
	 * The vertex should contain the data that was specified when constructing the empty VBO.
	 * Note: It is safe to specify a 4-component color even if alpha is not used, and vica versa.*/
	public abstract void addVertex(Vertex v);

	/**Makes a triangle from the last three vertices.*/
	public abstract void triangle(boolean reverse);

	/**Add 3 indices. Use to make faces from vertices.*/
	public abstract void triangle(int i1, int i2, int i3);

	/**Add two triangles from the last 4 vertices. If faceMode is GL_TRIANGLES, 6 indices are added.*/
	public abstract void quad(boolean reverse);

	/**Add 6 indices from 4 inputs as if it was a trianglestrip, or 4 indices if the mode is currently triangle_strip.*/
	public abstract void quad(int i1, int i2, int i3, int i4);

	/**Add an index. Use to make faces from vertices.*/
	public abstract void addIndex(int index);

	/**Get the current size of the vertex list*/
	public abstract int getIndex();

	/**Call after changing the vertex array. Update mode should be dynamic.
	 * The VBO or directbuffers get updated on the next render call.*/
	public abstract void requestUpdate();

	/**Terminate the current sequence and begin a new one with the indicated face mode*/
	public abstract void addSequence(int newFaceMode);

	/**Complete the vbo from the data input*/
	public abstract void end();

	/**Use the returned array to change the vertex data. Call requestUpdate() when done.*/
	public abstract float[] getVData();
	
	/**Render*/
	public abstract void render();

	/**Free memory*/
	public abstract void dispose(GL gl);

	/**Inefficient debug method.*/
	public abstract void render(V3D center, double scale);

	/**Inefficient debug method 2.*/
	public abstract void render(V3D center, double xScale, double yScale, double zScale);
	
	/**Get the number of indices occupied by a full vertex in the float array*/
	public abstract int getVStride();
	
	/**Get the index of the vertex position data relative to the start of the nearest full vertex in the float array*/
	public abstract int getVertexPointer();

	/**Get the index of the normal data relative to the start of the nearest full vertex in the float array*/
	public abstract int getNormalPointer();
	
	/**Get the index of the color data relative to the start of the nearest full vertex in the float array*/
	public abstract int getColorPointer();

	/**Get the index of the texture coordinate data relative to the start of the nearest full vertex in the float array*/
	public abstract int getTexCoordPointer();

	}