package game;

import io.IOH;

import java.awt.event.KeyEvent;

import javax.media.opengl.GL2;

import graphics.BlendMode;
import graphics.GFX;
import calc.V3D;
import mechanics.Entity;

/**Class for controlling the camera matrix. Is the first thing to render on a step.*/
public class View extends Entity
	{
	static double x,y,width,height, targetScale;
	public static boolean extCam = false;
	public View(V3D pos)
		{
		super(pos);
		setDepth(Integer.MAX_VALUE);
		
		
		x=pos.x();
		y=pos.y();
		targetScale = 1.5;
		width=320*targetScale;
		height=240*targetScale;
		GFX.gl.glEnable(GL2.GL_BLEND);
		BlendMode.NORMAL.set();
		}
	
	@Override
	public void step()
		{
		if(IOH.checkKeyPressed(KeyEvent.VK_F12))
			Overlay.me.screenshot();
		
		if(!extCam)
			{
			targetScale = 1.5+Pony.me.speed.len()/48;
			
			x = (x*15+Pony.me.pos.x()-width/2)/16;
			y = (y*15+Pony.me.pos.y()-height*3d/5)/16;
			x += -4*Pony.me.ny*(Pony.me.right?1:-1)+1*Pony.me.speed.x();
			y += +4*Pony.me.nx*(Pony.me.right?1:-1)+1*Pony.me.speed.y();
			if(MagicPointer.me != null)
				{
				x += (MagicPointer.me.pos.x()-Pony.me.pos.x())/64;
				y += (MagicPointer.me.pos.y()-Pony.me.pos.y())/64;
				}
			
			if(width<320*targetScale)
				width+=2;
			if(width>320*targetScale)
				width-=2;
			if(height<240*targetScale)
				height+=2;
			if(height>240*targetScale)
				height-=2;
			
			width=(width*15+320*targetScale)/16;
			height=(height*15+240*targetScale)/16;
			}
		}
	public void render()
		{
		GL2 gl = GFX.gl;
		//Make sure border bars are black when game aspect ratio does not match the window aspect ratio
		gl.glClearColor(0.0f,0.0f,0.0f,1.0f);
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT);
		gl.glColor4f(0.125f,0.125f,0.125f,1.0f);
		GFX.drawRectangle(0, 0, (float)width, (float)height);
		
		gl.glLoadIdentity();
		gl.glOrtho(x, x+width, y+height, y, -6400, 6400);
		}
	}