package game;

import graphics.GFX;
import calc.V3D;

public class ThrowSphere extends Ball implements Grabbable
	{
	V3D origPos; 
	Door myDoor = null;
	boolean isInDoor = false;
	public ThrowSphere(V3D pos)
		{
		super(pos);
		origPos = pos.clone();
		radius = 42/3;
		tex = GFX.tex("throwable");
		xScale = 0.66f;
		yScale = 0.66f;
		Grabbable.list.add(this);
		}
	@Override
	public void step()
		{
		super.step();
		if(	!isInDoor &&
				(pos.x()<View.x-256 || pos.y()<View.y-256 || 
				pos.x()>View.x+View.width+256 || pos.y()>View.y+View.height+256) &&
				(origPos.x()<View.x-64 || origPos.y()<View.y-64 || 
				origPos.x()>View.x+View.width+64 || origPos.y()>View.y+View.height+64))
			{
			pos.set(origPos);
			speed.set(0,0,0);
			}
		
		if(!isInDoor)
			{
			for(Door d: Door.list)
				{
				if(d.doorTimer==0 && d.pos.clone().add(-d.xScale*38,0,0).distance(pos)<40)
					{
					MagicPointer.me.dropItem();
					d.spherePlaced(this);
					myDoor = d;
					Ball.balls.remove(this);
					isInDoor = true;
					}
				}
			}
		if(isInDoor)
			{
			speed.set(0,0,0);
			pos.makeAverage(myDoor.pos.clone().add(-myDoor.xScale*38,0,0), 0.25);
			}
		}
	@Override
	public void destroy()
		{
		Grabbable.list.remove(this);
		super.destroy();
		}

	@Override
	public V3D getPosition()
		{
		return pos;
		}

	@Override
	public double getWeight()
		{
		return 0.25;
		}

	@Override
	public void move(V3D target)
		{
		V3D acc = (target.clone()).sub(pos);
		double d = acc.len();
		if(d>8)
			acc.multiply(8/d);
		speed.add(acc);
		d = speed.len();
		if(d>30)
			speed.multiply(30/d);
		}

	@Override
	public boolean canGrab()
		{
		return !isDestroyed() && !isInDoor;
		}

	}
