package game;

import graphics.GFX;
import graphics.Model;
import graphics.Tex;
import calc.Calc;
import calc.V3D;
import mechanics.Entity;
import mechanics.Scene;

public class Terrain extends Entity implements Intersectable
	{
	Model model;
	float[] verts;
	int [] inds;
	public static Terrain me;
	public Terrain(V3D pos)
		{
		super(pos);
		me = this;
		setDepth(-100);
		GFX.tex("cracks").setRepeating(Tex.REPEAT_BOTH);
		model = Model.get("Terrain.obj", null);
		verts = model.getVertices();
		inds = model.getTriangleIndices();
		for(int i=0; i<verts.length; i+=3)
			{
			verts[i+1] *= -1;
			}
		model.updateToArmature();
		}
	@Override
	public void step()
		{
		V3D p1 = new V3D(), p2 = new V3D(), p3 = new V3D();
		for(int i=0; i<inds.length; i+=3)
			{
			p1.set(verts[inds[i  ]*3],verts[inds[i  ]*3+1],0);
			p2.set(verts[inds[i+1]*3],verts[inds[i+1]*3+1],0);
			p3.set(verts[inds[i+2]*3],verts[inds[i+2]*3+1],0);
			for(Ball b : Ball.balls)
				{
				b.line(p1, V3D.ZERO, 0, p2, V3D.ZERO, 0, Scene.friction, true, true);
				b.line(p3, V3D.ZERO, 0, p2, V3D.ZERO, 0, Scene.friction, true, true);
				b.line(p1, V3D.ZERO, 0, p3, V3D.ZERO, 0, Scene.friction, true, true);
				}
			}
		}
	@Override
	public void destroy()
		{
		me = null;
		super.destroy();
		}
	
	@Override
	public double intersect(V3D origin, V3D direction)
		{
		double minimum = Double.MAX_VALUE;
		V3D p1 = new V3D(), p2 = new V3D(), p3 = new V3D();
		for(int i=0; i<inds.length; i+=3)
			{
			p1.set(verts[inds[i  ]*3],verts[inds[i  ]*3+1],0);
			p2.set(verts[inds[i+1]*3],verts[inds[i+1]*3+1],0);
			p3.set(verts[inds[i+2]*3],verts[inds[i+2]*3+1],0);
			double d = Calc.linesIntersection(p1,p2,origin,direction);
			if(d<minimum)
				minimum = d;
			d = Calc.linesIntersection(p1,p3,origin,direction);
			if(d<minimum)
				minimum = d;
			d = Calc.linesIntersection(p3,p2,origin,direction);
			if(d<minimum)
				minimum = d;
			}
		return minimum;
		}
	
	@Override
	public void render()
		{
		model.render();
		}
	}
