package game;

import graphics.GFX;
import calc.Calc;
import calc.V3D;
import mechanics.Entity;
import mechanics.Scene;

public class TailLink extends Entity
	{

	int index, total;
	double maxDist, dir, radius;
	private TailLink prev, next;
	Entity origin;
	/**Speed adder(only defined for root)*/
	V3D x = new V3D();
	private V3D c0 = new V3D(), c1 = new V3D(), c2 = new V3D();//Workspace
	public TailLink(V3D pos, TailLink[] list, int depth, double dist, int index, int total, TailLink prev, Entity origin)
		{
		super(pos);
		list[index] = this;
		setDepth(depth);
		maxDist = dist;
		this.index = index;
		this.total = total;
		this.prev = prev;
		radius = Math.sqrt((double)(1+index)/total)*dist;
		xScale = (float)radius/32;
		yScale = (float)radius/32;
		if(index==total-1)
			this.next = null;
		else
			this.next = new TailLink(pos.clone(), list, depth-1, dist, index+1,total,this,origin);
		this.origin = origin;
		tex = GFX.tex("circle32");
		visible = false;
		}
	@Override
	public void step()
		{
		speed.p[1]+=Scene.gravity;
		super.step();
		
		if(prev==null)
			dir = Calc.dir(0,0,x.x(),x.y());
		else
			{
		    softScript();
			dir = Calc.dir(prev.pos.x(), prev.pos.y(), pos.x(),pos.y());
			}
		speed.p[1]+=Scene.gravity;
		}

	private void softScript()
		{
		if(prev!=null) // Not root
			{
			speed.accelerate(-speed.sqLen()/512);
			if(prev.prev==null)//Previous is root
				{
				c0.set(pos).add(prev.pos, -1);
				V3D diff = c0;
				//double dist = diff.len();
				diff.normalize();
				c1.set(speed).add(prev.speed,-1);
				V3D diffSpeed = c1;
				double d = diffSpeed.dot(diff);
				//if(dist>=maxDist)
					{
					pos.set(prev.pos).add(diff,maxDist);
					speed.add(diff,-d);
					}
				}
			else
				{
				//speed.makeAverage(new V3D(Math.cos(dir),-Math.sin(dir),0),0.05);
				c0.set(pos).add(prev.pos, -1);
				V3D diff = c0;
				double dist = diff.len();
				diff.normalize();
				c1.set(speed).add(prev.speed,-1);
				V3D diffSpeed = c1;
				double d = diffSpeed.dot(diff);
				if(dist>maxDist)
					{
					pos.makeAverage(c2.set(prev.pos).add(diff,maxDist),1);
					prev.pos.makeAverage(c2.set(pos).add(diff,-maxDist),1);
					prev.speed.add(diff,d*0.95);
					speed.add(diff,-d*0.95);
					speed.accelerate(-0.01*speed.sqLen());
					}
				}
			}
		}
	
	public void updatePosition(V3D newPos, double hAdd, double vAdd)
		{
		speed.set(newPos).sub(pos).add(hAdd,vAdd,0);
		this.pos.set(newPos).sub(speed);
		x.x(hAdd);
		x.y(vAdd);

		next.speed.add(x,1.2);
		next.next.speed.add(x,0.8);
		next.next.next.speed.add(x,0.3);
		}
	

	}