package game;

import graphics.GFX;
import audio.Audio;
import audio.StupidClip;
import calc.Calc;
import calc.V3D;
import mechanics.Entity;

/**First object that is spawned. Should initialize game-specific stuff.*/
public class Root extends Entity
	{
	public static StupidClip music;
	static int corruption = 0;
	
	public Root(V3D pos)
		{
		super(pos);
		Audio.loadDir("res/music");
		music = Audio.get("music");
		music.setLooping(true);
		
		setDepth(Integer.MIN_VALUE);
		visible = false;
		new View(new V3D());
		new Overlay(new V3D());
		new Intro(new V3D());
		//new Cave(new V3D());
		}
	
	public void step()
		{
		}
	public static void corrupt()
		{
		corruptMusic();
		if(corruption>8)
			GFX.corruptTextures();
		if(corruption>32)
			Pony.me.armature.corrupt();
		if(corruption>24)
			Pony.me.model.corrupt();
		if(corruption>4)
			Overlay.corruptScreen();
		corruption ++;
		}
	
    private static void corruptMusic()
		{
		Calc.corruptBytes(music.dataArray,8192*2,65536*2,2);
		if(corruption>6)
			{
			byte[] src = Audio.get("studio").dataArray;
			byte[] dst = music.dataArray;
			int len = 8196+2*(int)(Math.random()*65536);
			int srcPos = 2*(int)(Math.random()*(src.length-len)/2);
			int dstPos = 2*(int)(Math.random()*(dst.length-len)/2);
			System.arraycopy(src, srcPos, dst, dstPos, len);
			}
		}

	@Override
	public void render()
		{}

	public static void recover()
		{
		GFX.recoverTextures();
		Pony.me.armature.recover();
		Pony.me.model.recover();
		Overlay.removeCorruptScreen();
		corruption = 0;
		}
	}
