package game;

import java.awt.event.KeyEvent;

import javax.media.opengl.GL2;

import mechanics.Scene;

import audio.Audio;

import io.IOH;
import graphics.Armature;
import graphics.Bone;
import graphics.GFX;
import graphics.Model;
import graphics.Tex;
import calc.Calc;
import calc.V3D;

/**Test implementation of arbitrary object.
 * All visible game objects should extend Entity.*/
public class Pony extends Ball
	{
	public static final int STAND		= 0;
	public static final int WALK 		= 1;
	public static final int RUN  		= 2;
	public static final int SKID 		= 3;
	public static final int JUMP 		= 4;
	
	public static Pony me;
	
	Model model;
	Armature armature;
	int animationIndex = 1;
	double frameDiff = 0;
	double frameSpeed = 0;
	double scale;
	boolean right = false;
	boolean control = true;
	boolean jumped = false;
	double hornX = 0, hornY = 0;
	double snx = 0;
	double dx = 0;
	double sny = -1;
	int blinkTimer = 0;
	TailLink[] tail;
    public Pony(V3D position) 
    	{
    	//Routine call to entity constructor
    	super(position);
    	me = this;
    	
    	radius = 32;
    	scale = radius/1.05;
    	//Set texture to one in the res/textures folder
    	tex = GFX.tex("circle32");
    	armature = Armature.get("Twidoll.bvh");
    	model = Model.get("Twidoll.obj", armature);
    	armature.getBone("Master").usePostMatrix = true;
    	
    	int total = 6;
    	tail = new TailLink[total];
    	new TailLink(pos.clone(),tail,getDepth()-1,scale/4,0,total,null,this);
    	}
    
    @Override
    public void step() 
    	{
    	super.step();

    	double pFrame = frameDiff;
    	frameDiff += frameSpeed;
    	if(frameDiff>=20)
    		{
    		frameDiff = 0;
    		pFrame = -1;
    		}
    	
    	if(gnd==0)
    		{
    		frameSpeed = 0;
    		nx = 0;
    		ny = -1;
    		animationIndex = JUMP;
    		frameDiff = Calc.limit(10+speed.p[1]*2, 0, 19);
    		}
    	else
    		{
    		V3D offSpeed = speed.clone().sub(nullSpeed);
    		double relativeSpeed = offSpeed.dot(new V3D(-ny,nx,0));
    		if(Math.abs(relativeSpeed)>1)
    			{frameSpeed = Math.abs(relativeSpeed)/2.5;
				animationIndex = WALK;}
			else
    			{frameSpeed = 0.75;
	    		animationIndex = STAND;}
    		}
    	

    	blinkTimer--;
    	if(blinkTimer<3)
    		model.image = 1;
    	else 
    		model.image = 0;
    	if(blinkTimer<0)
    		blinkTimer = 90+(int)(Math.random()*190);
    	if(control)
    		{
	    	dx = 0;
	    	if(IOH.checkKey(KeyEvent.VK_A))
	    		dx -= 1;
	    	if(IOH.checkKey(KeyEvent.VK_D))
	    		dx += 1;
    		}
    	if(dx!=0)
    		{
    		double f = dx*Math.max(0.1,(Math.pow((1-ny)/2,1.5))*0.8);
    		V3D offSpeed = speed.clone().sub(nullSpeed);
    		speed.add(-ny*f,nx*f,0);
    		double relativeSpeed = offSpeed.dot(new V3D(-ny,nx,0));
    		if(Math.abs(relativeSpeed)>0.2 && relativeSpeed*dx<0)
    			{
    			right = relativeSpeed>0;
    			if(gnd>0)
    				{
	    			animationIndex = SKID;
	    			frameSpeed = 0.75;
    				if(Scene.fourstage==0)
    		    		new Dust(pos.clone().add(-radius*0.75*nx,-radius*0.75*ny,0));
    				}
    			}
    		else
    			{
    			right = dx>0;
    			if(gnd>0)
    				{
	    			if(relativeSpeed*dx<8)
	    				{frameSpeed = Math.abs(relativeSpeed)/2.5;
	    				animationIndex = WALK;}
	    			else
	    				{frameSpeed = Math.abs(relativeSpeed)/8;
	    				animationIndex = RUN;}
    				}
    			}
    		}
    	if((animationIndex==RUN || animationIndex==WALK) && 
    			((frameDiff==0 && pFrame!=0) 
					 || (frameDiff>=5 && pFrame<5 && animationIndex == RUN)
					 || (frameDiff>=10 && pFrame<10)
					 || (frameDiff>=15 && pFrame<15 && animationIndex == RUN)))
			{
			new Dust(pos.clone().add(-radius*0.75*nx,-radius*0.75*ny,0));
			Audio.get("smallStep").play();
			}
    	
    	if(IOH.checkKey(KeyEvent.VK_SPACE) && control)
    		{
    		if(gnd>0 && !jumped)
    			{
    			jumped = true;
    			double jmp = 12;
    			gnd = 0;
    			speed.add(nx*jmp, ny*jmp,0);
    			Audio.get("step").play();
        		new Dust(pos.clone().add(-radius*0.75*nx,-radius*0.75*ny,0));
    			}
    		}
    	else
    		jumped = false;
    	
    	armatureDeform();
    	}
    @Override
    public void destroy()
    	{
    	me = null;
    	for(TailLink t: tail)
    		t.destroy();
    	super.destroy();
    	}
    
    @Override
    public void collision(V3D point, V3D normal, double addNormal, V3D pointSpeed, double friction, boolean ground)
    	{
    	boolean ok = gnd==0;
    	super.collision(point, normal, addNormal, pointSpeed, friction, ground);
    	if(gnd!=0 && ok)
    		{
    		Audio.get("step").play();
    		new Dust(pos.clone().add(-radius*0.75*nx,-radius*0.75*ny,0));
    		}
    	}
    
    private void armatureDeform()
		{
		snx += nx/2;
		sny += ny/2;
		if(snx==0 && sny==0)
			{
			snx = nx;
			sny = ny;
			}
		else
			{
			double d = Calc.dist(snx, sny);
			snx/=d;
			sny/=d;
			}
		armature.getBone("Master").postMatrix = new float[][] {
    			{0,(float)(-sny*(right?1:-1)),(float)(snx)},
    			{0,(float)(snx*(right?1:-1)),(float)sny},
    			{1,0,0}};
    	armature.computeFrame((int)(animationIndex*20+frameDiff), (float)Math.max(0.1, 1d-Math.max(0,(double)(Root.corruption-32)/66)), false);
    	model.updateToArmature();
    	
    	Bone hip = armature.getBone("Hip");
    	float[] adder = hip.getPositionFor(new float[]{0,-0.3924f,0.001524f});
    	tail[0].updatePosition(pos.clone().add(
    			adder[0]*scale,
    			adder[1]*scale,
    			adder[2]*scale),
    			-hip.units[0][1]*96/96+hip.units[0][2]*96/48,
    			-hip.units[1][1]*96/96+hip.units[1][2]*96/48);
    	
    	if(MagicPointer.me != null)
    		{
    		adder = armature.getBone("Head").getPositionFor(new float[]{0,0.652f,0.832f});
    		hornX = pos.x()+adder[0]*scale;
    		hornY = pos.y()+adder[1]*scale;
    		if(Scene.fourstage==2)
    			new Star(Pony.me.pos.clone().add(
    				16*(Math.random()-0.5),16*(Math.random()-0.5),0).add(
    				adder[0]*scale,
    				adder[1]*scale,
    				adder[2]*scale
    				));
    		}
		}

	@Override
    public void render()
    	{
    	GL2 gl = GFX.gl;
    	gl.glPushMatrix();
    	gl.glTranslated(pos.x(), pos.y(), 0);
    	gl.glScaled(scale,scale,scale);
    	model.render();
    	gl.glPopMatrix();
    	
    	Tex ponyTail = GFX.tex("pony"); 
    	ponyTail.enable(0);
    	gl.glBegin(GL2.GL_TRIANGLE_STRIP);
    	TailLink curr = tail[0];
		for(int i=0; i<tail.length; i++)
			{
			double tailRadius = curr.radius;
			float cx = 1-(float)i/(tail.length-1);
			double h = tailRadius*Math.cos(curr.dir+Math.PI/2);
			double v = -tailRadius*Math.sin(curr.dir+Math.PI/2);
			gl.glTexCoord2f(ponyTail.xMult*cx/8, (ponyTail.yMult*(0.5f-(float)xScale/2)/8));
			gl.glVertex2d(curr.pos.x()+h, curr.pos.y()+v);
			gl.glTexCoord2f(ponyTail.xMult*cx/8, (ponyTail.yMult*(0.5f+(float)xScale/2)/8));
			gl.glVertex2d(curr.pos.x()-h, curr.pos.y()-v);
			curr = tail[i];
			}
    	gl.glEnd();
    	ponyTail.disable();
    	
    	if(MagicPointer.me != null)
    		{
    		gl.glColor3f(1,1,1);
    		double xx = hornX;
    		double yy = hornY;
    		GFX.tex("magic").enable((int)Scene.eightstage/2);
    		gl.glBegin(GL2.GL_TRIANGLE_FAN);
    		gl.glTexCoord2d(0, 0.5);
    		gl.glVertex2d(xx, yy);
    		gl.glColor3f(1,1,1);
    		final int mm = 18;
    		double rr = ((MagicPointer.me.dragging?12:8)+
    				Math.random()*((MagicPointer.me.target==null||MagicPointer.me.dragging)?
    						1:(MagicPointer.me.target.canGrab()?2:0)));
    		for(int i=0; i<=mm; i++)
    			{
    			gl.glTexCoord2d(1, (double)i/mm);
    			double h = Math.cos(Math.PI*2*(double)i/mm)*rr;
    			double v = -Math.sin(Math.PI*2*(double)i/mm)*rr;
    			gl.glVertex2d(xx+h, yy+v);
    			}
    		gl.glEnd();
    		GFX.tex("magic").disable();
    		}
    	}
	}
