package game;

import mechanics.Entity;
import graphics.GFX;
import calc.V3D;

public class Platform extends mechanics.Entity implements Grabbable
	{
	final int[] xx = {128,-128,-128,128,128};
	final int[] yy = {-64,-64,64,64,-64};
	V3D origPos,lPos;
	Line[] line;
	int grabTimer = 0;
	Entity mouseHint = null;
	public Platform(V3D pos,boolean hint)
		{
		super(pos);
		lPos = pos.clone();
		Grabbable.list.add(this);
		origPos = pos.clone();
		tex = GFX.tex("Platform");
		xScale = 0.5f;
		yScale = 0.5f;
		line = new Line[4];
		for(int i=0; i<4; i++)
			{
			line[i] = new Line(pos.clone(),pos.clone());
			line[i].visible = false;
			line[i].setDepth(getDepth()+1);
			}
		if(hint)
			{
			mouseHint = new PlainEntity(pos.clone().add(24,24,0));
			mouseHint.setDepth(-10000);
			mouseHint.imageSpeed = 1f/20;
			mouseHint.tex = GFX.tex("mouse");
			}
		}
	@Override
	public void destroy()
		{
		if(mouseHint!=null)
			mouseHint.destroy();
		Grabbable.list.remove(this);
		super.destroy();
		}
	
	public void step()
		{
		super.step();
		speed.makeAverage(V3D.ZERO, 0.25);
		if(		(pos.x()<View.x-128 || pos.y()<View.y-128 || 
				pos.x()>View.x+View.width+128 || pos.y()>View.y+View.height+128) &&
				(origPos.x()<View.x-128 || origPos.y()<View.y-128 || 
				origPos.x()>View.x+View.width+128 || origPos.y()>View.y+View.height+128))
			{
			pos.set(origPos);
			speed.set(0,0,0);
			}
		
		for(int i=0; i<4; i++)
			{
			line[i].pos.set(pos).add(xScale*xx[i],yScale*yy[i],0);
			line[i].pos2.set(pos).add(xScale*xx[i+1],yScale*yy[i+1],0);
			line[i].speed.set(speed);
			line[i].speed2.set(speed);
			if(line[i].hasPlayerCollision && (i==0 || speed.dot(Pony.me.pos.clone().sub(pos))>0))
				{
				grabTimer = 60;
				speed.set(0,0,0);
				pos.set(lPos);
				}
			}
		lPos.set(pos);
		
		if(grabTimer>0)
			grabTimer--;
		
		color[1] = 1f-(float)grabTimer/60;
		color[2] = 1f-(float)grabTimer/60;
		}

	@Override
	public V3D getPosition()
		{
		return pos;
		}

	@Override
	public double getWeight()
		{
		return 0.5;
		}

	@Override
	public void move(V3D target)
		{
		V3D acc = (target.clone()).sub(pos);
		double d = acc.len();
		if(d>1)
			acc.multiply(1/d);
		speed.add(acc);
		d = speed.len();
		if(d>16)
			speed.multiply(16/d);

		if(mouseHint!=null)
			{mouseHint.destroy();
			mouseHint = null;}
		}
	@Override
	public boolean canGrab()
		{
		return grabTimer<=0 && !isDestroyed() && 
				(pos.x()>View.x-128 && pos.y()>View.y-64 && 
						pos.x()<View.x+View.width+128 && pos.y()<View.y+View.height+64);
		}

	}

