package game;

import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;

import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;

import com.jogamp.opengl.util.awt.TextRenderer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;

import graphics.BlendMode;
import graphics.GFX;
import main.Main;
import mechanics.Entity;
import mechanics.Scene;
import calc.Calc;
import calc.V3D;

/**Class for drawing the final elements of the game window, like a HUD.*/
public class Overlay extends Entity
	{
	static final int width = 320;
	static final int height = 240;
	static byte[] messData;
	static Texture messTexture;
	static int mess = 0;
	
	static TextRenderer courierNew12;
	static
		{
		courierNew12 =  new TextRenderer(new Font("Courier New", Font.PLAIN, 12));
		courierNew12.setColor(1,1,1,1);
		courierNew12.setSmoothing(false);
		}
	
    /**Silly Bloom shader, if defined in config file*/
	private int shaderprogram;
	
	private	long lastResetTime;
	private int frameCount;
	static int frameRate;
	static int badCount;
	double corruptAlpha = 1;
	
	/**Fades the screen. From -1 to 1, where -1 is totally black and 1 is completely white.*/
	static double white = 0;
	public static Overlay me;

	public Overlay(V3D pos)
		{
		super(pos);
		me = this;
		setDepth(Integer.MIN_VALUE+9);
		
		if(Main.bloom == Main.BLOOM_GLSL)
			loadShader();
		
		lastResetTime = System.nanoTime();
		frameCount = 0;
		frameRate = -1;
		
		int w = 512, h = 256;
		messData = new byte[320*240*4];
		messTexture = new Texture(GFX.gl, new TextureData(Main.profile, GL2.GL_RGBA, w,h, 0, GL2.GL_RGBA, GL2.GL_UNSIGNED_BYTE, false, false, false, ByteBuffer.allocate(w*h*4), null));
		messTexture.setTexParameteri(GFX.gl, GL2.GL_TEXTURE_WRAP_S, GL2.GL_REPEAT);
		messTexture.setTexParameteri(GFX.gl, GL2.GL_TEXTURE_WRAP_T, GL2.GL_REPEAT);
		messTexture.setTexParameteri(GFX.gl, GL2.GL_TEXTURE_MIN_FILTER, GL2.GL_NEAREST);
		messTexture.setTexParameteri(GFX.gl, GL2.GL_TEXTURE_MAG_FILTER, GL2.GL_NEAREST);
		}
	public static void removeCorruptScreen()
		{
		me.corruptAlpha = 0.99;
		}
	public static void corruptScreen()
		{
		int kk = Calc.limit(Root.corruption/6, 0, 3);
		kk = kk+(int)(Math.random()*kk+1);
		for(int k = kk; k>=0; k--)
			{
			for(int i = 0; i<8; i++)
				{
				int index = 4*(int)(Math.pow(Math.random(),2)*320);
				messData[index] = (byte)(256*Math.random());
				messData[index+1] = (byte)(256*Math.random());
				messData[index+2] = (byte)(256*Math.random());
				messData[index+3] = (byte)(256*Math.random());
				if(Math.random()<0.25)
					{
					index = 4*(int)(((1-Math.pow(Math.random(),16))*320*240)-1);
					messData[index] = (byte)(256*Math.random());
					messData[index+1] = (byte)(256*Math.random());
					messData[index+2] = (byte)(256*Math.random());
					messData[index+3] = (byte)(256*Math.random());
					}
				}
			if(mess<239)
				mess += 1;
			for(int i = mess; i>0; i--)
				System.arraycopy(messData, ((i-1)*320)*4+(int)(Math.random()*5), messData, ((i)*320)*4+(int)(Math.random()*5), (int)(Math.random()*320)*4);
			}
		messTexture.bind(GFX.gl);
		GFX.gl.glTexSubImage2D(GL2.GL_TEXTURE_2D, 0, 0, 0, 320, 240, GL2.GL_RGBA, GL2.GL_UNSIGNED_BYTE, ByteBuffer.wrap(messData));
		}
	
	@Override
	public void step()
		{
		frameCount++;
		long now = System.nanoTime();
		if(now>lastResetTime+1000000000)
			{
			frameRate = frameCount;
			frameCount = 0;
			lastResetTime = now;
			if(frameRate<Main.FPS-2)
				badCount++;
			else
				badCount=0;
			}
		if(corruptAlpha<1 && corruptAlpha>0)
			{
			corruptAlpha-=1d/30;
			if(corruptAlpha<=0)
				{
				corruptAlpha = 0;
				}
			}
		}

	private void loadShader()
		{
		GL2 gl = GFX.gl;
		try
			{
			int v = gl.glCreateShader(GL2.GL_VERTEX_SHADER);
			int f = gl.glCreateShader(GL2.GL_FRAGMENT_SHADER);
			
			BufferedReader brv = new BufferedReader(new FileReader("res/shaders/bloomVertex.glsl"));
			String vsrc = "";
			String line;
			while ((line=brv.readLine()) != null) 
				{
				vsrc += line + "\n";
				}
			
			gl.glShaderSource(v, 1, new String[]{vsrc}, new int[]{vsrc.length()},0);
			gl.glCompileShader(v);
			
			BufferedReader brf = new BufferedReader(new FileReader("res/shaders/bloomFragment.glsl"));
			String fsrc = "";
			
				while ((line=brf.readLine()) != null) 
					{
					fsrc += line + "\n";
					}
			gl.glShaderSource(f, 1, new String[]{fsrc}, new int[]{fsrc.length()},0);
			gl.glCompileShader(f);
			
			shaderprogram = gl.glCreateProgram();
			gl.glAttachShader(shaderprogram, v);
			gl.glAttachShader(shaderprogram, f);
			gl.glLinkProgram(shaderprogram);
			gl.glValidateProgram(shaderprogram);
			}
		catch (IOException e)
			{e.printStackTrace();}
		}

	@Override
	public void render()
		{
		GL2 gl = GFX.gl;
		BlendMode.NORMAL.set();


		GFX.gl.glMatrixMode(GL2.GL_MODELVIEW);
        GFX.gl.glLoadIdentity(); 
		GFX.gl.glOrthof(Scene.x, Scene.x+Scene.width, Scene.y+Scene.height, Scene.y, -6400, 6400);
		renderBloom();
		
		defineOverlayMatrix();
		
		gl.glColor4d(1,1,1,corruptAlpha);
		messTexture.bind(GFX.gl);
		messTexture.enable(GFX.gl);
		
		GFX.drawRectangle(0, 0, 320, 240, 0, 0, 320f/512, 240f/256);
		
		messTexture.disable(GFX.gl);
		
		//Bad framerate notification
		textBegin(courierNew12);
		gl.glColor4fv(GFX.RED,0);
		if(badCount>1)
			{
			textDraw(courierNew12, 0, 0, "BAD FRAMERATE: "+frameRate+"/"+Main.FPS);
			}
		textEnd(courierNew12);
		
		//Whiteout/blackout
		float w = (float)Math.abs(white);
		if(w>0.01)
			{
			gl.glColor4f(w,w,w,1);
			if(white>0)
				BlendMode.ADD.set();
			else
				BlendMode.SUBTRACT.set();
			GFX.drawRectangle(0, 0, width, height);
			BlendMode.NORMAL.set();
			}
		}
	public static void textDraw(TextRenderer renderer, int x, int y, String string)
		{
		y+=renderer.getFont().getSize();
		renderer.draw3D(string, x, -y, 0, 1);
		}

	public static void textBegin(TextRenderer renderer)
		{
		GFX.gl.glPushMatrix();
		GFX.gl.glScaled(1, -1, 1);
		//GFX.gl.glTranslated(0,height,0);
		
		GFX.gl.glMatrixMode(GL2.GL_PROJECTION);
		GFX.gl.glPushMatrix();
		GFX.gl.glMatrixMode(GL2.GL_MODELVIEW);
		renderer.begin3DRendering();
		GFX.gl.glMatrixMode(GL2.GL_MODELVIEW);
		}

	public static void textEnd(TextRenderer renderer)
		{
		renderer.end3DRendering();
		//Simply popping a matrix isn't enough. It must be redefined.
		//defineOverlayMatrix();
		GFX.gl.glMatrixMode(GL2.GL_PROJECTION);
		GFX.gl.glPopMatrix();
		GFX.gl.glMatrixMode(GL2.GL_MODELVIEW);
		GFX.gl.glPopMatrix();
		}

	public static void defineOverlayMatrix()
		{
		GFX.gl.glMatrixMode(GL2.GL_MODELVIEW);
        GFX.gl.glLoadIdentity(); 
		GFX.gl.glOrthof(0, width, height, 0, -6400, 6400);
		}
	/**Write a screenshot to out.png*/
	void screenshot()
		{
		System.out.println("SAVING SCREENSHOT");
		GL2 gl = GFX.gl;

		gl.glReadBuffer(GL2.GL_BACK);
		ByteBuffer pixels = ByteBuffer.allocateDirect(Scene.width*Scene.height*4);
		gl.glReadPixels(Scene.x, Scene.y, Scene.width, Scene.height, GL2.GL_RGBA, GL2.GL_UNSIGNED_BYTE, pixels);
		BufferedImage bi = new BufferedImage(Scene.width, Scene.height, BufferedImage.TYPE_4BYTE_ABGR);
		
		pixels.rewind();
		byte[] data = new byte[Scene.width*Scene.height*4];
		for(int j = Scene.height-1; j>=0; j--)
			{
			for(int i = 0; i<Scene.width; i++)
				{
				data[(j*Scene.width+i)*4  ] = pixels.get();
				data[(j*Scene.width+i)*4+1] = pixels.get();
				data[(j*Scene.width+i)*4+2] = pixels.get();
				data[(j*Scene.width+i)*4+3] = pixels.get();
				}
			}
		
		bi.getRaster().setDataElements(0, 0, Scene.width, Scene.height, data);
		
		try {ImageIO.write(bi, "PNG", new File("out.png"));}
		catch (IOException e)
			{e.printStackTrace();}
		}
	public void renderBloom()
		{
		GL2 gl = GFX.gl;
		if(Main.bloom!=Main.BLOOM_OFF)
			{
			gl.glColor3f(1,1,1);
			// define the projection(nothing)
			gl.glMatrixMode(GL2.GL_PROJECTION);
	        gl.glLoadIdentity(); 
	        // define the viewport
	        gl.glMatrixMode(GL2.GL_MODELVIEW);
	        gl.glLoadIdentity(); 
			GFX.glu.gluOrtho2D(0, Scene.width, Scene.height, 0);
			
			if(Main.bloom == Main.BLOOM_GLSL)
				{
				float tx = (float)Scene.width/Scene.renderTexture.getWidth();
				float ty = (float)Scene.height/Scene.renderTexture.getHeight();
				gl.glReadBuffer(GL2.GL_BACK);
				
				Scene.renderTexture.bind(gl);
				gl.glCopyTexSubImage2D(GL.GL_TEXTURE_2D, 0, 0, 0, Scene.x, Scene.y, Scene.width, Scene.height);
				Scene.renderTexture.enable(gl);
			
				gl.glUseProgram(shaderprogram);
				
				int h0 = gl.glGetUniformLocation(shaderprogram, "renderSampler");
				gl.glUniform1i(h0, 0); //first texture sampler
				//BlendMode.ADD.set();
				GFX.drawRectangle(0, 0, Scene.width, Scene.height, 0, ty, tx, 0);
				
				BlendMode.NORMAL.set();
				Scene.renderTexture.disable(gl);
				gl.glUseProgram(0);
				}
			else if(Main.bloom==Main.BLOOM_FFP)
				{
				//long before = System.currentTimeMillis();
				gl.glReadBuffer(GL2.GL_BACK);
				Scene.renderTexture.bind(gl);
				gl.glCopyTexSubImage2D(GL2.GL_TEXTURE_2D,0, 0, 0, Scene.x, Scene.y, Scene.width, Scene.height);
				gl.glEnable(GL2.GL_TEXTURE_2D);
				float tx = (float)Scene.width/Scene.renderTexture.getWidth();
				float ty = (float)Scene.height/Scene.renderTexture.getHeight();
				//Draw original at half resolution.
				GFX.drawRectangle(Scene.width/2, 0, Scene.width, Scene.height/2, 0, ty,tx, 0);
				//Contrast the image.
				BlendMode.MULTIPLY.set();
				for(int i=0; i<4; i++)
					GFX.drawRectangle(Scene.width/2, 0, Scene.width, Scene.height/2, 0, ty,tx, 0);
				
				BlendMode.NORMAL.set();
				int blurs = 1;
				Scene.workTexture.bind(gl);
				Scene.workTexture.enable(gl);
			    gl.glColor4f(1,1,1,0.75f);
			    float it = 2;
				while (blurs > 0) 
					{
					for (float x = -0.5f; x <=0.5f; x++)
				        {
				        for (float y = -0.5f; y <=0.5f; y++)
				            {
							gl.glCopyTexSubImage2D(GL2.GL_TEXTURE_2D,0, 0, 0, Scene.x+Scene.width/2, Scene.y+Scene.height/2, Scene.width/2+8, Scene.height/2+8);
							GFX.drawRectangle(Scene.width/2, 0, Scene.width, Scene.height/2, 
									(x*it)/Scene.workTexture.getWidth(), 
									((float)Scene.height+y*it)/2/Scene.workTexture.getHeight(),
									((float)Scene.width+x*it)/2/Scene.workTexture.getWidth(), 
									(y*it)/Scene.workTexture.getHeight());
							}
				        }
			        it*=2;
			        blurs--;
					}
				
				gl.glCopyTexSubImage2D(GL2.GL_TEXTURE_2D,0, 0, 0, Scene.x+Scene.width/2, Scene.y+Scene.height/2, Scene.width/2, Scene.height/2);
				Scene.renderTexture.bind(gl);
				BlendMode.NORMAL.set();
				gl.glColor4fv(GFX.WHITE,0);
				GFX.drawRectangle(0, 0, Scene.width, Scene.height, 0, ty, tx, 0);
				BlendMode.ADD.set();
				gl.glColor4f(1f,1f,1f, 1f);
				Scene.workTexture.bind(gl);
		        GFX.drawRectangle(0, 0, Scene.width, Scene.height, 0, (float)Scene.height/2/Scene.workTexture.getHeight(), (float)Scene.width/2/Scene.workTexture.getWidth(), 0);
		        BlendMode.NORMAL.set();
		        Scene.renderTexture.disable(gl);
				}
			gl.glColor3f(1,1,1);
			}
		}
	}
