package game;

import audio.Audio;
import audio.StupidClip;
import graphics.GFX;
import calc.Calc;
import calc.V3D;
import mechanics.Entity;

public class Outro extends Entity
	{
	
	int timer;
	StupidClip birds;
	
	public Outro(V3D pos)
		{
		super(pos);
		setDepth(999);
		Line l = new Line(pos.clone(),pos.clone().add(640,0,0));
		l.visible = false;
		l = new Line(pos.clone().add(640,-1024,0),pos.clone().add(640,0,0));
		l.visible = false;
		Entity fg = new PlainEntity(pos.clone().add(0,-32,0));

		new Celestia(pos.clone().add(640-136,0,0));
		fg.orientation = GFX.NORTHWEST;
		fg.tex = GFX.tex("grass-foreground");
		fg.setDepth(-999);
		birds = Audio.get("birds");
		birds.setLooping(true);
		birds.play();
		birds.setGain(0);
		}

	@Override
	public void step()
		{
		View.extCam = true;
		View.targetScale = 1;
		View.width = 320;
		View.height = 240;
		View.y = pos.y()-224;
		double targetX = Math.min(pos.x()+320, Pony.me.pos.x()-64);
		
		View.x = (View.x*7+targetX)/8;
		if(View.x<targetX)
			View.x+=1;
		if(View.x<targetX)
			View.x-=1;

		if(Pony.me.pos.x()>pos.x()+80)
			{
			Pony.me.control = false;
			Pony.me.dx = 1;
			}
		if(Pony.me.pos.x()>pos.x()+320)
			{
			if(Pony.me.speed.x()>1)
				Pony.me.dx = -1;
			else
				{
				Pony.me.dx = 0;
				timer++;
				if(timer>220)
					{
					Overlay.white = Calc.limit(((double)timer-220)/120,0,1);
					if(timer>300+70)
						System.exit(0);
					}
				}
			}
		birds.setGain(Calc.limit(1-(pos.x()+320-View.x)/480, 0, 1));
		}
	@Override
	public void render()
		{
		GFX.gl.glColor3f(1,1,1);
		GFX.drawTexture(GFX.tex("garden-background"), 0, (float)pos.x(), (float)pos.y()-224, 0, GFX.NORTHWEST, 1, 1, 0);
		}
	}
