package game;

import io.IOH;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;

import javax.media.opengl.GL2;

import audio.Audio;

import graphics.BlendMode;
import graphics.GFX;
import calc.Calc;
import calc.V3D;
import main.Main;
import mechanics.Entity;
import mechanics.Scene;

public class MagicPointer extends Entity
	{
	Attachment attachment;
	public static MagicPointer me;
	
	Grabbable target = null;
	boolean dragging = false;
	boolean click = false;
	Entity mouseHint = null;
	int mx,my;
	boolean waitForMouse = false;
	public MagicPointer(V3D pos)
		{
		super(pos);
		me = this;
		setDepth(-9999);
		tex = GFX.tex("lamp");
		xScale = 0.33f;
		yScale = 0.33f;
		this.imageSpeed = 0;
		this.image = 1;
		attachment = new Attachment(pos.clone(),this,16);
		

		mouseHint = new PlainEntity(new V3D(320-64,32,0));
		mouseHint.xScale = 1f;
		mouseHint.yScale = 1f;
		mouseHint.setDepth(-10000);
		mouseHint.imageSpeed = 0;
		mouseHint.tex = GFX.tex("mouse");

		orientation = GFX.NORTH;
		alarm[0] = 120;
		}
	@Override
	public void alarm(int i)
		{
		if(i==0)
			{
			waitForMouse = true;
			}
		}
	
	@Override
	public void destroy()
		{
		if(mouseHint!=null)
			mouseHint.destroy();
		me = null;
		super.destroy();
		}
	@Override
	public void step()
		{
		if(Scene.fourstage==0)
			new Star(pos.clone().add(16*(Math.random()-0.5),16*(Math.random()-0.5),0));
		
		if(mouseHint!=null)
			{
			V3D off = new V3D(View.x+View.width/2, View.y+View.height-32, 0);
			off.sub(pos);
			off.normalize();
			mouseHint.pos.set(pos).add(off,32);
			}
		
		Point mouse = MouseInfo.getPointerInfo().getLocation();
		mouse.x -= Main.canvas.getLocationOnScreen().x;
		mouse.y -= Main.canvas.getLocationOnScreen().y;
    	//Set x/y position to mouse position each step, accounting for the viewport and camera matrix
		double tx = View.x+(mouse.x-Scene.x)*View.width/Scene.width;
		double ty = View.y+(mouse.y-Scene.y)*View.height/Scene.height;
    	tx = Calc.limit(tx,View.x,View.x+View.width);
    	ty = Calc.limit(ty,View.y,View.y+View.height);
    	speed.add((tx-pos.x())/4-speed.x(),(ty-pos.y())/4-speed.y(),0);
    	if(waitForMouse && Calc.dist(mouse.x, mouse.y,mx,my)>12)
    		mouseHint.destroy();
    	mx = mouse.x;
    	my = mouse.y;
    	image = 1+(Scene.fourstage==0?1:0);
    	angle = (float) (Calc.dir(pos.x(), pos.y(), attachment.pos.x(), attachment.pos.y())+Math.PI/2);
    	super.step();
    	if(target == null)
    		{
	    	Grabbable c = null;
	    	double dist = Double.MAX_VALUE;
	    	for(Grabbable g: Grabbable.list)
	    		{
	    		double d = g.getPosition().distance(pos);
	    		if(d<dist)
	    			{
	    			c = g;
	    			dist = d;
	    			}
	    		}
	    	if(c!=null && dist<24)
	    		{
	    		target = c;
	    		Audio.get("magicHigh").play();
	    		}
    		}
    	else
    		{
    		if(IOH.checkMouse(MouseEvent.BUTTON1))
    			{
    			if(target.canGrab())
    				{
	    			if(!dragging)
	    				Audio.get("magicLow").play();
	    			target.move(pos);
	    			pos.makeAverage(target.getPosition(), target.getWeight());
	    			dragging = true;
    				}
    			else if(!click)
    				Audio.get("unavailable").play();
    			click = true;	
    			}
    		else
    			{
    			dragging = false;
    			click = false;
    			}
    		if(!target.canGrab() && dragging)
    			{dragging = false;
    			Audio.get("unavailable").play();}
    		if(!dragging)
    			{
    			double d = target.getPosition().distance(pos);
	    		if(d>32)
	    			{
	    			Audio.get("magicDrop").play();
	    			target = null;
	    			}
    			}
    		}
		}
	public void dropItem()
		{
		dragging = false;
		target = null;
		}
	
	public void render()
		{
		GL2 gl = GFX.gl;
		int mm;
		
		if(target!=null)
			{
			float c = (target.canGrab()?(dragging?1:0.5f):0.25f);
			gl.glColor3f(c,c,c);
			BlendMode.ADD.set();
			float rand = (float)(0.5+0.1*Math.random());
			GFX.drawTexture(GFX.tex("pinkLight"), 0, 
					(float)target.getPosition().x(), (float)target.getPosition().y(), 0, 
					GFX.CENTER, rand, rand, 0);
			BlendMode.NORMAL.set();
			}

		gl.glColor3f(1,1,1);
		double xx = pos.x()+10*Math.cos(angle-Math.PI/2);
		double yy = pos.y()-10*Math.sin(angle-Math.PI/2);
		GFX.tex("magic").enable((int)Scene.eightstage/2);
		gl.glBegin(GL2.GL_TRIANGLE_FAN);
		gl.glTexCoord2d(0, 0.5);
		gl.glVertex2d(xx, yy);
		gl.glColor3f(1,1,1);
		mm = 18;
		double rr = ((dragging?24:15)+Math.random()*((target==null||dragging)?2:(target.canGrab()?8:4)));
		for(int i=0; i<=mm; i++)
			{
			gl.glTexCoord2d(1, (double)i/mm);
			double h = Math.cos(Math.PI*2*(double)i/mm)*rr;
			double v = -Math.sin(Math.PI*2*(double)i/mm)*rr;
			gl.glVertex2d(xx+h, yy+v);
			}
		gl.glEnd();
		GFX.tex("magic").disable();
		

		super.render();
		
		BlendMode.SUBTRACT.set();
		gl.glBegin(GL2.GL_TRIANGLE_FAN);
		gl.glColor3f(0f,(float)Math.random()*0.02f,(float)Math.random()*0.01f);
		gl.glVertex2d(pos.x(), pos.y());
		gl.glColor3f(1,1,1);
		mm = 18;
		for(int i=0; i<=mm; i++)
			{
			double h = Math.cos(Math.PI*2*(double)i/mm)*1280;
			double v = -Math.sin(Math.PI*2*(double)i/mm)*1280;
			gl.glVertex2d(pos.x()+h, pos.y()+v);
			}
		gl.glEnd();
		BlendMode.NORMAL.set();
		}
	}
