package game;

import javax.media.opengl.GL2;

import calc.Calc;
import calc.V3D;
import graphics.GFX;
import mechanics.Entity;
import mechanics.Scene;

public class Line extends Entity implements Intersectable
	{
	V3D pos2,speed2;
	boolean hasPlayerCollision;
	public Line(V3D pos,V3D pos2)
		{
		super(pos);
		Intersectable.list.add(this);
		this.pos2 = pos2;
		speed2 = new V3D();
		}
	@Override
	public void beginStep()
		{
		hasPlayerCollision = false;
		}
	@Override
	public void step()
		{
		for(Ball b : Ball.balls)
			{
			boolean hit = b.line(pos,speed,0,pos2,speed2,0, Scene.friction,true,true);
			if(hit && b == Pony.me)
				hasPlayerCollision = true;
			}
		}
	@Override
	public double intersect(V3D origin, V3D direction)
		{
		return Calc.linesIntersection(pos,pos2,origin,direction);
		}
	@Override
	public void destroy()
		{
		Intersectable.list.remove(this);
		super.destroy();
		}
	@Override
	public void render()
		{
		GL2 gl = GFX.gl;
		
		gl.glColor3f(0,0,0);
		gl.glBegin(GL2.GL_LINE_STRIP);
		gl.glVertex2d(pos.p[0],pos.p[1]);
		gl.glVertex2d(pos2.p[0],pos2.p[1]);
		gl.glEnd();
		}
	}
