package game;

import javax.media.opengl.GL2;

import audio.Audio;
import audio.StupidClip;

import graphics.BlendMode;
import graphics.GFX;
import calc.V3D;
import mechanics.Entity;

public class Intro extends Entity
	{
	int skyTimer = 0;
	StupidClip wind;
	double black = 0;
	Line l1,l2,l3;
	Entity keyboardHint;
	Entity logo;
	public Intro(V3D pos)
		{
		super(pos);
		wind = Audio.get("wind");
		wind.setLooping(true);
		wind.play();
		new Pony(new V3D(160,113+64-32,0));
		Pony.me.control = true;
		Pony.me.right = true;

		setDepth(9999);
		View.extCam = true;
		View.targetScale = 1;
		View.x = 0;
		View.y = 0;
		View.width = 320;
		View.height = 240;
		
		l1=new Line(new V3D(0,113+64,0), new V3D(200,113+64,0));
		l2=new Line(new V3D(0,-256,0), new V3D(0,51200,0));
		l3=new Line(new V3D(320,-256,0), new V3D(320,51200,0));
		l1.visible = false;
		l3.visible = false;
		l2.visible = false;

		logo = new PlainEntity(new V3D(0,0,0));
		logo.setDepth(2);
		logo.tex = GFX.tex("logo");
		logo.orientation = GFX.NORTHWEST;

		keyboardHint = new PlainEntity(new V3D(320-64,32,0));
		keyboardHint.xScale = 1f;
		keyboardHint.yScale = 1f;
		keyboardHint.setDepth(2);
		keyboardHint.imageSpeed = 1f/20;
		keyboardHint.tex = GFX.tex("keyboard");
		}
	
	public void step()
		{
		skyTimer+=1;
		if(skyTimer>=320)
			skyTimer=0;
		if(Pony.me.pos.y()>View.y+192)
			View.y = Pony.me.pos.y()-192;
		
		if (Pony.me.pos.y()>1280 || black>0)
			{
			black+=1d/60;
			wind.setGain(1-black);
			if(black>=1)
				{
				wind.stop();
				wind.setGain(1);
				black=1;
				Pony.me.destroy();
				destroy();
				l1.destroy();
				l2.destroy();
				l3.destroy();
				keyboardHint.destroy();
				logo.destroy();
				new Cave(new V3D());
				}
			Overlay.white = -black;
			}
		}
	
	public void render()
		{
		GL2 gl = GFX.gl;
		gl.glColor3f(1,1,1);
		
		GFX.drawTexture(GFX.tex("bridge-background"), 0, 0 , (float)(View.y*0.66), 0, GFX.NORTHWEST, 1, 1, 0);
		GFX.drawTexture(GFX.tex("bridge-foreground"), 0, 0, 64, 0, GFX.NORTHWEST, 1, 1, 0);
		BlendMode.ADD.set();
		GFX.drawTexture(GFX.tex("clouds"), 0, skyTimer, (float)(View.y*0.44), 0, GFX.NORTHWEST, 1, 1, 0);
		GFX.drawTexture(GFX.tex("clouds"), 0, skyTimer-320, (float)(View.y*0.44), 0, GFX.NORTHWEST, 1, 1, 0);
		BlendMode.NORMAL.set();
		gl.glDisable(GL2.GL_TEXTURE_2D);
		}
	}
