package game;

import javax.media.opengl.GL2;

import graphics.GFX;
import audio.Audio;
import audio.StupidClip;
import calc.Calc;
import calc.V3D;
import mechanics.Entity;

public class Evil extends Entity
	{
	Line line;
	StupidClip evil;
	public static Evil me;
	double sTimer = 0;
	public Evil(V3D pos)
		{
		super(pos);
		me = this;
		setDepth(-100);
		line = new Line(pos.clone(),pos.clone());
		line.visible = false;
		evil = Audio.get("evil");
		evil.setLooping(true);
		evil.play();
		evil.setGain(0);
		}
	@Override
	public void destroy()
		{
		me = null;
		evil.stop();
		line.destroy();
		super.destroy();
		}
	@Override
	public void step()
		{
		speed.p[0] = (speed.p[0]*7+2+(Pony.me.pos.x()-pos.x())/64)/8;
		if(Math.random()*150<1)
			{
			if(Math.random()<0.5)
				speed.p[0]+=8;
			else
				speed.p[0]-=8;
			}
		
		line.pos.x(pos.x());
		line.pos.y(View.y-512);
		line.speed.set(speed);
		
		line.pos2.x(pos.x());
		line.pos2.y(View.y+View.height+512);
		line.speed2.set(speed);

		super.step();
		sTimer+=Math.PI*speed.x()/16/4;
		if(sTimer>Math.PI*2)
			sTimer-=Math.PI*2;
		
		evil.setGain(Calc.limit(1-Math.abs(pos.x()-(View.x+View.width/2))/320, 0, 1));
		}
	@Override
	public void render()
		{
		GL2 gl = GFX.gl;
		gl.glColor3f(1, 1, 1);
		GFX.tex("black64").enable(0);
		gl.glBegin(GL2.GL_TRIANGLE_STRIP);
		for(int yy = (int)View.y; yy<View.y+View.height+65; yy+=64)
			{
			gl.glColor4f(1, 1, 1, 1);
			gl.glTexCoord2d(0, yy/96);
			gl.glVertex2d(pos.x(), yy);
			gl.glTexCoord2d(1, yy/96);
			gl.glColor4f(1,1,1,0);
			gl.glVertex2d(pos.x()+32+Math.sin(sTimer+(double)yy/120)*16, yy);
			}
		gl.glEnd();
		if(pos.x()>View.x)
			{
			gl.glColor3f(1,1,1);
			gl.glBegin(GL2.GL_TRIANGLE_STRIP);

			gl.glTexCoord2d(0, 0);
			gl.glVertex2d(View.x,View.y);
			gl.glTexCoord2d(1, View.height/96);
			gl.glVertex2d(View.x,View.y+View.height);

			gl.glTexCoord2d(1, 0);
			gl.glVertex2d(pos.x(),View.y);
			gl.glTexCoord2d(1, View.height/96);
			gl.glVertex2d(pos.x(),View.y+View.height);
			gl.glEnd();
			}
		GFX.tex("black64").disable();
		}
	}
