package game;

import java.util.ArrayList;

import audio.Audio;
import graphics.GFX;
import calc.V3D;

public class Door extends mechanics.Entity
	{
	public static ArrayList<Door> list = new ArrayList<Door>();
	final int[] yy = {128,-128,-128,128,128};
	final int[] xx = {-64,-64,64,64,-64};
	V3D origPos,lPos;
	Line[] line;
	ThrowSphere mySphere = null;
	int doorTimer = 0;
	public Door(V3D pos)
		{
		super(pos);
		list.add(this);
		lPos = pos.clone();
		setDepth(100);
		origPos = pos.clone();
		tex = GFX.tex("door");
		xScale = 0.66f;
		yScale = 0.66f;
		line = new Line[4];
		for(int i=0; i<4; i++)
			{
			line[i] = new Line(pos.clone(),pos.clone());
			line[i].visible = false;
			line[i].setDepth(getDepth()+1);
			}
		}
	@Override
	public void destroy()
		{
		list.remove(this);
		super.destroy();
		}
	
	public void spherePlaced(ThrowSphere s)
		{
		if(doorTimer==0)
			{
			mySphere = s;
			Audio.get("kick").play();
			doorTimer = 1;
			s.isInDoor = true;
			}
		}
	
	public void step()
		{
		super.step();
		
		for(int i=0; i<4; i++)
			{
			line[i].pos.set(pos).add(xScale*xx[i],yScale*yy[i],0);
			line[i].pos2.set(pos).add(xScale*xx[i+1],yScale*yy[i+1],0);
			line[i].speed.set(speed);
			line[i].speed2.set(speed);
			}
		if(doorTimer>0 && doorTimer<60)
			{
			doorTimer++;
			if(doorTimer>=60)
				{
				Audio.get("door").play();
				doorTimer = 60;
				}
			}
		if(doorTimer == 60)
			{
			if(pos.y()<origPos.y()+yScale*112)
				speed.add(0,0.5,0);
			else if(speed.y()>0)
				speed.add(0,-0.5,0);
			else
				speed.set(0,0,0);
			}
		
		color[1] = 1f-(float)doorTimer/60;
		color[2] = 1f-(float)doorTimer/60;
		if(mySphere!=null)
			mySphere.color = color.clone();
		}
	}

