package game;

import javax.media.opengl.GL2;

import graphics.GFX;
import calc.V3D;
import mechanics.Entity;

public class Celestia extends Entity
	{
	double bodyTimer = 0;
	double hairTimer = 0;
	public Celestia(V3D pos)
		{
		super(pos);
		tex = GFX.tex("celestia");
		xScale = 0.22f;
		yScale = 0.22f;
		
		orientation = GFX.SOUTHWEST;
		}
	public void step()
		{
		yScale = 0.22f+0.0022f*(float)Math.sin(bodyTimer);
		bodyTimer+=Math.PI*2/100;
		if(bodyTimer>Math.PI*2)
			bodyTimer-=Math.PI*2;
		hairTimer+=Math.PI*2/45;
		if(hairTimer>Math.PI*2)
			hairTimer-=Math.PI*2;
		}
	
	public void render()
		{
		GL2 gl = GFX.gl;
		gl.glPushMatrix();
		gl.glTranslated(pos.x(), pos.y(), 0);
		gl.glScaled(xScale, yScale, 1);
		gl.glColor3f(1,1,1);
		GFX.tex("celestiaHair").enable(0);
		gl.glBegin(GL2.GL_TRIANGLE_STRIP);
		int LEN = 369;
		int MM = 32;
		double px = 344;
		double py = -270;
		double dir = Math.PI/4;
		for(int i=0; i<=MM; i++)
			{
			double r1 = Math.sin(Math.PI*Math.pow((double)i/MM,0.75))*(112+24*Math.sin(hairTimer+5*Math.PI*(1-(double)i/MM)));
			double r2 = Math.sin(Math.PI*Math.pow((double)i/MM,2))*64*(1-(double)i/MM);
			double h = Math.cos(dir-Math.PI/2);
			double v = -Math.sin(dir-Math.PI/2);
			gl.glTexCoord2d((float)i/MM, 0);
			gl.glVertex2d(px-h*r1, py-v*r1);
			gl.glTexCoord2d((float)i/MM, 1);
			gl.glVertex2d(px+h*r2, py+v*r2+r2*(0.5+Math.cos(hairTimer+Math.PI*3*(double)i/MM)/2));
			
			px+=Math.cos(dir)*LEN/MM;
			py-=Math.sin(dir)*LEN/MM;
			dir -= (Math.PI/4+Math.PI/2)/MM;
			}
		gl.glEnd();
		gl.glBegin(GL2.GL_TRIANGLE_STRIP);
		
		LEN = 512;
		MM = 32;
		px = 240;
		py = -(512-96);
		dir = Math.PI*5/6;
		for(int i=0; i<=MM; i++)
			{
			double r1 = Math.sin(Math.PI*Math.pow((double)i/MM,0.75))*(136+16*Math.sin(hairTimer+3*Math.PI*(1-(double)i/MM)));
			double r2 = Math.sin(Math.PI*Math.pow((double)i/MM,2))*(64*(1-(double)i/MM)+16*Math.cos(hairTimer+Math.PI*7*(double)i/MM));
			double h = Math.cos(dir-Math.PI/2);
			double v = -Math.sin(dir-Math.PI/2);
			gl.glTexCoord2d((float)i/MM, 1);
			gl.glVertex2d(px-h*r1, py-v*r1);
			gl.glTexCoord2d((float)i/MM, 0);
			gl.glVertex2d(px+h*r2, py+v*r2);
			
			px+=Math.cos(dir)*LEN/MM;
			py-=Math.sin(dir)*LEN/MM;
			dir += (Math.PI*1/6+Math.PI/2)/MM;
			}
		gl.glEnd();
		
		GFX.tex("celestiaHair").disable();
		gl.glPopMatrix();

		color[0]= 0.9f;
		color[1]= 0.9f;
		color[1]= 0.9f;
		super.render();
		gl.glColor3f(1,1,1);
		GFX.drawTexture(GFX.tex("smartypants"), 0, (float)pos.x()+133*xScale, (float)pos.y()-(512-174)*yScale, 0, GFX.NORTHWEST, xScale, yScale, 0);
		}
	}

