package game;

import audio.Audio;
import calc.V3D;
import mechanics.Entity;

public class Cave extends Entity
	{
	double black = 1;
	double fade = 0;
	V3D ponyStart;
	int sTimer = 0;
	int bTimer = 0;
	
	int winTimer = 0;
	public Cave(V3D pos)
		{
		super(pos);

		ponyStart = new V3D(96,0,0);
		new Pony(ponyStart.clone());
		//new ThrowSphere(ponyStart.clone().add(96,0,0));
		//new Door(ponyStart.clone().add(256,32,0));
		new ThrowSphere(new V3D(4165,705,0));
		new Door(new V3D(4734,742,0));
		
		new ThrowSphere(new V3D(5175,176,0));
		new Door(new V3D(6216,560,0));
		
		new Terrain(new V3D());
		new MagicPointer(ponyStart.clone());
		View.extCam = false;
		View.x = Pony.me.pos.x()-160;
		View.y = Pony.me.pos.y()+480;
		new Platform(new V3D(2177,-212,0),true);
		new Platform(new V3D(5356,611,0),false);
		}
	
	public void step()
		{
		final int MAX = 17000;
		if(Pony.me.pos.x()>MAX)
			{
			if(winTimer==0)
				{
				Audio.get("splode").play();
				Overlay.white = 1;
				Root.music.stop();MagicPointer.me.destroy();
				if(Evil.me!=null)
					Evil.me.destroy();
				Terrain.me.destroy();
				for(Door d: Door.list)
					d.destroy();
				Object[] tmp = Grabbable.list.toArray();
				for(Object d: tmp)
					{if(d instanceof Entity)
						((Entity)d).destroy();}
				Root.recover();
				new Line(Pony.me.pos.clone().add(-1024,Pony.me.radius,0),Pony.me.pos.clone().add(1024,Pony.me.radius,0));
				Line l = new Line(Pony.me.pos.clone().add(-512,Pony.me.radius,0),Pony.me.pos.clone().add(-512,-1024,0));
				l.visible = false;
				
				}
			if(winTimer==2)
				{
				Overlay.white = 0;
				destroy();
				new Outro(Pony.me.pos.clone().add(1024,Pony.me.radius,0));
				}
			winTimer++;
			}
		else
			{
			if(Pony.me.pos.x()>4751 && ponyStart.x()<4751)
				{
				ponyStart.set(Pony.me.pos);//CHECKPOINT
				}
			if(Evil.me == null && Pony.me.pos.x()>7200)
				new Evil(new V3D(6600,0,0));
			int targetCorruption = 0;
			if(Pony.me.pos.x()>3000 && Pony.me.pos.x()<6200)
				targetCorruption = 1+(int)((Pony.me.pos.x()-3000)*11/(6200-3000));
			else if(Pony.me.pos.x()>8000 && bTimer<20 && sTimer==0)
				targetCorruption = 12+(int)((Pony.me.pos.x()-8000)/256);
			if(Pony.me.pos.x()>7200)
				{
				if(Math.random()*120<1+(Pony.me.pos.x()-7200)/2000)
					new ShadowPony(new V3D(View.x+View.width*Math.random()*2,642,0));
				}
			sTimer++;
			if(sTimer>2)
				sTimer=0;
			bTimer++;
			if(bTimer>180)
				bTimer=0;
				
			if(targetCorruption>Root.corruption)
				Root.corrupt();
			if(black>0)
				{
				black-=1d/60;
				if(black<=0)
					{
					black = 0;
					Root.music.play();
					}
				Overlay.white = -black;
				}
			if(Pony.me.pos.y()>1366)
				{
				if(fade==0)
					Audio.get("fall").play();
				fade+=1d/30;
				if(fade>=1)
					{
					fade = 0;
					Pony.me.pos.set(ponyStart);
					Pony.me.speed.set(0,0,0);
					View.x = Pony.me.pos.x()-160;
					View.y = Pony.me.pos.y()+480;
					MagicPointer.me.pos.set(ponyStart);
					}
				Overlay.white = -fade;
				}
			}
		}

	}
