package game;

import java.util.ArrayList;

import graphics.GFX;
import calc.V3D;
import mechanics.*;

public abstract class Ball extends Entity
	{
	public static ArrayList<Ball> balls = new ArrayList<Ball>();
	
	double nx, ny, gnd, radius;
	V3D nullSpeed;
	public Ball(V3D pos)
		{
		super(pos);
		balls.add(this);
		nullSpeed = new V3D();
		nx = 0;
		ny = -1;
		gnd = 0;
		radius = 16;
		tex = GFX.tex("circle32");
		}
	@Override
	public void destroy()
		{
		super.destroy();
		balls.remove(this);
		}
	@Override
	public void step()
		{
    	speed.p[1] += Scene.gravity;
    	speed.accelerate(-speed.sqLen()*Scene.air);
    	
		if(gnd>0)
			gnd-=1d/8;
		else
			{
			gnd=0;
			nullSpeed.set(0,0,0);
			}
		super.step();
		}
	public boolean line(V3D p1, V3D s1, int r1, V3D p2, V3D s2, int r2, double friction, boolean ground, boolean handle)
		{
		double padding = +r1+r2+radius+speed.sqLen();
		double ix = Math.min(p1.x(), p2.x())-padding,iy = Math.min(p1.y(), p2.y())-padding,
			   ax = Math.max(p1.x(), p2.x())+padding,ay = Math.max(p1.y(), p2.y())+padding;
		if(pos.x()>ix && pos.y()>iy && pos.x()<ax && pos.y()<ay)
			{
			V3D diff = pos.clone().sub(p1);
			double lineLen = p1.distance(p2);
			V3D unit = p2.clone().sub(p1).multiply(1/lineLen);
			double dot = unit.dot(diff);
			boolean testWithSpeed = true;
			if(dot<0) {dot = 0; testWithSpeed = false;}
			if(dot>lineLen) {dot = lineLen; testWithSpeed = false;}
			double rad = r1*(1-dot/lineLen)+r2*dot/lineLen;
			V3D sp = s1.clone().multiply(1-dot/lineLen).add(s2,dot/lineLen); 
			
			V3D closest = p1.clone().add(unit,dot);
			V3D normal = pos.clone().sub(closest).normalize();
			double speedDot = speed.clone().sub(sp).dot(normal);
			if(speedDot<0.001 && closest.distance(pos)<rad+radius+((testWithSpeed)?-speedDot:speedDot/2))
				{
				if(handle)
					collision(closest,normal,rad,sp,friction,ground);
				return true;
				}
			}
		return false;
		}
	protected void collision(V3D point, V3D normal, double addNormal, V3D pointSpeed, double friction, boolean ground)
		{
		pos.set(point).add(normal,addNormal+radius);
		V3D spDiff = speed.clone().sub(pointSpeed);
		double f = -spDiff.dot(normal);
		speed.add(normal,f);
		speed.accelerateTowards(pointSpeed, Math.min(0.125*(1-normal.y()),Math.abs(f*friction)));
		if((gnd<1 && (normal.p[1]<-0.1 || normal.dot(new V3D(nx,ny,0))>0.5)) || normal.p[1]<ny)
			{
			nullSpeed.set(pointSpeed);
			nx = normal.x();
			ny = normal.y();
			gnd = 1;
			}
		}
	}
