package game;

import graphics.GFX;
import calc.V3D;
import mechanics.DestructionListener;
import mechanics.Entity;
import mechanics.Scene;

public class Attachment extends Entity implements DestructionListener
	{
	Entity p;
	double dist;
	public Attachment(V3D pos, Entity parent, double dist)
		{
		super(pos);
		this.p = parent;
		parent.addDestructionListener(this);
		this.dist = dist;
		tex = GFX.tex("circle32");
		visible = false;
		}
	public void step()
		{
		speed.p[1] += Scene.gravity*2;
		speed.accelerate(-speed.sqLen()*Scene.air*2);
		speed.accelerate(-0.05);
		V3D diff = pos.clone().sub(p.pos);
		double d = diff.len();
		if(d>dist)
			{
			pos = p.pos.clone().add(diff,dist/d);
			diff.multiply(1d/d);
			V3D speedDiff = speed.clone().add(p.speed,-0.5);
			speed.add(diff,-speedDiff.dot(diff));
			}
		super.step();
		}
	@Override
	public void instanceDestroyed(Entity e)
		{
		destroy();
		}
	

	}
