package calc;
/**
 * This class is used as a key when messing with faces in the obj loader.
 * More specifically, it is used to identify which tuples of (vertex,normal,texCoord) alreay exist.
 * */
public class FaceKey
	{
	public int vertex,normal,texCoord;
	
	public FaceKey(int v, int n, int t)
		{
		vertex=v;
		normal=n;
		texCoord=t;
		}
	
	public boolean equals(Object o)
		{
		if (o instanceof FaceKey)
			return (((FaceKey) o).vertex==vertex && ((FaceKey) o).normal==normal && ((FaceKey) o).texCoord==texCoord);
		else
			return false;
		}
	public int hashCode()
		{
		return (vertex*16000+normal)*16000+texCoord;
		}
	}
