package audio;


import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import javax.sound.sampled.LineUnavailableException;
import main.Main;

public class Audio
	{
	public static Audio audio;
	
	/**Pure java custom sound mixer implementation*/
	public static AudioLine line;
	/**Pure java custom sound clip implementation*/
	private static HashMap<String,StupidClip> soundsJ;

	private static ArrayList<JavaSoundListener> listeners;
	
	

	public Audio()
		{
		audio=this;
		listeners = new ArrayList<JavaSoundListener>();
		
		try
			{
			System.out.println("Initializing JavaSound");
			line = new AudioLine(Main.sampleRate,Main.audioBuffer);
			}
		catch (LineUnavailableException e)
			{
			Main.error("Could not create java sound output!\n" +
					"Try changing sampleRate in the settings file.\n" +
					"Recommended values are 44100 or 22050.", "JavaSound error");
			throw new RuntimeException("Could not create Java Sound output!");
			}
		soundsJ = new HashMap<String,StupidClip>();
		
		loadDir("res/sounds");
		}
	
	public synchronized static StupidClip get(String name)
		{
		return soundsJ.get(name);
		}
	public synchronized static StupidClip[] getAll()
		{
		ArrayList<StupidClip> list = new ArrayList<StupidClip>();
		Iterator<Entry<String, StupidClip>> it = soundsJ.entrySet().iterator();
	    while (it.hasNext()) 
	    	{
	        Map.Entry<String, StupidClip> pairs = (Map.Entry<String, StupidClip>)it.next();
	        list.add(pairs.getValue());
	    	}
	    StupidClip[] arr = new StupidClip[list.size()];
	    list.toArray(arr);
	    return arr;
		}
	
	public synchronized static void loadDir(String dirName)
		{
		File dir = new File(dirName);
		System.out.print("Load sound dir: "+dirName+" ... ");
		if(dir.isDirectory()) 
			{
			String filenames[] = dir.list();
			for (String file : filenames)
				{
				if(file.toLowerCase().endsWith(".ogg") || file.toLowerCase().endsWith(".wav"))
					load(dirName,file);
				}
			}
		System.out.println("... done.");
		}
	
	public synchronized static void unloadDir(String dirName)
		{
		File dir = new File(dirName);
		System.out.print("Unloading sound dir: "+dirName+" ... ");
		if(dir.isDirectory()) 
			{
			String filenames[] = dir.list();
			for (String file : filenames)
				{
				if(file.toLowerCase().endsWith(".ogg") || file.toLowerCase().endsWith(".wav"))
					unload(file);
				}
			}
		System.out.println("... done.");
		}
	
	private static void unload(String name)
		{
		//Find the name without the file extension.
		String key;
		int pos = name.length()-1;
		while (name.charAt(pos)!='.' && pos>0) pos-=1;
		if (pos == 0)
			return;
		key = name.substring(0, pos);
		
		delete(key);
		}

	public synchronized static void delete(String name)
		{
		StupidClip s = soundsJ.get(name);
		s.stop();
		soundsJ.remove(name);
		}

	public synchronized static void load(String dirName,String name)
		{
		//Find the name without the file extension.
		String key,format;
		int pos = name.length()-1;
		while (name.charAt(pos)!='.' && pos>0) pos-=1;
		if (pos == 0)
			return;
		key = name.substring(0, pos);
		format = name.substring(pos+1,name.length());
		
		//load and insert into HashMap
		System.out.print(name + " ");
		try
			{if((format.toLowerCase()).equals("ogg"))
				{
				soundsJ.put(key,StupidClip.loadOgg(dirName+"/"+name, line));
				}
			else
				{
				soundsJ.put(key,StupidClip.loadWav(dirName+"/"+name, line));
				}
			}
		catch (Exception e)
			{System.out.println("Missing or corrupt audio");
			e.printStackTrace();}
		}

	public static void addJavaSoundListener(JavaSoundListener l)
		{
		listeners.add(l);
		}
	public static void removeJavaSoundListener(JavaSoundListener l)
		{
		listeners.remove(l);
		}
	static void soundStop(StupidClip c, int milliseconds)
		{
		for(JavaSoundListener l: listeners)
			l.soundStop(c, milliseconds);
		}
	public static AudioLine getLine()
		{
		return line;
		}
	}