Scriptname CaN:CaNStartupScript extends Quest

Actor Property PlayerREF Auto Hidden
Quest Property aaaCaNStartupQuest Auto Const

Idle Property ElevatorFaceCamera Auto Const
Idle Property ElevatorBodyCamera Auto Const
InputEnableLayer Property CaNInputLayer Auto Hidden
Keyword Property AnimFaceArchetypePlayer Auto Const

Message Property aaaCaNStartupMenuHumanMsg Auto Const
Message Property aaaCaNStartupPowerArmorMsg Auto Const
Message Property aaaCaNStartupCombatMsg Auto Const

Int ButtonPressed = 0

Function InitCaNStartupMenu()
	If PlayerREF.IsInPowerArmor()
		aaaCaNStartupPowerArmorMsg.Show()
		Game.ForceFirstPerson()
		aaaCaNStartupQuest.Stop()
	ElseIf PlayerREF.IsInCombat()
		aaaCaNStartupCombatMsg.Show()
		Game.ForceFirstPerson()
		aaaCaNStartupQuest.Stop()
	Else
		PlayerREF.SetHasCharGenSkeleton(True)
		RegisterForMenuOpenCloseEvent("LooksMenu")
		RegisterForLooksMenuEvent()
		CaNInputLayer = InputEnableLayer.Create()
		CaNInputLayer.DisablePlayerControls()
		Game.ForceThirdPerson()
		Utility.Wait(0.5)
		PlayerREF.ChangeAnimFaceArchetype(None)
		PlayerREF.PlayIdle(ElevatorFaceCamera)
		Utility.Wait(1.5)
		OpenCaNStartupMenu()
	EndIf
EndFunction

Function OpenCaNStartupMenu()
	ButtonPressed = aaaCaNStartupMenuHumanMsg.Show()
	If ButtonPressed == 0
		OpenCaNCharGenMenu()
	ElseIf ButtonPressed == 1
		CloseCaNStartupMenu()
	EndIf
EndFunction

Function OpenCaNCharGenMenu()
	Utility.Wait(0.5)
	Game.ShowRaceMenu(uiMode = 1)
EndFunction

Function CloseCaNStartupMenu()
	PlayerREF.SetHasCharGenSkeleton(False)
	CaNInputLayer.EnablePlayerControls()
	CaNInputLayer = None
	UnRegisterForMenuOpenCloseEvent("LooksMenu")
	UnRegisterForLooksMenuEvent()
	Utility.Wait(0.5)
	PlayerREF.ChangeAnimFaceArchetype(AnimFaceArchetypePlayer)
	Game.ForceFirstPerson()
	aaaCaNStartupQuest.Stop()
EndFunction

Event OnQuestInit()
	PlayerREF = Game.GetPlayer()
	InitCaNStartupMenu()
EndEvent

Event OnLooksMenuEvent(Int aiFlavor)
	If (aiFlavor == 10)
		PlayerREF.PlayIdle(ElevatorBodyCamera)
	ElseIf (aiFlavor == 11)
		PlayerREF.PlayIdle(ElevatorFaceCamera)
	EndIf
EndEvent

Event OnMenuOpenCloseEvent(String asMenuName, Bool abOpening)
	If (asMenuName== "LooksMenu")
		If (abOpening==False)
			Utility.Wait(0.5)
			OpenCaNStartupMenu()
		EndIf
	EndIf
EndEvent