Scriptname CaN:CaNRaceFixEffectScript extends activemagiceffect

Actor Property selfRef Auto Hidden
Race Property CaNRace Auto Const
Spell Property CaNRaceFix Auto Const
Float Property CaNHeightF Auto Const
Float Property CaNHeightM Auto Const

Int TimerID = 1

Bool IsInPA

Event OnEffectStart(Actor Target, Actor Caster)
	selfRef = Target
	If (selfRef == Game.GetPlayer()) && (selfRef.GetRace() == CaNRace)
		If selfRef.IsInPowerArmor() == False
			If selfRef.GetActorBase().GetSex() == 0
				selfRef.SetScale(CaNHeightM)
			Else
				selfRef.SetScale(CaNHeightF)
			EndIf
			IsInPA = False
			selfRef.SetHasCharGenSkeleton(True)
		Else
			IsInPA = True
			selfRef.SetHasCharGenSkeleton(False)
		EndIf
		StartTimer(2, TimerID)
	Else
		selfRef.RemoveSpell(CaNRaceFix)
	EndIf
EndEvent

Event OnEffectFinish(Actor Target, Actor Caster)
	CancelTimer(TimerID)
	If selfRef == Game.GetPlayer()
		selfRef.SetScale(1)
	EndIf
EndEvent

Event OnTimer(int aiTimerID)
	If selfRef.GetRace() == CaNRace
		If selfRef.IsInPowerArmor() == False
			If (selfRef.GetActorBase().GetSex() == 0) && (selfRef.GetScale() != CaNHeightM)
				selfRef.SetScale(CaNHeightM)
			ElseIf (selfRef.GetActorBase().GetSex() == 1) && (selfRef.GetScale() != CaNHeightF)
				selfRef.SetScale(CaNHeightF)
			EndIf
			If IsInPA == True
				Utility.Wait(3)
				selfRef.SetHasCharGenSkeleton(False)
				selfRef.SetHasCharGenSkeleton(True)
				IsInPA = False
			EndIf
		ElseIf IsInPA == False
				selfRef.SetHasCharGenSkeleton(False)
				IsInPA = True
		EndIf
		StartTimer(2, TimerID)
	Else
		selfRef.RemoveSpell(CaNRaceFix)
	EndIf
EndEvent

Event OnPlayerLoadGame()
	If selfRef.IsInPowerArmor() == False
		selfRef.SetHasCharGenSkeleton(True)
	EndIf
EndEvent
