#ifndef KEYBINDINGS_H
#define KEYBINDINGS_H

#include <SDL/SDL.h>
#include <map>
#include <string>

#include "bimap.h"

typedef long InterfaceKey;

enum InterfaceKeyType
{
	INTERFACEKEY_NONE=0,
	INTERFACEKEY_SELECT,
	INTERFACEKEY_SEC_SELECT,
	INTERFACEKEY_DESELECT,
	INTERFACEKEY_SELECT_ALL,
	INTERFACEKEY_DESELECT_ALL,
	INTERFACEKEY_LEAVESCREEN,
	INTERFACEKEY_LEAVESCREEN_ALL,
	INTERFACEKEY_CLOSE_MEGA_ANNOUNCEMENT,
	INTERFACEKEY_OPTIONS,
	INTERFACEKEY_OPTION_EXPORT,
	INTERFACEKEY_HELP,
	INTERFACEKEY_TOGGLE_FULLSCREEN,
	INTERFACEKEY_MOVIES,
	INTERFACEKEY_ZOOM_IN,
	INTERFACEKEY_ZOOM_OUT,
	INTERFACEKEY_ZOOM_TOGGLE,
	INTERFACEKEY_ZOOM_RESET,
	INTERFACEKEY_MOVIE_RECORD,
	INTERFACEKEY_MOVIE_PLAY,
	INTERFACEKEY_MOVIE_SAVE,
	INTERFACEKEY_MOVIE_LOAD,
	INTERFACEKEY_TOGGLE_TTF,
	INTERFACEKEY_FPS_UP,
	INTERFACEKEY_FPS_DOWN,
	INTERFACEKEY_CHANGETAB,
	INTERFACEKEY_SEC_CHANGETAB,
	INTERFACEKEY_STANDARDSCROLL_UP,
	INTERFACEKEY_STANDARDSCROLL_DOWN,
	INTERFACEKEY_STANDARDSCROLL_LEFT,
	INTERFACEKEY_STANDARDSCROLL_RIGHT,
	INTERFACEKEY_STANDARDSCROLL_PAGEUP,
	INTERFACEKEY_STANDARDSCROLL_PAGEDOWN,
	INTERFACEKEY_SECONDSCROLL_UP,
	INTERFACEKEY_SECONDSCROLL_DOWN,
	INTERFACEKEY_SECONDSCROLL_PAGEUP,
	INTERFACEKEY_SECONDSCROLL_PAGEDOWN,
	INTERFACEKEY_CURSOR_UP,
	INTERFACEKEY_CURSOR_DOWN,
	INTERFACEKEY_CURSOR_LEFT,
	INTERFACEKEY_CURSOR_RIGHT,
	INTERFACEKEY_CURSOR_UPLEFT,
	INTERFACEKEY_CURSOR_UPRIGHT,
	INTERFACEKEY_CURSOR_DOWNLEFT,
	INTERFACEKEY_CURSOR_DOWNRIGHT,
	INTERFACEKEY_CURSOR_UP_FAST,
	INTERFACEKEY_CURSOR_DOWN_FAST,
	INTERFACEKEY_CURSOR_LEFT_FAST,
	INTERFACEKEY_CURSOR_RIGHT_FAST,
	INTERFACEKEY_CURSOR_UPLEFT_FAST,
	INTERFACEKEY_CURSOR_UPRIGHT_FAST,
	INTERFACEKEY_CURSOR_DOWNLEFT_FAST,
	INTERFACEKEY_CURSOR_DOWNRIGHT_FAST,
	INTERFACEKEY_CURSOR_UP_Z,
	INTERFACEKEY_CURSOR_DOWN_Z,
	INTERFACEKEY_CURSOR_UP_Z_AUX,
	INTERFACEKEY_CURSOR_DOWN_Z_AUX,
	INTERFACEKEY_MENU_CONFIRM,
	INTERFACEKEY_SAVE_BINDINGS,
	INTERFACEKEY_LOAD_BINDINGS,
	INTERFACEKEY_MACRO_BREAK,
	INTERFACEKEY_RECORD_MACRO,
	INTERFACEKEY_PLAY_MACRO,
	INTERFACEKEY_SAVE_MACRO,
	INTERFACEKEY_LOAD_MACRO,
	INTERFACEKEY_PREFIX,
	INTERFACEKEY_OPTION1,
	INTERFACEKEY_OPTION2,
	INTERFACEKEY_OPTION3,
	INTERFACEKEY_OPTION4,
	INTERFACEKEY_OPTION5,
	INTERFACEKEY_OPTION6,
	INTERFACEKEY_OPTION7,
	INTERFACEKEY_OPTION8,
	INTERFACEKEY_OPTION9,
	INTERFACEKEY_OPTION10,
	INTERFACEKEY_OPTION11,
	INTERFACEKEY_OPTION12,
	INTERFACEKEY_OPTION13,
	INTERFACEKEY_OPTION14,
	INTERFACEKEY_OPTION15,
	INTERFACEKEY_OPTION16,
	INTERFACEKEY_OPTION17,
	INTERFACEKEY_OPTION18,
	INTERFACEKEY_OPTION19,
	INTERFACEKEY_OPTION20,
	INTERFACEKEY_SEC_OPTION1,
	INTERFACEKEY_SEC_OPTION2,
	INTERFACEKEY_SEC_OPTION3,
	INTERFACEKEY_SEC_OPTION4,
	INTERFACEKEY_SEC_OPTION5,
	INTERFACEKEY_SEC_OPTION6,
	INTERFACEKEY_SEC_OPTION7,
	INTERFACEKEY_SEC_OPTION8,
	INTERFACEKEY_SEC_OPTION9,
	INTERFACEKEY_SEC_OPTION10,
	INTERFACEKEY_SEC_OPTION11,
	INTERFACEKEY_SEC_OPTION12,
	INTERFACEKEY_SEC_OPTION13,
	INTERFACEKEY_SEC_OPTION14,
	INTERFACEKEY_SEC_OPTION15,
	INTERFACEKEY_SEC_OPTION16,
	INTERFACEKEY_SEC_OPTION17,
	INTERFACEKEY_SEC_OPTION18,
	INTERFACEKEY_SEC_OPTION19,
	INTERFACEKEY_SEC_OPTION20,
	INTERFACEKEY_CUSTOM_A,
	INTERFACEKEY_CUSTOM_B,
	INTERFACEKEY_CUSTOM_C,
	INTERFACEKEY_CUSTOM_D,
	INTERFACEKEY_CUSTOM_E,
	INTERFACEKEY_CUSTOM_F,
	INTERFACEKEY_CUSTOM_G,
	INTERFACEKEY_CUSTOM_H,
	INTERFACEKEY_CUSTOM_I,
	INTERFACEKEY_CUSTOM_J,
	INTERFACEKEY_CUSTOM_K,
	INTERFACEKEY_CUSTOM_L,
	INTERFACEKEY_CUSTOM_M,
	INTERFACEKEY_CUSTOM_N,
	INTERFACEKEY_CUSTOM_O,
	INTERFACEKEY_CUSTOM_P,
	INTERFACEKEY_CUSTOM_Q,
	INTERFACEKEY_CUSTOM_R,
	INTERFACEKEY_CUSTOM_S,
	INTERFACEKEY_CUSTOM_T,
	INTERFACEKEY_CUSTOM_U,
	INTERFACEKEY_CUSTOM_V,
	INTERFACEKEY_CUSTOM_W,
	INTERFACEKEY_CUSTOM_X,
	INTERFACEKEY_CUSTOM_Y,
	INTERFACEKEY_CUSTOM_Z,
	INTERFACEKEY_CUSTOM_SHIFT_A,
	INTERFACEKEY_CUSTOM_SHIFT_B,
	INTERFACEKEY_CUSTOM_SHIFT_C,
	INTERFACEKEY_CUSTOM_SHIFT_D,
	INTERFACEKEY_CUSTOM_SHIFT_E,
	INTERFACEKEY_CUSTOM_SHIFT_F,
	INTERFACEKEY_CUSTOM_SHIFT_G,
	INTERFACEKEY_CUSTOM_SHIFT_H,
	INTERFACEKEY_CUSTOM_SHIFT_I,
	INTERFACEKEY_CUSTOM_SHIFT_J,
	INTERFACEKEY_CUSTOM_SHIFT_K,
	INTERFACEKEY_CUSTOM_SHIFT_L,
	INTERFACEKEY_CUSTOM_SHIFT_M,
	INTERFACEKEY_CUSTOM_SHIFT_N,
	INTERFACEKEY_CUSTOM_SHIFT_O,
	INTERFACEKEY_CUSTOM_SHIFT_P,
	INTERFACEKEY_CUSTOM_SHIFT_Q,
	INTERFACEKEY_CUSTOM_SHIFT_R,
	INTERFACEKEY_CUSTOM_SHIFT_S,
	INTERFACEKEY_CUSTOM_SHIFT_T,
	INTERFACEKEY_CUSTOM_SHIFT_U,
	INTERFACEKEY_CUSTOM_SHIFT_V,
	INTERFACEKEY_CUSTOM_SHIFT_W,
	INTERFACEKEY_CUSTOM_SHIFT_X,
	INTERFACEKEY_CUSTOM_SHIFT_Y,
	INTERFACEKEY_CUSTOM_SHIFT_Z,
	INTERFACEKEY_CUSTOM_CTRL_A,
	INTERFACEKEY_CUSTOM_CTRL_B,
	INTERFACEKEY_CUSTOM_CTRL_C,
	INTERFACEKEY_CUSTOM_CTRL_D,
	INTERFACEKEY_CUSTOM_CTRL_E,
	INTERFACEKEY_CUSTOM_CTRL_F,
	INTERFACEKEY_CUSTOM_CTRL_G,
	INTERFACEKEY_CUSTOM_CTRL_H,
	INTERFACEKEY_CUSTOM_CTRL_I,
	INTERFACEKEY_CUSTOM_CTRL_J,
	INTERFACEKEY_CUSTOM_CTRL_K,
	INTERFACEKEY_CUSTOM_CTRL_L,
	INTERFACEKEY_CUSTOM_CTRL_M,
	INTERFACEKEY_CUSTOM_CTRL_N,
	INTERFACEKEY_CUSTOM_CTRL_O,
	INTERFACEKEY_CUSTOM_CTRL_P,
	INTERFACEKEY_CUSTOM_CTRL_Q,
	INTERFACEKEY_CUSTOM_CTRL_R,
	INTERFACEKEY_CUSTOM_CTRL_S,
	INTERFACEKEY_CUSTOM_CTRL_T,
	INTERFACEKEY_CUSTOM_CTRL_U,
	INTERFACEKEY_CUSTOM_CTRL_V,
	INTERFACEKEY_CUSTOM_CTRL_W,
	INTERFACEKEY_CUSTOM_CTRL_X,
	INTERFACEKEY_CUSTOM_CTRL_Y,
	INTERFACEKEY_CUSTOM_CTRL_Z,
	INTERFACEKEY_CUSTOM_ALT_A,
	INTERFACEKEY_CUSTOM_ALT_B,
	INTERFACEKEY_CUSTOM_ALT_C,
	INTERFACEKEY_CUSTOM_ALT_D,
	INTERFACEKEY_CUSTOM_ALT_E,
	INTERFACEKEY_CUSTOM_ALT_F,
	INTERFACEKEY_CUSTOM_ALT_G,
	INTERFACEKEY_CUSTOM_ALT_H,
	INTERFACEKEY_CUSTOM_ALT_I,
	INTERFACEKEY_CUSTOM_ALT_J,
	INTERFACEKEY_CUSTOM_ALT_K,
	INTERFACEKEY_CUSTOM_ALT_L,
	INTERFACEKEY_CUSTOM_ALT_M,
	INTERFACEKEY_CUSTOM_ALT_N,
	INTERFACEKEY_CUSTOM_ALT_O,
	INTERFACEKEY_CUSTOM_ALT_P,
	INTERFACEKEY_CUSTOM_ALT_Q,
	INTERFACEKEY_CUSTOM_ALT_R,
	INTERFACEKEY_CUSTOM_ALT_S,
	INTERFACEKEY_CUSTOM_ALT_T,
	INTERFACEKEY_CUSTOM_ALT_U,
	INTERFACEKEY_CUSTOM_ALT_V,
	INTERFACEKEY_CUSTOM_ALT_W,
	INTERFACEKEY_CUSTOM_ALT_X,
	INTERFACEKEY_CUSTOM_ALT_Y,
	INTERFACEKEY_CUSTOM_ALT_Z,

	WORLDKEY_START,
	INTERFACEKEY_WORLD_PARAM_TITLE=WORLDKEY_START,
	INTERFACEKEY_WORLD_PARAM_ADD,
	INTERFACEKEY_WORLD_PARAM_COPY,
	INTERFACEKEY_WORLD_PARAM_DELETE,
	INTERFACEKEY_WORLD_PARAM_NAME_RANDOM,
	INTERFACEKEY_WORLD_PARAM_NAME_ENTER,
	INTERFACEKEY_WORLD_PARAM_SEED_RANDOM,
	INTERFACEKEY_WORLD_PARAM_SEED_ENTER,
	INTERFACEKEY_WORLD_PARAM_LOAD,
	INTERFACEKEY_WORLD_PARAM_SAVE,
	INTERFACEKEY_WORLD_PARAM_DIM_X_UP,
	INTERFACEKEY_WORLD_PARAM_DIM_X_DOWN,
	INTERFACEKEY_WORLD_PARAM_DIM_Y_UP,
	INTERFACEKEY_WORLD_PARAM_DIM_Y_DOWN,
	INTERFACEKEY_WORLD_PARAM_SET,
	INTERFACEKEY_WORLD_PARAM_INCREASE,
	INTERFACEKEY_WORLD_PARAM_DECREASE,
	INTERFACEKEY_WORLD_PARAM_ENTER_VALUE,
	INTERFACEKEY_WORLD_PARAM_NULLIFY,
	INTERFACEKEY_WORLD_PARAM_PRESET,
	INTERFACEKEY_WORLD_PARAM_REJECT_CONTINUE,
	INTERFACEKEY_WORLD_PARAM_REJECT_ABORT,
	INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_THIS,
	INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_ALL,
	INTERFACEKEY_WORLD_GEN_CONTINUE,
	INTERFACEKEY_WORLD_GEN_USE,
	INTERFACEKEY_WORLD_GEN_ABORT,
	INTERFACEKEY_WORLDGEN_EXPORT_MAP,
	INTERFACEKEY_LEGENDS_EXPORT_MAP,
	INTERFACEKEY_LEGENDS_EXPORT_XML,
	INTERFACEKEY_LEGENDS_EXPORT_DETAILED_MAP,
	INTERFACEKEY_LEGENDS_TOGGLE_CIVSITE,
	INTERFACEKEY_LEGENDS_STRING_FILTER,

	ADVENTURERKEY_START,
	INTERFACEKEY_A_RETURN_TO_ARENA=ADVENTURERKEY_START,
	INTERFACEKEY_A_MOVE_N,
	INTERFACEKEY_A_MOVE_S,
	INTERFACEKEY_A_MOVE_E,
	INTERFACEKEY_A_MOVE_W,
	INTERFACEKEY_A_MOVE_NW,
	INTERFACEKEY_A_MOVE_NE,
	INTERFACEKEY_A_MOVE_SW,
	INTERFACEKEY_A_MOVE_SE,
	INTERFACEKEY_A_MOVE_SAME_SQUARE,
	INTERFACEKEY_A_CARE_MOVE_N,
	INTERFACEKEY_A_CARE_MOVE_S,
	INTERFACEKEY_A_CARE_MOVE_E,
	INTERFACEKEY_A_CARE_MOVE_W,
	INTERFACEKEY_A_CARE_MOVE_NW,
	INTERFACEKEY_A_CARE_MOVE_NE,
	INTERFACEKEY_A_CARE_MOVE_SW,
	INTERFACEKEY_A_CARE_MOVE_SE,
	INTERFACEKEY_A_CARE_MOVE_UPDOWN,
	INTERFACEKEY_A_MOVE_N_UP,
	INTERFACEKEY_A_MOVE_S_UP,
	INTERFACEKEY_A_MOVE_E_UP,
	INTERFACEKEY_A_MOVE_W_UP,
	INTERFACEKEY_A_MOVE_NW_UP,
	INTERFACEKEY_A_MOVE_NE_UP,
	INTERFACEKEY_A_MOVE_SW_UP,
	INTERFACEKEY_A_MOVE_SE_UP,
	INTERFACEKEY_A_MOVE_UP,
	INTERFACEKEY_A_MOVE_N_DOWN,
	INTERFACEKEY_A_MOVE_S_DOWN,
	INTERFACEKEY_A_MOVE_E_DOWN,
	INTERFACEKEY_A_MOVE_W_DOWN,
	INTERFACEKEY_A_MOVE_NW_DOWN,
	INTERFACEKEY_A_MOVE_NE_DOWN,
	INTERFACEKEY_A_MOVE_SW_DOWN,
	INTERFACEKEY_A_MOVE_SE_DOWN,
	INTERFACEKEY_A_MOVE_DOWN,
	INTERFACEKEY_A_MOVE_UP_AUX,
	INTERFACEKEY_A_MOVE_DOWN_AUX,
	INTERFACEKEY_A_COMBAT_ATTACK,
	INTERFACEKEY_A_COMBAT_DODGE,
	INTERFACEKEY_A_COMBAT_CHARGEDEF,
	INTERFACEKEY_A_STATUS,
	INTERFACEKEY_A_STATUS_WRESTLE,
	INTERFACEKEY_A_STATUS_CUSTOMIZE,
	INTERFACEKEY_A_STATUS_KILLS,
	INTERFACEKEY_A_STATUS_HEALTH,
	INTERFACEKEY_A_STATUS_ATT_SKILL,
	INTERFACEKEY_A_STATUS_DESC,
	INTERFACEKEY_A_CLEAR_ANNOUNCEMENTS,
	INTERFACEKEY_A_SLEEP,
	INTERFACEKEY_A_SLEEP_SLEEP,
	INTERFACEKEY_A_SLEEP_WAIT,
	INTERFACEKEY_A_SLEEP_DAWN,
	INTERFACEKEY_A_WAIT,
	INTERFACEKEY_A_ATTACK,
	INTERFACEKEY_A_ATTACK_CONFIRM,
	INTERFACEKEY_A_LOOK,
	INTERFACEKEY_A_SEARCH,
	INTERFACEKEY_A_TALK,
	INTERFACEKEY_A_INTERACT,
	INTERFACEKEY_A_ACTION,
	INTERFACEKEY_A_ACTION_CREATE,
	INTERFACEKEY_A_ACTION_BUTCHER,
	INTERFACEKEY_A_ACTION_ABILITY,
	INTERFACEKEY_A_ACTION_POWER,
	INTERFACEKEY_A_INV_LOOK,
	INTERFACEKEY_A_INV_REMOVE,
	INTERFACEKEY_A_INV_WEAR,
	INTERFACEKEY_A_INV_EATDRINK,
	INTERFACEKEY_A_INV_PUTIN,
	INTERFACEKEY_A_INV_DROP,
	INTERFACEKEY_A_GROUND,
	INTERFACEKEY_A_THROW,
	INTERFACEKEY_A_SHOOT,
	INTERFACEKEY_A_ANNOUNCEMENTS,
	INTERFACEKEY_A_COMBAT,
	INTERFACEKEY_A_MOVEMENT,
	INTERFACEKEY_A_MOVEMENT_SWIM,
	INTERFACEKEY_A_SNEAK,
	INTERFACEKEY_A_CENTER,
	INTERFACEKEY_A_COMPANIONS,
	INTERFACEKEY_A_BUILDING,
	INTERFACEKEY_A_TRAVEL,
	INTERFACEKEY_A_TRAVEL_SLEEP,
	INTERFACEKEY_A_TRAVEL_MAP,
	INTERFACEKEY_A_TRAVEL_HIDE_INSTRUCTIONS,
	INTERFACEKEY_A_DATE,
	INTERFACEKEY_A_WEATHER,
	INTERFACEKEY_A_TEMPERATURE,
	INTERFACEKEY_A_STANCE,
	INTERFACEKEY_A_ENTER_NAME,
	INTERFACEKEY_A_CUST_NAME,
	INTERFACEKEY_A_RANDOM_NAME,
	INTERFACEKEY_A_CHANGE_GENDER,
	INTERFACEKEY_A_END_TRAVEL,
	INTERFACEKEY_A_TRAVEL_CLOUDS,
	INTERFACEKEY_A_LOG,
	INTERFACEKEY_A_TRAVEL_LOG,
	INTERFACEKEY_A_LOG_TASKS,
	INTERFACEKEY_A_LOG_ENTITIES,
	INTERFACEKEY_A_LOG_SITES,
	INTERFACEKEY_A_LOG_SUBREGIONS,
	INTERFACEKEY_A_LOG_FEATURE_LAYERS,
	INTERFACEKEY_A_LOG_ZOOM_CURRENT_LOCATION,
	INTERFACEKEY_A_LOG_ZOOM_SELECTED,
	INTERFACEKEY_A_LOG_LINE,
	INTERFACEKEY_A_LOG_MAP,
	INTERFACEKEY_A_BARTER_VIEW,
	INTERFACEKEY_A_BARTER_CURRENCY_1,
	INTERFACEKEY_A_BARTER_CURRENCY_2,
	INTERFACEKEY_A_BARTER_TRADE,

	EMBARKKEY_START,
	INTERFACEKEY_SETUP_EMBARK=EMBARKKEY_START,
	INTERFACEKEY_SETUP_NAME_FORT,
	INTERFACEKEY_SETUP_NAME_GROUP,
	INTERFACEKEY_SETUP_RECLAIM,
	INTERFACEKEY_SETUP_FIND,
	INTERFACEKEY_SETUP_NOTES,
	INTERFACEKEY_SETUP_NOTES_TAKE_NOTES,
	INTERFACEKEY_SETUP_NOTES_DELETE_NOTE,
	INTERFACEKEY_SETUP_NOTES_CHANGE_SYMBOL_SELECTION,
	INTERFACEKEY_SETUP_NOTES_ADOPT_SYMBOL,
	INTERFACEKEY_SETUP_LOCAL_Y_UP,
	INTERFACEKEY_SETUP_LOCAL_Y_DOWN,
	INTERFACEKEY_SETUP_LOCAL_X_UP,
	INTERFACEKEY_SETUP_LOCAL_X_DOWN,
	INTERFACEKEY_SETUP_LOCAL_Y_MUP,
	INTERFACEKEY_SETUP_LOCAL_Y_MDOWN,
	INTERFACEKEY_SETUP_LOCAL_X_MUP,
	INTERFACEKEY_SETUP_LOCAL_X_MDOWN,
	INTERFACEKEY_SETUP_BIOME_1,
	INTERFACEKEY_SETUP_BIOME_2,
	INTERFACEKEY_SETUP_BIOME_3,
	INTERFACEKEY_SETUP_BIOME_4,
	INTERFACEKEY_SETUP_BIOME_5,
	INTERFACEKEY_SETUP_BIOME_6,
	INTERFACEKEY_SETUP_BIOME_7,
	INTERFACEKEY_SETUP_BIOME_8,
	INTERFACEKEY_SETUP_BIOME_9,
	INTERFACEKEY_CHOOSE_NAME_RANDOM,
	INTERFACEKEY_CHOOSE_NAME_CLEAR,
	INTERFACEKEY_CHOOSE_NAME_TYPE,
	INTERFACEKEY_SETUPGAME_NEW,
	INTERFACEKEY_SETUPGAME_VIEW,
	INTERFACEKEY_SETUPGAME_CUSTOMIZE_UNIT,
	INTERFACEKEY_SETUPGAME_SAVE_PROFILE,
	INTERFACEKEY_SETUPGAME_SAVE_PROFILE_ABORT,
	INTERFACEKEY_SETUPGAME_SAVE_PROFILE_GO,
	INTERFACEKEY_SETUPGAME_VIEW_PROFILE_PROBLEMS,

	BUILDINGKEY_START,
	INTERFACEKEY_BUILDJOB_ADD=BUILDINGKEY_START,
	INTERFACEKEY_BUILDJOB_CANCEL,
	INTERFACEKEY_BUILDJOB_PROMOTE,
	INTERFACEKEY_BUILDJOB_REPEAT,
	INTERFACEKEY_BUILDJOB_SUSPEND,
	INTERFACEKEY_BUILDJOB_WORKSHOP_PROFILE,
	INTERFACEKEY_BUILDJOB_WELL_FREE,
	INTERFACEKEY_BUILDJOB_WELL_SIZE,
	INTERFACEKEY_BUILDJOB_TARGET_FREE,
	INTERFACEKEY_BUILDJOB_TARGET_SIZE,
	INTERFACEKEY_BUILDJOB_TARGET_DOWN,
	INTERFACEKEY_BUILDJOB_TARGET_UP,
	INTERFACEKEY_BUILDJOB_TARGET_RIGHT,
	INTERFACEKEY_BUILDJOB_TARGET_LEFT,
	INTERFACEKEY_BUILDJOB_STATUE_ASSIGN,
	INTERFACEKEY_BUILDJOB_STATUE_FREE,
	INTERFACEKEY_BUILDJOB_STATUE_SIZE,
	INTERFACEKEY_BUILDJOB_CAGE_JUSTICE,
	INTERFACEKEY_BUILDJOB_CAGE_FREE,
	INTERFACEKEY_BUILDJOB_CAGE_SIZE,
	INTERFACEKEY_BUILDJOB_CAGE_ASSIGN_OCC,
	INTERFACEKEY_BUILDJOB_CAGE_WATER,
	INTERFACEKEY_BUILDJOB_CAGE_ASSIGN,
	INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN_OCC,
	INTERFACEKEY_BUILDJOB_CHAIN_JUSTICE,
	INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN,
	INTERFACEKEY_BUILDJOB_CHAIN_FREE,
	INTERFACEKEY_BUILDJOB_CHAIN_SIZE,
	INTERFACEKEY_BUILDJOB_SIEGE_FIRING,
	INTERFACEKEY_BUILDJOB_SIEGE_ORIENT,
	INTERFACEKEY_BUILDJOB_DOOR_INTERNAL,
	INTERFACEKEY_BUILDJOB_DOOR_LOCK,
	INTERFACEKEY_BUILDJOB_DOOR_AJAR,
	INTERFACEKEY_BUILDJOB_COFFIN_ASSIGN,
	INTERFACEKEY_BUILDJOB_COFFIN_FREE,
	INTERFACEKEY_BUILDJOB_COFFIN_SIZE,
	INTERFACEKEY_BUILDJOB_COFFIN_BURIAL,
	INTERFACEKEY_BUILDJOB_COFFIN_CIV,
	INTERFACEKEY_BUILDJOB_COFFIN_PET,
	INTERFACEKEY_BUILDJOB_CHAIR_ASSIGN,
	INTERFACEKEY_BUILDJOB_CHAIR_FREE,
	INTERFACEKEY_BUILDJOB_CHAIR_SIZE,
	INTERFACEKEY_BUILDJOB_TABLE_ASSIGN,
	INTERFACEKEY_BUILDJOB_TABLE_HALL,
	INTERFACEKEY_BUILDJOB_TABLE_FREE,
	INTERFACEKEY_BUILDJOB_TABLE_SIZE,
	INTERFACEKEY_BUILDJOB_BED_ASSIGN,
	INTERFACEKEY_BUILDJOB_BED_FREE,
	INTERFACEKEY_BUILDJOB_BED_BARRACKS,
	INTERFACEKEY_BUILDJOB_BED_DORMITORY,
	INTERFACEKEY_BUILDJOB_BED_RENT,
	INTERFACEKEY_BUILDJOB_BED_SIZE,
	INTERFACEKEY_BUILDJOB_BED_NAME,
	INTERFACEKEY_BUILDJOB_BED_SLEEP,
	INTERFACEKEY_BUILDJOB_BED_TRAIN,
	INTERFACEKEY_BUILDJOB_BED_INDIV_EQ,
	INTERFACEKEY_BUILDJOB_BED_SQUAD_EQ,
	INTERFACEKEY_BUILDJOB_BED_POSITION,
	INTERFACEKEY_BUILDJOB_DEPOT_BRING,
	INTERFACEKEY_BUILDJOB_DEPOT_TRADE,
	INTERFACEKEY_BUILDJOB_DEPOT_REQUEST_TRADER,
	INTERFACEKEY_BUILDJOB_DEPOT_BROKER_ONLY,
	INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_NONE,
	INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_MEAT,
	INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_FISH,
	INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_GEM,
	INTERFACEKEY_BUILDJOB_FARM_FALLOW,
	INTERFACEKEY_BUILDJOB_FARM_FERTILIZE,
	INTERFACEKEY_BUILDJOB_FARM_SEASFERT,
	INTERFACEKEY_BUILDJOB_FARM_SPRING,
	INTERFACEKEY_BUILDJOB_FARM_SUMMER,
	INTERFACEKEY_BUILDJOB_FARM_AUTUMN,
	INTERFACEKEY_BUILDJOB_FARM_WINTER,
	INTERFACEKEY_BUILDJOB_RACK_MAT_BONE,
	INTERFACEKEY_BUILDJOB_RACK_MAT_BRONZE,
	INTERFACEKEY_BUILDJOB_RACK_MAT_COPPER,
	INTERFACEKEY_BUILDJOB_RACK_MAT_IRON,
	INTERFACEKEY_BUILDJOB_RACK_MAT_STEEL,
	INTERFACEKEY_BUILDJOB_RACK_MAT_WOOD,
	INTERFACEKEY_BUILDJOB_RACK_MAT_METAL,
	INTERFACEKEY_BUILDJOB_STAND_MAT_BONE,
	INTERFACEKEY_BUILDJOB_STAND_MAT_LEATHER,
	INTERFACEKEY_BUILDJOB_STAND_MAT_COPPER,
	INTERFACEKEY_BUILDJOB_STAND_MAT_BRONZE,
	INTERFACEKEY_BUILDJOB_STAND_MAT_STEEL,
	INTERFACEKEY_BUILDJOB_STAND_MAT_IRON,
	INTERFACEKEY_BUILDJOB_STAND_MAT_WOOD,
	INTERFACEKEY_BUILDJOB_STAND_MAT_METAL,
	INTERFACEKEY_BUILDJOB_RACKSTAND_ASSIGN,
	INTERFACEKEY_BUILDJOB_RACKSTAND_FREE,
	INTERFACEKEY_BUILDJOB_RACKSTAND_SIZE,
	INTERFACEKEY_BUILDJOB_RACKSTAND_ITEM,
	INTERFACEKEY_BUILDJOB_RACKSTAND_MAT,
	INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS1,
	INTERFACEKEY_BUILDJOB_RACKSTAND_KILL1,
	INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS2,
	INTERFACEKEY_BUILDJOB_RACKSTAND_KILL2,
	INTERFACEKEY_HOTKEY_BUILDING_ARMORSTAND,
	INTERFACEKEY_HOTKEY_BUILDING_BED,
	INTERFACEKEY_HOTKEY_BUILDING_CHAIR,
	INTERFACEKEY_HOTKEY_BUILDING_COFFIN,
	INTERFACEKEY_HOTKEY_BUILDING_DOOR,
	INTERFACEKEY_HOTKEY_BUILDING_FLOODGATE,
	INTERFACEKEY_HOTKEY_BUILDING_HATCH,
	INTERFACEKEY_HOTKEY_BUILDING_GRATE_WALL,
	INTERFACEKEY_HOTKEY_BUILDING_GRATE_FLOOR,
	INTERFACEKEY_HOTKEY_BUILDING_BARS_VERTICAL,
	INTERFACEKEY_HOTKEY_BUILDING_BARS_FLOOR,
	INTERFACEKEY_HOTKEY_BUILDING_CABINET,
	INTERFACEKEY_HOTKEY_BUILDING_BOX,
	INTERFACEKEY_HOTKEY_BUILDING_KENNEL,
	INTERFACEKEY_HOTKEY_BUILDING_FARMPLOT,
	INTERFACEKEY_HOTKEY_BUILDING_WEAPONRACK,
	INTERFACEKEY_HOTKEY_BUILDING_STATUE,
	INTERFACEKEY_HOTKEY_BUILDING_TABLE,
	INTERFACEKEY_HOTKEY_BUILDING_ROAD_DIRT,
	INTERFACEKEY_HOTKEY_BUILDING_ROAD_PAVED,
	INTERFACEKEY_HOTKEY_BUILDING_BRIDGE,
	INTERFACEKEY_HOTKEY_BUILDING_WELL,
	INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP,
	INTERFACEKEY_HOTKEY_BUILDING_FURNACE,
	INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GLASS,
	INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GEM,
	INTERFACEKEY_HOTKEY_BUILDING_SHOP,
	INTERFACEKEY_HOTKEY_BUILDING_ANIMALTRAP,
	INTERFACEKEY_HOTKEY_BUILDING_CHAIN,
	INTERFACEKEY_HOTKEY_BUILDING_CAGE,
	INTERFACEKEY_HOTKEY_BUILDING_TRADEDEPOT,
	INTERFACEKEY_HOTKEY_BUILDING_TRAP,
	INTERFACEKEY_HOTKEY_BUILDING_MACHINE,
	INTERFACEKEY_HOTKEY_BUILDING_SUPPORT,
	INTERFACEKEY_HOTKEY_BUILDING_ARCHERYTARGET,
	INTERFACEKEY_HOTKEY_BUILDING_TRACTION_BENCH,
	INTERFACEKEY_HOTKEY_BUILDING_SLAB,
	INTERFACEKEY_HOTKEY_BUILDING_NEST_BOX,
	INTERFACEKEY_HOTKEY_BUILDING_HIVE,
	INTERFACEKEY_HOTKEY_BUILDING_MACHINE_SCREW_PUMP,
	INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WATER_WHEEL,
	INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WINDMILL,
	INTERFACEKEY_HOTKEY_BUILDING_MACHINE_GEAR_ASSEMBLY,
	INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_VERTICAL,
	INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_HORIZONTAL,
	INTERFACEKEY_HOTKEY_BUILDING_MACHINE_ROLLERS,
	INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_BALLISTA,
	INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_CATAPULT,
	INTERFACEKEY_HOTKEY_BUILDING_TRAP_STONE,
	INTERFACEKEY_HOTKEY_BUILDING_TRAP_WEAPON,
	INTERFACEKEY_HOTKEY_BUILDING_TRAP_LEVER,
	INTERFACEKEY_HOTKEY_BUILDING_TRAP_TRIGGER,
	INTERFACEKEY_HOTKEY_BUILDING_TRAP_CAGE,
	INTERFACEKEY_HOTKEY_BUILDING_TRAP_SPIKE,
	INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION,
	INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_WALL,
	INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FLOOR,
	INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_RAMP,
	INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UP,
	INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_DOWN,
	INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UPDOWN,
	INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FORTIFICATION,
	INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_TRACK,
	INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_TRACK_STOP,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LEATHER,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_QUERN,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MILLSTONE,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LOOM,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CLOTHES,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BOWYER,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CARPENTER,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_METALSMITH,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LAVAMILL,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_JEWELER,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MASON,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BUTCHER,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_TANNER,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_DYER,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CRAFTSMAN,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_SIEGE,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MECHANIC,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_STILL,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FARMER,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_KITCHEN,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FISHERY,
	INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_ASHERY,
	INTERFACEKEY_HOTKEY_BUILDING_FURNACE_WOOD,
	INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER,
	INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS,
	INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN,
	INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER_LAVA,
	INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS_LAVA,
	INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN_LAVA,
	INTERFACEKEY_HIVE_INSTALL_COLONY,
	INTERFACEKEY_HIVE_GATHER_PRODUCTS,
	INTERFACEKEY_BUILDING_DIM_Y_UP,
	INTERFACEKEY_BUILDING_DIM_Y_DOWN,
	INTERFACEKEY_BUILDING_DIM_X_UP,
	INTERFACEKEY_BUILDING_DIM_X_DOWN,
	INTERFACEKEY_BUILDING_ORIENT_UP,
	INTERFACEKEY_BUILDING_ORIENT_LEFT,
	INTERFACEKEY_BUILDING_ORIENT_RIGHT,
	INTERFACEKEY_BUILDING_ORIENT_DOWN,
	INTERFACEKEY_BUILDING_ORIENT_NONE,
	INTERFACEKEY_BUILDING_VIEW_ITEM,
	INTERFACEKEY_BUILDING_ADVANCE_STAGE,
	INTERFACEKEY_BUILDING_EXPAND_CONTRACT,
	INTERFACEKEY_BUILDING_TRIGGER_ENABLE_WATER,
	INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_UP,
	INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_DOWN,
	INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_UP,
	INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_DOWN,
	INTERFACEKEY_BUILDING_TRIGGER_ENABLE_MAGMA,
	INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_UP,
	INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_DOWN,
	INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_UP,
	INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_DOWN,
	INTERFACEKEY_BUILDING_TRIGGER_ENABLE_TRACK_CART,
	INTERFACEKEY_BUILDING_TRIGGER_MIN_TRACK_CART_DOWN,
	INTERFACEKEY_BUILDING_TRIGGER_MIN_TRACK_CART_UP,
	INTERFACEKEY_BUILDING_TRIGGER_MAX_TRACK_CART_DOWN,
	INTERFACEKEY_BUILDING_TRIGGER_MAX_TRACK_CART_UP,
	INTERFACEKEY_BUILDING_TRIGGER_ENABLE_CREATURE,
	INTERFACEKEY_BUILDING_TRIGGER_ENABLE_LOCALS,
	INTERFACEKEY_BUILDING_TRIGGER_RESETS,
	INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_UP,
	INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_DOWN,
	INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_UP,
	INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_DOWN,
	INTERFACEKEY_BUILDING_ROLLERS_SPEED_UP,
	INTERFACEKEY_BUILDING_ROLLERS_SPEED_DOWN,
	INTERFACEKEY_BUILDING_TRACK_STOP_FRICTION_UP,
	INTERFACEKEY_BUILDING_TRACK_STOP_FRICTION_DOWN,
	INTERFACEKEY_BUILDING_TRACK_STOP_DUMP,
	INTERFACEKEY_DESTROYBUILDING,
	INTERFACEKEY_SUSPENDBUILDING,
	INTERFACEKEY_BUILDINGLIST_ZOOM_T,
	INTERFACEKEY_BUILDINGLIST_ZOOM_Q,

	WORKSHOPKEY_START,
	INTERFACEKEY_HOTKEY_MAKE_ASH=WORKSHOPKEY_START,
	INTERFACEKEY_HOTKEY_MAKE_CHARCOAL,
	INTERFACEKEY_HOTKEY_MELT_OBJECT,
	INTERFACEKEY_HOTKEY_GLASS_GREEN,
	INTERFACEKEY_HOTKEY_GLASS_CLEAR,
	INTERFACEKEY_HOTKEY_GLASS_CRYSTAL,
	INTERFACEKEY_HOTKEY_COLLECT_SAND,
	INTERFACEKEY_HOTKEY_COLLECT_CLAY,
	INTERFACEKEY_HOTKEY_GLASS_ROUGH,
	INTERFACEKEY_HOTKEY_GLASS_ARMORSTAND,
	INTERFACEKEY_HOTKEY_GLASS_BOX,
	INTERFACEKEY_HOTKEY_GLASS_CABINET,
	INTERFACEKEY_HOTKEY_GLASS_COFFIN,
	INTERFACEKEY_HOTKEY_GLASS_FLOODGATE,
	INTERFACEKEY_HOTKEY_GLASS_HATCH_COVER,
	INTERFACEKEY_HOTKEY_GLASS_GRATE,
	INTERFACEKEY_HOTKEY_GLASS_GOBLET,
	INTERFACEKEY_HOTKEY_GLASS_TOY,
	INTERFACEKEY_HOTKEY_GLASS_INSTRUMENT,
	INTERFACEKEY_HOTKEY_GLASS_DOOR,
	INTERFACEKEY_HOTKEY_GLASS_STATUE,
	INTERFACEKEY_HOTKEY_GLASS_TABLE,
	INTERFACEKEY_HOTKEY_GLASS_CAGE,
	INTERFACEKEY_HOTKEY_GLASS_CHAIR,
	INTERFACEKEY_HOTKEY_GLASS_BLOCKS,
	INTERFACEKEY_HOTKEY_GLASS_FLASK,
	INTERFACEKEY_HOTKEY_GLASS_WEAPONRACK,
	INTERFACEKEY_HOTKEY_GLASS_WINDOW,
	INTERFACEKEY_HOTKEY_ASHERY_LYE,
	INTERFACEKEY_HOTKEY_ASHERY_POTASH,
	INTERFACEKEY_HOTKEY_ASHERY_POTASH_DIRECT,
	INTERFACEKEY_HOTKEY_CARPENTER_BARREL,
	INTERFACEKEY_HOTKEY_CARPENTER_BLOCKS,
	INTERFACEKEY_HOTKEY_CARPENTER_BUCKET,
	INTERFACEKEY_HOTKEY_CARPENTER_TRAP_ANIMAL,
	INTERFACEKEY_HOTKEY_CARPENTER_CAGE,
	INTERFACEKEY_HOTKEY_CARPENTER_ARMORSTAND,
	INTERFACEKEY_HOTKEY_CARPENTER_BED,
	INTERFACEKEY_HOTKEY_CARPENTER_CHAIR,
	INTERFACEKEY_HOTKEY_CARPENTER_COFFIN,
	INTERFACEKEY_HOTKEY_CARPENTER_DOOR,
	INTERFACEKEY_HOTKEY_CARPENTER_FLOODGATE,
	INTERFACEKEY_HOTKEY_CARPENTER_HATCH_COVER,
	INTERFACEKEY_HOTKEY_CARPENTER_GRATE,
	INTERFACEKEY_HOTKEY_CARPENTER_CABINET,
	INTERFACEKEY_HOTKEY_CARPENTER_BIN,
	INTERFACEKEY_HOTKEY_CARPENTER_BOX,
	INTERFACEKEY_HOTKEY_CARPENTER_WEAPONRACK,
	INTERFACEKEY_HOTKEY_CARPENTER_TABLE,
	INTERFACEKEY_HOTKEY_SIEGE_BALLISTA,
	INTERFACEKEY_HOTKEY_SIEGE_CATAPULT,
	INTERFACEKEY_HOTKEY_LEATHER_BOX,
	INTERFACEKEY_HOTKEY_LEATHER_FLASK,
	INTERFACEKEY_HOTKEY_LEATHER_SHIRT,
	INTERFACEKEY_HOTKEY_LEATHER_CLOAK,
	INTERFACEKEY_HOTKEY_LEATHER_BACKPACK,
	INTERFACEKEY_HOTKEY_LEATHER_QUIVER,
	INTERFACEKEY_HOTKEY_LEATHER_IMAGE,
	INTERFACEKEY_HOTKEY_CLOTHES_MAT_PLANT,
	INTERFACEKEY_HOTKEY_CLOTHES_MAT_SILK,
	INTERFACEKEY_HOTKEY_CLOTHES_MAT_YARN,
	INTERFACEKEY_HOTKEY_CLOTHES_SHIRT,
	INTERFACEKEY_HOTKEY_CLOTHES_CLOAK,
	INTERFACEKEY_HOTKEY_CLOTHES_BOX,
	INTERFACEKEY_HOTKEY_CLOTHES_CHAIN,
	INTERFACEKEY_HOTKEY_CLOTHES_IMAGE,
	INTERFACEKEY_HOTKEY_CRAFTS_MAT_STONE,
	INTERFACEKEY_HOTKEY_CRAFTS_MAT_WOOD,
	INTERFACEKEY_HOTKEY_CRAFTS_DEC_BONE,
	INTERFACEKEY_HOTKEY_CRAFTS_DEC_SHELL,
	INTERFACEKEY_HOTKEY_CRAFTS_DEC_TOOTH,
	INTERFACEKEY_HOTKEY_CRAFTS_DEC_HORN,
	INTERFACEKEY_HOTKEY_CRAFTS_DEC_PEARL,
	INTERFACEKEY_HOTKEY_CRAFTS_TOTEM,
	INTERFACEKEY_HOTKEY_CRAFTS_CLOTH,
	INTERFACEKEY_HOTKEY_CRAFTS_SILK,
	INTERFACEKEY_HOTKEY_CRAFTS_YARN,
	INTERFACEKEY_HOTKEY_CRAFTS_SEL_WOOD,
	INTERFACEKEY_HOTKEY_CRAFTS_SEL_BONE,
	INTERFACEKEY_HOTKEY_CRAFTS_SEL_SHELL,
	INTERFACEKEY_HOTKEY_CRAFTS_SHELL,
	INTERFACEKEY_HOTKEY_CRAFTS_TOOTH,
	INTERFACEKEY_HOTKEY_CRAFTS_HORN,
	INTERFACEKEY_HOTKEY_CRAFTS_PEARL,
	INTERFACEKEY_HOTKEY_CRAFTS_BONE,
	INTERFACEKEY_HOTKEY_CRAFTS_LEATHER,
	INTERFACEKEY_HOTKEY_CRAFTS_SLAB,
	INTERFACEKEY_HOTKEY_CRAFTS_MAT_CRAFTS,
	INTERFACEKEY_HOTKEY_CRAFTS_MAT_GOBLET,
	INTERFACEKEY_HOTKEY_CRAFTS_MAT_INSTRUMENT,
	INTERFACEKEY_HOTKEY_CRAFTS_MAT_TOY,
	INTERFACEKEY_HOTKEY_SMITH_WEAPON,
	INTERFACEKEY_HOTKEY_SMITH_ARMOR,
	INTERFACEKEY_HOTKEY_SMITH_FURNITURE,
	INTERFACEKEY_HOTKEY_SMITH_SIEGE,
	INTERFACEKEY_HOTKEY_SMITH_TRAP,
	INTERFACEKEY_HOTKEY_SMITH_OTHER,
	INTERFACEKEY_HOTKEY_SMITH_METAL,
	INTERFACEKEY_HOTKEY_ALCHEMIST_SOAP,
	INTERFACEKEY_HOTKEY_STILL_BREW,
	INTERFACEKEY_HOTKEY_STILL_EXTRACT,
	INTERFACEKEY_HOTKEY_LOOM_COLLECT_SILK,
	INTERFACEKEY_HOTKEY_LOOM_WEAVE_CLOTH,
	INTERFACEKEY_HOTKEY_LOOM_WEAVE_SILK,
	INTERFACEKEY_HOTKEY_LOOM_WEAVE_YARN,
	INTERFACEKEY_HOTKEY_LOOM_WEAVE_METAL,
	INTERFACEKEY_HOTKEY_KITCHEN_COOK_2,
	INTERFACEKEY_HOTKEY_KITCHEN_COOK_3,
	INTERFACEKEY_HOTKEY_KITCHEN_COOK_4,
	INTERFACEKEY_HOTKEY_KITCHEN_RENDER_FAT,
	INTERFACEKEY_HOTKEY_FARMER_PROCESS,
	INTERFACEKEY_HOTKEY_FARMER_PROCESS_VIAL,
	INTERFACEKEY_HOTKEY_FARMER_PROCESS_BAG,
	INTERFACEKEY_HOTKEY_FARMER_PROCESS_BARREL,
	INTERFACEKEY_HOTKEY_FARMER_CHEESE,
	INTERFACEKEY_HOTKEY_FARMER_MILK,
	INTERFACEKEY_HOTKEY_FARMER_SHEAR_CREATURE,
	INTERFACEKEY_HOTKEY_FARMER_SPIN_THREAD,
	INTERFACEKEY_HOTKEY_MILL_MILL,
	INTERFACEKEY_HOTKEY_KENNEL_CATCH_VERMIN,
	INTERFACEKEY_HOTKEY_KENNEL_TAME_VERMIN,
	INTERFACEKEY_HOTKEY_FISHERY_PROCESS,
	INTERFACEKEY_HOTKEY_FISHERY_EXTRACT,
	INTERFACEKEY_HOTKEY_FISHERY_CATCH,
	INTERFACEKEY_HOTKEY_BUTCHER_BUTCHER,
	INTERFACEKEY_HOTKEY_BUTCHER_EXTRACT,
	INTERFACEKEY_HOTKEY_BUTCHER_CATCH,
	INTERFACEKEY_HOTKEY_TANNER_TAN,
	INTERFACEKEY_HOTKEY_DYER_THREAD,
	INTERFACEKEY_HOTKEY_DYER_CLOTH,
	INTERFACEKEY_HOTKEY_JEWELER_FURNITURE,
	INTERFACEKEY_HOTKEY_JEWELER_FINISHED,
	INTERFACEKEY_HOTKEY_JEWELER_AMMO,
	INTERFACEKEY_HOTKEY_JEWELER_CUT,
	INTERFACEKEY_HOTKEY_JEWELER_ENCRUST,
	INTERFACEKEY_HOTKEY_MECHANIC_PARTS,
	INTERFACEKEY_HOTKEY_MECHANIC_TRACTION_BENCH,
	INTERFACEKEY_HOTKEY_MASON_ARMORSTAND,
	INTERFACEKEY_HOTKEY_MASON_BLOCKS,
	INTERFACEKEY_HOTKEY_MASON_CHAIR,
	INTERFACEKEY_HOTKEY_MASON_COFFIN,
	INTERFACEKEY_HOTKEY_MASON_DOOR,
	INTERFACEKEY_HOTKEY_MASON_FLOODGATE,
	INTERFACEKEY_HOTKEY_MASON_HATCH_COVER,
	INTERFACEKEY_HOTKEY_MASON_GRATE,
	INTERFACEKEY_HOTKEY_MASON_CABINET,
	INTERFACEKEY_HOTKEY_MASON_BOX,
	INTERFACEKEY_HOTKEY_MASON_STATUE,
	INTERFACEKEY_HOTKEY_MASON_TABLE,
	INTERFACEKEY_HOTKEY_MASON_WEAPONRACK,
	INTERFACEKEY_HOTKEY_MASON_QUERN,
	INTERFACEKEY_HOTKEY_MASON_MILLSTONE,
	INTERFACEKEY_HOTKEY_MASON_SLAB,
	INTERFACEKEY_HOTKEY_TRAP_BRIDGE,
	INTERFACEKEY_HOTKEY_TRAP_DOOR,
	INTERFACEKEY_HOTKEY_TRAP_FLOODGATE,
	INTERFACEKEY_HOTKEY_TRAP_SPIKE,
	INTERFACEKEY_HOTKEY_TRAP_HATCH,
	INTERFACEKEY_HOTKEY_TRAP_GRATE_WALL,
	INTERFACEKEY_HOTKEY_TRAP_GRATE_FLOOR,
	INTERFACEKEY_HOTKEY_TRAP_BARS_VERTICAL,
	INTERFACEKEY_HOTKEY_TRAP_BARS_FLOOR,
	INTERFACEKEY_HOTKEY_TRAP_SUPPORT,
	INTERFACEKEY_HOTKEY_TRAP_CHAIN,
	INTERFACEKEY_HOTKEY_TRAP_CAGE,
	INTERFACEKEY_HOTKEY_TRAP_GEAR_ASSEMBLY,
	INTERFACEKEY_HOTKEY_TRAP_TRACK_STOP,
	INTERFACEKEY_HOTKEY_TRAP_PULL_LEVER,

	PILEZONEKEY_START,
	INTERFACEKEY_BUILDJOB_STOCKPILE_MASTER=PILEZONEKEY_START,
	INTERFACEKEY_BUILDJOB_STOCKPILE_LINK_ANYWHERE,
	INTERFACEKEY_BUILDJOB_STOCKPILE_GIVE_TO,
	INTERFACEKEY_BUILDJOB_STOCKPILE_DELETE_CHILD,
	INTERFACEKEY_BUILDJOB_STOCKPILE_SETTINGS,
	INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_UP,
	INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_DOWN,
	INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_ZERO,
	INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_MAX,
	INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_UP,
	INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_DOWN,
	INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_ZERO,
	INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_MAX,
	INTERFACEKEY_BUILDJOB_STOCKPILE_WHEELBARROW,
	INTERFACEKEY_STOCKPILE_ANIMAL,
	INTERFACEKEY_STOCKPILE_FOOD,
	INTERFACEKEY_STOCKPILE_WEAPON,
	INTERFACEKEY_STOCKPILE_ARMOR,
	INTERFACEKEY_STOCKPILE_CUSTOM,
	INTERFACEKEY_STOCKPILE_CUSTOM_SETTINGS,
	INTERFACEKEY_STOCKPILE_FURNITURE,
	INTERFACEKEY_STOCKPILE_GRAVEYARD,
	INTERFACEKEY_STOCKPILE_REFUSE,
	INTERFACEKEY_STOCKPILE_WOOD,
	INTERFACEKEY_STOCKPILE_STONE,
	INTERFACEKEY_STOCKPILE_GEM,
	INTERFACEKEY_STOCKPILE_BARBLOCK,
	INTERFACEKEY_STOCKPILE_CLOTH,
	INTERFACEKEY_STOCKPILE_LEATHER,
	INTERFACEKEY_STOCKPILE_AMMO,
	INTERFACEKEY_STOCKPILE_COINS,
	INTERFACEKEY_STOCKPILE_FINISHED,
	INTERFACEKEY_STOCKPILE_NONE,
	INTERFACEKEY_STOCKPILE_SETTINGS_ENABLE,
	INTERFACEKEY_STOCKPILE_SETTINGS_DISABLE,
	INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_ALL,
	INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_ALL,
	INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_SUB,
	INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_SUB,
	INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC1,
	INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC2,
	INTERFACEKEY_CIVZONE_REMOVE,
	INTERFACEKEY_CIVZONE_REMOVE_ZONE,
	INTERFACEKEY_CIVZONE_SHAPE,
	INTERFACEKEY_CIVZONE_NEXT,
	INTERFACEKEY_CIVZONE_WATER_SOURCE,
	INTERFACEKEY_CIVZONE_FISH,
	INTERFACEKEY_CIVZONE_DUMP,
	INTERFACEKEY_CIVZONE_POND,
	INTERFACEKEY_CIVZONE_HOSPITAL,
	INTERFACEKEY_CIVZONE_SAND_COLLECT,
	INTERFACEKEY_CIVZONE_CLAY_COLLECT,
	INTERFACEKEY_CIVZONE_ACTIVE,
	INTERFACEKEY_CIVZONE_MEETING,
	INTERFACEKEY_CIVZONE_ANIMAL_TRAINING,
	INTERFACEKEY_CIVZONE_PEN,
	INTERFACEKEY_CIVZONE_PEN_OPTIONS,
	INTERFACEKEY_CIVZONE_POND_OPTIONS,
	INTERFACEKEY_CIVZONE_POND_WATER,
	INTERFACEKEY_CIVZONE_HOSPITAL_OPTIONS,

	STOCKORDERKEY_START,
	INTERFACEKEY_STORES_VIEW=STOCKORDERKEY_START,
	INTERFACEKEY_STORES_ZOOM,
	INTERFACEKEY_STORES_FORBID,
	INTERFACEKEY_STORES_MELT,
	INTERFACEKEY_STORES_DUMP,
	INTERFACEKEY_STORES_HIDE,
	INTERFACEKEY_PET_BUTCHER,
	INTERFACEKEY_ANIMAL_SELECT_TRAINER,
	INTERFACEKEY_ANIMAL_WAR_TRAINING,
	INTERFACEKEY_ANIMAL_HUNTING_TRAINING,
	INTERFACEKEY_KITCHEN_COOK,
	INTERFACEKEY_KITCHEN_BREW,
	INTERFACEKEY_ORDERS_AUTOFORBID,
	INTERFACEKEY_ORDERS_FORBID_PROJECTILE,
	INTERFACEKEY_ORDERS_FORBID_YOUR_CORPSE,
	INTERFACEKEY_ORDERS_FORBID_YOUR_ITEMS,
	INTERFACEKEY_ORDERS_FORBID_OTHER_CORPSE,
	INTERFACEKEY_ORDERS_FORBID_OTHER_ITEMS,
	INTERFACEKEY_ORDERS_REFUSE_GATHER,
	INTERFACEKEY_ORDERS_REFUSE_OUTSIDE,
	INTERFACEKEY_ORDERS_REFUSE_OUTSIDE_VERMIN,
	INTERFACEKEY_ORDERS_REFUSE_DUMP_CORPSE,
	INTERFACEKEY_ORDERS_REFUSE_DUMP_SKULL,
	INTERFACEKEY_ORDERS_REFUSE_DUMP_BONE,
	INTERFACEKEY_ORDERS_REFUSE_DUMP_SHELL,
	INTERFACEKEY_ORDERS_REFUSE_DUMP_SKIN,
	INTERFACEKEY_ORDERS_REFUSE_DUMP_OTHER,
	INTERFACEKEY_ORDERS_REFUSE_DUMP_STRAND_TISSUE,
	INTERFACEKEY_ORDERS_GATHER_FURNITURE,
	INTERFACEKEY_ORDERS_GATHER_ANIMALS,
	INTERFACEKEY_ORDERS_GATHER_FOOD,
	INTERFACEKEY_ORDERS_GATHER_BODIES,
	INTERFACEKEY_ORDERS_REFUSE,
	INTERFACEKEY_ORDERS_GATHER_STONE,
	INTERFACEKEY_ORDERS_GATHER_WOOD,
	INTERFACEKEY_ORDERS_ALL_HARVEST,
	INTERFACEKEY_ORDERS_SAMEPILE,
	INTERFACEKEY_ORDERS_MIXFOODS,
	INTERFACEKEY_ORDERS_LOOM,
	INTERFACEKEY_ORDERS_DYED_CLOTH,
	INTERFACEKEY_ORDERS_EXCEPTIONS,
	INTERFACEKEY_ORDERS_WORKSHOP,
	INTERFACEKEY_ORDERS_COLLECT_WEB,
	INTERFACEKEY_ORDERS_SLAUGHTER,
	INTERFACEKEY_ORDERS_BUTCHER,
	INTERFACEKEY_ORDERS_TAN,
	INTERFACEKEY_ORDERS_AUTO_FISHERY,
	INTERFACEKEY_ORDERS_AUTO_KITCHEN,
	INTERFACEKEY_ORDERS_AUTO_KILN,
	INTERFACEKEY_ORDERS_AUTO_SMELTER,
	INTERFACEKEY_ORDERS_AUTO_OTHER,
	INTERFACEKEY_ORDERS_ZONE,
	INTERFACEKEY_ORDERS_ZONE_DRINKING,
	INTERFACEKEY_ORDERS_ZONE_FISHING,

	DWARFMAINKEY_START,
	INTERFACEKEY_D_ONESTEP=DWARFMAINKEY_START,
	INTERFACEKEY_D_PAUSE,
	INTERFACEKEY_D_DEPOT,
	INTERFACEKEY_D_HOT_KEYS,
	INTERFACEKEY_D_HOTKEY1,
	INTERFACEKEY_D_HOTKEY2,
	INTERFACEKEY_D_HOTKEY3,
	INTERFACEKEY_D_HOTKEY4,
	INTERFACEKEY_D_HOTKEY5,
	INTERFACEKEY_D_HOTKEY6,
	INTERFACEKEY_D_HOTKEY7,
	INTERFACEKEY_D_HOTKEY8,
	INTERFACEKEY_D_HOTKEY9,
	INTERFACEKEY_D_HOTKEY10,
	INTERFACEKEY_D_HOTKEY11,
	INTERFACEKEY_D_HOTKEY12,
	INTERFACEKEY_D_HOTKEY13,
	INTERFACEKEY_D_HOTKEY14,
	INTERFACEKEY_D_HOTKEY15,
	INTERFACEKEY_D_HOTKEY16,
	INTERFACEKEY_D_HOTKEY_CHANGE_NAME,
	INTERFACEKEY_D_HOTKEY_ZOOM,
	INTERFACEKEY_D_ANNOUNCE,
	INTERFACEKEY_D_REPORTS,
	INTERFACEKEY_D_BUILDING,
	INTERFACEKEY_D_CIVLIST,
	INTERFACEKEY_D_DESIGNATE,
	INTERFACEKEY_D_ARTLIST,
	INTERFACEKEY_D_NOBLES,
	INTERFACEKEY_D_ORDERS,
	INTERFACEKEY_D_MILITARY,
	INTERFACEKEY_D_ROOMS,
	INTERFACEKEY_D_SQUADS,
	INTERFACEKEY_D_STOCKPILES,
	INTERFACEKEY_D_CIVZONE,
	INTERFACEKEY_D_VIEWUNIT,
	INTERFACEKEY_D_JOBLIST,
	INTERFACEKEY_D_UNITLIST,
	INTERFACEKEY_D_LOOK,
	INTERFACEKEY_D_HAULING,
	INTERFACEKEY_D_HAULING_NEW_ROUTE,
	INTERFACEKEY_D_HAULING_NEW_STOP,
	INTERFACEKEY_D_HAULING_REMOVE,
	INTERFACEKEY_D_HAULING_PROMOTE,
	INTERFACEKEY_D_HAULING_VEHICLE,
	INTERFACEKEY_D_HAULING_NICKNAME,
	INTERFACEKEY_D_HAULING_STOP_NEW_DEPART,
	INTERFACEKEY_D_HAULING_STOP_NEW_LINK,
	INTERFACEKEY_D_HAULING_STOP_REMOVE,
	INTERFACEKEY_D_HAULING_STOP_SL_SELECT_PILE,
	INTERFACEKEY_D_HAULING_STOP_SL_TAKE_GIVE,
	INTERFACEKEY_D_HAULING_STOP_LC_DIR,
	INTERFACEKEY_D_HAULING_STOP_LC_MODE,
	INTERFACEKEY_D_HAULING_STOP_LC_TIMER_UP,
	INTERFACEKEY_D_HAULING_STOP_LC_TIMER_DOWN,
	INTERFACEKEY_D_HAULING_STOP_LC_FULLNESS_UP,
	INTERFACEKEY_D_HAULING_STOP_LC_FULLNESS_DOWN,
	INTERFACEKEY_D_HAULING_STOP_LC_MORE_LESS,
	INTERFACEKEY_D_HAULING_STOP_LC_DESIRED_TOTAL,
	INTERFACEKEY_D_HAULING_STOP_LC_CHANGE,
	INTERFACEKEY_D_HAULING_STOP_LC_ADVANCED,
	INTERFACEKEY_D_BURROWS,
	INTERFACEKEY_D_BURROWS_ADD,
	INTERFACEKEY_D_BURROWS_DELETE,
	INTERFACEKEY_D_BURROWS_DEFINE,
	INTERFACEKEY_D_BURROWS_ADD_UNIT,
	INTERFACEKEY_D_BURROWS_CENTER,
	INTERFACEKEY_D_BURROWS_NAME,
	INTERFACEKEY_D_BURROWS_CHANGE_SELECTION,
	INTERFACEKEY_D_BURROWS_BRUSH,
	INTERFACEKEY_D_BURROWS_REMOVE,
	INTERFACEKEY_D_NOTE,
	INTERFACEKEY_D_NOTE_PLACE,
	INTERFACEKEY_D_NOTE_DELETE,
	INTERFACEKEY_D_NOTE_NAME,
	INTERFACEKEY_D_NOTE_ENTER,
	INTERFACEKEY_D_NOTE_ADOPT_SYMBOL,
	INTERFACEKEY_D_NOTE_CHANGE_SELECTION,
	INTERFACEKEY_D_NOTE_POINTS,
	INTERFACEKEY_D_NOTE_ROUTE,
	INTERFACEKEY_D_NOTE_ROUTE_ADD,
	INTERFACEKEY_D_NOTE_ROUTE_EDIT,
	INTERFACEKEY_D_NOTE_ROUTE_DELETE,
	INTERFACEKEY_D_NOTE_ROUTE_CENTER,
	INTERFACEKEY_D_NOTE_ROUTE_NAME,
	INTERFACEKEY_D_BUILDJOB,
	INTERFACEKEY_D_STATUS,
	INTERFACEKEY_D_STATUS_OVERALL_HEALTH_RECENTER,
	INTERFACEKEY_D_BUILDITEM,
	INTERFACEKEY_D_BITEM_FORBID,
	INTERFACEKEY_D_BITEM_DUMP,
	INTERFACEKEY_D_BITEM_MELT,
	INTERFACEKEY_D_BITEM_HIDE,
	INTERFACEKEY_D_LOOK_FORBID,
	INTERFACEKEY_D_LOOK_DUMP,
	INTERFACEKEY_D_LOOK_MELT,
	INTERFACEKEY_D_LOOK_HIDE,
	INTERFACEKEY_D_LOOK_FOLLOW,
	INTERFACEKEY_D_LOOK_ARENA_CREATURE,
	INTERFACEKEY_D_LOOK_ARENA_ADV_MODE,
	INTERFACEKEY_D_LOOK_ARENA_WATER,
	INTERFACEKEY_D_LOOK_ARENA_MAGMA,
	INTERFACEKEY_ARENA_CREATURE_SIDE_DOWN,
	INTERFACEKEY_ARENA_CREATURE_SIDE_UP,
	INTERFACEKEY_ARENA_CREATURE_NEW_ITEM,
	INTERFACEKEY_ARENA_CREATURE_BLANK_LIST,
	INTERFACEKEY_ARENA_CREATURE_REMOVE_ITEM,
	INTERFACEKEY_ARENA_CREATURE_UNDEAD,
	INTERFACEKEY_ARENA_CREATURE_STRING,
	INTERFACEKEY_ASSIGNTRADE_VIEW,
	INTERFACEKEY_ASSIGNTRADE_STRING,
	INTERFACEKEY_ASSIGNTRADE_EXCLUDE_PROHIBITED,
	INTERFACEKEY_ASSIGNTRADE_PENDING,
	INTERFACEKEY_ASSIGNTRADE_SORT,
	INTERFACEKEY_NOBLELIST_REPLACE,
	INTERFACEKEY_NOBLELIST_SETTINGS,
	INTERFACEKEY_NOBLELIST_CAPITAL,
	INTERFACEKEY_NOBLELIST_VIEW_CANDIDATE,
	INTERFACEKEY_TRADE_VIEW,
	INTERFACEKEY_TRADE_TRADE,
	INTERFACEKEY_TRADE_OFFER,
	INTERFACEKEY_TRADE_SEIZE,
	INTERFACEKEY_MILITARY_ACTIVATE,
	INTERFACEKEY_MILITARY_VIEW,
	INTERFACEKEY_MILITARY_WEAPON,
	INTERFACEKEY_MILITARY_ZOOM,
	INTERFACEKEY_ANNOUNCE_ZOOM,
	INTERFACEKEY_UNITJOB_REMOVE_CRE,
	INTERFACEKEY_UNITJOB_ZOOM_CRE,
	INTERFACEKEY_UNITJOB_ZOOM_BUILD,
	INTERFACEKEY_UNITJOB_VIEW,
	INTERFACEKEY_UNITJOB_MANAGER,
	INTERFACEKEY_MANAGER_NEW_ORDER,
	INTERFACEKEY_MANAGER_REMOVE,
	INTERFACEKEY_MANAGER_PROMOTE,
	INTERFACEKEY_MANAGER_MAX,
	INTERFACEKEY_MANAGER_WAGES,
	INTERFACEKEY_DESIGNATE_BITEM,
	INTERFACEKEY_DESIGNATE_CLAIM,
	INTERFACEKEY_DESIGNATE_UNCLAIM,
	INTERFACEKEY_DESIGNATE_MELT,
	INTERFACEKEY_DESIGNATE_NO_MELT,
	INTERFACEKEY_DESIGNATE_DUMP,
	INTERFACEKEY_DESIGNATE_NO_DUMP,
	INTERFACEKEY_DESIGNATE_HIDE,
	INTERFACEKEY_DESIGNATE_NO_HIDE,
	INTERFACEKEY_DESIGNATE_DIG,
	INTERFACEKEY_DESIGNATE_DIG_REMOVE_STAIRS_RAMPS,
	INTERFACEKEY_DESIGNATE_TRAFFIC,
	INTERFACEKEY_DESIGNATE_TRAFFIC_HIGH,
	INTERFACEKEY_DESIGNATE_TRAFFIC_NORMAL,
	INTERFACEKEY_DESIGNATE_TRAFFIC_LOW,
	INTERFACEKEY_DESIGNATE_TRAFFIC_RESTRICTED,
	INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT,
	INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT,
	INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT_MORE,
	INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT_MORE,
	INTERFACEKEY_DESIGNATE_STAIR_UP,
	INTERFACEKEY_DESIGNATE_STAIR_DOWN,
	INTERFACEKEY_DESIGNATE_STAIR_UPDOWN,
	INTERFACEKEY_DESIGNATE_RAMP,
	INTERFACEKEY_DESIGNATE_CHANNEL,
	INTERFACEKEY_DESIGNATE_CHOP,
	INTERFACEKEY_DESIGNATE_PLANTS,
	INTERFACEKEY_DESIGNATE_SMOOTH,
	INTERFACEKEY_DESIGNATE_ENGRAVE,
	INTERFACEKEY_DESIGNATE_FORTIFY,
	INTERFACEKEY_DESIGNATE_TRACK,
	INTERFACEKEY_DESIGNATE_TOGGLE_ENGRAVING,
	INTERFACEKEY_DESIGNATE_UNDO,
	INTERFACEKEY_DESIGNATE_REMOVE_CONSTRUCTION,
	INTERFACEKEY_ITEM_DESCRIPTION,
	INTERFACEKEY_ITEM_FORBID,
	INTERFACEKEY_ITEM_MELT,
	INTERFACEKEY_ITEM_DUMP,
	INTERFACEKEY_ITEM_HIDE,
	INTERFACEKEY_UNITVIEW_CUSTOMIZE,
	INTERFACEKEY_UNITVIEW_HEALTH,
	INTERFACEKEY_UNITVIEW_RELATIONSHIPS,
	INTERFACEKEY_UNITVIEW_RELATIONSHIPS_ZOOM,
	INTERFACEKEY_UNITVIEW_RELATIONSHIPS_VIEW,
	INTERFACEKEY_UNITVIEW_KILLS,
	INTERFACEKEY_UNITVIEW_GEN,
	INTERFACEKEY_UNITVIEW_INV,
	INTERFACEKEY_UNITVIEW_PRF,
	INTERFACEKEY_UNITVIEW_WND,
	INTERFACEKEY_UNITVIEW_FOLLOW,
	INTERFACEKEY_UNITVIEW_NEXT,
	INTERFACEKEY_UNITVIEW_SLAUGHTER,
	INTERFACEKEY_UNITVIEW_GEN_COMBAT,
	INTERFACEKEY_UNITVIEW_GEN_LABOR,
	INTERFACEKEY_UNITVIEW_GEN_MISC,
	INTERFACEKEY_UNITVIEW_PRF_PROF,
	INTERFACEKEY_UNITVIEW_PRF_PET,
	INTERFACEKEY_UNITVIEW_PRF_VIEW,
	INTERFACEKEY_UNITVIEW_PRF_NEW_SQUAD,
	INTERFACEKEY_UNITVIEW_PRF_REMOVE_FROM_SQUAD,
	INTERFACEKEY_UNITVIEW_PRF_NAME_CURRENT_SQUAD,
	INTERFACEKEY_UNITVIEW_PRF_NAME_SELECTED_SQUAD,
	INTERFACEKEY_CUSTOMIZE_UNIT_NICKNAME,
	INTERFACEKEY_CUSTOMIZE_UNIT_PROFNAME,

	MILITIAKEY_START,
	INTERFACEKEY_D_MILITARY_CREATE_SQUAD=MILITIAKEY_START,
	INTERFACEKEY_D_MILITARY_DISBAND_SQUAD,
	INTERFACEKEY_D_MILITARY_CREATE_SUB_SQUAD,
	INTERFACEKEY_D_MILITARY_CANCEL_ORDERS,
	INTERFACEKEY_D_MILITARY_POSITIONS,
	INTERFACEKEY_D_MILITARY_ALERTS,
	INTERFACEKEY_D_MILITARY_ALERTS_ADD,
	INTERFACEKEY_D_MILITARY_ALERTS_DELETE,
	INTERFACEKEY_D_MILITARY_ALERTS_SET,
	INTERFACEKEY_D_MILITARY_ALERTS_NAME,
	INTERFACEKEY_D_MILITARY_ALERTS_SET_RETAIN,
	INTERFACEKEY_D_MILITARY_EQUIP,
	INTERFACEKEY_D_MILITARY_EQUIP_CUSTOMIZE,
	INTERFACEKEY_D_MILITARY_EQUIP_UNIFORM,
	INTERFACEKEY_D_MILITARY_EQUIP_PRIORITY,
	INTERFACEKEY_D_MILITARY_UNIFORMS,
	INTERFACEKEY_D_MILITARY_SUPPLIES,
	INTERFACEKEY_D_MILITARY_SUPPLIES_WATER_DOWN,
	INTERFACEKEY_D_MILITARY_SUPPLIES_WATER_UP,
	INTERFACEKEY_D_MILITARY_SUPPLIES_FOOD_DOWN,
	INTERFACEKEY_D_MILITARY_SUPPLIES_FOOD_UP,
	INTERFACEKEY_D_MILITARY_AMMUNITION,
	INTERFACEKEY_D_MILITARY_AMMUNITION_ADD_ITEM,
	INTERFACEKEY_D_MILITARY_AMMUNITION_REMOVE_ITEM,
	INTERFACEKEY_D_MILITARY_AMMUNITION_LOWER_AMOUNT,
	INTERFACEKEY_D_MILITARY_AMMUNITION_RAISE_AMOUNT,
	INTERFACEKEY_D_MILITARY_AMMUNITION_LOWER_AMOUNT_LOTS,
	INTERFACEKEY_D_MILITARY_AMMUNITION_RAISE_AMOUNT_LOTS,
	INTERFACEKEY_D_MILITARY_AMMUNITION_MATERIAL,
	INTERFACEKEY_D_MILITARY_AMMUNITION_COMBAT,
	INTERFACEKEY_D_MILITARY_AMMUNITION_TRAINING,
	INTERFACEKEY_D_MILITARY_TRAINING,
	INTERFACEKEY_D_MILITARY_SCHEDULE,
	INTERFACEKEY_D_MILITARY_ADD_UNIFORM,
	INTERFACEKEY_D_MILITARY_DELETE_UNIFORM,
	INTERFACEKEY_D_MILITARY_NAME_UNIFORM,
	INTERFACEKEY_D_MILITARY_NAME_SQUAD,
	INTERFACEKEY_D_MILITARY_ADD_ARMOR,
	INTERFACEKEY_D_MILITARY_ADD_PANTS,
	INTERFACEKEY_D_MILITARY_ADD_HELM,
	INTERFACEKEY_D_MILITARY_ADD_GLOVES,
	INTERFACEKEY_D_MILITARY_ADD_BOOTS,
	INTERFACEKEY_D_MILITARY_ADD_SHIELD,
	INTERFACEKEY_D_MILITARY_ADD_WEAPON,
	INTERFACEKEY_D_MILITARY_ADD_MATERIAL,
	INTERFACEKEY_D_MILITARY_ADD_COLOR,
	INTERFACEKEY_D_MILITARY_REPLACE_CLOTHING,
	INTERFACEKEY_D_MILITARY_EXACT_MATCH,
	INTERFACEKEY_D_SQUADS_MOVE,
	INTERFACEKEY_D_SQUADS_KILL,
	INTERFACEKEY_D_SQUADS_KILL_LIST,
	INTERFACEKEY_D_SQUADS_KILL_RECT,
	INTERFACEKEY_D_SQUADS_SCHEDULE,
	INTERFACEKEY_D_SQUADS_CANCEL_ORDER,
	INTERFACEKEY_D_SQUADS_ALERT,
	INTERFACEKEY_D_SQUADS_SELECT_INDIVIDUALS,
	INTERFACEKEY_D_SQUADS_CENTER,
	INTERFACEKEY_D_SQUAD_SCH_SLEEP,
	INTERFACEKEY_D_SQUAD_SCH_CIVILIAN_UNIFORM,
	INTERFACEKEY_D_SQUAD_SCH_GIVE_ORDER,
	INTERFACEKEY_D_SQUAD_SCH_EDIT_ORDER,
	INTERFACEKEY_D_SQUAD_SCH_CANCEL_ORDER,
	INTERFACEKEY_D_SQUAD_SCH_COPY_ORDERS,
	INTERFACEKEY_D_SQUAD_SCH_PASTE_ORDERS,
	INTERFACEKEY_D_SQUAD_SCH_MS_NAME,

	//TEXTENTRY
	INTERFACEKEY_STRING_A000,
	INTERFACEKEY_STRING_A001,
	INTERFACEKEY_STRING_A002,
	INTERFACEKEY_STRING_A003,
	INTERFACEKEY_STRING_A004,
	INTERFACEKEY_STRING_A005,
	INTERFACEKEY_STRING_A006,
	INTERFACEKEY_STRING_A007,
	INTERFACEKEY_STRING_A008,
	INTERFACEKEY_STRING_A009,
	INTERFACEKEY_STRING_A010,
	INTERFACEKEY_STRING_A011,
	INTERFACEKEY_STRING_A012,
	INTERFACEKEY_STRING_A013,
	INTERFACEKEY_STRING_A014,
	INTERFACEKEY_STRING_A015,
	INTERFACEKEY_STRING_A016,
	INTERFACEKEY_STRING_A017,
	INTERFACEKEY_STRING_A018,
	INTERFACEKEY_STRING_A019,
	INTERFACEKEY_STRING_A020,
	INTERFACEKEY_STRING_A021,
	INTERFACEKEY_STRING_A022,
	INTERFACEKEY_STRING_A023,
	INTERFACEKEY_STRING_A024,
	INTERFACEKEY_STRING_A025,
	INTERFACEKEY_STRING_A026,
	INTERFACEKEY_STRING_A027,
	INTERFACEKEY_STRING_A028,
	INTERFACEKEY_STRING_A029,
	INTERFACEKEY_STRING_A030,
	INTERFACEKEY_STRING_A031,
	INTERFACEKEY_STRING_A032,
	INTERFACEKEY_STRING_A033,
	INTERFACEKEY_STRING_A034,
	INTERFACEKEY_STRING_A035,
	INTERFACEKEY_STRING_A036,
	INTERFACEKEY_STRING_A037,
	INTERFACEKEY_STRING_A038,
	INTERFACEKEY_STRING_A039,
	INTERFACEKEY_STRING_A040,
	INTERFACEKEY_STRING_A041,
	INTERFACEKEY_STRING_A042,
	INTERFACEKEY_STRING_A043,
	INTERFACEKEY_STRING_A044,
	INTERFACEKEY_STRING_A045,
	INTERFACEKEY_STRING_A046,
	INTERFACEKEY_STRING_A047,
	INTERFACEKEY_STRING_A048,
	INTERFACEKEY_STRING_A049,
	INTERFACEKEY_STRING_A050,
	INTERFACEKEY_STRING_A051,
	INTERFACEKEY_STRING_A052,
	INTERFACEKEY_STRING_A053,
	INTERFACEKEY_STRING_A054,
	INTERFACEKEY_STRING_A055,
	INTERFACEKEY_STRING_A056,
	INTERFACEKEY_STRING_A057,
	INTERFACEKEY_STRING_A058,
	INTERFACEKEY_STRING_A059,
	INTERFACEKEY_STRING_A060,
	INTERFACEKEY_STRING_A061,
	INTERFACEKEY_STRING_A062,
	INTERFACEKEY_STRING_A063,
	INTERFACEKEY_STRING_A064,
	INTERFACEKEY_STRING_A065,
	INTERFACEKEY_STRING_A066,
	INTERFACEKEY_STRING_A067,
	INTERFACEKEY_STRING_A068,
	INTERFACEKEY_STRING_A069,
	INTERFACEKEY_STRING_A070,
	INTERFACEKEY_STRING_A071,
	INTERFACEKEY_STRING_A072,
	INTERFACEKEY_STRING_A073,
	INTERFACEKEY_STRING_A074,
	INTERFACEKEY_STRING_A075,
	INTERFACEKEY_STRING_A076,
	INTERFACEKEY_STRING_A077,
	INTERFACEKEY_STRING_A078,
	INTERFACEKEY_STRING_A079,
	INTERFACEKEY_STRING_A080,
	INTERFACEKEY_STRING_A081,
	INTERFACEKEY_STRING_A082,
	INTERFACEKEY_STRING_A083,
	INTERFACEKEY_STRING_A084,
	INTERFACEKEY_STRING_A085,
	INTERFACEKEY_STRING_A086,
	INTERFACEKEY_STRING_A087,
	INTERFACEKEY_STRING_A088,
	INTERFACEKEY_STRING_A089,
	INTERFACEKEY_STRING_A090,
	INTERFACEKEY_STRING_A091,
	INTERFACEKEY_STRING_A092,
	INTERFACEKEY_STRING_A093,
	INTERFACEKEY_STRING_A094,
	INTERFACEKEY_STRING_A095,
	INTERFACEKEY_STRING_A096,
	INTERFACEKEY_STRING_A097,
	INTERFACEKEY_STRING_A098,
	INTERFACEKEY_STRING_A099,
	INTERFACEKEY_STRING_A100,
	INTERFACEKEY_STRING_A101,
	INTERFACEKEY_STRING_A102,
	INTERFACEKEY_STRING_A103,
	INTERFACEKEY_STRING_A104,
	INTERFACEKEY_STRING_A105,
	INTERFACEKEY_STRING_A106,
	INTERFACEKEY_STRING_A107,
	INTERFACEKEY_STRING_A108,
	INTERFACEKEY_STRING_A109,
	INTERFACEKEY_STRING_A110,
	INTERFACEKEY_STRING_A111,
	INTERFACEKEY_STRING_A112,
	INTERFACEKEY_STRING_A113,
	INTERFACEKEY_STRING_A114,
	INTERFACEKEY_STRING_A115,
	INTERFACEKEY_STRING_A116,
	INTERFACEKEY_STRING_A117,
	INTERFACEKEY_STRING_A118,
	INTERFACEKEY_STRING_A119,
	INTERFACEKEY_STRING_A120,
	INTERFACEKEY_STRING_A121,
	INTERFACEKEY_STRING_A122,
	INTERFACEKEY_STRING_A123,
	INTERFACEKEY_STRING_A124,
	INTERFACEKEY_STRING_A125,
	INTERFACEKEY_STRING_A126,
	INTERFACEKEY_STRING_A127,
	INTERFACEKEY_STRING_A128,
	INTERFACEKEY_STRING_A129,
	INTERFACEKEY_STRING_A130,
	INTERFACEKEY_STRING_A131,
	INTERFACEKEY_STRING_A132,
	INTERFACEKEY_STRING_A133,
	INTERFACEKEY_STRING_A134,
	INTERFACEKEY_STRING_A135,
	INTERFACEKEY_STRING_A136,
	INTERFACEKEY_STRING_A137,
	INTERFACEKEY_STRING_A138,
	INTERFACEKEY_STRING_A139,
	INTERFACEKEY_STRING_A140,
	INTERFACEKEY_STRING_A141,
	INTERFACEKEY_STRING_A142,
	INTERFACEKEY_STRING_A143,
	INTERFACEKEY_STRING_A144,
	INTERFACEKEY_STRING_A145,
	INTERFACEKEY_STRING_A146,
	INTERFACEKEY_STRING_A147,
	INTERFACEKEY_STRING_A148,
	INTERFACEKEY_STRING_A149,
	INTERFACEKEY_STRING_A150,
	INTERFACEKEY_STRING_A151,
	INTERFACEKEY_STRING_A152,
	INTERFACEKEY_STRING_A153,
	INTERFACEKEY_STRING_A154,
	INTERFACEKEY_STRING_A155,
	INTERFACEKEY_STRING_A156,
	INTERFACEKEY_STRING_A157,
	INTERFACEKEY_STRING_A158,
	INTERFACEKEY_STRING_A159,
	INTERFACEKEY_STRING_A160,
	INTERFACEKEY_STRING_A161,
	INTERFACEKEY_STRING_A162,
	INTERFACEKEY_STRING_A163,
	INTERFACEKEY_STRING_A164,
	INTERFACEKEY_STRING_A165,
	INTERFACEKEY_STRING_A166,
	INTERFACEKEY_STRING_A167,
	INTERFACEKEY_STRING_A168,
	INTERFACEKEY_STRING_A169,
	INTERFACEKEY_STRING_A170,
	INTERFACEKEY_STRING_A171,
	INTERFACEKEY_STRING_A172,
	INTERFACEKEY_STRING_A173,
	INTERFACEKEY_STRING_A174,
	INTERFACEKEY_STRING_A175,
	INTERFACEKEY_STRING_A176,
	INTERFACEKEY_STRING_A177,
	INTERFACEKEY_STRING_A178,
	INTERFACEKEY_STRING_A179,
	INTERFACEKEY_STRING_A180,
	INTERFACEKEY_STRING_A181,
	INTERFACEKEY_STRING_A182,
	INTERFACEKEY_STRING_A183,
	INTERFACEKEY_STRING_A184,
	INTERFACEKEY_STRING_A185,
	INTERFACEKEY_STRING_A186,
	INTERFACEKEY_STRING_A187,
	INTERFACEKEY_STRING_A188,
	INTERFACEKEY_STRING_A189,
	INTERFACEKEY_STRING_A190,
	INTERFACEKEY_STRING_A191,
	INTERFACEKEY_STRING_A192,
	INTERFACEKEY_STRING_A193,
	INTERFACEKEY_STRING_A194,
	INTERFACEKEY_STRING_A195,
	INTERFACEKEY_STRING_A196,
	INTERFACEKEY_STRING_A197,
	INTERFACEKEY_STRING_A198,
	INTERFACEKEY_STRING_A199,
	INTERFACEKEY_STRING_A200,
	INTERFACEKEY_STRING_A201,
	INTERFACEKEY_STRING_A202,
	INTERFACEKEY_STRING_A203,
	INTERFACEKEY_STRING_A204,
	INTERFACEKEY_STRING_A205,
	INTERFACEKEY_STRING_A206,
	INTERFACEKEY_STRING_A207,
	INTERFACEKEY_STRING_A208,
	INTERFACEKEY_STRING_A209,
	INTERFACEKEY_STRING_A210,
	INTERFACEKEY_STRING_A211,
	INTERFACEKEY_STRING_A212,
	INTERFACEKEY_STRING_A213,
	INTERFACEKEY_STRING_A214,
	INTERFACEKEY_STRING_A215,
	INTERFACEKEY_STRING_A216,
	INTERFACEKEY_STRING_A217,
	INTERFACEKEY_STRING_A218,
	INTERFACEKEY_STRING_A219,
	INTERFACEKEY_STRING_A220,
	INTERFACEKEY_STRING_A221,
	INTERFACEKEY_STRING_A222,
	INTERFACEKEY_STRING_A223,
	INTERFACEKEY_STRING_A224,
	INTERFACEKEY_STRING_A225,
	INTERFACEKEY_STRING_A226,
	INTERFACEKEY_STRING_A227,
	INTERFACEKEY_STRING_A228,
	INTERFACEKEY_STRING_A229,
	INTERFACEKEY_STRING_A230,
	INTERFACEKEY_STRING_A231,
	INTERFACEKEY_STRING_A232,
	INTERFACEKEY_STRING_A233,
	INTERFACEKEY_STRING_A234,
	INTERFACEKEY_STRING_A235,
	INTERFACEKEY_STRING_A236,
	INTERFACEKEY_STRING_A237,
	INTERFACEKEY_STRING_A238,
	INTERFACEKEY_STRING_A239,
	INTERFACEKEY_STRING_A240,
	INTERFACEKEY_STRING_A241,
	INTERFACEKEY_STRING_A242,
	INTERFACEKEY_STRING_A243,
	INTERFACEKEY_STRING_A244,
	INTERFACEKEY_STRING_A245,
	INTERFACEKEY_STRING_A246,
	INTERFACEKEY_STRING_A247,
	INTERFACEKEY_STRING_A248,
	INTERFACEKEY_STRING_A249,
	INTERFACEKEY_STRING_A250,
	INTERFACEKEY_STRING_A251,
	INTERFACEKEY_STRING_A252,
	INTERFACEKEY_STRING_A253,
	INTERFACEKEY_STRING_A254,
	INTERFACEKEY_STRING_A255,
	INTERFACEKEY_KEYBINDING_COMPLETE,
	INTERFACEKEYNUM,
};

extern bimap<InterfaceKey,std::string> bindingNames;
extern bimap<InterfaceKey,std::string> displayNames;
extern bimap<SDLKey,std::string> sdlNames;

void keybinding_init();

#endif
