#include "keybindings.h"

#include <SDL/SDL.h>

using namespace std;

bimap<InterfaceKey,std::string> bindingNames;
bimap<InterfaceKey,std::string> displayNames;
bimap<SDLKey,std::string> sdlNames;

void keybinding_init() {
	bindingNames.insert(INTERFACEKEY_NONE, "NONE");
	bindingNames.insert(INTERFACEKEY_SELECT, "SELECT");
	bindingNames.insert(INTERFACEKEY_SEC_SELECT, "SEC_SELECT");
	bindingNames.insert(INTERFACEKEY_DESELECT, "DESELECT");
	bindingNames.insert(INTERFACEKEY_SELECT_ALL, "SELECT_ALL");
	bindingNames.insert(INTERFACEKEY_DESELECT_ALL, "DESELECT_ALL");
	bindingNames.insert(INTERFACEKEY_LEAVESCREEN, "LEAVESCREEN");
	bindingNames.insert(INTERFACEKEY_LEAVESCREEN_ALL, "LEAVESCREEN_ALL");
	bindingNames.insert(INTERFACEKEY_CLOSE_MEGA_ANNOUNCEMENT, "CLOSE_MEGA_ANNOUNCEMENT");
	bindingNames.insert(INTERFACEKEY_TOGGLE_FULLSCREEN, "TOGGLE_FULLSCREEN");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_ADD, "WORLD_PARAM_ADD");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_COPY, "WORLD_PARAM_COPY");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_DELETE, "WORLD_PARAM_DELETE");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_TITLE, "WORLD_PARAM_TITLE");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_NAME_RANDOM, "WORLD_PARAM_NAME_RANDOM");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_NAME_ENTER, "WORLD_PARAM_NAME_ENTER");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_SEED_RANDOM, "WORLD_PARAM_SEED_RANDOM");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_SEED_ENTER, "WORLD_PARAM_SEED_ENTER");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_LOAD, "WORLD_PARAM_LOAD");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_SAVE, "WORLD_PARAM_SAVE");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_DIM_X_UP, "WORLD_PARAM_DIM_X_UP");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_DIM_X_DOWN, "WORLD_PARAM_DIM_X_DOWN");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_DIM_Y_UP, "WORLD_PARAM_DIM_Y_UP");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_DIM_Y_DOWN, "WORLD_PARAM_DIM_Y_DOWN");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_SET, "WORLD_PARAM_SET");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_INCREASE, "WORLD_PARAM_INCREASE");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_DECREASE, "WORLD_PARAM_DECREASE");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_ENTER_VALUE, "WORLD_PARAM_ENTER_VALUE");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_NULLIFY, "WORLD_PARAM_NULLIFY");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_PRESET, "WORLD_PARAM_PRESET");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_REJECT_CONTINUE, "WORLD_PARAM_REJECT_CONTINUE");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_REJECT_ABORT, "WORLD_PARAM_REJECT_ABORT");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_THIS, "WORLD_PARAM_REJECT_ALLOW_THIS");
	bindingNames.insert(INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_ALL, "WORLD_PARAM_REJECT_ALLOW_ALL");
	bindingNames.insert(INTERFACEKEY_WORLD_GEN_CONTINUE, "WORLD_GEN_CONTINUE");
	bindingNames.insert(INTERFACEKEY_WORLD_GEN_USE, "WORLD_GEN_USE");
	bindingNames.insert(INTERFACEKEY_WORLD_GEN_ABORT, "WORLD_GEN_ABORT");
	bindingNames.insert(INTERFACEKEY_SETUP_EMBARK, "SETUP_EMBARK");
	bindingNames.insert(INTERFACEKEY_SETUP_NAME_FORT, "SETUP_NAME_FORT");
	bindingNames.insert(INTERFACEKEY_SETUP_NAME_GROUP, "SETUP_NAME_GROUP");
	bindingNames.insert(INTERFACEKEY_SETUP_RECLAIM, "SETUP_RECLAIM");
	bindingNames.insert(INTERFACEKEY_SETUP_FIND, "SETUP_FIND");
	bindingNames.insert(INTERFACEKEY_SETUP_NOTES, "SETUP_NOTES");
	bindingNames.insert(INTERFACEKEY_SETUP_NOTES_TAKE_NOTES, "SETUP_NOTES_TAKE_NOTES");
	bindingNames.insert(INTERFACEKEY_SETUP_NOTES_DELETE_NOTE, "SETUP_NOTES_DELETE_NOTE");
	bindingNames.insert(INTERFACEKEY_SETUP_NOTES_CHANGE_SYMBOL_SELECTION, "SETUP_NOTES_CHANGE_SYMBOL_SELECTION");
	bindingNames.insert(INTERFACEKEY_SETUP_NOTES_ADOPT_SYMBOL, "SETUP_NOTES_ADOPT_SYMBOL");
	bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_Y_UP, "SETUP_LOCAL_Y_UP");
	bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_Y_DOWN, "SETUP_LOCAL_Y_DOWN");
	bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_X_UP, "SETUP_LOCAL_X_UP");
	bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_X_DOWN, "SETUP_LOCAL_X_DOWN");
	bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_Y_MUP, "SETUP_LOCAL_Y_MUP");
	bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_Y_MDOWN, "SETUP_LOCAL_Y_MDOWN");
	bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_X_MUP, "SETUP_LOCAL_X_MUP");
	bindingNames.insert(INTERFACEKEY_SETUP_LOCAL_X_MDOWN, "SETUP_LOCAL_X_MDOWN");
	bindingNames.insert(INTERFACEKEY_SETUP_BIOME_1, "SETUP_BIOME_1");
	bindingNames.insert(INTERFACEKEY_SETUP_BIOME_2, "SETUP_BIOME_2");
	bindingNames.insert(INTERFACEKEY_SETUP_BIOME_3, "SETUP_BIOME_3");
	bindingNames.insert(INTERFACEKEY_SETUP_BIOME_4, "SETUP_BIOME_4");
	bindingNames.insert(INTERFACEKEY_SETUP_BIOME_5, "SETUP_BIOME_5");
	bindingNames.insert(INTERFACEKEY_SETUP_BIOME_6, "SETUP_BIOME_6");
	bindingNames.insert(INTERFACEKEY_SETUP_BIOME_7, "SETUP_BIOME_7");
	bindingNames.insert(INTERFACEKEY_SETUP_BIOME_8, "SETUP_BIOME_8");
	bindingNames.insert(INTERFACEKEY_SETUP_BIOME_9, "SETUP_BIOME_9");
	bindingNames.insert(INTERFACEKEY_CHOOSE_NAME_RANDOM, "CHOOSE_NAME_RANDOM");
	bindingNames.insert(INTERFACEKEY_CHOOSE_NAME_CLEAR, "CHOOSE_NAME_CLEAR");
	bindingNames.insert(INTERFACEKEY_CHOOSE_NAME_TYPE, "CHOOSE_NAME_TYPE");
	bindingNames.insert(INTERFACEKEY_ITEM_DESCRIPTION, "ITEM_DESCRIPTION");
	bindingNames.insert(INTERFACEKEY_ITEM_FORBID, "ITEM_FORBID");
	bindingNames.insert(INTERFACEKEY_ITEM_MELT, "ITEM_MELT");
	bindingNames.insert(INTERFACEKEY_ITEM_DUMP, "ITEM_DUMP");
	bindingNames.insert(INTERFACEKEY_ITEM_HIDE, "ITEM_HIDE");
	bindingNames.insert(INTERFACEKEY_HELP, "HELP");
	bindingNames.insert(INTERFACEKEY_MOVIES, "MOVIES");
	bindingNames.insert(INTERFACEKEY_OPTIONS, "OPTIONS");
	bindingNames.insert(INTERFACEKEY_OPTION_EXPORT, "OPTION_EXPORT");
	bindingNames.insert(INTERFACEKEY_CHANGETAB, "CHANGETAB");
	bindingNames.insert(INTERFACEKEY_SEC_CHANGETAB, "SEC_CHANGETAB");
	bindingNames.insert(INTERFACEKEY_STANDARDSCROLL_LEFT, "STANDARDSCROLL_LEFT");
	bindingNames.insert(INTERFACEKEY_STANDARDSCROLL_RIGHT, "STANDARDSCROLL_RIGHT");
	bindingNames.insert(INTERFACEKEY_STANDARDSCROLL_UP, "STANDARDSCROLL_UP");
	bindingNames.insert(INTERFACEKEY_STANDARDSCROLL_DOWN, "STANDARDSCROLL_DOWN");
	bindingNames.insert(INTERFACEKEY_STANDARDSCROLL_PAGEUP, "STANDARDSCROLL_PAGEUP");
	bindingNames.insert(INTERFACEKEY_STANDARDSCROLL_PAGEDOWN, "STANDARDSCROLL_PAGEDOWN");
	bindingNames.insert(INTERFACEKEY_SECONDSCROLL_UP, "SECONDSCROLL_UP");
	bindingNames.insert(INTERFACEKEY_SECONDSCROLL_DOWN, "SECONDSCROLL_DOWN");
	bindingNames.insert(INTERFACEKEY_SECONDSCROLL_PAGEUP, "SECONDSCROLL_PAGEUP");
	bindingNames.insert(INTERFACEKEY_SECONDSCROLL_PAGEDOWN, "SECONDSCROLL_PAGEDOWN");
	bindingNames.insert(INTERFACEKEY_CURSOR_UP, "CURSOR_UP");
	bindingNames.insert(INTERFACEKEY_CURSOR_DOWN, "CURSOR_DOWN");
	bindingNames.insert(INTERFACEKEY_CURSOR_LEFT, "CURSOR_LEFT");
	bindingNames.insert(INTERFACEKEY_CURSOR_RIGHT, "CURSOR_RIGHT");
	bindingNames.insert(INTERFACEKEY_CURSOR_UPLEFT, "CURSOR_UPLEFT");
	bindingNames.insert(INTERFACEKEY_CURSOR_UPRIGHT, "CURSOR_UPRIGHT");
	bindingNames.insert(INTERFACEKEY_CURSOR_DOWNLEFT, "CURSOR_DOWNLEFT");
	bindingNames.insert(INTERFACEKEY_CURSOR_DOWNRIGHT, "CURSOR_DOWNRIGHT");
	bindingNames.insert(INTERFACEKEY_CURSOR_UP_FAST, "CURSOR_UP_FAST");
	bindingNames.insert(INTERFACEKEY_CURSOR_DOWN_FAST, "CURSOR_DOWN_FAST");
	bindingNames.insert(INTERFACEKEY_CURSOR_LEFT_FAST, "CURSOR_LEFT_FAST");
	bindingNames.insert(INTERFACEKEY_CURSOR_RIGHT_FAST, "CURSOR_RIGHT_FAST");
	bindingNames.insert(INTERFACEKEY_CURSOR_UPLEFT_FAST, "CURSOR_UPLEFT_FAST");
	bindingNames.insert(INTERFACEKEY_CURSOR_UPRIGHT_FAST, "CURSOR_UPRIGHT_FAST");
	bindingNames.insert(INTERFACEKEY_CURSOR_DOWNLEFT_FAST, "CURSOR_DOWNLEFT_FAST");
	bindingNames.insert(INTERFACEKEY_CURSOR_DOWNRIGHT_FAST, "CURSOR_DOWNRIGHT_FAST");
	bindingNames.insert(INTERFACEKEY_CURSOR_UP_Z, "CURSOR_UP_Z");
	bindingNames.insert(INTERFACEKEY_CURSOR_DOWN_Z, "CURSOR_DOWN_Z");
	bindingNames.insert(INTERFACEKEY_CURSOR_UP_Z_AUX, "CURSOR_UP_Z_AUX");
	bindingNames.insert(INTERFACEKEY_CURSOR_DOWN_Z_AUX, "CURSOR_DOWN_Z_AUX");
	bindingNames.insert(INTERFACEKEY_A_RETURN_TO_ARENA, "A_RETURN_TO_ARENA");
	bindingNames.insert(INTERFACEKEY_A_MOVE_N, "A_MOVE_N");
	bindingNames.insert(INTERFACEKEY_A_MOVE_S, "A_MOVE_S");
	bindingNames.insert(INTERFACEKEY_A_MOVE_E, "A_MOVE_E");
	bindingNames.insert(INTERFACEKEY_A_MOVE_W, "A_MOVE_W");
	bindingNames.insert(INTERFACEKEY_A_MOVE_NW, "A_MOVE_NW");
	bindingNames.insert(INTERFACEKEY_A_MOVE_NE, "A_MOVE_NE");
	bindingNames.insert(INTERFACEKEY_A_MOVE_SW, "A_MOVE_SW");
	bindingNames.insert(INTERFACEKEY_A_MOVE_SE, "A_MOVE_SE");
	bindingNames.insert(INTERFACEKEY_A_MOVE_SAME_SQUARE, "A_MOVE_SAME_SQUARE");
	bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_N, "A_CARE_MOVE_N");
	bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_S, "A_CARE_MOVE_S");
	bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_E, "A_CARE_MOVE_E");
	bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_W, "A_CARE_MOVE_W");
	bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_NW, "A_CARE_MOVE_NW");
	bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_NE, "A_CARE_MOVE_NE");
	bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_SW, "A_CARE_MOVE_SW");
	bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_SE, "A_CARE_MOVE_SE");
	bindingNames.insert(INTERFACEKEY_A_CARE_MOVE_UPDOWN, "A_CARE_MOVE_UPDOWN");
	bindingNames.insert(INTERFACEKEY_A_MOVE_N_UP, "A_MOVE_N_UP");
	bindingNames.insert(INTERFACEKEY_A_MOVE_S_UP, "A_MOVE_S_UP");
	bindingNames.insert(INTERFACEKEY_A_MOVE_E_UP, "A_MOVE_E_UP");
	bindingNames.insert(INTERFACEKEY_A_MOVE_W_UP, "A_MOVE_W_UP");
	bindingNames.insert(INTERFACEKEY_A_MOVE_NW_UP, "A_MOVE_NW_UP");
	bindingNames.insert(INTERFACEKEY_A_MOVE_NE_UP, "A_MOVE_NE_UP");
	bindingNames.insert(INTERFACEKEY_A_MOVE_SW_UP, "A_MOVE_SW_UP");
	bindingNames.insert(INTERFACEKEY_A_MOVE_SE_UP, "A_MOVE_SE_UP");
	bindingNames.insert(INTERFACEKEY_A_MOVE_UP, "A_MOVE_UP");
	bindingNames.insert(INTERFACEKEY_A_MOVE_N_DOWN, "A_MOVE_N_DOWN");
	bindingNames.insert(INTERFACEKEY_A_MOVE_S_DOWN, "A_MOVE_S_DOWN");
	bindingNames.insert(INTERFACEKEY_A_MOVE_E_DOWN, "A_MOVE_E_DOWN");
	bindingNames.insert(INTERFACEKEY_A_MOVE_W_DOWN, "A_MOVE_W_DOWN");
	bindingNames.insert(INTERFACEKEY_A_MOVE_NW_DOWN, "A_MOVE_NW_DOWN");
	bindingNames.insert(INTERFACEKEY_A_MOVE_NE_DOWN, "A_MOVE_NE_DOWN");
	bindingNames.insert(INTERFACEKEY_A_MOVE_SW_DOWN, "A_MOVE_SW_DOWN");
	bindingNames.insert(INTERFACEKEY_A_MOVE_SE_DOWN, "A_MOVE_SE_DOWN");
	bindingNames.insert(INTERFACEKEY_A_MOVE_DOWN, "A_MOVE_DOWN");
	bindingNames.insert(INTERFACEKEY_A_MOVE_UP_AUX, "A_MOVE_UP_AUX");
	bindingNames.insert(INTERFACEKEY_A_MOVE_DOWN_AUX, "A_MOVE_DOWN_AUX");
	bindingNames.insert(INTERFACEKEY_WORLDGEN_EXPORT_MAP, "WORLDGEN_EXPORT_MAP");
	bindingNames.insert(INTERFACEKEY_LEGENDS_EXPORT_MAP, "LEGENDS_EXPORT_MAP");
	bindingNames.insert(INTERFACEKEY_LEGENDS_EXPORT_XML, "LEGENDS_EXPORT_XML");
	bindingNames.insert(INTERFACEKEY_LEGENDS_EXPORT_DETAILED_MAP, "LEGENDS_EXPORT_DETAILED_MAP");
	bindingNames.insert(INTERFACEKEY_LEGENDS_TOGGLE_CIVSITE, "LEGENDS_TOGGLE_CIVSITE");
	bindingNames.insert(INTERFACEKEY_LEGENDS_STRING_FILTER, "LEGENDS_STRING_FILTER");
	bindingNames.insert(INTERFACEKEY_A_COMBAT_ATTACK, "A_COMBAT_ATTACK");
	bindingNames.insert(INTERFACEKEY_A_COMBAT_DODGE, "A_COMBAT_DODGE");
	bindingNames.insert(INTERFACEKEY_A_COMBAT_CHARGEDEF, "A_COMBAT_CHARGEDEF");
	bindingNames.insert(INTERFACEKEY_A_STATUS, "A_STATUS");
	bindingNames.insert(INTERFACEKEY_A_STATUS_WRESTLE, "A_STATUS_WRESTLE");
	bindingNames.insert(INTERFACEKEY_A_STATUS_CUSTOMIZE, "A_STATUS_CUSTOMIZE");
	bindingNames.insert(INTERFACEKEY_A_STATUS_KILLS, "A_STATUS_KILLS");
	bindingNames.insert(INTERFACEKEY_A_STATUS_HEALTH, "A_STATUS_HEALTH");
	bindingNames.insert(INTERFACEKEY_A_STATUS_ATT_SKILL, "A_STATUS_ATT_SKILL");
	bindingNames.insert(INTERFACEKEY_A_STATUS_DESC, "A_STATUS_DESC");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_CUSTOMIZE, "UNITVIEW_CUSTOMIZE");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_HEALTH, "UNITVIEW_HEALTH");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_RELATIONSHIPS, "UNITVIEW_RELATIONSHIPS");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_RELATIONSHIPS_ZOOM, "UNITVIEW_RELATIONSHIPS_ZOOM");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_RELATIONSHIPS_VIEW, "UNITVIEW_RELATIONSHIPS_VIEW");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_KILLS, "UNITVIEW_KILLS");
	bindingNames.insert(INTERFACEKEY_CUSTOMIZE_UNIT_NICKNAME, "CUSTOMIZE_UNIT_NICKNAME");
	bindingNames.insert(INTERFACEKEY_CUSTOMIZE_UNIT_PROFNAME, "CUSTOMIZE_UNIT_PROFNAME");
	bindingNames.insert(INTERFACEKEY_A_CLEAR_ANNOUNCEMENTS, "A_CLEAR_ANNOUNCEMENTS");
	bindingNames.insert(INTERFACEKEY_A_SLEEP, "A_SLEEP");
	bindingNames.insert(INTERFACEKEY_A_SLEEP_SLEEP, "A_SLEEP_SLEEP");
	bindingNames.insert(INTERFACEKEY_A_SLEEP_WAIT, "A_SLEEP_WAIT");
	bindingNames.insert(INTERFACEKEY_A_SLEEP_DAWN, "A_SLEEP_DAWN");
	bindingNames.insert(INTERFACEKEY_A_WAIT, "A_WAIT");
	bindingNames.insert(INTERFACEKEY_A_ATTACK, "A_ATTACK");
	bindingNames.insert(INTERFACEKEY_A_ATTACK_CONFIRM, "A_ATTACK_CONFIRM");
	bindingNames.insert(INTERFACEKEY_A_LOOK, "A_LOOK");
	bindingNames.insert(INTERFACEKEY_A_SEARCH, "A_SEARCH");
	bindingNames.insert(INTERFACEKEY_A_TALK, "A_TALK");
	bindingNames.insert(INTERFACEKEY_A_INTERACT, "A_INTERACT");
	bindingNames.insert(INTERFACEKEY_A_ACTION, "A_ACTION");
	bindingNames.insert(INTERFACEKEY_A_ACTION_CREATE, "A_ACTION_CREATE");
	bindingNames.insert(INTERFACEKEY_A_ACTION_BUTCHER, "A_ACTION_BUTCHER");
	bindingNames.insert(INTERFACEKEY_A_ACTION_ABILITY, "A_ACTION_ABILITY");
	bindingNames.insert(INTERFACEKEY_A_ACTION_POWER, "A_ACTION_POWER");
	bindingNames.insert(INTERFACEKEY_A_INV_LOOK, "A_INV_LOOK");
	bindingNames.insert(INTERFACEKEY_A_INV_REMOVE, "A_INV_REMOVE");
	bindingNames.insert(INTERFACEKEY_A_INV_WEAR, "A_INV_WEAR");
	bindingNames.insert(INTERFACEKEY_A_INV_EATDRINK, "A_INV_EATDRINK");
	bindingNames.insert(INTERFACEKEY_A_INV_PUTIN, "A_INV_PUTIN");
	bindingNames.insert(INTERFACEKEY_A_INV_DROP, "A_INV_DROP");
	bindingNames.insert(INTERFACEKEY_A_GROUND, "A_GROUND");
	bindingNames.insert(INTERFACEKEY_A_THROW, "A_THROW");
	bindingNames.insert(INTERFACEKEY_A_SHOOT, "A_SHOOT");
	bindingNames.insert(INTERFACEKEY_A_ANNOUNCEMENTS, "A_ANNOUNCEMENTS");
	bindingNames.insert(INTERFACEKEY_A_COMBAT, "A_COMBAT");
	bindingNames.insert(INTERFACEKEY_A_MOVEMENT, "A_MOVEMENT");
	bindingNames.insert(INTERFACEKEY_A_MOVEMENT_SWIM, "A_MOVEMENT_SWIM");
	bindingNames.insert(INTERFACEKEY_A_SNEAK, "A_SNEAK");
	bindingNames.insert(INTERFACEKEY_A_CENTER, "A_CENTER");
	bindingNames.insert(INTERFACEKEY_A_COMPANIONS, "A_COMPANIONS");
	bindingNames.insert(INTERFACEKEY_A_BUILDING, "A_BUILDING");
	bindingNames.insert(INTERFACEKEY_A_TRAVEL, "A_TRAVEL");
	bindingNames.insert(INTERFACEKEY_A_TRAVEL_SLEEP, "A_TRAVEL_SLEEP");
	bindingNames.insert(INTERFACEKEY_A_TRAVEL_MAP, "A_TRAVEL_MAP");
	bindingNames.insert(INTERFACEKEY_A_TRAVEL_HIDE_INSTRUCTIONS, "A_TRAVEL_HIDE_INSTRUCTIONS");
	bindingNames.insert(INTERFACEKEY_A_DATE, "A_DATE");
	bindingNames.insert(INTERFACEKEY_A_WEATHER, "A_WEATHER");
	bindingNames.insert(INTERFACEKEY_A_TEMPERATURE, "A_TEMPERATURE");
	bindingNames.insert(INTERFACEKEY_A_STANCE, "A_STANCE");
	bindingNames.insert(INTERFACEKEY_OPTION1, "OPTION1");
	bindingNames.insert(INTERFACEKEY_OPTION2, "OPTION2");
	bindingNames.insert(INTERFACEKEY_OPTION3, "OPTION3");
	bindingNames.insert(INTERFACEKEY_OPTION4, "OPTION4");
	bindingNames.insert(INTERFACEKEY_OPTION5, "OPTION5");
	bindingNames.insert(INTERFACEKEY_OPTION6, "OPTION6");
	bindingNames.insert(INTERFACEKEY_OPTION7, "OPTION7");
	bindingNames.insert(INTERFACEKEY_OPTION8, "OPTION8");
	bindingNames.insert(INTERFACEKEY_OPTION9, "OPTION9");
	bindingNames.insert(INTERFACEKEY_OPTION10, "OPTION10");
	bindingNames.insert(INTERFACEKEY_OPTION11, "OPTION11");
	bindingNames.insert(INTERFACEKEY_OPTION12, "OPTION12");
	bindingNames.insert(INTERFACEKEY_OPTION13, "OPTION13");
	bindingNames.insert(INTERFACEKEY_OPTION14, "OPTION14");
	bindingNames.insert(INTERFACEKEY_OPTION15, "OPTION15");
	bindingNames.insert(INTERFACEKEY_OPTION16, "OPTION16");
	bindingNames.insert(INTERFACEKEY_OPTION17, "OPTION17");
	bindingNames.insert(INTERFACEKEY_OPTION18, "OPTION18");
	bindingNames.insert(INTERFACEKEY_OPTION19, "OPTION19");
	bindingNames.insert(INTERFACEKEY_OPTION20, "OPTION20");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION1, "SEC_OPTION1");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION2, "SEC_OPTION2");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION3, "SEC_OPTION3");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION4, "SEC_OPTION4");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION5, "SEC_OPTION5");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION6, "SEC_OPTION6");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION7, "SEC_OPTION7");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION8, "SEC_OPTION8");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION9, "SEC_OPTION9");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION10, "SEC_OPTION10");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION11, "SEC_OPTION11");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION12, "SEC_OPTION12");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION13, "SEC_OPTION13");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION14, "SEC_OPTION14");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION15, "SEC_OPTION15");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION16, "SEC_OPTION16");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION17, "SEC_OPTION17");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION18, "SEC_OPTION18");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION19, "SEC_OPTION19");
	bindingNames.insert(INTERFACEKEY_SEC_OPTION20, "SEC_OPTION20");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MAKE_ASH, "HOTKEY_MAKE_ASH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MAKE_CHARCOAL, "HOTKEY_MAKE_CHARCOAL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MELT_OBJECT, "HOTKEY_MELT_OBJECT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_GREEN, "HOTKEY_GLASS_GREEN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_CLEAR, "HOTKEY_GLASS_CLEAR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_CRYSTAL, "HOTKEY_GLASS_CRYSTAL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_COLLECT_SAND, "HOTKEY_COLLECT_SAND");
	bindingNames.insert(INTERFACEKEY_HOTKEY_COLLECT_CLAY, "HOTKEY_COLLECT_CLAY");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_ROUGH, "HOTKEY_GLASS_ROUGH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_ARMORSTAND, "HOTKEY_GLASS_ARMORSTAND");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_BOX, "HOTKEY_GLASS_BOX");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_CABINET, "HOTKEY_GLASS_CABINET");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_COFFIN, "HOTKEY_GLASS_COFFIN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_FLOODGATE, "HOTKEY_GLASS_FLOODGATE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_HATCH_COVER, "HOTKEY_GLASS_HATCH_COVER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_GRATE, "HOTKEY_GLASS_GRATE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_GOBLET, "HOTKEY_GLASS_GOBLET");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_TOY, "HOTKEY_GLASS_TOY");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_INSTRUMENT, "HOTKEY_GLASS_INSTRUMENT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_DOOR, "HOTKEY_GLASS_DOOR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_STATUE, "HOTKEY_GLASS_STATUE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_TABLE, "HOTKEY_GLASS_TABLE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_CAGE, "HOTKEY_GLASS_CAGE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_CHAIR, "HOTKEY_GLASS_CHAIR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_BLOCKS, "HOTKEY_GLASS_BLOCKS");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_FLASK, "HOTKEY_GLASS_FLASK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_WEAPONRACK, "HOTKEY_GLASS_WEAPONRACK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_GLASS_WINDOW, "HOTKEY_GLASS_WINDOW");
	bindingNames.insert(INTERFACEKEY_HOTKEY_ASHERY_LYE, "HOTKEY_ASHERY_LYE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_ASHERY_POTASH, "HOTKEY_ASHERY_POTASH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_ASHERY_POTASH_DIRECT, "HOTKEY_ASHERY_POTASH_DIRECT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BARREL, "HOTKEY_CARPENTER_BARREL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BLOCKS, "HOTKEY_CARPENTER_BLOCKS");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BUCKET, "HOTKEY_CARPENTER_BUCKET");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_TRAP_ANIMAL, "HOTKEY_CARPENTER_TRAP_ANIMAL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_CAGE, "HOTKEY_CARPENTER_CAGE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_ARMORSTAND, "HOTKEY_CARPENTER_ARMORSTAND");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BED, "HOTKEY_CARPENTER_BED");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_CHAIR, "HOTKEY_CARPENTER_CHAIR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_COFFIN, "HOTKEY_CARPENTER_COFFIN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_DOOR, "HOTKEY_CARPENTER_DOOR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_FLOODGATE, "HOTKEY_CARPENTER_FLOODGATE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_HATCH_COVER, "HOTKEY_CARPENTER_HATCH_COVER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_GRATE, "HOTKEY_CARPENTER_GRATE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_CABINET, "HOTKEY_CARPENTER_CABINET");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BIN, "HOTKEY_CARPENTER_BIN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BOX, "HOTKEY_CARPENTER_BOX");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_WEAPONRACK, "HOTKEY_CARPENTER_WEAPONRACK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_TABLE, "HOTKEY_CARPENTER_TABLE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_SIEGE_BALLISTA, "HOTKEY_SIEGE_BALLISTA");
	bindingNames.insert(INTERFACEKEY_HOTKEY_SIEGE_CATAPULT, "HOTKEY_SIEGE_CATAPULT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_BOX, "HOTKEY_LEATHER_BOX");
	bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_FLASK, "HOTKEY_LEATHER_FLASK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_SHIRT, "HOTKEY_LEATHER_SHIRT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_CLOAK, "HOTKEY_LEATHER_CLOAK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_BACKPACK, "HOTKEY_LEATHER_BACKPACK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_QUIVER, "HOTKEY_LEATHER_QUIVER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_LEATHER_IMAGE, "HOTKEY_LEATHER_IMAGE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_MAT_PLANT, "HOTKEY_CLOTHES_MAT_PLANT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_MAT_SILK, "HOTKEY_CLOTHES_MAT_SILK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_MAT_YARN, "HOTKEY_CLOTHES_MAT_YARN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_SHIRT, "HOTKEY_CLOTHES_SHIRT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_CLOAK, "HOTKEY_CLOTHES_CLOAK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_BOX, "HOTKEY_CLOTHES_BOX");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_CHAIN, "HOTKEY_CLOTHES_CHAIN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_IMAGE, "HOTKEY_CLOTHES_IMAGE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_STONE, "HOTKEY_CRAFTS_MAT_STONE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_WOOD, "HOTKEY_CRAFTS_MAT_WOOD");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_DEC_BONE, "HOTKEY_CRAFTS_DEC_BONE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_DEC_SHELL, "HOTKEY_CRAFTS_DEC_SHELL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_DEC_TOOTH, "HOTKEY_CRAFTS_DEC_TOOTH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_DEC_HORN, "HOTKEY_CRAFTS_DEC_HORN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_DEC_PEARL, "HOTKEY_CRAFTS_DEC_PEARL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_TOTEM, "HOTKEY_CRAFTS_TOTEM");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_CLOTH, "HOTKEY_CRAFTS_CLOTH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SILK, "HOTKEY_CRAFTS_SILK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_YARN, "HOTKEY_CRAFTS_YARN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SEL_WOOD, "HOTKEY_CRAFTS_SEL_WOOD");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SEL_BONE, "HOTKEY_CRAFTS_SEL_BONE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SEL_SHELL, "HOTKEY_CRAFTS_SEL_SHELL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SHELL, "HOTKEY_CRAFTS_SHELL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_TOOTH, "HOTKEY_CRAFTS_TOOTH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_HORN, "HOTKEY_CRAFTS_HORN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_PEARL, "HOTKEY_CRAFTS_PEARL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_BONE, "HOTKEY_CRAFTS_BONE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_LEATHER, "HOTKEY_CRAFTS_LEATHER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SLAB, "HOTKEY_CRAFTS_SLAB");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_CRAFTS, "HOTKEY_CRAFTS_MAT_CRAFTS");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_GOBLET, "HOTKEY_CRAFTS_MAT_GOBLET");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_INSTRUMENT, "HOTKEY_CRAFTS_MAT_INSTRUMENT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_TOY, "HOTKEY_CRAFTS_MAT_TOY");
	bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_WEAPON, "HOTKEY_SMITH_WEAPON");
	bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_ARMOR, "HOTKEY_SMITH_ARMOR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_FURNITURE, "HOTKEY_SMITH_FURNITURE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_SIEGE, "HOTKEY_SMITH_SIEGE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_TRAP, "HOTKEY_SMITH_TRAP");
	bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_OTHER, "HOTKEY_SMITH_OTHER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_SMITH_METAL, "HOTKEY_SMITH_METAL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ARMORSTAND, "HOTKEY_BUILDING_ARMORSTAND");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BED, "HOTKEY_BUILDING_BED");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRACTION_BENCH, "HOTKEY_BUILDING_TRACTION_BENCH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SLAB, "HOTKEY_BUILDING_SLAB");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_NEST_BOX, "HOTKEY_BUILDING_NEST_BOX");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_HIVE, "HOTKEY_BUILDING_HIVE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CHAIR, "HOTKEY_BUILDING_CHAIR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_COFFIN, "HOTKEY_BUILDING_COFFIN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_DOOR, "HOTKEY_BUILDING_DOOR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FLOODGATE, "HOTKEY_BUILDING_FLOODGATE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_HATCH, "HOTKEY_BUILDING_HATCH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_GRATE_WALL, "HOTKEY_BUILDING_GRATE_WALL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_GRATE_FLOOR, "HOTKEY_BUILDING_GRATE_FLOOR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BARS_VERTICAL, "HOTKEY_BUILDING_BARS_VERTICAL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BARS_FLOOR, "HOTKEY_BUILDING_BARS_FLOOR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CABINET, "HOTKEY_BUILDING_CABINET");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BOX, "HOTKEY_BUILDING_BOX");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_KENNEL, "HOTKEY_BUILDING_KENNEL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FARMPLOT, "HOTKEY_BUILDING_FARMPLOT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WEAPONRACK, "HOTKEY_BUILDING_WEAPONRACK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_STATUE, "HOTKEY_BUILDING_STATUE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TABLE, "HOTKEY_BUILDING_TABLE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ROAD_DIRT, "HOTKEY_BUILDING_ROAD_DIRT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ROAD_PAVED, "HOTKEY_BUILDING_ROAD_PAVED");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BRIDGE, "HOTKEY_BUILDING_BRIDGE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WELL, "HOTKEY_BUILDING_WELL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE, "HOTKEY_BUILDING_SIEGEENGINE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP, "HOTKEY_BUILDING_WORKSHOP");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE, "HOTKEY_BUILDING_FURNACE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GLASS, "HOTKEY_BUILDING_WINDOW_GLASS");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GEM, "HOTKEY_BUILDING_WINDOW_GEM");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SHOP, "HOTKEY_BUILDING_SHOP");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ANIMALTRAP, "HOTKEY_BUILDING_ANIMALTRAP");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CHAIN, "HOTKEY_BUILDING_CHAIN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CAGE, "HOTKEY_BUILDING_CAGE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRADEDEPOT, "HOTKEY_BUILDING_TRADEDEPOT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP, "HOTKEY_BUILDING_TRAP");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE, "HOTKEY_BUILDING_MACHINE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SUPPORT, "HOTKEY_BUILDING_SUPPORT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ARCHERYTARGET, "HOTKEY_BUILDING_ARCHERYTARGET");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_SCREW_PUMP, "HOTKEY_BUILDING_MACHINE_SCREW_PUMP");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WATER_WHEEL, "HOTKEY_BUILDING_MACHINE_WATER_WHEEL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WINDMILL, "HOTKEY_BUILDING_MACHINE_WINDMILL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_GEAR_ASSEMBLY, "HOTKEY_BUILDING_MACHINE_GEAR_ASSEMBLY");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_HORIZONTAL, "HOTKEY_BUILDING_MACHINE_AXLE_HORIZONTAL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_VERTICAL, "HOTKEY_BUILDING_MACHINE_AXLE_VERTICAL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_ROLLERS, "HOTKEY_BUILDING_MACHINE_ROLLERS");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_BALLISTA, "HOTKEY_BUILDING_SIEGEENGINE_BALLISTA");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_CATAPULT, "HOTKEY_BUILDING_SIEGEENGINE_CATAPULT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_STONE, "HOTKEY_BUILDING_TRAP_STONE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_WEAPON, "HOTKEY_BUILDING_TRAP_WEAPON");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_LEVER, "HOTKEY_BUILDING_TRAP_LEVER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_TRIGGER, "HOTKEY_BUILDING_TRAP_TRIGGER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_CAGE, "HOTKEY_BUILDING_TRAP_CAGE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_SPIKE, "HOTKEY_BUILDING_TRAP_SPIKE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION, "HOTKEY_BUILDING_CONSTRUCTION");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FORTIFICATION, "HOTKEY_BUILDING_CONSTRUCTION_FORTIFICATION");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_WALL, "HOTKEY_BUILDING_CONSTRUCTION_WALL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FLOOR, "HOTKEY_BUILDING_CONSTRUCTION_FLOOR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_RAMP, "HOTKEY_BUILDING_CONSTRUCTION_RAMP");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UP, "HOTKEY_BUILDING_CONSTRUCTION_STAIR_UP");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_DOWN, "HOTKEY_BUILDING_CONSTRUCTION_STAIR_DOWN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UPDOWN, "HOTKEY_BUILDING_CONSTRUCTION_STAIR_UPDOWN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_TRACK, "HOTKEY_BUILDING_CONSTRUCTION_TRACK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_TRACK_STOP, "HOTKEY_BUILDING_CONSTRUCTION_TRACK_STOP");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LEATHER, "HOTKEY_BUILDING_WORKSHOP_LEATHER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_QUERN, "HOTKEY_BUILDING_WORKSHOP_QUERN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MILLSTONE, "HOTKEY_BUILDING_WORKSHOP_MILLSTONE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LOOM, "HOTKEY_BUILDING_WORKSHOP_LOOM");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CLOTHES, "HOTKEY_BUILDING_WORKSHOP_CLOTHES");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BOWYER, "HOTKEY_BUILDING_WORKSHOP_BOWYER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CARPENTER, "HOTKEY_BUILDING_WORKSHOP_CARPENTER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_METALSMITH, "HOTKEY_BUILDING_WORKSHOP_METALSMITH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LAVAMILL, "HOTKEY_BUILDING_WORKSHOP_LAVAMILL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_JEWELER, "HOTKEY_BUILDING_WORKSHOP_JEWELER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MASON, "HOTKEY_BUILDING_WORKSHOP_MASON");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BUTCHER, "HOTKEY_BUILDING_WORKSHOP_BUTCHER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_TANNER, "HOTKEY_BUILDING_WORKSHOP_TANNER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_DYER, "HOTKEY_BUILDING_WORKSHOP_DYER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CRAFTSMAN, "HOTKEY_BUILDING_WORKSHOP_CRAFTSMAN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_SIEGE, "HOTKEY_BUILDING_WORKSHOP_SIEGE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MECHANIC, "HOTKEY_BUILDING_WORKSHOP_MECHANIC");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_STILL, "HOTKEY_BUILDING_WORKSHOP_STILL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FARMER, "HOTKEY_BUILDING_WORKSHOP_FARMER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_KITCHEN, "HOTKEY_BUILDING_WORKSHOP_KITCHEN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FISHERY, "HOTKEY_BUILDING_WORKSHOP_FISHERY");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_ASHERY, "HOTKEY_BUILDING_WORKSHOP_ASHERY");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_WOOD, "HOTKEY_BUILDING_FURNACE_WOOD");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER, "HOTKEY_BUILDING_FURNACE_SMELTER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS, "HOTKEY_BUILDING_FURNACE_GLASS");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN, "HOTKEY_BUILDING_FURNACE_KILN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER_LAVA, "HOTKEY_BUILDING_FURNACE_SMELTER_LAVA");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS_LAVA, "HOTKEY_BUILDING_FURNACE_GLASS_LAVA");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN_LAVA, "HOTKEY_BUILDING_FURNACE_KILN_LAVA");
	bindingNames.insert(INTERFACEKEY_HIVE_INSTALL_COLONY, "HIVE_INSTALL_COLONY");
	bindingNames.insert(INTERFACEKEY_HIVE_GATHER_PRODUCTS, "HIVE_GATHER_PRODUCTS");
	bindingNames.insert(INTERFACEKEY_D_ONESTEP, "D_ONESTEP");
	bindingNames.insert(INTERFACEKEY_D_PAUSE, "D_PAUSE");
	bindingNames.insert(INTERFACEKEY_D_DEPOT, "D_DEPOT");
	bindingNames.insert(INTERFACEKEY_D_HOT_KEYS, "D_HOT_KEYS");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY1, "D_HOTKEY1");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY2, "D_HOTKEY2");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY3, "D_HOTKEY3");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY4, "D_HOTKEY4");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY5, "D_HOTKEY5");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY6, "D_HOTKEY6");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY7, "D_HOTKEY7");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY8, "D_HOTKEY8");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY9, "D_HOTKEY9");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY10, "D_HOTKEY10");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY11, "D_HOTKEY11");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY12, "D_HOTKEY12");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY13, "D_HOTKEY13");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY14, "D_HOTKEY14");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY15, "D_HOTKEY15");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY16, "D_HOTKEY16");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY_CHANGE_NAME, "D_HOTKEY_CHANGE_NAME");
	bindingNames.insert(INTERFACEKEY_D_HOTKEY_ZOOM, "D_HOTKEY_ZOOM");
	bindingNames.insert(INTERFACEKEY_D_ANNOUNCE, "D_ANNOUNCE");
	bindingNames.insert(INTERFACEKEY_D_REPORTS, "D_REPORTS");
	bindingNames.insert(INTERFACEKEY_D_BUILDING, "D_BUILDING");
	bindingNames.insert(INTERFACEKEY_D_CIVLIST, "D_CIVLIST");
	bindingNames.insert(INTERFACEKEY_D_DESIGNATE, "D_DESIGNATE");
	bindingNames.insert(INTERFACEKEY_D_ARTLIST, "D_ARTLIST");
	bindingNames.insert(INTERFACEKEY_D_NOBLES, "D_NOBLES");
	bindingNames.insert(INTERFACEKEY_D_ORDERS, "D_ORDERS");
	bindingNames.insert(INTERFACEKEY_D_MILITARY, "D_MILITARY");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_CREATE_SQUAD, "D_MILITARY_CREATE_SQUAD");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_DISBAND_SQUAD, "D_MILITARY_DISBAND_SQUAD");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_CREATE_SUB_SQUAD, "D_MILITARY_CREATE_SUB_SQUAD");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_CANCEL_ORDERS, "D_MILITARY_CANCEL_ORDERS");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_POSITIONS, "D_MILITARY_POSITIONS");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ALERTS, "D_MILITARY_ALERTS");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ALERTS_ADD, "D_MILITARY_ALERTS_ADD");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ALERTS_DELETE, "D_MILITARY_ALERTS_DELETE");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ALERTS_SET, "D_MILITARY_ALERTS_SET");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ALERTS_NAME, "D_MILITARY_ALERTS_NAME");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ALERTS_SET_RETAIN, "D_MILITARY_ALERTS_SET_RETAIN");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_EQUIP, "D_MILITARY_EQUIP");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_EQUIP_CUSTOMIZE, "D_MILITARY_EQUIP_CUSTOMIZE");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_EQUIP_UNIFORM, "D_MILITARY_EQUIP_UNIFORM");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_EQUIP_PRIORITY, "D_MILITARY_EQUIP_PRIORITY");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_UNIFORMS, "D_MILITARY_UNIFORMS");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_SUPPLIES, "D_MILITARY_SUPPLIES");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_SUPPLIES_WATER_DOWN, "D_MILITARY_SUPPLIES_WATER_DOWN");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_SUPPLIES_WATER_UP, "D_MILITARY_SUPPLIES_WATER_UP");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_SUPPLIES_FOOD_DOWN, "D_MILITARY_SUPPLIES_FOOD_DOWN");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_SUPPLIES_FOOD_UP, "D_MILITARY_SUPPLIES_FOOD_UP");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION, "D_MILITARY_AMMUNITION");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_ADD_ITEM, "D_MILITARY_AMMUNITION_ADD_ITEM");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_REMOVE_ITEM, "D_MILITARY_AMMUNITION_REMOVE_ITEM");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_LOWER_AMOUNT, "D_MILITARY_AMMUNITION_LOWER_AMOUNT");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_RAISE_AMOUNT, "D_MILITARY_AMMUNITION_RAISE_AMOUNT");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_LOWER_AMOUNT_LOTS, "D_MILITARY_AMMUNITION_LOWER_AMOUNT_LOTS");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_RAISE_AMOUNT_LOTS, "D_MILITARY_AMMUNITION_RAISE_AMOUNT_LOTS");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_MATERIAL, "D_MILITARY_AMMUNITION_MATERIAL");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_COMBAT, "D_MILITARY_AMMUNITION_COMBAT");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_TRAINING, "D_MILITARY_AMMUNITION_TRAINING");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_TRAINING, "D_MILITARY_TRAINING");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_SCHEDULE, "D_MILITARY_SCHEDULE");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ADD_UNIFORM, "D_MILITARY_ADD_UNIFORM");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_DELETE_UNIFORM, "D_MILITARY_DELETE_UNIFORM");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_NAME_UNIFORM, "D_MILITARY_NAME_UNIFORM");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_NAME_SQUAD, "D_MILITARY_NAME_SQUAD");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ADD_ARMOR, "D_MILITARY_ADD_ARMOR");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ADD_PANTS, "D_MILITARY_ADD_PANTS");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ADD_HELM, "D_MILITARY_ADD_HELM");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ADD_GLOVES, "D_MILITARY_ADD_GLOVES");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ADD_BOOTS, "D_MILITARY_ADD_BOOTS");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ADD_SHIELD, "D_MILITARY_ADD_SHIELD");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ADD_WEAPON, "D_MILITARY_ADD_WEAPON");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ADD_MATERIAL, "D_MILITARY_ADD_MATERIAL");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_ADD_COLOR, "D_MILITARY_ADD_COLOR");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_REPLACE_CLOTHING, "D_MILITARY_REPLACE_CLOTHING");
	bindingNames.insert(INTERFACEKEY_D_MILITARY_EXACT_MATCH, "D_MILITARY_EXACT_MATCH");
	bindingNames.insert(INTERFACEKEY_D_ROOMS, "D_ROOMS");
	bindingNames.insert(INTERFACEKEY_BUILDINGLIST_ZOOM_T, "BUILDINGLIST_ZOOM_T");
	bindingNames.insert(INTERFACEKEY_BUILDINGLIST_ZOOM_Q, "BUILDINGLIST_ZOOM_Q");
	bindingNames.insert(INTERFACEKEY_D_SQUADS, "D_SQUADS");
	bindingNames.insert(INTERFACEKEY_D_SQUADS_MOVE, "D_SQUADS_MOVE");
	bindingNames.insert(INTERFACEKEY_D_SQUADS_KILL, "D_SQUADS_KILL");
	bindingNames.insert(INTERFACEKEY_D_SQUADS_KILL_LIST, "D_SQUADS_KILL_LIST");
	bindingNames.insert(INTERFACEKEY_D_SQUADS_KILL_RECT, "D_SQUADS_KILL_RECT");
	bindingNames.insert(INTERFACEKEY_D_SQUADS_SCHEDULE, "D_SQUADS_SCHEDULE");
	bindingNames.insert(INTERFACEKEY_D_SQUADS_CANCEL_ORDER, "D_SQUADS_CANCEL_ORDER");
	bindingNames.insert(INTERFACEKEY_D_SQUADS_ALERT, "D_SQUADS_ALERT");
	bindingNames.insert(INTERFACEKEY_D_SQUADS_SELECT_INDIVIDUALS, "D_SQUADS_SELECT_INDIVIDUALS");
	bindingNames.insert(INTERFACEKEY_D_SQUADS_CENTER, "D_SQUADS_CENTER");
	bindingNames.insert(INTERFACEKEY_D_SQUAD_SCH_SLEEP, "D_SQUAD_SCH_SLEEP");
	bindingNames.insert(INTERFACEKEY_D_SQUAD_SCH_CIVILIAN_UNIFORM, "D_SQUAD_SCH_CIVILIAN_UNIFORM");
	bindingNames.insert(INTERFACEKEY_D_SQUAD_SCH_GIVE_ORDER, "D_SQUAD_SCH_GIVE_ORDER");
	bindingNames.insert(INTERFACEKEY_D_SQUAD_SCH_EDIT_ORDER, "D_SQUAD_SCH_EDIT_ORDER");
	bindingNames.insert(INTERFACEKEY_D_SQUAD_SCH_CANCEL_ORDER, "D_SQUAD_SCH_CANCEL_ORDER");
	bindingNames.insert(INTERFACEKEY_D_SQUAD_SCH_COPY_ORDERS, "D_SQUAD_SCH_COPY_ORDERS");
	bindingNames.insert(INTERFACEKEY_D_SQUAD_SCH_PASTE_ORDERS, "D_SQUAD_SCH_PASTE_ORDERS");
	bindingNames.insert(INTERFACEKEY_D_SQUAD_SCH_MS_NAME, "D_SQUAD_SCH_MS_NAME");
	bindingNames.insert(INTERFACEKEY_D_STOCKPILES, "D_STOCKPILES");
	bindingNames.insert(INTERFACEKEY_D_CIVZONE, "D_CIVZONE");
	bindingNames.insert(INTERFACEKEY_D_VIEWUNIT, "D_VIEWUNIT");
	bindingNames.insert(INTERFACEKEY_D_JOBLIST, "D_JOBLIST");
	bindingNames.insert(INTERFACEKEY_D_UNITLIST, "D_UNITLIST");
	bindingNames.insert(INTERFACEKEY_D_LOOK, "D_LOOK");
	bindingNames.insert(INTERFACEKEY_D_HAULING, "D_HAULING");
	bindingNames.insert(INTERFACEKEY_D_HAULING_NEW_ROUTE, "D_HAULING_NEW_ROUTE");
	bindingNames.insert(INTERFACEKEY_D_HAULING_NEW_STOP, "D_HAULING_NEW_STOP");
	bindingNames.insert(INTERFACEKEY_D_HAULING_REMOVE, "D_HAULING_REMOVE");
	bindingNames.insert(INTERFACEKEY_D_HAULING_PROMOTE, "D_HAULING_PROMOTE");
	bindingNames.insert(INTERFACEKEY_D_HAULING_VEHICLE, "D_HAULING_VEHICLE");
	bindingNames.insert(INTERFACEKEY_D_HAULING_NICKNAME, "D_HAULING_NICKNAME");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_NEW_DEPART, "D_HAULING_STOP_NEW_DEPART");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_NEW_LINK, "D_HAULING_STOP_NEW_LINK");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_REMOVE, "D_HAULING_STOP_REMOVE");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_SL_SELECT_PILE, "D_HAULING_STOP_SL_SELECT_PILE");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_SL_TAKE_GIVE, "D_HAULING_STOP_SL_TAKE_GIVE");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_DIR, "D_HAULING_STOP_LC_DIR");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_MODE, "D_HAULING_STOP_LC_MODE");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_TIMER_UP, "D_HAULING_STOP_LC_TIMER_UP");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_TIMER_DOWN, "D_HAULING_STOP_LC_TIMER_DOWN");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_FULLNESS_UP, "D_HAULING_STOP_LC_FULLNESS_UP");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_FULLNESS_DOWN, "D_HAULING_STOP_LC_FULLNESS_DOWN");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_MORE_LESS, "D_HAULING_STOP_LC_MORE_LESS");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_DESIRED_TOTAL, "D_HAULING_STOP_LC_DESIRED_TOTAL");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_CHANGE, "D_HAULING_STOP_LC_CHANGE");
	bindingNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_ADVANCED, "D_HAULING_STOP_LC_ADVANCED");
	bindingNames.insert(INTERFACEKEY_D_BURROWS, "D_BURROWS");
	bindingNames.insert(INTERFACEKEY_D_BURROWS_ADD, "D_BURROWS_ADD");
	bindingNames.insert(INTERFACEKEY_D_BURROWS_DELETE, "D_BURROWS_DELETE");
	bindingNames.insert(INTERFACEKEY_D_BURROWS_DEFINE, "D_BURROWS_DEFINE");
	bindingNames.insert(INTERFACEKEY_D_BURROWS_ADD_UNIT, "D_BURROWS_ADD_UNIT");
	bindingNames.insert(INTERFACEKEY_D_BURROWS_CENTER, "D_BURROWS_CENTER");
	bindingNames.insert(INTERFACEKEY_D_BURROWS_NAME, "D_BURROWS_NAME");
	bindingNames.insert(INTERFACEKEY_D_BURROWS_CHANGE_SELECTION, "D_BURROWS_CHANGE_SELECTION");
	bindingNames.insert(INTERFACEKEY_D_BURROWS_BRUSH, "D_BURROWS_BRUSH");
	bindingNames.insert(INTERFACEKEY_D_BURROWS_REMOVE, "D_BURROWS_REMOVE");
	bindingNames.insert(INTERFACEKEY_D_NOTE, "D_NOTE");
	bindingNames.insert(INTERFACEKEY_D_NOTE_PLACE, "D_NOTE_PLACE");
	bindingNames.insert(INTERFACEKEY_D_NOTE_DELETE, "D_NOTE_DELETE");
	bindingNames.insert(INTERFACEKEY_D_NOTE_NAME, "D_NOTE_NAME");
	bindingNames.insert(INTERFACEKEY_D_NOTE_ENTER, "D_NOTE_ENTER");
	bindingNames.insert(INTERFACEKEY_D_NOTE_ADOPT_SYMBOL, "D_NOTE_ADOPT_SYMBOL");
	bindingNames.insert(INTERFACEKEY_D_NOTE_CHANGE_SELECTION, "D_NOTE_CHANGE_SELECTION");
	bindingNames.insert(INTERFACEKEY_D_NOTE_POINTS, "D_NOTE_POINTS");
	bindingNames.insert(INTERFACEKEY_D_NOTE_ROUTE, "D_NOTE_ROUTE");
	bindingNames.insert(INTERFACEKEY_D_NOTE_ROUTE_ADD, "D_NOTE_ROUTE_ADD");
	bindingNames.insert(INTERFACEKEY_D_NOTE_ROUTE_EDIT, "D_NOTE_ROUTE_EDIT");
	bindingNames.insert(INTERFACEKEY_D_NOTE_ROUTE_DELETE, "D_NOTE_ROUTE_DELETE");
	bindingNames.insert(INTERFACEKEY_D_NOTE_ROUTE_CENTER, "D_NOTE_ROUTE_CENTER");
	bindingNames.insert(INTERFACEKEY_D_NOTE_ROUTE_NAME, "D_NOTE_ROUTE_NAME");
	bindingNames.insert(INTERFACEKEY_D_BUILDJOB, "D_BUILDJOB");
	bindingNames.insert(INTERFACEKEY_D_STATUS, "D_STATUS");
	bindingNames.insert(INTERFACEKEY_D_STATUS_OVERALL_HEALTH_RECENTER, "D_STATUS_OVERALL_HEALTH_RECENTER");
	bindingNames.insert(INTERFACEKEY_D_BUILDITEM, "D_BUILDITEM");
	bindingNames.insert(INTERFACEKEY_D_BITEM_FORBID, "D_BITEM_FORBID");
	bindingNames.insert(INTERFACEKEY_D_BITEM_DUMP, "D_BITEM_DUMP");
	bindingNames.insert(INTERFACEKEY_D_BITEM_HIDE, "D_BITEM_HIDE");
	bindingNames.insert(INTERFACEKEY_D_BITEM_MELT, "D_BITEM_MELT");
	bindingNames.insert(INTERFACEKEY_D_LOOK_FORBID, "D_LOOK_FORBID");
	bindingNames.insert(INTERFACEKEY_D_LOOK_DUMP, "D_LOOK_DUMP");
	bindingNames.insert(INTERFACEKEY_D_LOOK_MELT, "D_LOOK_MELT");
	bindingNames.insert(INTERFACEKEY_D_LOOK_HIDE, "D_LOOK_HIDE");
	bindingNames.insert(INTERFACEKEY_D_LOOK_FOLLOW, "D_LOOK_FOLLOW");
	bindingNames.insert(INTERFACEKEY_D_LOOK_ARENA_CREATURE, "D_LOOK_ARENA_CREATURE");
	bindingNames.insert(INTERFACEKEY_D_LOOK_ARENA_ADV_MODE, "D_LOOK_ARENA_ADV_MODE");
	bindingNames.insert(INTERFACEKEY_D_LOOK_ARENA_WATER, "D_LOOK_ARENA_WATER");
	bindingNames.insert(INTERFACEKEY_D_LOOK_ARENA_MAGMA, "D_LOOK_ARENA_MAGMA");
	bindingNames.insert(INTERFACEKEY_ARENA_CREATURE_SIDE_DOWN, "ARENA_CREATURE_SIDE_DOWN");
	bindingNames.insert(INTERFACEKEY_ARENA_CREATURE_SIDE_UP, "ARENA_CREATURE_SIDE_UP");
	bindingNames.insert(INTERFACEKEY_ARENA_CREATURE_NEW_ITEM, "ARENA_CREATURE_NEW_ITEM");
	bindingNames.insert(INTERFACEKEY_ARENA_CREATURE_BLANK_LIST, "ARENA_CREATURE_BLANK_LIST");
	bindingNames.insert(INTERFACEKEY_ARENA_CREATURE_REMOVE_ITEM, "ARENA_CREATURE_REMOVE_ITEM");
	bindingNames.insert(INTERFACEKEY_ARENA_CREATURE_UNDEAD, "ARENA_CREATURE_UNDEAD");
	bindingNames.insert(INTERFACEKEY_ARENA_CREATURE_STRING, "ARENA_CREATURE_STRING");
	bindingNames.insert(INTERFACEKEY_A_ENTER_NAME, "A_ENTER_NAME");
	bindingNames.insert(INTERFACEKEY_A_CUST_NAME, "A_CUST_NAME");
	bindingNames.insert(INTERFACEKEY_A_RANDOM_NAME, "A_RANDOM_NAME");
	bindingNames.insert(INTERFACEKEY_A_CHANGE_GENDER, "A_CHANGE_GENDER");
	bindingNames.insert(INTERFACEKEY_A_END_TRAVEL, "A_END_TRAVEL");
	bindingNames.insert(INTERFACEKEY_A_TRAVEL_CLOUDS, "A_TRAVEL_CLOUDS");
	bindingNames.insert(INTERFACEKEY_A_LOG, "A_LOG");
	bindingNames.insert(INTERFACEKEY_A_TRAVEL_LOG, "A_TRAVEL_LOG");
	bindingNames.insert(INTERFACEKEY_A_LOG_TASKS, "A_LOG_TASKS");
	bindingNames.insert(INTERFACEKEY_A_LOG_ENTITIES, "A_LOG_ENTITIES");
	bindingNames.insert(INTERFACEKEY_A_LOG_SITES, "A_LOG_SITES");
	bindingNames.insert(INTERFACEKEY_A_LOG_SUBREGIONS, "A_LOG_SUBREGIONS");
	bindingNames.insert(INTERFACEKEY_A_LOG_FEATURE_LAYERS, "A_LOG_FEATURE_LAYERS");
	bindingNames.insert(INTERFACEKEY_A_LOG_ZOOM_CURRENT_LOCATION, "A_LOG_ZOOM_CURRENT_LOCATION");
	bindingNames.insert(INTERFACEKEY_A_LOG_ZOOM_SELECTED, "A_LOG_ZOOM_SELECTED");
	bindingNames.insert(INTERFACEKEY_A_LOG_LINE, "A_LOG_LINE");
	bindingNames.insert(INTERFACEKEY_A_LOG_MAP, "A_LOG_MAP");
	bindingNames.insert(INTERFACEKEY_ORDERS_AUTOFORBID, "ORDERS_AUTOFORBID");
	bindingNames.insert(INTERFACEKEY_ORDERS_FORBID_PROJECTILE, "ORDERS_FORBID_PROJECTILE");
	bindingNames.insert(INTERFACEKEY_ORDERS_FORBID_YOUR_CORPSE, "ORDERS_FORBID_YOUR_CORPSE");
	bindingNames.insert(INTERFACEKEY_ORDERS_FORBID_YOUR_ITEMS, "ORDERS_FORBID_YOUR_ITEMS");
	bindingNames.insert(INTERFACEKEY_ORDERS_FORBID_OTHER_CORPSE, "ORDERS_FORBID_OTHER_CORPSE");
	bindingNames.insert(INTERFACEKEY_ORDERS_FORBID_OTHER_ITEMS, "ORDERS_FORBID_OTHER_ITEMS");
	bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_GATHER, "ORDERS_REFUSE_GATHER");
	bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_OUTSIDE, "ORDERS_REFUSE_OUTSIDE");
	bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_OUTSIDE_VERMIN, "ORDERS_REFUSE_OUTSIDE_VERMIN");
	bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_CORPSE, "ORDERS_REFUSE_DUMP_CORPSE");
	bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_SKULL, "ORDERS_REFUSE_DUMP_SKULL");
	bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_SKIN, "ORDERS_REFUSE_DUMP_SKIN");
	bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_BONE, "ORDERS_REFUSE_DUMP_BONE");
	bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_SHELL, "ORDERS_REFUSE_DUMP_SHELL");
	bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_OTHER, "ORDERS_REFUSE_DUMP_OTHER");
	bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_STRAND_TISSUE, "ORDERS_REFUSE_DUMP_STRAND_TISSUE");
	bindingNames.insert(INTERFACEKEY_ORDERS_GATHER_FURNITURE, "ORDERS_GATHER_FURNITURE");
	bindingNames.insert(INTERFACEKEY_ORDERS_GATHER_ANIMALS, "ORDERS_GATHER_ANIMALS");
	bindingNames.insert(INTERFACEKEY_ORDERS_GATHER_FOOD, "ORDERS_GATHER_FOOD");
	bindingNames.insert(INTERFACEKEY_ORDERS_GATHER_BODIES, "ORDERS_GATHER_BODIES");
	bindingNames.insert(INTERFACEKEY_ORDERS_REFUSE, "ORDERS_REFUSE");
	bindingNames.insert(INTERFACEKEY_ORDERS_GATHER_STONE, "ORDERS_GATHER_STONE");
	bindingNames.insert(INTERFACEKEY_ORDERS_GATHER_WOOD, "ORDERS_GATHER_WOOD");
	bindingNames.insert(INTERFACEKEY_ORDERS_ALL_HARVEST, "ORDERS_ALL_HARVEST");
	bindingNames.insert(INTERFACEKEY_ORDERS_SAMEPILE, "ORDERS_SAMEPILE");
	bindingNames.insert(INTERFACEKEY_ORDERS_MIXFOODS, "ORDERS_MIXFOODS");
	bindingNames.insert(INTERFACEKEY_ORDERS_EXCEPTIONS, "ORDERS_EXCEPTIONS");
	bindingNames.insert(INTERFACEKEY_ORDERS_LOOM, "ORDERS_LOOM");
	bindingNames.insert(INTERFACEKEY_ORDERS_DYED_CLOTH, "ORDERS_DYED_CLOTH");
	bindingNames.insert(INTERFACEKEY_ORDERS_WORKSHOP, "ORDERS_WORKSHOP");
	bindingNames.insert(INTERFACEKEY_ORDERS_COLLECT_WEB, "ORDERS_COLLECT_WEB");
	bindingNames.insert(INTERFACEKEY_ORDERS_SLAUGHTER, "ORDERS_SLAUGHTER");
	bindingNames.insert(INTERFACEKEY_ORDERS_BUTCHER, "ORDERS_BUTCHER");
	bindingNames.insert(INTERFACEKEY_ORDERS_TAN, "ORDERS_TAN");
	bindingNames.insert(INTERFACEKEY_ORDERS_AUTO_FISHERY, "ORDERS_AUTO_FISHERY");
	bindingNames.insert(INTERFACEKEY_ORDERS_AUTO_KITCHEN, "ORDERS_AUTO_KITCHEN");
	bindingNames.insert(INTERFACEKEY_ORDERS_AUTO_KILN, "ORDERS_AUTO_KILN");
	bindingNames.insert(INTERFACEKEY_ORDERS_AUTO_SMELTER, "ORDERS_AUTO_SMELTER");
	bindingNames.insert(INTERFACEKEY_ORDERS_AUTO_OTHER, "ORDERS_AUTO_OTHER");
	bindingNames.insert(INTERFACEKEY_ORDERS_ZONE, "ORDERS_ZONE");
	bindingNames.insert(INTERFACEKEY_ORDERS_ZONE_DRINKING, "ORDERS_ZONE_DRINKING");
	bindingNames.insert(INTERFACEKEY_ORDERS_ZONE_FISHING, "ORDERS_ZONE_FISHING");
	bindingNames.insert(INTERFACEKEY_DESTROYBUILDING, "DESTROYBUILDING");
	bindingNames.insert(INTERFACEKEY_SUSPENDBUILDING, "SUSPENDBUILDING");
	bindingNames.insert(INTERFACEKEY_MENU_CONFIRM, "MENU_CONFIRM");
	bindingNames.insert(INTERFACEKEY_SAVE_BINDINGS, "SAVE_BINDINGS");
	bindingNames.insert(INTERFACEKEY_LOAD_BINDINGS, "LOAD_BINDINGS");
	bindingNames.insert(INTERFACEKEY_KEYBINDING_COMPLETE, "KEYBINDING_COMPLETE");
	bindingNames.insert(INTERFACEKEY_ZOOM_IN, "ZOOM_IN");
	bindingNames.insert(INTERFACEKEY_ZOOM_OUT, "ZOOM_OUT");
	bindingNames.insert(INTERFACEKEY_ZOOM_TOGGLE, "ZOOM_TOGGLE");
	bindingNames.insert(INTERFACEKEY_ZOOM_RESET, "ZOOM_RESET");
	bindingNames.insert(INTERFACEKEY_MACRO_BREAK, "MACRO_BREAK");
	bindingNames.insert(INTERFACEKEY_RECORD_MACRO, "RECORD_MACRO");
	bindingNames.insert(INTERFACEKEY_PLAY_MACRO, "PLAY_MACRO");
	bindingNames.insert(INTERFACEKEY_SAVE_MACRO, "SAVE_MACRO");
	bindingNames.insert(INTERFACEKEY_LOAD_MACRO, "LOAD_MACRO");
	bindingNames.insert(INTERFACEKEY_HOTKEY_ALCHEMIST_SOAP, "HOTKEY_ALCHEMIST_SOAP");
	bindingNames.insert(INTERFACEKEY_HOTKEY_STILL_BREW, "HOTKEY_STILL_BREW");
	bindingNames.insert(INTERFACEKEY_HOTKEY_STILL_EXTRACT, "HOTKEY_STILL_EXTRACT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_LOOM_COLLECT_SILK, "HOTKEY_LOOM_COLLECT_SILK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_LOOM_WEAVE_CLOTH, "HOTKEY_LOOM_WEAVE_CLOTH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_LOOM_WEAVE_SILK, "HOTKEY_LOOM_WEAVE_SILK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_LOOM_WEAVE_YARN, "HOTKEY_LOOM_WEAVE_YARN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_LOOM_WEAVE_METAL, "HOTKEY_LOOM_WEAVE_METAL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_KITCHEN_COOK_2, "HOTKEY_KITCHEN_COOK_2");
	bindingNames.insert(INTERFACEKEY_HOTKEY_KITCHEN_COOK_3, "HOTKEY_KITCHEN_COOK_3");
	bindingNames.insert(INTERFACEKEY_HOTKEY_KITCHEN_COOK_4, "HOTKEY_KITCHEN_COOK_4");
	bindingNames.insert(INTERFACEKEY_HOTKEY_KITCHEN_RENDER_FAT, "HOTKEY_KITCHEN_RENDER_FAT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_PROCESS, "HOTKEY_FARMER_PROCESS");
	bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_PROCESS_VIAL, "HOTKEY_FARMER_PROCESS_VIAL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_PROCESS_BAG, "HOTKEY_FARMER_PROCESS_BAG");
	bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_PROCESS_BARREL, "HOTKEY_FARMER_PROCESS_BARREL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_CHEESE, "HOTKEY_FARMER_CHEESE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_MILK, "HOTKEY_FARMER_MILK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_SHEAR_CREATURE, "HOTKEY_FARMER_SHEAR_CREATURE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_FARMER_SPIN_THREAD, "HOTKEY_FARMER_SPIN_THREAD");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MILL_MILL, "HOTKEY_MILL_MILL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_KENNEL_CATCH_VERMIN, "HOTKEY_KENNEL_CATCH_VERMIN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_KENNEL_TAME_VERMIN, "HOTKEY_KENNEL_TAME_VERMIN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_FISHERY_PROCESS, "HOTKEY_FISHERY_PROCESS");
	bindingNames.insert(INTERFACEKEY_HOTKEY_FISHERY_EXTRACT, "HOTKEY_FISHERY_EXTRACT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_FISHERY_CATCH, "HOTKEY_FISHERY_CATCH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUTCHER_BUTCHER, "HOTKEY_BUTCHER_BUTCHER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUTCHER_EXTRACT, "HOTKEY_BUTCHER_EXTRACT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_BUTCHER_CATCH, "HOTKEY_BUTCHER_CATCH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TANNER_TAN, "HOTKEY_TANNER_TAN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_DYER_THREAD, "HOTKEY_DYER_THREAD");
	bindingNames.insert(INTERFACEKEY_HOTKEY_DYER_CLOTH, "HOTKEY_DYER_CLOTH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_JEWELER_FURNITURE, "HOTKEY_JEWELER_FURNITURE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_JEWELER_FINISHED, "HOTKEY_JEWELER_FINISHED");
	bindingNames.insert(INTERFACEKEY_HOTKEY_JEWELER_AMMO, "HOTKEY_JEWELER_AMMO");
	bindingNames.insert(INTERFACEKEY_HOTKEY_JEWELER_CUT, "HOTKEY_JEWELER_CUT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_JEWELER_ENCRUST, "HOTKEY_JEWELER_ENCRUST");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MECHANIC_PARTS, "HOTKEY_MECHANIC_PARTS");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MECHANIC_TRACTION_BENCH, "HOTKEY_MECHANIC_TRACTION_BENCH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_ARMORSTAND, "HOTKEY_MASON_ARMORSTAND");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_BLOCKS, "HOTKEY_MASON_BLOCKS");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_CHAIR, "HOTKEY_MASON_CHAIR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_COFFIN, "HOTKEY_MASON_COFFIN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_DOOR, "HOTKEY_MASON_DOOR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_FLOODGATE, "HOTKEY_MASON_FLOODGATE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_HATCH_COVER, "HOTKEY_MASON_HATCH_COVER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_GRATE, "HOTKEY_MASON_GRATE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_CABINET, "HOTKEY_MASON_CABINET");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_BOX, "HOTKEY_MASON_BOX");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_STATUE, "HOTKEY_MASON_STATUE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_QUERN, "HOTKEY_MASON_QUERN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_MILLSTONE, "HOTKEY_MASON_MILLSTONE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_TABLE, "HOTKEY_MASON_TABLE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_WEAPONRACK, "HOTKEY_MASON_WEAPONRACK");
	bindingNames.insert(INTERFACEKEY_HOTKEY_MASON_SLAB, "HOTKEY_MASON_SLAB");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_BRIDGE, "HOTKEY_TRAP_BRIDGE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_GEAR_ASSEMBLY, "HOTKEY_TRAP_GEAR_ASSEMBLY");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_DOOR, "HOTKEY_TRAP_DOOR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_FLOODGATE, "HOTKEY_TRAP_FLOODGATE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_SPIKE, "HOTKEY_TRAP_SPIKE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_HATCH, "HOTKEY_TRAP_HATCH");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_GRATE_WALL, "HOTKEY_TRAP_GRATE_WALL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_GRATE_FLOOR, "HOTKEY_TRAP_GRATE_FLOOR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_BARS_VERTICAL, "HOTKEY_TRAP_BARS_VERTICAL");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_BARS_FLOOR, "HOTKEY_TRAP_BARS_FLOOR");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_SUPPORT, "HOTKEY_TRAP_SUPPORT");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_CHAIN, "HOTKEY_TRAP_CHAIN");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_CAGE, "HOTKEY_TRAP_CAGE");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_PULL_LEVER, "HOTKEY_TRAP_PULL_LEVER");
	bindingNames.insert(INTERFACEKEY_HOTKEY_TRAP_TRACK_STOP, "HOTKEY_TRAP_TRACK_STOP");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_ADD, "BUILDJOB_ADD");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CANCEL, "BUILDJOB_CANCEL");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_PROMOTE, "BUILDJOB_PROMOTE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_REPEAT, "BUILDJOB_REPEAT");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_SUSPEND, "BUILDJOB_SUSPEND");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_WORKSHOP_PROFILE, "BUILDJOB_WORKSHOP_PROFILE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_WELL_FREE, "BUILDJOB_WELL_FREE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_WELL_SIZE, "BUILDJOB_WELL_SIZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_TARGET_FREE, "BUILDJOB_TARGET_FREE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_TARGET_SIZE, "BUILDJOB_TARGET_SIZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_TARGET_DOWN, "BUILDJOB_TARGET_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_TARGET_UP, "BUILDJOB_TARGET_UP");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_TARGET_RIGHT, "BUILDJOB_TARGET_RIGHT");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_TARGET_LEFT, "BUILDJOB_TARGET_LEFT");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STATUE_ASSIGN, "BUILDJOB_STATUE_ASSIGN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STATUE_FREE, "BUILDJOB_STATUE_FREE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STATUE_SIZE, "BUILDJOB_STATUE_SIZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CAGE_JUSTICE, "BUILDJOB_CAGE_JUSTICE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CAGE_FREE, "BUILDJOB_CAGE_FREE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CAGE_SIZE, "BUILDJOB_CAGE_SIZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CAGE_ASSIGN_OCC, "BUILDJOB_CAGE_ASSIGN_OCC");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CAGE_WATER, "BUILDJOB_CAGE_WATER");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CAGE_ASSIGN, "BUILDJOB_CAGE_ASSIGN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN_OCC, "BUILDJOB_CHAIN_ASSIGN_OCC");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_JUSTICE, "BUILDJOB_CHAIN_JUSTICE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN, "BUILDJOB_CHAIN_ASSIGN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_FREE, "BUILDJOB_CHAIN_FREE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_SIZE, "BUILDJOB_CHAIN_SIZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_SIEGE_FIRING, "BUILDJOB_SIEGE_FIRING");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_SIEGE_ORIENT, "BUILDJOB_SIEGE_ORIENT");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_DOOR_INTERNAL, "BUILDJOB_DOOR_INTERNAL");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_DOOR_LOCK, "BUILDJOB_DOOR_LOCK");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_DOOR_AJAR, "BUILDJOB_DOOR_AJAR");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_ASSIGN, "BUILDJOB_COFFIN_ASSIGN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_FREE, "BUILDJOB_COFFIN_FREE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_SIZE, "BUILDJOB_COFFIN_SIZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_BURIAL, "BUILDJOB_COFFIN_BURIAL");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_CIV, "BUILDJOB_COFFIN_CIV");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_PET, "BUILDJOB_COFFIN_PET");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIR_ASSIGN, "BUILDJOB_CHAIR_ASSIGN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIR_FREE, "BUILDJOB_CHAIR_FREE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_CHAIR_SIZE, "BUILDJOB_CHAIR_SIZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_TABLE_ASSIGN, "BUILDJOB_TABLE_ASSIGN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_TABLE_HALL, "BUILDJOB_TABLE_HALL");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_TABLE_FREE, "BUILDJOB_TABLE_FREE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_TABLE_SIZE, "BUILDJOB_TABLE_SIZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_ASSIGN, "BUILDJOB_BED_ASSIGN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_FREE, "BUILDJOB_BED_FREE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_BARRACKS, "BUILDJOB_BED_BARRACKS");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_DORMITORY, "BUILDJOB_BED_DORMITORY");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_RENT, "BUILDJOB_BED_RENT");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_SIZE, "BUILDJOB_BED_SIZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_NAME, "BUILDJOB_BED_NAME");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_SLEEP, "BUILDJOB_BED_SLEEP");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_TRAIN, "BUILDJOB_BED_TRAIN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_INDIV_EQ, "BUILDJOB_BED_INDIV_EQ");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_SQUAD_EQ, "BUILDJOB_BED_SQUAD_EQ");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_BED_POSITION, "BUILDJOB_BED_POSITION");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_DEPOT_BRING, "BUILDJOB_DEPOT_BRING");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_DEPOT_TRADE, "BUILDJOB_DEPOT_TRADE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_DEPOT_REQUEST_TRADER, "BUILDJOB_DEPOT_REQUEST_TRADER");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_DEPOT_BROKER_ONLY, "BUILDJOB_DEPOT_BROKER_ONLY");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_NONE, "BUILDJOB_ANIMALTRAP_BAIT_NONE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_MEAT, "BUILDJOB_ANIMALTRAP_BAIT_MEAT");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_FISH, "BUILDJOB_ANIMALTRAP_BAIT_FISH");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_GEM, "BUILDJOB_ANIMALTRAP_BAIT_GEM");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_FALLOW, "BUILDJOB_FARM_FALLOW");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_FERTILIZE, "BUILDJOB_FARM_FERTILIZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_SEASFERT, "BUILDJOB_FARM_SEASFERT");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_SPRING, "BUILDJOB_FARM_SPRING");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_SUMMER, "BUILDJOB_FARM_SUMMER");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_AUTUMN, "BUILDJOB_FARM_AUTUMN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_FARM_WINTER, "BUILDJOB_FARM_WINTER");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_MASTER, "BUILDJOB_STOCKPILE_MASTER");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_LINK_ANYWHERE, "BUILDJOB_STOCKPILE_LINK_ANYWHERE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_GIVE_TO, "BUILDJOB_STOCKPILE_GIVE_TO");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_WHEELBARROW, "BUILDJOB_STOCKPILE_WHEELBARROW");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_DELETE_CHILD, "BUILDJOB_STOCKPILE_DELETE_CHILD");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_SETTINGS, "BUILDJOB_STOCKPILE_SETTINGS");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_UP, "BUILDJOB_STOCKPILE_BARREL_UP");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_DOWN, "BUILDJOB_STOCKPILE_BARREL_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_ZERO, "BUILDJOB_STOCKPILE_BARREL_ZERO");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_MAX, "BUILDJOB_STOCKPILE_BARREL_MAX");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_UP, "BUILDJOB_STOCKPILE_BIN_UP");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_DOWN, "BUILDJOB_STOCKPILE_BIN_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_ZERO, "BUILDJOB_STOCKPILE_BIN_ZERO");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_MAX, "BUILDJOB_STOCKPILE_BIN_MAX");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_BONE, "BUILDJOB_RACK_MAT_BONE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_BRONZE, "BUILDJOB_RACK_MAT_BRONZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_COPPER, "BUILDJOB_RACK_MAT_COPPER");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_IRON, "BUILDJOB_RACK_MAT_IRON");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_STEEL, "BUILDJOB_RACK_MAT_STEEL");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_WOOD, "BUILDJOB_RACK_MAT_WOOD");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_METAL, "BUILDJOB_RACK_MAT_METAL");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_BONE, "BUILDJOB_STAND_MAT_BONE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_LEATHER, "BUILDJOB_STAND_MAT_LEATHER");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_COPPER, "BUILDJOB_STAND_MAT_COPPER");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_BRONZE, "BUILDJOB_STAND_MAT_BRONZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_STEEL, "BUILDJOB_STAND_MAT_STEEL");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_IRON, "BUILDJOB_STAND_MAT_IRON");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_WOOD, "BUILDJOB_STAND_MAT_WOOD");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_METAL, "BUILDJOB_STAND_MAT_METAL");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_ASSIGN, "BUILDJOB_RACKSTAND_ASSIGN");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_FREE, "BUILDJOB_RACKSTAND_FREE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_SIZE, "BUILDJOB_RACKSTAND_SIZE");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_ITEM, "BUILDJOB_RACKSTAND_ITEM");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_MAT, "BUILDJOB_RACKSTAND_MAT");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS1, "BUILDJOB_RACKSTAND_DEFAULTS1");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_KILL1, "BUILDJOB_RACKSTAND_KILL1");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS2, "BUILDJOB_RACKSTAND_DEFAULTS2");
	bindingNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_KILL2, "BUILDJOB_RACKSTAND_KILL2");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_ENABLE, "STOCKPILE_SETTINGS_ENABLE");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_DISABLE, "STOCKPILE_SETTINGS_DISABLE");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_ALL, "STOCKPILE_SETTINGS_PERMIT_ALL");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_ALL, "STOCKPILE_SETTINGS_FORBID_ALL");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_SUB, "STOCKPILE_SETTINGS_PERMIT_SUB");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_SUB, "STOCKPILE_SETTINGS_FORBID_SUB");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC1, "STOCKPILE_SETTINGS_SPECIFIC1");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC2, "STOCKPILE_SETTINGS_SPECIFIC2");
	bindingNames.insert(INTERFACEKEY_MOVIE_RECORD, "MOVIE_RECORD");
	bindingNames.insert(INTERFACEKEY_MOVIE_PLAY, "MOVIE_PLAY");
	bindingNames.insert(INTERFACEKEY_MOVIE_SAVE, "MOVIE_SAVE");
	bindingNames.insert(INTERFACEKEY_MOVIE_LOAD, "MOVIE_LOAD");
	bindingNames.insert(INTERFACEKEY_ASSIGNTRADE_VIEW, "ASSIGNTRADE_VIEW");
	bindingNames.insert(INTERFACEKEY_ASSIGNTRADE_STRING, "ASSIGNTRADE_STRING");
	bindingNames.insert(INTERFACEKEY_ASSIGNTRADE_EXCLUDE_PROHIBITED, "ASSIGNTRADE_EXCLUDE_PROHIBITED");
	bindingNames.insert(INTERFACEKEY_ASSIGNTRADE_PENDING, "ASSIGNTRADE_PENDING");
	bindingNames.insert(INTERFACEKEY_ASSIGNTRADE_SORT, "ASSIGNTRADE_SORT");
	bindingNames.insert(INTERFACEKEY_NOBLELIST_REPLACE, "NOBLELIST_REPLACE");
	bindingNames.insert(INTERFACEKEY_NOBLELIST_SETTINGS, "NOBLELIST_SETTINGS");
	bindingNames.insert(INTERFACEKEY_NOBLELIST_CAPITAL, "NOBLELIST_CAPITAL");
	bindingNames.insert(INTERFACEKEY_NOBLELIST_VIEW_CANDIDATE, "NOBLELIST_VIEW_CANDIDATE");
	bindingNames.insert(INTERFACEKEY_A_BARTER_VIEW, "A_BARTER_VIEW");
	bindingNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_1, "A_BARTER_CURRENCY_1");
	bindingNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_2, "A_BARTER_CURRENCY_2");
	bindingNames.insert(INTERFACEKEY_A_BARTER_TRADE, "A_BARTER_TRADE");
	bindingNames.insert(INTERFACEKEY_TRADE_VIEW, "TRADE_VIEW");
	bindingNames.insert(INTERFACEKEY_TRADE_TRADE, "TRADE_TRADE");
	bindingNames.insert(INTERFACEKEY_TRADE_OFFER, "TRADE_OFFER");
	bindingNames.insert(INTERFACEKEY_TRADE_SEIZE, "TRADE_SEIZE");
	bindingNames.insert(INTERFACEKEY_STORES_VIEW, "STORES_VIEW");
	bindingNames.insert(INTERFACEKEY_STORES_ZOOM, "STORES_ZOOM");
	bindingNames.insert(INTERFACEKEY_STORES_FORBID, "STORES_FORBID");
	bindingNames.insert(INTERFACEKEY_STORES_MELT, "STORES_MELT");
	bindingNames.insert(INTERFACEKEY_STORES_DUMP, "STORES_DUMP");
	bindingNames.insert(INTERFACEKEY_STORES_HIDE, "STORES_HIDE");
	bindingNames.insert(INTERFACEKEY_MILITARY_ACTIVATE, "MILITARY_ACTIVATE");
	bindingNames.insert(INTERFACEKEY_MILITARY_VIEW, "MILITARY_VIEW");
	bindingNames.insert(INTERFACEKEY_MILITARY_WEAPON, "MILITARY_WEAPON");
	bindingNames.insert(INTERFACEKEY_MILITARY_ZOOM, "MILITARY_ZOOM");
	bindingNames.insert(INTERFACEKEY_ANNOUNCE_ZOOM, "ANNOUNCE_ZOOM");
	bindingNames.insert(INTERFACEKEY_UNITJOB_REMOVE_CRE, "UNITJOB_REMOVE_CRE");
	bindingNames.insert(INTERFACEKEY_UNITJOB_ZOOM_CRE, "UNITJOB_ZOOM_CRE");
	bindingNames.insert(INTERFACEKEY_UNITJOB_ZOOM_BUILD, "UNITJOB_ZOOM_BUILD");
	bindingNames.insert(INTERFACEKEY_UNITJOB_VIEW, "UNITJOB_VIEW");
	bindingNames.insert(INTERFACEKEY_UNITJOB_MANAGER, "UNITJOB_MANAGER");
	bindingNames.insert(INTERFACEKEY_MANAGER_NEW_ORDER, "MANAGER_NEW_ORDER");
	bindingNames.insert(INTERFACEKEY_MANAGER_REMOVE, "MANAGER_REMOVE");
	bindingNames.insert(INTERFACEKEY_MANAGER_PROMOTE, "MANAGER_PROMOTE");
	bindingNames.insert(INTERFACEKEY_MANAGER_MAX, "MANAGER_MAX");
	bindingNames.insert(INTERFACEKEY_MANAGER_WAGES, "MANAGER_WAGES");
	bindingNames.insert(INTERFACEKEY_PET_BUTCHER, "PET_BUTCHER");
	bindingNames.insert(INTERFACEKEY_ANIMAL_SELECT_TRAINER, "ANIMAL_SELECT_TRAINER");
	bindingNames.insert(INTERFACEKEY_ANIMAL_WAR_TRAINING, "ANIMAL_WAR_TRAINING");
	bindingNames.insert(INTERFACEKEY_ANIMAL_HUNTING_TRAINING, "ANIMAL_HUNTING_TRAINING");
	bindingNames.insert(INTERFACEKEY_KITCHEN_COOK, "KITCHEN_COOK");
	bindingNames.insert(INTERFACEKEY_KITCHEN_BREW, "KITCHEN_BREW");
	bindingNames.insert(INTERFACEKEY_SETUPGAME_NEW, "SETUPGAME_NEW");
	bindingNames.insert(INTERFACEKEY_SETUPGAME_VIEW, "SETUPGAME_VIEW");
	bindingNames.insert(INTERFACEKEY_SETUPGAME_CUSTOMIZE_UNIT, "SETUPGAME_CUSTOMIZE_UNIT");
	bindingNames.insert(INTERFACEKEY_SETUPGAME_SAVE_PROFILE, "SETUPGAME_SAVE_PROFILE");
	bindingNames.insert(INTERFACEKEY_SETUPGAME_SAVE_PROFILE_ABORT, "SETUPGAME_SAVE_PROFILE_ABORT");
	bindingNames.insert(INTERFACEKEY_SETUPGAME_SAVE_PROFILE_GO, "SETUPGAME_SAVE_PROFILE_GO");
	bindingNames.insert(INTERFACEKEY_SETUPGAME_VIEW_PROFILE_PROBLEMS, "SETUPGAME_VIEW_PROFILE_PROBLEMS");
	bindingNames.insert(INTERFACEKEY_CIVZONE_REMOVE, "CIVZONE_REMOVE");
	bindingNames.insert(INTERFACEKEY_CIVZONE_REMOVE_ZONE, "CIVZONE_REMOVE_ZONE");
	bindingNames.insert(INTERFACEKEY_CIVZONE_SHAPE, "CIVZONE_SHAPE");
	bindingNames.insert(INTERFACEKEY_CIVZONE_NEXT, "CIVZONE_NEXT");
	bindingNames.insert(INTERFACEKEY_CIVZONE_POND_OPTIONS, "CIVZONE_POND_OPTIONS");
	bindingNames.insert(INTERFACEKEY_CIVZONE_HOSPITAL_OPTIONS, "CIVZONE_HOSPITAL_OPTIONS");
	bindingNames.insert(INTERFACEKEY_CIVZONE_WATER_SOURCE, "CIVZONE_WATER_SOURCE");
	bindingNames.insert(INTERFACEKEY_CIVZONE_FISH, "CIVZONE_FISH");
	bindingNames.insert(INTERFACEKEY_CIVZONE_DUMP, "CIVZONE_DUMP");
	bindingNames.insert(INTERFACEKEY_CIVZONE_POND, "CIVZONE_POND");
	bindingNames.insert(INTERFACEKEY_CIVZONE_HOSPITAL, "CIVZONE_HOSPITAL");
	bindingNames.insert(INTERFACEKEY_CIVZONE_SAND_COLLECT, "CIVZONE_SAND_COLLECT");
	bindingNames.insert(INTERFACEKEY_CIVZONE_CLAY_COLLECT, "CIVZONE_CLAY_COLLECT");
	bindingNames.insert(INTERFACEKEY_CIVZONE_ACTIVE, "CIVZONE_ACTIVE");
	bindingNames.insert(INTERFACEKEY_CIVZONE_MEETING, "CIVZONE_MEETING");
	bindingNames.insert(INTERFACEKEY_CIVZONE_ANIMAL_TRAINING, "CIVZONE_ANIMAL_TRAINING");
	bindingNames.insert(INTERFACEKEY_CIVZONE_POND_WATER, "CIVZONE_POND_WATER");
	bindingNames.insert(INTERFACEKEY_CIVZONE_PEN, "CIVZONE_PEN");
	bindingNames.insert(INTERFACEKEY_CIVZONE_PEN_OPTIONS, "CIVZONE_PEN_OPTIONS");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_ANIMAL, "STOCKPILE_ANIMAL");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_FOOD, "STOCKPILE_FOOD");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_WEAPON, "STOCKPILE_WEAPON");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_ARMOR, "STOCKPILE_ARMOR");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_CUSTOM, "STOCKPILE_CUSTOM");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_CUSTOM_SETTINGS, "STOCKPILE_CUSTOM_SETTINGS");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_FURNITURE, "STOCKPILE_FURNITURE");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_GRAVEYARD, "STOCKPILE_GRAVEYARD");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_REFUSE, "STOCKPILE_REFUSE");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_WOOD, "STOCKPILE_WOOD");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_STONE, "STOCKPILE_STONE");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_GEM, "STOCKPILE_GEM");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_BARBLOCK, "STOCKPILE_BARBLOCK");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_CLOTH, "STOCKPILE_CLOTH");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_LEATHER, "STOCKPILE_LEATHER");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_AMMO, "STOCKPILE_AMMO");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_COINS, "STOCKPILE_COINS");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_FINISHED, "STOCKPILE_FINISHED");
	bindingNames.insert(INTERFACEKEY_STOCKPILE_NONE, "STOCKPILE_NONE");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_BITEM, "DESIGNATE_BITEM");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_CLAIM, "DESIGNATE_CLAIM");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_UNCLAIM, "DESIGNATE_UNCLAIM");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_MELT, "DESIGNATE_MELT");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_NO_MELT, "DESIGNATE_NO_MELT");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_DUMP, "DESIGNATE_DUMP");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_NO_DUMP, "DESIGNATE_NO_DUMP");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_HIDE, "DESIGNATE_HIDE");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_NO_HIDE, "DESIGNATE_NO_HIDE");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC, "DESIGNATE_TRAFFIC");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_HIGH, "DESIGNATE_TRAFFIC_HIGH");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_NORMAL, "DESIGNATE_TRAFFIC_NORMAL");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_LOW, "DESIGNATE_TRAFFIC_LOW");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_RESTRICTED, "DESIGNATE_TRAFFIC_RESTRICTED");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT, "DESIGNATE_TRAFFIC_INCREASE_WEIGHT");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT, "DESIGNATE_TRAFFIC_DECREASE_WEIGHT");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT_MORE, "DESIGNATE_TRAFFIC_INCREASE_WEIGHT_MORE");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT_MORE, "DESIGNATE_TRAFFIC_DECREASE_WEIGHT_MORE");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_DIG, "DESIGNATE_DIG");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_DIG_REMOVE_STAIRS_RAMPS, "DESIGNATE_DIG_REMOVE_STAIRS_RAMPS");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_STAIR_UP, "DESIGNATE_STAIR_UP");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_STAIR_DOWN, "DESIGNATE_STAIR_DOWN");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_STAIR_UPDOWN, "DESIGNATE_STAIR_UPDOWN");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_RAMP, "DESIGNATE_RAMP");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_CHANNEL, "DESIGNATE_CHANNEL");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_CHOP, "DESIGNATE_CHOP");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_PLANTS, "DESIGNATE_PLANTS");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_SMOOTH, "DESIGNATE_SMOOTH");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_ENGRAVE, "DESIGNATE_ENGRAVE");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_FORTIFY, "DESIGNATE_FORTIFY");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_TRACK, "DESIGNATE_TRACK");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_TOGGLE_ENGRAVING, "DESIGNATE_TOGGLE_ENGRAVING");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_UNDO, "DESIGNATE_UNDO");
	bindingNames.insert(INTERFACEKEY_DESIGNATE_REMOVE_CONSTRUCTION, "DESIGNATE_REMOVE_CONSTRUCTION");
	bindingNames.insert(INTERFACEKEY_BUILDING_DIM_Y_UP, "BUILDING_DIM_Y_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_DIM_Y_DOWN, "BUILDING_DIM_Y_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDING_DIM_X_UP, "BUILDING_DIM_X_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_DIM_X_DOWN, "BUILDING_DIM_X_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDING_ORIENT_UP, "BUILDING_ORIENT_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_ORIENT_LEFT, "BUILDING_ORIENT_LEFT");
	bindingNames.insert(INTERFACEKEY_BUILDING_ORIENT_RIGHT, "BUILDING_ORIENT_RIGHT");
	bindingNames.insert(INTERFACEKEY_BUILDING_ORIENT_DOWN, "BUILDING_ORIENT_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDING_ORIENT_NONE, "BUILDING_ORIENT_NONE");
	bindingNames.insert(INTERFACEKEY_BUILDING_VIEW_ITEM, "BUILDING_VIEW_ITEM");
	bindingNames.insert(INTERFACEKEY_BUILDING_ADVANCE_STAGE, "BUILDING_ADVANCE_STAGE");
	bindingNames.insert(INTERFACEKEY_BUILDING_EXPAND_CONTRACT, "BUILDING_EXPAND_CONTRACT");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_WATER, "BUILDING_TRIGGER_ENABLE_WATER");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_UP, "BUILDING_TRIGGER_MIN_WATER_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_DOWN, "BUILDING_TRIGGER_MIN_WATER_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_UP, "BUILDING_TRIGGER_MAX_WATER_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_DOWN, "BUILDING_TRIGGER_MAX_WATER_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_MAGMA, "BUILDING_TRIGGER_ENABLE_MAGMA");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_UP, "BUILDING_TRIGGER_MIN_MAGMA_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_DOWN, "BUILDING_TRIGGER_MIN_MAGMA_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_UP, "BUILDING_TRIGGER_MAX_MAGMA_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_DOWN, "BUILDING_TRIGGER_MAX_MAGMA_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_TRACK_CART, "BUILDING_TRIGGER_ENABLE_TRACK_CART");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_TRACK_CART_DOWN, "BUILDING_TRIGGER_MIN_TRACK_CART_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_TRACK_CART_UP, "BUILDING_TRIGGER_MIN_TRACK_CART_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_TRACK_CART_DOWN, "BUILDING_TRIGGER_MAX_TRACK_CART_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_TRACK_CART_UP, "BUILDING_TRIGGER_MAX_TRACK_CART_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_ROLLERS_SPEED_UP, "BUILDING_ROLLERS_SPEED_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_ROLLERS_SPEED_DOWN, "BUILDING_ROLLERS_SPEED_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRACK_STOP_FRICTION_UP, "BUILDING_TRACK_STOP_FRICTION_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRACK_STOP_FRICTION_DOWN, "BUILDING_TRACK_STOP_FRICTION_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRACK_STOP_DUMP, "BUILDING_TRACK_STOP_DUMP");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_CREATURE, "BUILDING_TRIGGER_ENABLE_CREATURE");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_LOCALS, "BUILDING_TRIGGER_ENABLE_LOCALS");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_RESETS, "BUILDING_TRIGGER_RESETS");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_UP, "BUILDING_TRIGGER_MIN_SIZE_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_DOWN, "BUILDING_TRIGGER_MIN_SIZE_DOWN");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_UP, "BUILDING_TRIGGER_MAX_SIZE_UP");
	bindingNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_DOWN, "BUILDING_TRIGGER_MAX_SIZE_DOWN");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_GEN, "UNITVIEW_GEN");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_INV, "UNITVIEW_INV");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF, "UNITVIEW_PRF");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_WND, "UNITVIEW_WND");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_FOLLOW, "UNITVIEW_FOLLOW");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_NEXT, "UNITVIEW_NEXT");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_SLAUGHTER, "UNITVIEW_SLAUGHTER");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_GEN_COMBAT, "UNITVIEW_GEN_COMBAT");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_GEN_LABOR, "UNITVIEW_GEN_LABOR");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_GEN_MISC, "UNITVIEW_GEN_MISC");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_PROF, "UNITVIEW_PRF_PROF");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_PET, "UNITVIEW_PRF_PET");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_VIEW, "UNITVIEW_PRF_VIEW");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_NEW_SQUAD, "UNITVIEW_PRF_NEW_SQUAD");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_REMOVE_FROM_SQUAD, "UNITVIEW_PRF_REMOVE_FROM_SQUAD");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_NAME_CURRENT_SQUAD, "UNITVIEW_PRF_NAME_CURRENT_SQUAD");
	bindingNames.insert(INTERFACEKEY_UNITVIEW_PRF_NAME_SELECTED_SQUAD, "UNITVIEW_PRF_NAME_SELECTED_SQUAD");

	bindingNames.insert(INTERFACEKEY_STRING_A000, "STRING_A000");
	bindingNames.insert(INTERFACEKEY_STRING_A001, "STRING_A001");
	bindingNames.insert(INTERFACEKEY_STRING_A002, "STRING_A002");
	bindingNames.insert(INTERFACEKEY_STRING_A003, "STRING_A003");
	bindingNames.insert(INTERFACEKEY_STRING_A004, "STRING_A004");
	bindingNames.insert(INTERFACEKEY_STRING_A005, "STRING_A005");
	bindingNames.insert(INTERFACEKEY_STRING_A006, "STRING_A006");
	bindingNames.insert(INTERFACEKEY_STRING_A007, "STRING_A007");
	bindingNames.insert(INTERFACEKEY_STRING_A008, "STRING_A008");
	bindingNames.insert(INTERFACEKEY_STRING_A009, "STRING_A009");
	bindingNames.insert(INTERFACEKEY_STRING_A010, "STRING_A010");
	bindingNames.insert(INTERFACEKEY_STRING_A011, "STRING_A011");
	bindingNames.insert(INTERFACEKEY_STRING_A012, "STRING_A012");
	bindingNames.insert(INTERFACEKEY_STRING_A013, "STRING_A013");
	bindingNames.insert(INTERFACEKEY_STRING_A014, "STRING_A014");
	bindingNames.insert(INTERFACEKEY_STRING_A015, "STRING_A015");
	bindingNames.insert(INTERFACEKEY_STRING_A016, "STRING_A016");
	bindingNames.insert(INTERFACEKEY_STRING_A017, "STRING_A017");
	bindingNames.insert(INTERFACEKEY_STRING_A018, "STRING_A018");
	bindingNames.insert(INTERFACEKEY_STRING_A019, "STRING_A019");
	bindingNames.insert(INTERFACEKEY_STRING_A020, "STRING_A020");
	bindingNames.insert(INTERFACEKEY_STRING_A021, "STRING_A021");
	bindingNames.insert(INTERFACEKEY_STRING_A022, "STRING_A022");
	bindingNames.insert(INTERFACEKEY_STRING_A023, "STRING_A023");
	bindingNames.insert(INTERFACEKEY_STRING_A024, "STRING_A024");
	bindingNames.insert(INTERFACEKEY_STRING_A025, "STRING_A025");
	bindingNames.insert(INTERFACEKEY_STRING_A026, "STRING_A026");
	bindingNames.insert(INTERFACEKEY_STRING_A027, "STRING_A027");
	bindingNames.insert(INTERFACEKEY_STRING_A028, "STRING_A028");
	bindingNames.insert(INTERFACEKEY_STRING_A029, "STRING_A029");
	bindingNames.insert(INTERFACEKEY_STRING_A030, "STRING_A030");
	bindingNames.insert(INTERFACEKEY_STRING_A031, "STRING_A031");
	bindingNames.insert(INTERFACEKEY_STRING_A032, "STRING_A032");
	bindingNames.insert(INTERFACEKEY_STRING_A033, "STRING_A033");
	bindingNames.insert(INTERFACEKEY_STRING_A034, "STRING_A034");
	bindingNames.insert(INTERFACEKEY_STRING_A035, "STRING_A035");
	bindingNames.insert(INTERFACEKEY_STRING_A036, "STRING_A036");
	bindingNames.insert(INTERFACEKEY_STRING_A037, "STRING_A037");
	bindingNames.insert(INTERFACEKEY_STRING_A038, "STRING_A038");
	bindingNames.insert(INTERFACEKEY_STRING_A039, "STRING_A039");
	bindingNames.insert(INTERFACEKEY_STRING_A040, "STRING_A040");
	bindingNames.insert(INTERFACEKEY_STRING_A041, "STRING_A041");
	bindingNames.insert(INTERFACEKEY_STRING_A042, "STRING_A042");
	bindingNames.insert(INTERFACEKEY_STRING_A043, "STRING_A043");
	bindingNames.insert(INTERFACEKEY_STRING_A044, "STRING_A044");
	bindingNames.insert(INTERFACEKEY_STRING_A045, "STRING_A045");
	bindingNames.insert(INTERFACEKEY_STRING_A046, "STRING_A046");
	bindingNames.insert(INTERFACEKEY_STRING_A047, "STRING_A047");
	bindingNames.insert(INTERFACEKEY_STRING_A048, "STRING_A048");
	bindingNames.insert(INTERFACEKEY_STRING_A049, "STRING_A049");
	bindingNames.insert(INTERFACEKEY_STRING_A050, "STRING_A050");
	bindingNames.insert(INTERFACEKEY_STRING_A051, "STRING_A051");
	bindingNames.insert(INTERFACEKEY_STRING_A052, "STRING_A052");
	bindingNames.insert(INTERFACEKEY_STRING_A053, "STRING_A053");
	bindingNames.insert(INTERFACEKEY_STRING_A054, "STRING_A054");
	bindingNames.insert(INTERFACEKEY_STRING_A055, "STRING_A055");
	bindingNames.insert(INTERFACEKEY_STRING_A056, "STRING_A056");
	bindingNames.insert(INTERFACEKEY_STRING_A057, "STRING_A057");
	bindingNames.insert(INTERFACEKEY_STRING_A058, "STRING_A058");
	bindingNames.insert(INTERFACEKEY_STRING_A059, "STRING_A059");
	bindingNames.insert(INTERFACEKEY_STRING_A060, "STRING_A060");
	bindingNames.insert(INTERFACEKEY_STRING_A061, "STRING_A061");
	bindingNames.insert(INTERFACEKEY_STRING_A062, "STRING_A062");
	bindingNames.insert(INTERFACEKEY_STRING_A063, "STRING_A063");
	bindingNames.insert(INTERFACEKEY_STRING_A064, "STRING_A064");
	bindingNames.insert(INTERFACEKEY_STRING_A065, "STRING_A065");
	bindingNames.insert(INTERFACEKEY_STRING_A066, "STRING_A066");
	bindingNames.insert(INTERFACEKEY_STRING_A067, "STRING_A067");
	bindingNames.insert(INTERFACEKEY_STRING_A068, "STRING_A068");
	bindingNames.insert(INTERFACEKEY_STRING_A069, "STRING_A069");
	bindingNames.insert(INTERFACEKEY_STRING_A070, "STRING_A070");
	bindingNames.insert(INTERFACEKEY_STRING_A071, "STRING_A071");
	bindingNames.insert(INTERFACEKEY_STRING_A072, "STRING_A072");
	bindingNames.insert(INTERFACEKEY_STRING_A073, "STRING_A073");
	bindingNames.insert(INTERFACEKEY_STRING_A074, "STRING_A074");
	bindingNames.insert(INTERFACEKEY_STRING_A075, "STRING_A075");
	bindingNames.insert(INTERFACEKEY_STRING_A076, "STRING_A076");
	bindingNames.insert(INTERFACEKEY_STRING_A077, "STRING_A077");
	bindingNames.insert(INTERFACEKEY_STRING_A078, "STRING_A078");
	bindingNames.insert(INTERFACEKEY_STRING_A079, "STRING_A079");
	bindingNames.insert(INTERFACEKEY_STRING_A080, "STRING_A080");
	bindingNames.insert(INTERFACEKEY_STRING_A081, "STRING_A081");
	bindingNames.insert(INTERFACEKEY_STRING_A082, "STRING_A082");
	bindingNames.insert(INTERFACEKEY_STRING_A083, "STRING_A083");
	bindingNames.insert(INTERFACEKEY_STRING_A084, "STRING_A084");
	bindingNames.insert(INTERFACEKEY_STRING_A085, "STRING_A085");
	bindingNames.insert(INTERFACEKEY_STRING_A086, "STRING_A086");
	bindingNames.insert(INTERFACEKEY_STRING_A087, "STRING_A087");
	bindingNames.insert(INTERFACEKEY_STRING_A088, "STRING_A088");
	bindingNames.insert(INTERFACEKEY_STRING_A089, "STRING_A089");
	bindingNames.insert(INTERFACEKEY_STRING_A090, "STRING_A090");
	bindingNames.insert(INTERFACEKEY_STRING_A091, "STRING_A091");
	bindingNames.insert(INTERFACEKEY_STRING_A092, "STRING_A092");
	bindingNames.insert(INTERFACEKEY_STRING_A093, "STRING_A093");
	bindingNames.insert(INTERFACEKEY_STRING_A094, "STRING_A094");
	bindingNames.insert(INTERFACEKEY_STRING_A095, "STRING_A095");
	bindingNames.insert(INTERFACEKEY_STRING_A096, "STRING_A096");
	bindingNames.insert(INTERFACEKEY_STRING_A097, "STRING_A097");
	bindingNames.insert(INTERFACEKEY_STRING_A098, "STRING_A098");
	bindingNames.insert(INTERFACEKEY_STRING_A099, "STRING_A099");
	bindingNames.insert(INTERFACEKEY_STRING_A100, "STRING_A100");
	bindingNames.insert(INTERFACEKEY_STRING_A101, "STRING_A101");
	bindingNames.insert(INTERFACEKEY_STRING_A102, "STRING_A102");
	bindingNames.insert(INTERFACEKEY_STRING_A103, "STRING_A103");
	bindingNames.insert(INTERFACEKEY_STRING_A104, "STRING_A104");
	bindingNames.insert(INTERFACEKEY_STRING_A105, "STRING_A105");
	bindingNames.insert(INTERFACEKEY_STRING_A106, "STRING_A106");
	bindingNames.insert(INTERFACEKEY_STRING_A107, "STRING_A107");
	bindingNames.insert(INTERFACEKEY_STRING_A108, "STRING_A108");
	bindingNames.insert(INTERFACEKEY_STRING_A109, "STRING_A109");
	bindingNames.insert(INTERFACEKEY_STRING_A110, "STRING_A110");
	bindingNames.insert(INTERFACEKEY_STRING_A111, "STRING_A111");
	bindingNames.insert(INTERFACEKEY_STRING_A112, "STRING_A112");
	bindingNames.insert(INTERFACEKEY_STRING_A113, "STRING_A113");
	bindingNames.insert(INTERFACEKEY_STRING_A114, "STRING_A114");
	bindingNames.insert(INTERFACEKEY_STRING_A115, "STRING_A115");
	bindingNames.insert(INTERFACEKEY_STRING_A116, "STRING_A116");
	bindingNames.insert(INTERFACEKEY_STRING_A117, "STRING_A117");
	bindingNames.insert(INTERFACEKEY_STRING_A118, "STRING_A118");
	bindingNames.insert(INTERFACEKEY_STRING_A119, "STRING_A119");
	bindingNames.insert(INTERFACEKEY_STRING_A120, "STRING_A120");
	bindingNames.insert(INTERFACEKEY_STRING_A121, "STRING_A121");
	bindingNames.insert(INTERFACEKEY_STRING_A122, "STRING_A122");
	bindingNames.insert(INTERFACEKEY_STRING_A123, "STRING_A123");
	bindingNames.insert(INTERFACEKEY_STRING_A124, "STRING_A124");
	bindingNames.insert(INTERFACEKEY_STRING_A125, "STRING_A125");
	bindingNames.insert(INTERFACEKEY_STRING_A126, "STRING_A126");
	bindingNames.insert(INTERFACEKEY_STRING_A127, "STRING_A127");
	bindingNames.insert(INTERFACEKEY_STRING_A128, "STRING_A128");
	bindingNames.insert(INTERFACEKEY_STRING_A129, "STRING_A129");
	bindingNames.insert(INTERFACEKEY_STRING_A130, "STRING_A130");
	bindingNames.insert(INTERFACEKEY_STRING_A131, "STRING_A131");
	bindingNames.insert(INTERFACEKEY_STRING_A132, "STRING_A132");
	bindingNames.insert(INTERFACEKEY_STRING_A133, "STRING_A133");
	bindingNames.insert(INTERFACEKEY_STRING_A134, "STRING_A134");
	bindingNames.insert(INTERFACEKEY_STRING_A135, "STRING_A135");
	bindingNames.insert(INTERFACEKEY_STRING_A136, "STRING_A136");
	bindingNames.insert(INTERFACEKEY_STRING_A137, "STRING_A137");
	bindingNames.insert(INTERFACEKEY_STRING_A138, "STRING_A138");
	bindingNames.insert(INTERFACEKEY_STRING_A139, "STRING_A139");
	bindingNames.insert(INTERFACEKEY_STRING_A140, "STRING_A140");
	bindingNames.insert(INTERFACEKEY_STRING_A141, "STRING_A141");
	bindingNames.insert(INTERFACEKEY_STRING_A142, "STRING_A142");
	bindingNames.insert(INTERFACEKEY_STRING_A143, "STRING_A143");
	bindingNames.insert(INTERFACEKEY_STRING_A144, "STRING_A144");
	bindingNames.insert(INTERFACEKEY_STRING_A145, "STRING_A145");
	bindingNames.insert(INTERFACEKEY_STRING_A146, "STRING_A146");
	bindingNames.insert(INTERFACEKEY_STRING_A147, "STRING_A147");
	bindingNames.insert(INTERFACEKEY_STRING_A148, "STRING_A148");
	bindingNames.insert(INTERFACEKEY_STRING_A149, "STRING_A149");
	bindingNames.insert(INTERFACEKEY_STRING_A150, "STRING_A150");
	bindingNames.insert(INTERFACEKEY_STRING_A151, "STRING_A151");
	bindingNames.insert(INTERFACEKEY_STRING_A152, "STRING_A152");
	bindingNames.insert(INTERFACEKEY_STRING_A153, "STRING_A153");
	bindingNames.insert(INTERFACEKEY_STRING_A154, "STRING_A154");
	bindingNames.insert(INTERFACEKEY_STRING_A155, "STRING_A155");
	bindingNames.insert(INTERFACEKEY_STRING_A156, "STRING_A156");
	bindingNames.insert(INTERFACEKEY_STRING_A157, "STRING_A157");
	bindingNames.insert(INTERFACEKEY_STRING_A158, "STRING_A158");
	bindingNames.insert(INTERFACEKEY_STRING_A159, "STRING_A159");
	bindingNames.insert(INTERFACEKEY_STRING_A160, "STRING_A160");
	bindingNames.insert(INTERFACEKEY_STRING_A161, "STRING_A161");
	bindingNames.insert(INTERFACEKEY_STRING_A162, "STRING_A162");
	bindingNames.insert(INTERFACEKEY_STRING_A163, "STRING_A163");
	bindingNames.insert(INTERFACEKEY_STRING_A164, "STRING_A164");
	bindingNames.insert(INTERFACEKEY_STRING_A165, "STRING_A165");
	bindingNames.insert(INTERFACEKEY_STRING_A166, "STRING_A166");
	bindingNames.insert(INTERFACEKEY_STRING_A167, "STRING_A167");
	bindingNames.insert(INTERFACEKEY_STRING_A168, "STRING_A168");
	bindingNames.insert(INTERFACEKEY_STRING_A169, "STRING_A169");
	bindingNames.insert(INTERFACEKEY_STRING_A170, "STRING_A170");
	bindingNames.insert(INTERFACEKEY_STRING_A171, "STRING_A171");
	bindingNames.insert(INTERFACEKEY_STRING_A172, "STRING_A172");
	bindingNames.insert(INTERFACEKEY_STRING_A173, "STRING_A173");
	bindingNames.insert(INTERFACEKEY_STRING_A174, "STRING_A174");
	bindingNames.insert(INTERFACEKEY_STRING_A175, "STRING_A175");
	bindingNames.insert(INTERFACEKEY_STRING_A176, "STRING_A176");
	bindingNames.insert(INTERFACEKEY_STRING_A177, "STRING_A177");
	bindingNames.insert(INTERFACEKEY_STRING_A178, "STRING_A178");
	bindingNames.insert(INTERFACEKEY_STRING_A179, "STRING_A179");
	bindingNames.insert(INTERFACEKEY_STRING_A180, "STRING_A180");
	bindingNames.insert(INTERFACEKEY_STRING_A181, "STRING_A181");
	bindingNames.insert(INTERFACEKEY_STRING_A182, "STRING_A182");
	bindingNames.insert(INTERFACEKEY_STRING_A183, "STRING_A183");
	bindingNames.insert(INTERFACEKEY_STRING_A184, "STRING_A184");
	bindingNames.insert(INTERFACEKEY_STRING_A185, "STRING_A185");
	bindingNames.insert(INTERFACEKEY_STRING_A186, "STRING_A186");
	bindingNames.insert(INTERFACEKEY_STRING_A187, "STRING_A187");
	bindingNames.insert(INTERFACEKEY_STRING_A188, "STRING_A188");
	bindingNames.insert(INTERFACEKEY_STRING_A189, "STRING_A189");
	bindingNames.insert(INTERFACEKEY_STRING_A190, "STRING_A190");
	bindingNames.insert(INTERFACEKEY_STRING_A191, "STRING_A191");
	bindingNames.insert(INTERFACEKEY_STRING_A192, "STRING_A192");
	bindingNames.insert(INTERFACEKEY_STRING_A193, "STRING_A193");
	bindingNames.insert(INTERFACEKEY_STRING_A194, "STRING_A194");
	bindingNames.insert(INTERFACEKEY_STRING_A195, "STRING_A195");
	bindingNames.insert(INTERFACEKEY_STRING_A196, "STRING_A196");
	bindingNames.insert(INTERFACEKEY_STRING_A197, "STRING_A197");
	bindingNames.insert(INTERFACEKEY_STRING_A198, "STRING_A198");
	bindingNames.insert(INTERFACEKEY_STRING_A199, "STRING_A199");
	bindingNames.insert(INTERFACEKEY_STRING_A200, "STRING_A200");
	bindingNames.insert(INTERFACEKEY_STRING_A201, "STRING_A201");
	bindingNames.insert(INTERFACEKEY_STRING_A202, "STRING_A202");
	bindingNames.insert(INTERFACEKEY_STRING_A203, "STRING_A203");
	bindingNames.insert(INTERFACEKEY_STRING_A204, "STRING_A204");
	bindingNames.insert(INTERFACEKEY_STRING_A205, "STRING_A205");
	bindingNames.insert(INTERFACEKEY_STRING_A206, "STRING_A206");
	bindingNames.insert(INTERFACEKEY_STRING_A207, "STRING_A207");
	bindingNames.insert(INTERFACEKEY_STRING_A208, "STRING_A208");
	bindingNames.insert(INTERFACEKEY_STRING_A209, "STRING_A209");
	bindingNames.insert(INTERFACEKEY_STRING_A210, "STRING_A210");
	bindingNames.insert(INTERFACEKEY_STRING_A211, "STRING_A211");
	bindingNames.insert(INTERFACEKEY_STRING_A212, "STRING_A212");
	bindingNames.insert(INTERFACEKEY_STRING_A213, "STRING_A213");
	bindingNames.insert(INTERFACEKEY_STRING_A214, "STRING_A214");
	bindingNames.insert(INTERFACEKEY_STRING_A215, "STRING_A215");
	bindingNames.insert(INTERFACEKEY_STRING_A216, "STRING_A216");
	bindingNames.insert(INTERFACEKEY_STRING_A217, "STRING_A217");
	bindingNames.insert(INTERFACEKEY_STRING_A218, "STRING_A218");
	bindingNames.insert(INTERFACEKEY_STRING_A219, "STRING_A219");
	bindingNames.insert(INTERFACEKEY_STRING_A220, "STRING_A220");
	bindingNames.insert(INTERFACEKEY_STRING_A221, "STRING_A221");
	bindingNames.insert(INTERFACEKEY_STRING_A222, "STRING_A222");
	bindingNames.insert(INTERFACEKEY_STRING_A223, "STRING_A223");
	bindingNames.insert(INTERFACEKEY_STRING_A224, "STRING_A224");
	bindingNames.insert(INTERFACEKEY_STRING_A225, "STRING_A225");
	bindingNames.insert(INTERFACEKEY_STRING_A226, "STRING_A226");
	bindingNames.insert(INTERFACEKEY_STRING_A227, "STRING_A227");
	bindingNames.insert(INTERFACEKEY_STRING_A228, "STRING_A228");
	bindingNames.insert(INTERFACEKEY_STRING_A229, "STRING_A229");
	bindingNames.insert(INTERFACEKEY_STRING_A230, "STRING_A230");
	bindingNames.insert(INTERFACEKEY_STRING_A231, "STRING_A231");
	bindingNames.insert(INTERFACEKEY_STRING_A232, "STRING_A232");
	bindingNames.insert(INTERFACEKEY_STRING_A233, "STRING_A233");
	bindingNames.insert(INTERFACEKEY_STRING_A234, "STRING_A234");
	bindingNames.insert(INTERFACEKEY_STRING_A235, "STRING_A235");
	bindingNames.insert(INTERFACEKEY_STRING_A236, "STRING_A236");
	bindingNames.insert(INTERFACEKEY_STRING_A237, "STRING_A237");
	bindingNames.insert(INTERFACEKEY_STRING_A238, "STRING_A238");
	bindingNames.insert(INTERFACEKEY_STRING_A239, "STRING_A239");
	bindingNames.insert(INTERFACEKEY_STRING_A240, "STRING_A240");
	bindingNames.insert(INTERFACEKEY_STRING_A241, "STRING_A241");
	bindingNames.insert(INTERFACEKEY_STRING_A242, "STRING_A242");
	bindingNames.insert(INTERFACEKEY_STRING_A243, "STRING_A243");
	bindingNames.insert(INTERFACEKEY_STRING_A244, "STRING_A244");
	bindingNames.insert(INTERFACEKEY_STRING_A245, "STRING_A245");
	bindingNames.insert(INTERFACEKEY_STRING_A246, "STRING_A246");
	bindingNames.insert(INTERFACEKEY_STRING_A247, "STRING_A247");
	bindingNames.insert(INTERFACEKEY_STRING_A248, "STRING_A248");
	bindingNames.insert(INTERFACEKEY_STRING_A249, "STRING_A249");
	bindingNames.insert(INTERFACEKEY_STRING_A250, "STRING_A250");
	bindingNames.insert(INTERFACEKEY_STRING_A251, "STRING_A251");
	bindingNames.insert(INTERFACEKEY_STRING_A252, "STRING_A252");
	bindingNames.insert(INTERFACEKEY_STRING_A253, "STRING_A253");
	bindingNames.insert(INTERFACEKEY_STRING_A254, "STRING_A254");
	bindingNames.insert(INTERFACEKEY_STRING_A255, "STRING_A255");
	bindingNames.insert(INTERFACEKEY_CUSTOM_A, "CUSTOM_A");
	bindingNames.insert(INTERFACEKEY_CUSTOM_B, "CUSTOM_B");
	bindingNames.insert(INTERFACEKEY_CUSTOM_C, "CUSTOM_C");
	bindingNames.insert(INTERFACEKEY_CUSTOM_D, "CUSTOM_D");
	bindingNames.insert(INTERFACEKEY_CUSTOM_E, "CUSTOM_E");
	bindingNames.insert(INTERFACEKEY_CUSTOM_F, "CUSTOM_F");
	bindingNames.insert(INTERFACEKEY_CUSTOM_G, "CUSTOM_G");
	bindingNames.insert(INTERFACEKEY_CUSTOM_H, "CUSTOM_H");
	bindingNames.insert(INTERFACEKEY_CUSTOM_I, "CUSTOM_I");
	bindingNames.insert(INTERFACEKEY_CUSTOM_J, "CUSTOM_J");
	bindingNames.insert(INTERFACEKEY_CUSTOM_K, "CUSTOM_K");
	bindingNames.insert(INTERFACEKEY_CUSTOM_L, "CUSTOM_L");
	bindingNames.insert(INTERFACEKEY_CUSTOM_M, "CUSTOM_M");
	bindingNames.insert(INTERFACEKEY_CUSTOM_N, "CUSTOM_N");
	bindingNames.insert(INTERFACEKEY_CUSTOM_O, "CUSTOM_O");
	bindingNames.insert(INTERFACEKEY_CUSTOM_P, "CUSTOM_P");
	bindingNames.insert(INTERFACEKEY_CUSTOM_Q, "CUSTOM_Q");
	bindingNames.insert(INTERFACEKEY_CUSTOM_R, "CUSTOM_R");
	bindingNames.insert(INTERFACEKEY_CUSTOM_S, "CUSTOM_S");
	bindingNames.insert(INTERFACEKEY_CUSTOM_T, "CUSTOM_T");
	bindingNames.insert(INTERFACEKEY_CUSTOM_U, "CUSTOM_U");
	bindingNames.insert(INTERFACEKEY_CUSTOM_V, "CUSTOM_V");
	bindingNames.insert(INTERFACEKEY_CUSTOM_W, "CUSTOM_W");
	bindingNames.insert(INTERFACEKEY_CUSTOM_X, "CUSTOM_X");
	bindingNames.insert(INTERFACEKEY_CUSTOM_Y, "CUSTOM_Y");
	bindingNames.insert(INTERFACEKEY_CUSTOM_Z, "CUSTOM_Z");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_A, "CUSTOM_SHIFT_A");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_B, "CUSTOM_SHIFT_B");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_C, "CUSTOM_SHIFT_C");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_D, "CUSTOM_SHIFT_D");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_E, "CUSTOM_SHIFT_E");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_F, "CUSTOM_SHIFT_F");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_G, "CUSTOM_SHIFT_G");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_H, "CUSTOM_SHIFT_H");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_I, "CUSTOM_SHIFT_I");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_J, "CUSTOM_SHIFT_J");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_K, "CUSTOM_SHIFT_K");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_L, "CUSTOM_SHIFT_L");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_M, "CUSTOM_SHIFT_M");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_N, "CUSTOM_SHIFT_N");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_O, "CUSTOM_SHIFT_O");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_P, "CUSTOM_SHIFT_P");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_Q, "CUSTOM_SHIFT_Q");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_R, "CUSTOM_SHIFT_R");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_S, "CUSTOM_SHIFT_S");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_T, "CUSTOM_SHIFT_T");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_U, "CUSTOM_SHIFT_U");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_V, "CUSTOM_SHIFT_V");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_W, "CUSTOM_SHIFT_W");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_X, "CUSTOM_SHIFT_X");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_Y, "CUSTOM_SHIFT_Y");
	bindingNames.insert(INTERFACEKEY_CUSTOM_SHIFT_Z, "CUSTOM_SHIFT_Z");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_A, "CUSTOM_CTRL_A");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_B, "CUSTOM_CTRL_B");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_C, "CUSTOM_CTRL_C");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_D, "CUSTOM_CTRL_D");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_E, "CUSTOM_CTRL_E");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_F, "CUSTOM_CTRL_F");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_G, "CUSTOM_CTRL_G");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_H, "CUSTOM_CTRL_H");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_I, "CUSTOM_CTRL_I");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_J, "CUSTOM_CTRL_J");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_K, "CUSTOM_CTRL_K");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_L, "CUSTOM_CTRL_L");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_M, "CUSTOM_CTRL_M");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_N, "CUSTOM_CTRL_N");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_O, "CUSTOM_CTRL_O");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_P, "CUSTOM_CTRL_P");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_Q, "CUSTOM_CTRL_Q");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_R, "CUSTOM_CTRL_R");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_S, "CUSTOM_CTRL_S");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_T, "CUSTOM_CTRL_T");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_U, "CUSTOM_CTRL_U");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_V, "CUSTOM_CTRL_V");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_W, "CUSTOM_CTRL_W");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_X, "CUSTOM_CTRL_X");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_Y, "CUSTOM_CTRL_Y");
	bindingNames.insert(INTERFACEKEY_CUSTOM_CTRL_Z, "CUSTOM_CTRL_Z");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_A, "CUSTOM_ALT_A");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_B, "CUSTOM_ALT_B");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_C, "CUSTOM_ALT_C");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_D, "CUSTOM_ALT_D");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_E, "CUSTOM_ALT_E");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_F, "CUSTOM_ALT_F");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_G, "CUSTOM_ALT_G");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_H, "CUSTOM_ALT_H");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_I, "CUSTOM_ALT_I");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_J, "CUSTOM_ALT_J");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_K, "CUSTOM_ALT_K");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_L, "CUSTOM_ALT_L");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_M, "CUSTOM_ALT_M");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_N, "CUSTOM_ALT_N");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_O, "CUSTOM_ALT_O");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_P, "CUSTOM_ALT_P");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_Q, "CUSTOM_ALT_Q");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_R, "CUSTOM_ALT_R");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_S, "CUSTOM_ALT_S");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_T, "CUSTOM_ALT_T");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_U, "CUSTOM_ALT_U");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_V, "CUSTOM_ALT_V");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_W, "CUSTOM_ALT_W");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_X, "CUSTOM_ALT_X");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_Y, "CUSTOM_ALT_Y");
	bindingNames.insert(INTERFACEKEY_CUSTOM_ALT_Z, "CUSTOM_ALT_Z");
	bindingNames.insert(INTERFACEKEY_FPS_UP, "FPS_UP");
	bindingNames.insert(INTERFACEKEY_FPS_DOWN, "FPS_DOWN");
	bindingNames.insert(INTERFACEKEY_TOGGLE_TTF, "TOGGLE_TTF");
	bindingNames.insert(INTERFACEKEY_PREFIX, "PREFIX");
        

	displayNames.insert(INTERFACEKEY_NONE, "None");
	displayNames.insert(INTERFACEKEY_SELECT, "Select");
	displayNames.insert(INTERFACEKEY_SEC_SELECT, "Secondary Select");
	displayNames.insert(INTERFACEKEY_DESELECT, "Deselect");
	displayNames.insert(INTERFACEKEY_SELECT_ALL, "Select all");
	displayNames.insert(INTERFACEKEY_DESELECT_ALL, "Deselect All");
	displayNames.insert(INTERFACEKEY_LEAVESCREEN, "Leave screen");
	displayNames.insert(INTERFACEKEY_LEAVESCREEN_ALL, "Leave all screens");
	displayNames.insert(INTERFACEKEY_CLOSE_MEGA_ANNOUNCEMENT, "Close mega announcement");
	displayNames.insert(INTERFACEKEY_TOGGLE_FULLSCREEN, "Toggle Fullscreen");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_ADD, "World Param: Add");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_COPY, "World Param: Copy");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_DELETE, "World Param: Delete");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_TITLE, "World Param: Title");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_NAME_RANDOM, "World Param: Name, Random");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_NAME_ENTER, "World Param: Name, Enter");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_SEED_RANDOM, "World Param: Seed, Random");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_SEED_ENTER, "World Param: Seed, Enter");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_LOAD, "World Param: Load");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_SAVE, "World Param: Save");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_DIM_X_UP, "World Param: Dim X, Up");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_DIM_X_DOWN, "World Param: Dim X, Down");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_DIM_Y_UP, "World Param: Dim Y, Up");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_DIM_Y_DOWN, "World Param: Dim Y, Down");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_SET, "World Param: Enter Advanced Parameters");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_INCREASE, "World Param: Increase Parameter");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_DECREASE, "World Param: Decrease Parameter");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_ENTER_VALUE, "World Param: Enter Value");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_NULLIFY, "World Param: Nullify Parameter");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_PRESET, "World Param: Set Presets");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_REJECT_CONTINUE, "World Param: Reject, Continue");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_REJECT_ABORT, "World Param: Reject, Abort");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_THIS, "World Param: Reject, Allow This");
	displayNames.insert(INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_ALL, "World Param: Reject, Allow All");
	displayNames.insert(INTERFACEKEY_WORLD_GEN_CONTINUE, "World Generation: Continue");
	displayNames.insert(INTERFACEKEY_WORLD_GEN_USE, "World Generation: Use");
	displayNames.insert(INTERFACEKEY_WORLD_GEN_ABORT, "World Generation: Abort");
	displayNames.insert(INTERFACEKEY_SETUP_EMBARK, "Setup game: Embark");
	displayNames.insert(INTERFACEKEY_SETUP_NAME_FORT, "Setup game: Name Fort");
	displayNames.insert(INTERFACEKEY_SETUP_NAME_GROUP, "Setup game: Name Group");
	displayNames.insert(INTERFACEKEY_SETUP_RECLAIM, "Setup game: Reclaim");
	displayNames.insert(INTERFACEKEY_SETUP_FIND, "Setup game: Find");
	displayNames.insert(INTERFACEKEY_SETUP_NOTES, "Setup game: Notes");
	displayNames.insert(INTERFACEKEY_SETUP_NOTES_TAKE_NOTES, "Setup game: Notes, New Note");
	displayNames.insert(INTERFACEKEY_SETUP_NOTES_DELETE_NOTE, "Setup game: Notes, Delete Note");
	displayNames.insert(INTERFACEKEY_SETUP_NOTES_CHANGE_SYMBOL_SELECTION, "Setup game: Notes, Change Symbol Selection");
	displayNames.insert(INTERFACEKEY_SETUP_NOTES_ADOPT_SYMBOL, "Setup game: Notes, Adopt Symbol");
	displayNames.insert(INTERFACEKEY_SETUP_LOCAL_Y_UP, "Setup game: Resize Local Y Up");
	displayNames.insert(INTERFACEKEY_SETUP_LOCAL_Y_DOWN, "Setup game: Resize Local Y Down");
	displayNames.insert(INTERFACEKEY_SETUP_LOCAL_X_UP, "Setup game: Resize Local X Up");
	displayNames.insert(INTERFACEKEY_SETUP_LOCAL_X_DOWN, "Setup game: Resize Local X Down");
	displayNames.insert(INTERFACEKEY_SETUP_LOCAL_Y_MUP, "Setup game: Move Local Y Up");
	displayNames.insert(INTERFACEKEY_SETUP_LOCAL_Y_MDOWN, "Setup game: Move Local Y Down");
	displayNames.insert(INTERFACEKEY_SETUP_LOCAL_X_MUP, "Setup game: Move Local X Up");
	displayNames.insert(INTERFACEKEY_SETUP_LOCAL_X_MDOWN, "Setup game: Move Local X Down");
	displayNames.insert(INTERFACEKEY_SETUP_BIOME_1, "Setup game: View Biome 1");
	displayNames.insert(INTERFACEKEY_SETUP_BIOME_2, "Setup game: View Biome 2");
	displayNames.insert(INTERFACEKEY_SETUP_BIOME_3, "Setup game: View Biome 3");
	displayNames.insert(INTERFACEKEY_SETUP_BIOME_4, "Setup game: View Biome 4");
	displayNames.insert(INTERFACEKEY_SETUP_BIOME_5, "Setup game: View Biome 5");
	displayNames.insert(INTERFACEKEY_SETUP_BIOME_6, "Setup game: View Biome 6");
	displayNames.insert(INTERFACEKEY_SETUP_BIOME_7, "Setup game: View Biome 7");
	displayNames.insert(INTERFACEKEY_SETUP_BIOME_8, "Setup game: View Biome 8");
	displayNames.insert(INTERFACEKEY_SETUP_BIOME_9, "Setup game: View Biome 9");
	displayNames.insert(INTERFACEKEY_CHOOSE_NAME_RANDOM, "Choose name: Random");
	displayNames.insert(INTERFACEKEY_CHOOSE_NAME_CLEAR, "Choose name: Clear");
	displayNames.insert(INTERFACEKEY_CHOOSE_NAME_TYPE, "Choose name: Type");
	displayNames.insert(INTERFACEKEY_ITEM_DESCRIPTION, "View item: Description");
	displayNames.insert(INTERFACEKEY_ITEM_FORBID, "View item: Forbid");
	displayNames.insert(INTERFACEKEY_ITEM_MELT, "View item: Melt");
	displayNames.insert(INTERFACEKEY_ITEM_DUMP, "View item: Dump");
	displayNames.insert(INTERFACEKEY_ITEM_HIDE, "View item: Hide");
	displayNames.insert(INTERFACEKEY_OPTIONS, "Main menu");
	displayNames.insert(INTERFACEKEY_OPTION_EXPORT, "Options, Export Local Image");
	displayNames.insert(INTERFACEKEY_HELP, "Help");
	displayNames.insert(INTERFACEKEY_MOVIES, "Movies");
	displayNames.insert(INTERFACEKEY_CHANGETAB, "Change tab or highlight selection");
	displayNames.insert(INTERFACEKEY_SEC_CHANGETAB, "Change tab or highlight selection, secondary");
	displayNames.insert(INTERFACEKEY_STANDARDSCROLL_UP, "Move selector up");
	displayNames.insert(INTERFACEKEY_STANDARDSCROLL_DOWN, "Move selector down");
	displayNames.insert(INTERFACEKEY_STANDARDSCROLL_LEFT, "Move selector left");
	displayNames.insert(INTERFACEKEY_STANDARDSCROLL_RIGHT, "Move selector right");
	displayNames.insert(INTERFACEKEY_STANDARDSCROLL_PAGEUP, "Page selector up");
	displayNames.insert(INTERFACEKEY_STANDARDSCROLL_PAGEDOWN, "Page selector down");
	displayNames.insert(INTERFACEKEY_SECONDSCROLL_UP, "Move secondary selector up");
	displayNames.insert(INTERFACEKEY_SECONDSCROLL_DOWN, "Move secondary selector down");
	displayNames.insert(INTERFACEKEY_SECONDSCROLL_PAGEUP, "Page secondary selector up");
	displayNames.insert(INTERFACEKEY_SECONDSCROLL_PAGEDOWN, "Page secondary selector down");
	displayNames.insert(INTERFACEKEY_CURSOR_UP, "Move view/cursor up");
	displayNames.insert(INTERFACEKEY_CURSOR_DOWN, "Move view/cursor down");
	displayNames.insert(INTERFACEKEY_CURSOR_LEFT, "Move view/cursor left");
	displayNames.insert(INTERFACEKEY_CURSOR_RIGHT, "Move view/cursor right");
	displayNames.insert(INTERFACEKEY_CURSOR_UPLEFT, "Move view/cursor up and left");
	displayNames.insert(INTERFACEKEY_CURSOR_UPRIGHT, "Move view/cursor up and right");
	displayNames.insert(INTERFACEKEY_CURSOR_DOWNLEFT, "Move view/cursor down and left");
	displayNames.insert(INTERFACEKEY_CURSOR_DOWNRIGHT, "Move view/cursor down and right");
	displayNames.insert(INTERFACEKEY_CURSOR_UP_FAST, "Move view/cursor up, fast");
	displayNames.insert(INTERFACEKEY_CURSOR_DOWN_FAST, "Move view/cursor down, fast");
	displayNames.insert(INTERFACEKEY_CURSOR_LEFT_FAST, "Move view/cursor left, fast");
	displayNames.insert(INTERFACEKEY_CURSOR_RIGHT_FAST, "Move view/cursor right, fast");
	displayNames.insert(INTERFACEKEY_CURSOR_UPLEFT_FAST, "Move view/cursor up and left, fast");
	displayNames.insert(INTERFACEKEY_CURSOR_UPRIGHT_FAST, "Move view/cursor up and right, fast");
	displayNames.insert(INTERFACEKEY_CURSOR_DOWNLEFT_FAST, "Move view/cursor down and left, fast");
	displayNames.insert(INTERFACEKEY_CURSOR_DOWNRIGHT_FAST, "Move view/cursor down and right, fast");
	displayNames.insert(INTERFACEKEY_CURSOR_UP_Z, "Move view/cursor up (z)");
	displayNames.insert(INTERFACEKEY_CURSOR_DOWN_Z, "Move view/cursor down (z)");
	displayNames.insert(INTERFACEKEY_CURSOR_UP_Z_AUX, "Move view/cursor up (z), aux");
	displayNames.insert(INTERFACEKEY_CURSOR_DOWN_Z_AUX, "Move view/cursor down (z), aux");
	displayNames.insert(INTERFACEKEY_A_RETURN_TO_ARENA, "Adventure: return to arena");
	displayNames.insert(INTERFACEKEY_A_MOVE_N, "Adventure: move north");
	displayNames.insert(INTERFACEKEY_A_MOVE_S, "Adventure: move south");
	displayNames.insert(INTERFACEKEY_A_MOVE_E, "Adventure: move east");
	displayNames.insert(INTERFACEKEY_A_MOVE_W, "Adventure: move west");
	displayNames.insert(INTERFACEKEY_A_MOVE_NW, "Adventure: move northwest");
	displayNames.insert(INTERFACEKEY_A_MOVE_NE, "Adventure: move northeast");
	displayNames.insert(INTERFACEKEY_A_MOVE_SW, "Adventure: move southwest");
	displayNames.insert(INTERFACEKEY_A_MOVE_SE, "Adventure: move southeast");
	displayNames.insert(INTERFACEKEY_A_MOVE_SAME_SQUARE, "Adventure: move same square");
	displayNames.insert(INTERFACEKEY_A_CARE_MOVE_N, "Adventure: careful move north up/down");
	displayNames.insert(INTERFACEKEY_A_CARE_MOVE_S, "Adventure: careful move south up/down");
	displayNames.insert(INTERFACEKEY_A_CARE_MOVE_E, "Adventure: careful move east up/down");
	displayNames.insert(INTERFACEKEY_A_CARE_MOVE_W, "Adventure: careful move west up/down");
	displayNames.insert(INTERFACEKEY_A_CARE_MOVE_NW, "Adventure: careful move northwest up/down");
	displayNames.insert(INTERFACEKEY_A_CARE_MOVE_NE, "Adventure: careful move northeast up/down");
	displayNames.insert(INTERFACEKEY_A_CARE_MOVE_SW, "Adventure: careful move southwest up/down");
	displayNames.insert(INTERFACEKEY_A_CARE_MOVE_SE, "Adventure: careful move southeast up/down");
	displayNames.insert(INTERFACEKEY_A_CARE_MOVE_UPDOWN, "Adventure: careful move up/down");
	displayNames.insert(INTERFACEKEY_A_MOVE_N_UP, "Adventure: move north/up");
	displayNames.insert(INTERFACEKEY_A_MOVE_S_UP, "Adventure: move south/up");
	displayNames.insert(INTERFACEKEY_A_MOVE_E_UP, "Adventure: move east/up");
	displayNames.insert(INTERFACEKEY_A_MOVE_W_UP, "Adventure: move west/up");
	displayNames.insert(INTERFACEKEY_A_MOVE_NW_UP, "Adventure: move northwest/up");
	displayNames.insert(INTERFACEKEY_A_MOVE_NE_UP, "Adventure: move northeast/up");
	displayNames.insert(INTERFACEKEY_A_MOVE_SW_UP, "Adventure: move southwest/up");
	displayNames.insert(INTERFACEKEY_A_MOVE_SE_UP, "Adventure: move southeast/up");
	displayNames.insert(INTERFACEKEY_A_MOVE_UP, "Adventure: move up");
	displayNames.insert(INTERFACEKEY_A_MOVE_N_DOWN, "Adventure: move north/down");
	displayNames.insert(INTERFACEKEY_A_MOVE_S_DOWN, "Adventure: move south/down");
	displayNames.insert(INTERFACEKEY_A_MOVE_E_DOWN, "Adventure: move east/down");
	displayNames.insert(INTERFACEKEY_A_MOVE_W_DOWN, "Adventure: move west/down");
	displayNames.insert(INTERFACEKEY_A_MOVE_NW_DOWN, "Adventure: move northwest/down");
	displayNames.insert(INTERFACEKEY_A_MOVE_NE_DOWN, "Adventure: move northeast/down");
	displayNames.insert(INTERFACEKEY_A_MOVE_SW_DOWN, "Adventure: move southwest/down");
	displayNames.insert(INTERFACEKEY_A_MOVE_SE_DOWN, "Adventure: move southeast/down");
	displayNames.insert(INTERFACEKEY_A_MOVE_DOWN, "Adventure: move down");
	displayNames.insert(INTERFACEKEY_A_MOVE_UP_AUX, "Adventure: move up, aux");
	displayNames.insert(INTERFACEKEY_A_MOVE_DOWN_AUX, "Adventure: move down, aux");
	displayNames.insert(INTERFACEKEY_WORLDGEN_EXPORT_MAP, "World Gen: Export Map");
	displayNames.insert(INTERFACEKEY_LEGENDS_EXPORT_MAP, "Legends: Export Map");
	displayNames.insert(INTERFACEKEY_LEGENDS_EXPORT_XML, "Legends: Export XML");
	displayNames.insert(INTERFACEKEY_LEGENDS_EXPORT_DETAILED_MAP, "Legends: Export Detailed Map");
	displayNames.insert(INTERFACEKEY_LEGENDS_TOGGLE_CIVSITE, "Legends: Civ/Site");
	displayNames.insert(INTERFACEKEY_LEGENDS_STRING_FILTER, "Legends: String filter");
	displayNames.insert(INTERFACEKEY_A_COMBAT_ATTACK, "Adventure: Combat, Attack Mode");
	displayNames.insert(INTERFACEKEY_A_COMBAT_DODGE, "Adventure: Combat, Dodge Mode");
	displayNames.insert(INTERFACEKEY_A_COMBAT_CHARGEDEF, "Adventure: Combat, Charge Defend Mode");
	displayNames.insert(INTERFACEKEY_A_STATUS, "Adventure: Status");
	displayNames.insert(INTERFACEKEY_A_STATUS_WRESTLE, "Adventure: Status, Close Combat");
	displayNames.insert(INTERFACEKEY_A_STATUS_CUSTOMIZE, "Adventure: Status, Customize");
	displayNames.insert(INTERFACEKEY_A_STATUS_KILLS, "Adventure: Status, Kills");
	displayNames.insert(INTERFACEKEY_A_STATUS_HEALTH, "Adventure: Status, Health");
	displayNames.insert(INTERFACEKEY_A_STATUS_ATT_SKILL, "Adventure: Status, Att/Skills");
	displayNames.insert(INTERFACEKEY_A_STATUS_DESC, "Adventure: Status, Desc");
	displayNames.insert(INTERFACEKEY_UNITVIEW_CUSTOMIZE, "Unit View, Customize");
	displayNames.insert(INTERFACEKEY_UNITVIEW_HEALTH, "Unit View, Health");
	displayNames.insert(INTERFACEKEY_UNITVIEW_RELATIONSHIPS, "Unit View, Relationships");
	displayNames.insert(INTERFACEKEY_UNITVIEW_RELATIONSHIPS_ZOOM, "Unit View, Relationships, Zoom");
	displayNames.insert(INTERFACEKEY_UNITVIEW_RELATIONSHIPS_VIEW, "Unit View, Relationships, View");
	displayNames.insert(INTERFACEKEY_UNITVIEW_KILLS, "Unit View, Kills");
	displayNames.insert(INTERFACEKEY_CUSTOMIZE_UNIT_NICKNAME, "Customize Unit, Nickname");
	displayNames.insert(INTERFACEKEY_CUSTOMIZE_UNIT_PROFNAME, "Customize Unit, Profession");
	displayNames.insert(INTERFACEKEY_A_CLEAR_ANNOUNCEMENTS, "Adventure: Clear announcements");
	displayNames.insert(INTERFACEKEY_A_SLEEP, "Adventure: Sleep");
	displayNames.insert(INTERFACEKEY_A_SLEEP_SLEEP, "Adventure: Sleep, Sleep");
	displayNames.insert(INTERFACEKEY_A_SLEEP_WAIT, "Adventure: Sleep, Wait");
	displayNames.insert(INTERFACEKEY_A_SLEEP_DAWN, "Adventure: Sleep, Dawn");
	displayNames.insert(INTERFACEKEY_A_WAIT, "Adventure: Wait");
	displayNames.insert(INTERFACEKEY_A_ATTACK, "Adventure: Attack");
	displayNames.insert(INTERFACEKEY_A_ATTACK_CONFIRM, "Adventure: Attack, Confirm");
	displayNames.insert(INTERFACEKEY_A_LOOK, "Adventure: Look");
	displayNames.insert(INTERFACEKEY_A_SEARCH, "Adventure: Search");
	displayNames.insert(INTERFACEKEY_A_TALK, "Adventure: Talk");
	displayNames.insert(INTERFACEKEY_A_INTERACT, "Adventure: Inv. Interact");
	displayNames.insert(INTERFACEKEY_A_ACTION, "Adventure: Misc. Action");
	displayNames.insert(INTERFACEKEY_A_ACTION_CREATE, "Adventure: Misc. Action, Create");
	displayNames.insert(INTERFACEKEY_A_ACTION_BUTCHER, "Adventure: Misc. Action, Butcher");
	displayNames.insert(INTERFACEKEY_A_ACTION_ABILITY, "Adventure: Misc. Action, Ability");
	displayNames.insert(INTERFACEKEY_A_ACTION_POWER, "Adventure: Misc. Action, Power");
	displayNames.insert(INTERFACEKEY_A_INV_LOOK, "Adventure: Inv. Look");
	displayNames.insert(INTERFACEKEY_A_INV_REMOVE, "Adventure: Inv. Remove");
	displayNames.insert(INTERFACEKEY_A_INV_WEAR, "Adventure: Inv. Wear");
	displayNames.insert(INTERFACEKEY_A_INV_EATDRINK, "Adventure: Inv. Eat/Drink");
	displayNames.insert(INTERFACEKEY_A_INV_PUTIN, "Adventure: Inv. Put In");
	displayNames.insert(INTERFACEKEY_A_INV_DROP, "Adventure: Inv. Drop");
	displayNames.insert(INTERFACEKEY_A_GROUND, "Adventure: Get/Ground");
	displayNames.insert(INTERFACEKEY_A_THROW, "Adventure: Throw");
	displayNames.insert(INTERFACEKEY_A_SHOOT, "Adventure: Fire");
	displayNames.insert(INTERFACEKEY_A_ANNOUNCEMENTS, "Adventure: Announcements");
	displayNames.insert(INTERFACEKEY_A_COMBAT, "Adventure: Combat Options");
	displayNames.insert(INTERFACEKEY_A_MOVEMENT, "Adventure: Movement Options");
	displayNames.insert(INTERFACEKEY_A_MOVEMENT_SWIM, "Adventure: Movement Options, Swim");
	displayNames.insert(INTERFACEKEY_A_SNEAK, "Adventure: Sneak");
	displayNames.insert(INTERFACEKEY_A_CENTER, "Adventure: Center");
	displayNames.insert(INTERFACEKEY_A_COMPANIONS, "Adventure: Companions");
	displayNames.insert(INTERFACEKEY_A_BUILDING, "Adventure: Building Interact");
	displayNames.insert(INTERFACEKEY_A_TRAVEL, "Adventure: Travel");
	displayNames.insert(INTERFACEKEY_A_TRAVEL_SLEEP, "Adventure: Travel, Sleep");
	displayNames.insert(INTERFACEKEY_A_TRAVEL_MAP, "Adventure: Travel, Map");
	displayNames.insert(INTERFACEKEY_A_TRAVEL_HIDE_INSTRUCTIONS, "Adventure: Travel, Hide Instructions");
	displayNames.insert(INTERFACEKEY_A_DATE, "Adventure: Get Date");
	displayNames.insert(INTERFACEKEY_A_WEATHER, "Adventure: Get Weather");
	displayNames.insert(INTERFACEKEY_A_TEMPERATURE, "Adventure: Get Temperature");
	displayNames.insert(INTERFACEKEY_A_STANCE, "Adventure: Change Stance");
	displayNames.insert(INTERFACEKEY_OPTION1, "Option 1");
	displayNames.insert(INTERFACEKEY_OPTION2, "Option 2");
	displayNames.insert(INTERFACEKEY_OPTION3, "Option 3");
	displayNames.insert(INTERFACEKEY_OPTION4, "Option 4");
	displayNames.insert(INTERFACEKEY_OPTION5, "Option 5");
	displayNames.insert(INTERFACEKEY_OPTION6, "Option 6");
	displayNames.insert(INTERFACEKEY_OPTION7, "Option 7");
	displayNames.insert(INTERFACEKEY_OPTION8, "Option 8");
	displayNames.insert(INTERFACEKEY_OPTION9, "Option 9");
	displayNames.insert(INTERFACEKEY_OPTION10, "Option 10");
	displayNames.insert(INTERFACEKEY_OPTION11, "Option 11");
	displayNames.insert(INTERFACEKEY_OPTION12, "Option 12");
	displayNames.insert(INTERFACEKEY_OPTION13, "Option 13");
	displayNames.insert(INTERFACEKEY_OPTION14, "Option 14");
	displayNames.insert(INTERFACEKEY_OPTION15, "Option 15");
	displayNames.insert(INTERFACEKEY_OPTION16, "Option 16");
	displayNames.insert(INTERFACEKEY_OPTION17, "Option 17");
	displayNames.insert(INTERFACEKEY_OPTION18, "Option 18");
	displayNames.insert(INTERFACEKEY_OPTION19, "Option 19");
	displayNames.insert(INTERFACEKEY_OPTION20, "Option 20");
	displayNames.insert(INTERFACEKEY_SEC_OPTION1, "Secondary Option 1");
	displayNames.insert(INTERFACEKEY_SEC_OPTION2, "Secondary Option 2");
	displayNames.insert(INTERFACEKEY_SEC_OPTION3, "Secondary Option 3");
	displayNames.insert(INTERFACEKEY_SEC_OPTION4, "Secondary Option 4");
	displayNames.insert(INTERFACEKEY_SEC_OPTION5, "Secondary Option 5");
	displayNames.insert(INTERFACEKEY_SEC_OPTION6, "Secondary Option 6");
	displayNames.insert(INTERFACEKEY_SEC_OPTION7, "Secondary Option 7");
	displayNames.insert(INTERFACEKEY_SEC_OPTION8, "Secondary Option 8");
	displayNames.insert(INTERFACEKEY_SEC_OPTION9, "Secondary Option 9");
	displayNames.insert(INTERFACEKEY_SEC_OPTION10, "Secondary Option 10");
	displayNames.insert(INTERFACEKEY_SEC_OPTION11, "Secondary Option 11");
	displayNames.insert(INTERFACEKEY_SEC_OPTION12, "Secondary Option 12");
	displayNames.insert(INTERFACEKEY_SEC_OPTION13, "Secondary Option 13");
	displayNames.insert(INTERFACEKEY_SEC_OPTION14, "Secondary Option 14");
	displayNames.insert(INTERFACEKEY_SEC_OPTION15, "Secondary Option 15");
	displayNames.insert(INTERFACEKEY_SEC_OPTION16, "Secondary Option 16");
	displayNames.insert(INTERFACEKEY_SEC_OPTION17, "Secondary Option 17");
	displayNames.insert(INTERFACEKEY_SEC_OPTION18, "Secondary Option 18");
	displayNames.insert(INTERFACEKEY_SEC_OPTION19, "Secondary Option 19");
	displayNames.insert(INTERFACEKEY_SEC_OPTION20, "Secondary Option 20");
	displayNames.insert(INTERFACEKEY_HOTKEY_MAKE_ASH, "Hotkey: Make Ash");
	displayNames.insert(INTERFACEKEY_HOTKEY_MAKE_CHARCOAL, "Hotkey: Make Charcoal");
	displayNames.insert(INTERFACEKEY_HOTKEY_MELT_OBJECT, "Hotkey: Melt Object");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_GREEN, "Hotkey: Green Glass");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_CLEAR, "Hotkey: Clear Glass");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_CRYSTAL, "Hotkey: Crystal Glass");
	displayNames.insert(INTERFACEKEY_HOTKEY_COLLECT_SAND, "Hotkey: Collect Sand");
	displayNames.insert(INTERFACEKEY_HOTKEY_COLLECT_CLAY, "Hotkey: Collect Clay");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_ROUGH, "Hotkey: Raw Glass");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_ARMORSTAND, "Hotkey: Glass Armorstand");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_BOX, "Hotkey: Glass Box");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_CABINET, "Hotkey: Glass Cabinet");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_COFFIN, "Hotkey: Glass Coffin");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_FLOODGATE, "Hotkey: Glass Floodgate");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_HATCH_COVER, "Hotkey: Glass Hatch Cover");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_GRATE, "Hotkey: Glass Grate");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_GOBLET, "Hotkey: Glass Goblet");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_TOY, "Hotkey: Glass Toy");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_INSTRUMENT, "Hotkey: Glass Instrument");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_DOOR, "Hotkey: Glass Portal");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_STATUE, "Hotkey: Glass Statue");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_TABLE, "Hotkey: Glass Table");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_CAGE, "Hotkey: Glass Cage");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_CHAIR, "Hotkey: Glass Chair");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_BLOCKS, "Hotkey: Glass Blocks");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_FLASK, "Hotkey: Glass Vial");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_WEAPONRACK, "Hotkey: Glass Weaponrack");
	displayNames.insert(INTERFACEKEY_HOTKEY_GLASS_WINDOW, "Hotkey: Glass Window");
	displayNames.insert(INTERFACEKEY_HOTKEY_ASHERY_LYE, "Hotkey: Ashery, Lye");
	displayNames.insert(INTERFACEKEY_HOTKEY_ASHERY_POTASH, "Hotkey: Ashery, Potash (Lye)");
	displayNames.insert(INTERFACEKEY_HOTKEY_ASHERY_POTASH_DIRECT, "Hotkey: Ashery, Potash (Ash)");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BARREL, "Hotkey: Carpenter, Barrel");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BLOCKS, "Hotkey: Carpenter, Blocks");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BUCKET, "Hotkey: Carpenter, Bucket");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_TRAP_ANIMAL, "Hotkey: Carpenter, Animal Trap");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_CAGE, "Hotkey: Carpenter, Cage");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_ARMORSTAND, "Hotkey: Carpenter, Armorstand");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BED, "Hotkey: Carpenter, Bed");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_CHAIR, "Hotkey: Carpenter, Chair");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_COFFIN, "Hotkey: Carpenter, Coffin");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_DOOR, "Hotkey: Carpenter, Door");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_FLOODGATE, "Hotkey: Carpenter, Floodgate");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_HATCH_COVER, "Hotkey: Carpenter, Hatch Cover");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_GRATE, "Hotkey: Carpenter, Grate");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_CABINET, "Hotkey: Carpenter, Cabinet");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BIN, "Hotkey: Carpenter, Bin");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_BOX, "Hotkey: Carpenter, Box");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_WEAPONRACK, "Hotkey: Carpenter, Weaponrack");
	displayNames.insert(INTERFACEKEY_HOTKEY_CARPENTER_TABLE, "Hotkey: Carpenter, Table");
	displayNames.insert(INTERFACEKEY_HOTKEY_SIEGE_BALLISTA, "Hotkey: Siege Shop, Ballista");
	displayNames.insert(INTERFACEKEY_HOTKEY_SIEGE_CATAPULT, "Hotkey: Siege Shop, Catapult");
	displayNames.insert(INTERFACEKEY_HOTKEY_LEATHER_BOX, "Hotkey: Leather, Bag");
	displayNames.insert(INTERFACEKEY_HOTKEY_LEATHER_FLASK, "Hotkey: Leather, Flask");
	displayNames.insert(INTERFACEKEY_HOTKEY_LEATHER_SHIRT, "Hotkey: Leather, Shirt");
	displayNames.insert(INTERFACEKEY_HOTKEY_LEATHER_CLOAK, "Hotkey: Leather, Cloak");
	displayNames.insert(INTERFACEKEY_HOTKEY_LEATHER_BACKPACK, "Hotkey: Leather, Backpack");
	displayNames.insert(INTERFACEKEY_HOTKEY_LEATHER_QUIVER, "Hotkey: Leather, Quiver");
	displayNames.insert(INTERFACEKEY_HOTKEY_LEATHER_IMAGE, "Hotkey: Leather, Image");
	displayNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_MAT_PLANT, "Hotkey: Clothes, Cloth");
	displayNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_MAT_SILK, "Hotkey: Clothes, Silk");
	displayNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_MAT_YARN, "Hotkey: Clothes, Yarn");
	displayNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_SHIRT, "Hotkey: Clothes, Shirt");
	displayNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_CLOAK, "Hotkey: Clothes, Cloak");
	displayNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_BOX, "Hotkey: Clothes, Box");
	displayNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_CHAIN, "Hotkey: Clothes, Rope");
	displayNames.insert(INTERFACEKEY_HOTKEY_CLOTHES_IMAGE, "Hotkey: Clothes, Image");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_STONE, "Hotkey: Crafts, Mat Stone");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_WOOD, "Hotkey: Crafts, Mat Wood");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_DEC_BONE, "Hotkey: Crafts, Dec Bone");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_DEC_SHELL, "Hotkey: Crafts, Dec Shell");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_DEC_TOOTH, "Hotkey: Crafts, Dec Tooth");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_DEC_HORN, "Hotkey: Crafts, Dec Horn");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_DEC_PEARL, "Hotkey: Crafts, Dec Pearl");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_TOTEM, "Hotkey: Crafts, Totem");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_CLOTH, "Hotkey: Crafts, Cloth");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SILK, "Hotkey: Crafts, Silk");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_YARN, "Hotkey: Crafts, Yarn");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SEL_WOOD, "Hotkey: Crafts, Wood Material");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SEL_BONE, "Hotkey: Crafts, Bone Material");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SEL_SHELL, "Hotkey: Crafts, Shell Material");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SHELL, "Hotkey: Crafts, Shell");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_TOOTH, "Hotkey: Crafts, Tooth");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_HORN, "Hotkey: Crafts, Horn");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_PEARL, "Hotkey: Crafts, Pearl");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_BONE, "Hotkey: Crafts, Bone");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_LEATHER, "Hotkey: Crafts, Leather");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_SLAB, "Hotkey: Crafts, Slab");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_CRAFTS, "Hotkey: Crafts, Mat Crafts");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_GOBLET, "Hotkey: Crafts, Mat Goblet");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_INSTRUMENT, "Hotkey: Crafts, Mat Instrument");
	displayNames.insert(INTERFACEKEY_HOTKEY_CRAFTS_MAT_TOY, "Hotkey: Crafts, Mat Toy");
	displayNames.insert(INTERFACEKEY_HOTKEY_SMITH_WEAPON, "Hotkey: Forge, Weapon");
	displayNames.insert(INTERFACEKEY_HOTKEY_SMITH_ARMOR, "Hotkey: Forge, Armor");
	displayNames.insert(INTERFACEKEY_HOTKEY_SMITH_FURNITURE, "Hotkey: Forge, Furniture");
	displayNames.insert(INTERFACEKEY_HOTKEY_SMITH_SIEGE, "Hotkey: Forge, Siege");
	displayNames.insert(INTERFACEKEY_HOTKEY_SMITH_TRAP, "Hotkey: Forge, Trap");
	displayNames.insert(INTERFACEKEY_HOTKEY_SMITH_OTHER, "Hotkey: Forge, Other");
	displayNames.insert(INTERFACEKEY_HOTKEY_SMITH_METAL, "Hotkey: Forge, Metal Clothing");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ARMORSTAND, "Hotkey: Building, Armorstand");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BED, "Hotkey: Building, Bed");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRACTION_BENCH, "Hotkey: Building, Traction Bench");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SLAB, "Hotkey: Building, Slab");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_NEST_BOX, "Hotkey: Building, Nest Box");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_HIVE, "Hotkey: Building, Hive");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CHAIR, "Hotkey: Building, Chair");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_COFFIN, "Hotkey: Building, Coffin");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_DOOR, "Hotkey: Building, Door");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FLOODGATE, "Hotkey: Building, Floodgate");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_HATCH, "Hotkey: Building, Hatch");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_GRATE_WALL, "Hotkey: Building, Wall Grate");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_GRATE_FLOOR, "Hotkey: Building, Floor Grate");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BARS_VERTICAL, "Hotkey: Building, Vertical Bars");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BARS_FLOOR, "Hotkey: Building, Floor Bars");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CABINET, "Hotkey: Building, Cabinet");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BOX, "Hotkey: Building, Chest");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_KENNEL, "Hotkey: Building, Kennel");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FARMPLOT, "Hotkey: Building, Farm Plot");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WEAPONRACK, "Hotkey: Building, Weaponrack");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_STATUE, "Hotkey: Building, Statue");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TABLE, "Hotkey: Building, Table");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ROAD_DIRT, "Hotkey: Building, Dirt Road");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ROAD_PAVED, "Hotkey: Building, Paved Road");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_BRIDGE, "Hotkey: Building, Bridge");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WELL, "Hotkey: Building, Well");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE, "Hotkey: Building, Siege");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP, "Hotkey: Building, Workshop");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE, "Hotkey: Building, Furnace");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GLASS, "Hotkey: Building, Glass Window");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GEM, "Hotkey: Building, Gem Window");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SHOP, "Hotkey: Building, Shop");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ANIMALTRAP, "Hotkey: Building, Animal Trap");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CHAIN, "Hotkey: Building, Chain");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CAGE, "Hotkey: Building, Cage");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRADEDEPOT, "Hotkey: Building, Trade Depot");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP, "Hotkey: Building, Trap");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE, "Hotkey: Building, Machine Component");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SUPPORT, "Hotkey: Building, Support");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_ARCHERYTARGET, "Hotkey: Building, Archery Target");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_SCREW_PUMP, "Hotkey: Building, Machine Component, Screw Pump");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WATER_WHEEL, "Hotkey: Building, Machine Component, Water Wheel");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WINDMILL, "Hotkey: Building, Machine Component, Windmill");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_GEAR_ASSEMBLY, "Hotkey: Building, Machine Component, Gear Assembly");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_HORIZONTAL, "Hotkey: Building, Machine Component, Horizontal Axle");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_VERTICAL, "Hotkey: Building, Machine Component, Vertical Axle");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_MACHINE_ROLLERS, "Hotkey: Building, Machine Component, Rollers");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_BALLISTA, "Hotkey: Building, Siege, Ballista");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_CATAPULT, "Hotkey: Building, Siege, Catapult");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_STONE, "Hotkey: Building, Trap, Stone");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_WEAPON, "Hotkey: Building, Trap, Weapon");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_LEVER, "Hotkey: Building, Trap, Lever");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_TRIGGER, "Hotkey: Building, Trap, Trigger");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_CAGE, "Hotkey: Building, Trap, Cage");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_TRAP_SPIKE, "Hotkey: Building, Trap, Upright Spear/Spike");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION, "Hotkey: Building, Wall/Floor/Stairs");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FORTIFICATION, "Hotkey: Building, Construction, Fortification");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_WALL, "Hotkey: Building, Construction, Wall");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FLOOR, "Hotkey: Building, Construction, Floor");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_RAMP, "Hotkey: Building, Construction, Ramp");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UP, "Hotkey: Building, Construction, Upward Stair");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_DOWN, "Hotkey: Building, Construction, Downward Stair");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UPDOWN, "Hotkey: Building, Construction, Up/Down Stair");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_TRACK, "Hotkey: Building, Construction, Track");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_TRACK_STOP, "Hotkey: Building, Construction, Track Stop");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LEATHER, "Hotkey: Building, Wksp, Leather");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_QUERN, "Hotkey: Building, Wksp, Quern");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MILLSTONE, "Hotkey: Building, Wksp, Millstone");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LOOM, "Hotkey: Building, Wksp, Loom");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CLOTHES, "Hotkey: Building, Wksp, Clothes");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BOWYER, "Hotkey: Building, Wksp, Bowyer");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CARPENTER, "Hotkey: Building, Wksp, Carpenter");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_METALSMITH, "Hotkey: Building, Wksp, Metalsmith");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LAVAMILL, "Hotkey: Building, Wksp, Lavamill");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_JEWELER, "Hotkey: Building, Wksp, Jeweler");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MASON, "Hotkey: Building, Wksp, Mason");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BUTCHER, "Hotkey: Building, Wksp, Butcher");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_TANNER, "Hotkey: Building, Wksp, Tanner");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_DYER, "Hotkey: Building, Wksp, Dyer");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CRAFTSMAN, "Hotkey: Building, Wksp, Craftsman");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_SIEGE, "Hotkey: Building, Wksp, Siege");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MECHANIC, "Hotkey: Building, Wksp, Mechanic");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_STILL, "Hotkey: Building, Wksp, Still");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FARMER, "Hotkey: Building, Wksp, Farmer");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_KITCHEN, "Hotkey: Building, Wksp, Kitchen");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FISHERY, "Hotkey: Building, Wksp, Fishery");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_ASHERY, "Hotkey: Building, Wksp, Ashery");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_WOOD, "Hotkey: Building, Furn, Wood");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER, "Hotkey: Building, Furn, Smelter");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS, "Hotkey: Building, Furn, Glass");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN, "Hotkey: Building, Furn, Kiln");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER_LAVA, "Hotkey: Building, Furn, Smelter");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS_LAVA, "Hotkey: Building, Furn, Glass");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN_LAVA, "Hotkey: Building, Furn, Kiln");
	displayNames.insert(INTERFACEKEY_HIVE_INSTALL_COLONY, "Hotkey: Building, Hive, Install Colony");
	displayNames.insert(INTERFACEKEY_HIVE_GATHER_PRODUCTS, "Hotkey: Building, Hive, Gather Products");
	displayNames.insert(INTERFACEKEY_D_ONESTEP, "Main: One-Step");
	displayNames.insert(INTERFACEKEY_D_PAUSE, "Main: Pause/Resume");
	displayNames.insert(INTERFACEKEY_D_DEPOT, "Depot Access");
	displayNames.insert(INTERFACEKEY_D_HOT_KEYS, "Main: Hot Keys");
	displayNames.insert(INTERFACEKEY_D_HOTKEY1, "Main: Hot Key 1");
	displayNames.insert(INTERFACEKEY_D_HOTKEY2, "Main: Hot Key 2");
	displayNames.insert(INTERFACEKEY_D_HOTKEY3, "Main: Hot Key 3");
	displayNames.insert(INTERFACEKEY_D_HOTKEY4, "Main: Hot Key 4");
	displayNames.insert(INTERFACEKEY_D_HOTKEY5, "Main: Hot Key 5");
	displayNames.insert(INTERFACEKEY_D_HOTKEY6, "Main: Hot Key 6");
	displayNames.insert(INTERFACEKEY_D_HOTKEY7, "Main: Hot Key 7");
	displayNames.insert(INTERFACEKEY_D_HOTKEY8, "Main: Hot Key 8");
	displayNames.insert(INTERFACEKEY_D_HOTKEY9, "Main: Hot Key 9");
	displayNames.insert(INTERFACEKEY_D_HOTKEY10, "Main: Hot Key 10");
	displayNames.insert(INTERFACEKEY_D_HOTKEY11, "Main: Hot Key 11");
	displayNames.insert(INTERFACEKEY_D_HOTKEY12, "Main: Hot Key 12");
	displayNames.insert(INTERFACEKEY_D_HOTKEY13, "Main: Hot Key 13");
	displayNames.insert(INTERFACEKEY_D_HOTKEY14, "Main: Hot Key 14");
	displayNames.insert(INTERFACEKEY_D_HOTKEY15, "Main: Hot Key 15");
	displayNames.insert(INTERFACEKEY_D_HOTKEY16, "Main: Hot Key 16");
	displayNames.insert(INTERFACEKEY_D_HOTKEY_CHANGE_NAME, "Hot Keys: Change Name");
	displayNames.insert(INTERFACEKEY_D_HOTKEY_ZOOM, "Hot Keys: Zoom");
	displayNames.insert(INTERFACEKEY_D_ANNOUNCE, "Main: Announcements");
	displayNames.insert(INTERFACEKEY_D_REPORTS, "Main: Reports");
	displayNames.insert(INTERFACEKEY_D_BUILDING, "Main: Place Building");
	displayNames.insert(INTERFACEKEY_D_CIVLIST, "Main: Civilizations");
	displayNames.insert(INTERFACEKEY_D_DESIGNATE, "Main: Designations");
	displayNames.insert(INTERFACEKEY_D_ARTLIST, "Main: Artifacts");
	displayNames.insert(INTERFACEKEY_D_NOBLES, "Main: Nobles");
	displayNames.insert(INTERFACEKEY_D_ORDERS, "Main: Standing Orders");
	displayNames.insert(INTERFACEKEY_D_MILITARY, "Main: Military");
	displayNames.insert(INTERFACEKEY_D_MILITARY_CREATE_SQUAD, "Main: Military, Create Squad");
	displayNames.insert(INTERFACEKEY_D_MILITARY_DISBAND_SQUAD, "Main: Military, Disband Squad");
	displayNames.insert(INTERFACEKEY_D_MILITARY_CREATE_SUB_SQUAD, "Main: Military, Create Sub-Squad");
	displayNames.insert(INTERFACEKEY_D_MILITARY_CANCEL_ORDERS, "Main: Military, Cancel Orders");
	displayNames.insert(INTERFACEKEY_D_MILITARY_POSITIONS, "Main: Military, Positions");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ALERTS, "Main: Military, Alerts");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ALERTS_ADD, "Main: Military, Alerts, Add");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ALERTS_DELETE, "Main: Military, Alerts, Delete");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ALERTS_SET, "Main: Military, Alerts, Set");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ALERTS_NAME, "Main: Military, Alerts, Name");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ALERTS_SET_RETAIN, "Main: Military, Alerts, Set/Retain");
	displayNames.insert(INTERFACEKEY_D_MILITARY_EQUIP, "Main: Military, Equip");
	displayNames.insert(INTERFACEKEY_D_MILITARY_EQUIP_CUSTOMIZE, "Main: Military, Equip, Customize");
	displayNames.insert(INTERFACEKEY_D_MILITARY_EQUIP_UNIFORM, "Main: Military, Equip, Uniform");
	displayNames.insert(INTERFACEKEY_D_MILITARY_EQUIP_PRIORITY, "Main: Military, Equip, Priority");
	displayNames.insert(INTERFACEKEY_D_MILITARY_UNIFORMS, "Main: Military, Uniforms");
	displayNames.insert(INTERFACEKEY_D_MILITARY_SUPPLIES, "Main: Military, Supplies");
	displayNames.insert(INTERFACEKEY_D_MILITARY_SUPPLIES_WATER_DOWN, "Main: Military, Supplies, Water Down");
	displayNames.insert(INTERFACEKEY_D_MILITARY_SUPPLIES_WATER_UP, "Main: Military, Supplies, Water Up");
	displayNames.insert(INTERFACEKEY_D_MILITARY_SUPPLIES_FOOD_DOWN, "Main: Military, Supplies, Food Down");
	displayNames.insert(INTERFACEKEY_D_MILITARY_SUPPLIES_FOOD_UP, "Main: Military, Supplies, Food Up");
	displayNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION, "Main: Military, Ammunition");
	displayNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_ADD_ITEM, "Main: Military, Ammunition, Add Item");
	displayNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_REMOVE_ITEM, "Main: Military, Ammunition, Remove Item");
	displayNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_LOWER_AMOUNT, "Main: Military, Ammunition, Lower Amount");
	displayNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_RAISE_AMOUNT, "Main: Military, Ammunition, Raise Amount");
	displayNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_LOWER_AMOUNT_LOTS, "Main: Military, Ammunition, Lower Amount Lots");
	displayNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_RAISE_AMOUNT_LOTS, "Main: Military, Ammunition, Raise Amount Lots");
	displayNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_MATERIAL, "Main: Military, Ammunition, Material");
	displayNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_COMBAT, "Main: Military, Ammunition, Combat");
	displayNames.insert(INTERFACEKEY_D_MILITARY_AMMUNITION_TRAINING, "Main: Military, Ammunition, Training");
	displayNames.insert(INTERFACEKEY_D_MILITARY_TRAINING, "Main: Military, Training");
	displayNames.insert(INTERFACEKEY_D_MILITARY_SCHEDULE, "Main: Military, Schedule");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ADD_UNIFORM, "Main: Military, Add Uniform");
	displayNames.insert(INTERFACEKEY_D_MILITARY_DELETE_UNIFORM, "Main: Military, Delete Uniform");
	displayNames.insert(INTERFACEKEY_D_MILITARY_NAME_UNIFORM, "Main: Military, Name Uniform");
	displayNames.insert(INTERFACEKEY_D_MILITARY_NAME_SQUAD, "Main: Military, Name Squad");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ADD_ARMOR, "Main: Military, Add Armor");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ADD_PANTS, "Main: Military, Add Pants");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ADD_HELM, "Main: Military, Add Helm");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ADD_GLOVES, "Main: Military, Add Gloves");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ADD_BOOTS, "Main: Military, Add Boots");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ADD_SHIELD, "Main: Military, Add Shield");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ADD_WEAPON, "Main: Military, Add Weapon");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ADD_MATERIAL, "Main: Military, Add Material");
	displayNames.insert(INTERFACEKEY_D_MILITARY_ADD_COLOR, "Main: Military, Add Color");
	displayNames.insert(INTERFACEKEY_D_MILITARY_REPLACE_CLOTHING, "Main: Military, Replace Clothing");
	displayNames.insert(INTERFACEKEY_D_MILITARY_EXACT_MATCH, "Main: Military, Exact Match");
	displayNames.insert(INTERFACEKEY_D_ROOMS, "Main: Rooms");
	displayNames.insert(INTERFACEKEY_BUILDINGLIST_ZOOM_T, "Building List: Zoom T");
	displayNames.insert(INTERFACEKEY_BUILDINGLIST_ZOOM_Q, "Building List: Zoom Q");
	displayNames.insert(INTERFACEKEY_D_SQUADS, "Main: Control Squads");
	displayNames.insert(INTERFACEKEY_D_SQUADS_MOVE, "Main: Control Squads, Move");
	displayNames.insert(INTERFACEKEY_D_SQUADS_KILL, "Main: Control Squads, Kill");
	displayNames.insert(INTERFACEKEY_D_SQUADS_KILL_LIST, "Main: Control Squads, Kill List");
	displayNames.insert(INTERFACEKEY_D_SQUADS_KILL_RECT, "Main: Control Squads, Kill Rect");
	displayNames.insert(INTERFACEKEY_D_SQUADS_SCHEDULE, "Main: Control Squads, Schedule");
	displayNames.insert(INTERFACEKEY_D_SQUADS_CANCEL_ORDER, "Main: Control Squads, Cancel Order");
	displayNames.insert(INTERFACEKEY_D_SQUADS_ALERT, "Main: Control Squads, Alert");
	displayNames.insert(INTERFACEKEY_D_SQUADS_SELECT_INDIVIDUALS, "Main: Control Squads, Select Individuals");
	displayNames.insert(INTERFACEKEY_D_SQUADS_CENTER, "Main: Control Squads, Center");
	displayNames.insert(INTERFACEKEY_D_SQUAD_SCH_SLEEP, "Squad Schedule: Sleep");
	displayNames.insert(INTERFACEKEY_D_SQUAD_SCH_CIVILIAN_UNIFORM, "Squad Schedule: Civilian Uniform");
	displayNames.insert(INTERFACEKEY_D_SQUAD_SCH_GIVE_ORDER, "Squad Schedule: Give Order");
	displayNames.insert(INTERFACEKEY_D_SQUAD_SCH_EDIT_ORDER, "Squad Schedule: Edit Order");
	displayNames.insert(INTERFACEKEY_D_SQUAD_SCH_CANCEL_ORDER, "Squad Schedule: Cancel Order");
	displayNames.insert(INTERFACEKEY_D_SQUAD_SCH_COPY_ORDERS, "Squad Schedule: Copy Orders");
	displayNames.insert(INTERFACEKEY_D_SQUAD_SCH_PASTE_ORDERS, "Squad Schedule: Paste Orders");
	displayNames.insert(INTERFACEKEY_D_SQUAD_SCH_MS_NAME, "Squad Schedule: Name Grid Cell");
	displayNames.insert(INTERFACEKEY_D_STOCKPILES, "Main: Stockpiles");
	displayNames.insert(INTERFACEKEY_D_CIVZONE, "Main: Activity Zone");
	displayNames.insert(INTERFACEKEY_D_VIEWUNIT, "Main: View Units");
	displayNames.insert(INTERFACEKEY_D_JOBLIST, "Main: Job List");
	displayNames.insert(INTERFACEKEY_D_UNITLIST, "Main: Unit List");
	displayNames.insert(INTERFACEKEY_D_LOOK, "Main: Look");
	displayNames.insert(INTERFACEKEY_D_HAULING, "Main: Hauling");
	displayNames.insert(INTERFACEKEY_D_HAULING_NEW_ROUTE, "Main: Hauling, New Route");
	displayNames.insert(INTERFACEKEY_D_HAULING_NEW_STOP, "Main: Hauling, New Stop");
	displayNames.insert(INTERFACEKEY_D_HAULING_REMOVE, "Main: Hauling, Remove");
	displayNames.insert(INTERFACEKEY_D_HAULING_PROMOTE, "Main: Hauling, Promote");
	displayNames.insert(INTERFACEKEY_D_HAULING_VEHICLE, "Main: Hauling, Vehicle");
	displayNames.insert(INTERFACEKEY_D_HAULING_NICKNAME, "Main: Hauling, Name");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_NEW_DEPART, "Main: Hauling, Stop, New Leave Condition");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_NEW_LINK, "Main: Hauling, Stop, New Stockpile Link");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_REMOVE, "Main: Hauling, Stop, Remove");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_SL_SELECT_PILE, "Main: Hauling, Stop, Stockpile, Select");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_SL_TAKE_GIVE, "Main: Hauling, Stop, Stockpile, Take/Give");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_DIR, "Main: Hauling, Stop, Leave Condition, Dir");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_MODE, "Main: Hauling, Stop, Leave Condition, Mode");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_TIMER_UP, "Main: Hauling, Stop, Leave Condition, Timer Up");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_TIMER_DOWN, "Main: Hauling, Stop, Leave Condition, Timer Down");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_FULLNESS_UP, "Main: Hauling, Stop, Leave Condition, Fullness Up");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_FULLNESS_DOWN, "Main: Hauling, Stop, Leave Condition, Fullness Down");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_MORE_LESS, "Main: Hauling, Stop, Leave Condition, More/Less");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_DESIRED_TOTAL, "Main: Hauling, Stop, Leave Condition, Desired/Total");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_CHANGE, "Main: Hauling, Stop, Leave Condition, Change");
	displayNames.insert(INTERFACEKEY_D_HAULING_STOP_LC_ADVANCED, "Main: Hauling, Stop, Leave Condition, Advanced");
	displayNames.insert(INTERFACEKEY_D_BURROWS, "Main: Burrows");
	displayNames.insert(INTERFACEKEY_D_BURROWS_ADD, "Main: Burrows, Add");
	displayNames.insert(INTERFACEKEY_D_BURROWS_DELETE, "Main: Burrows, Delete");
	displayNames.insert(INTERFACEKEY_D_BURROWS_DEFINE, "Main: Burrows, Define");
	displayNames.insert(INTERFACEKEY_D_BURROWS_ADD_UNIT, "Main: Burrows, Add Citizen");
	displayNames.insert(INTERFACEKEY_D_BURROWS_CENTER, "Main: Burrows, Center");
	displayNames.insert(INTERFACEKEY_D_BURROWS_NAME, "Main: Burrows, Name");
	displayNames.insert(INTERFACEKEY_D_BURROWS_CHANGE_SELECTION, "Main: Burrows, Change Selector");
	displayNames.insert(INTERFACEKEY_D_BURROWS_BRUSH, "Main: Burrows, Brush");
	displayNames.insert(INTERFACEKEY_D_BURROWS_REMOVE, "Main: Burrows, Paint/Erase");
	displayNames.insert(INTERFACEKEY_D_NOTE, "Main: Note");
	displayNames.insert(INTERFACEKEY_D_NOTE_PLACE, "Main: Note, Place");
	displayNames.insert(INTERFACEKEY_D_NOTE_DELETE, "Main: Note, Delete");
	displayNames.insert(INTERFACEKEY_D_NOTE_NAME, "Main: Note, Enter Name");
	displayNames.insert(INTERFACEKEY_D_NOTE_ENTER, "Main: Note, Enter Text");
	displayNames.insert(INTERFACEKEY_D_NOTE_ADOPT_SYMBOL, "Main: Note, Adopt Symbol");
	displayNames.insert(INTERFACEKEY_D_NOTE_CHANGE_SELECTION, "Main: Note, Change Selection");
	displayNames.insert(INTERFACEKEY_D_NOTE_POINTS, "Main: Note, Route, Done");
	displayNames.insert(INTERFACEKEY_D_NOTE_ROUTE, "Main: Note, Routes");
	displayNames.insert(INTERFACEKEY_D_NOTE_ROUTE_ADD, "Main: Note, Route, Add");
	displayNames.insert(INTERFACEKEY_D_NOTE_ROUTE_EDIT, "Main: Note, Route, Edit");
	displayNames.insert(INTERFACEKEY_D_NOTE_ROUTE_DELETE, "Main: Note, Route, Delete");
	displayNames.insert(INTERFACEKEY_D_NOTE_ROUTE_CENTER, "Main: Note, Route, Center");
	displayNames.insert(INTERFACEKEY_D_NOTE_ROUTE_NAME, "Main: Note, Route, Name");
	displayNames.insert(INTERFACEKEY_D_BUILDJOB, "Main: Building Jobs");
	displayNames.insert(INTERFACEKEY_D_STATUS, "Main: Overall Status");
	displayNames.insert(INTERFACEKEY_D_STATUS_OVERALL_HEALTH_RECENTER, "Main: Status, Overall Health, Recenter");
	displayNames.insert(INTERFACEKEY_D_BUILDITEM, "Main: Building Items");
	displayNames.insert(INTERFACEKEY_D_BITEM_FORBID, "Building Items: Forbid");
	displayNames.insert(INTERFACEKEY_D_BITEM_DUMP, "Building Items: Dump");
	displayNames.insert(INTERFACEKEY_D_BITEM_MELT, "Building Items: Melt");
	displayNames.insert(INTERFACEKEY_D_BITEM_HIDE, "Building Items: Hide");
	displayNames.insert(INTERFACEKEY_D_LOOK_FORBID, "Dwf Look: Forbid");
	displayNames.insert(INTERFACEKEY_D_LOOK_DUMP, "Dwf Look: Dump");
	displayNames.insert(INTERFACEKEY_D_LOOK_MELT, "Dwf Look: Melt");
	displayNames.insert(INTERFACEKEY_D_LOOK_HIDE, "Dwf Look: Hide");
	displayNames.insert(INTERFACEKEY_D_LOOK_FOLLOW, "Dwf Look: Follow");
	displayNames.insert(INTERFACEKEY_D_LOOK_ARENA_CREATURE, "Dwf Look: Arena Creature");
	displayNames.insert(INTERFACEKEY_D_LOOK_ARENA_ADV_MODE, "Dwf Look: Arena Adv Mode");
	displayNames.insert(INTERFACEKEY_D_LOOK_ARENA_WATER, "Dwf Look: Arena Water");
	displayNames.insert(INTERFACEKEY_D_LOOK_ARENA_MAGMA, "Dwf Look: Arena Magma");
	displayNames.insert(INTERFACEKEY_ARENA_CREATURE_SIDE_DOWN, "Arena Creature: Side Down");
	displayNames.insert(INTERFACEKEY_ARENA_CREATURE_SIDE_UP, "Arena Creature: Side Up");
	displayNames.insert(INTERFACEKEY_ARENA_CREATURE_NEW_ITEM, "Arena Creature: New Item");
	displayNames.insert(INTERFACEKEY_ARENA_CREATURE_BLANK_LIST, "Arena Creature: Blank List");
	displayNames.insert(INTERFACEKEY_ARENA_CREATURE_REMOVE_ITEM, "Arena Creature: Remove Item");
	displayNames.insert(INTERFACEKEY_ARENA_CREATURE_UNDEAD, "Arena Creature: Undead");
	displayNames.insert(INTERFACEKEY_ARENA_CREATURE_STRING, "Arena Creature: String");
	displayNames.insert(INTERFACEKEY_A_ENTER_NAME, "Adventure: Creation, Name Entry");
	displayNames.insert(INTERFACEKEY_A_CUST_NAME, "Adventure: Creation, Customize Name");
	displayNames.insert(INTERFACEKEY_A_RANDOM_NAME, "Adventure: Creation, Random Name");
	displayNames.insert(INTERFACEKEY_A_CHANGE_GENDER, "Adventure: Creation, Change Gender");
	displayNames.insert(INTERFACEKEY_A_END_TRAVEL, "Adventure: Travel, Visit Site");
	displayNames.insert(INTERFACEKEY_A_TRAVEL_CLOUDS, "Adventure: Travel, Clouds");
	displayNames.insert(INTERFACEKEY_A_LOG, "Adventure: Log");
	displayNames.insert(INTERFACEKEY_A_TRAVEL_LOG, "Adventure: Travel, Log");
	displayNames.insert(INTERFACEKEY_A_LOG_TASKS, "Adventure: Log, Tasks");
	displayNames.insert(INTERFACEKEY_A_LOG_ENTITIES, "Adventure: Log, Entities");
	displayNames.insert(INTERFACEKEY_A_LOG_SITES, "Adventure: Log, Sites");
	displayNames.insert(INTERFACEKEY_A_LOG_SUBREGIONS, "Adventure: Log, Regions");
	displayNames.insert(INTERFACEKEY_A_LOG_FEATURE_LAYERS, "Adventure: Log, Feature Layers");
	displayNames.insert(INTERFACEKEY_A_LOG_ZOOM_CURRENT_LOCATION, "Adventure: Log, Zoom to Current Location");
	displayNames.insert(INTERFACEKEY_A_LOG_ZOOM_SELECTED, "Adventure: Log, Zoom to Selected");
	displayNames.insert(INTERFACEKEY_A_LOG_LINE, "Adventure: Log, Toggle Line");
	displayNames.insert(INTERFACEKEY_A_LOG_MAP, "Adventure: Log, Toggle Map/Info");
	displayNames.insert(INTERFACEKEY_ORDERS_AUTOFORBID, "Orders: Forbid");
	displayNames.insert(INTERFACEKEY_ORDERS_FORBID_PROJECTILE, "Orders: Forbid Projectiles");
	displayNames.insert(INTERFACEKEY_ORDERS_FORBID_YOUR_CORPSE, "Orders: Forbid Your Corpse");
	displayNames.insert(INTERFACEKEY_ORDERS_FORBID_YOUR_ITEMS, "Orders: Forbid Your Items");
	displayNames.insert(INTERFACEKEY_ORDERS_FORBID_OTHER_CORPSE, "Orders: Forbid Other Corpse");
	displayNames.insert(INTERFACEKEY_ORDERS_FORBID_OTHER_ITEMS, "Orders: Forbid Other Items");
	displayNames.insert(INTERFACEKEY_ORDERS_REFUSE_GATHER, "Orders: Gather Refuse");
	displayNames.insert(INTERFACEKEY_ORDERS_REFUSE_OUTSIDE, "Orders: Gather Outside");
	displayNames.insert(INTERFACEKEY_ORDERS_REFUSE_OUTSIDE_VERMIN, "Orders: Gather Outside Vermin");
	displayNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_CORPSE, "Orders: Dump Corpse");
	displayNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_SKULL, "Orders: Dump Skull");
	displayNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_SKIN, "Orders: Dump Skin");
	displayNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_BONE, "Orders: Dump Bone");
	displayNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_SHELL, "Orders: Dump Shell");
	displayNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_OTHER, "Orders: Dump Other");
	displayNames.insert(INTERFACEKEY_ORDERS_REFUSE_DUMP_STRAND_TISSUE, "Orders: Dump Strand Tissue");
	displayNames.insert(INTERFACEKEY_ORDERS_GATHER_FURNITURE, "Orders: Gather Furniture");
	displayNames.insert(INTERFACEKEY_ORDERS_GATHER_ANIMALS, "Orders: Gather Animals");
	displayNames.insert(INTERFACEKEY_ORDERS_GATHER_FOOD, "Orders: Gather Food");
	displayNames.insert(INTERFACEKEY_ORDERS_GATHER_BODIES, "Orders: Gather Bodies");
	displayNames.insert(INTERFACEKEY_ORDERS_REFUSE, "Orders: Refuse");
	displayNames.insert(INTERFACEKEY_ORDERS_GATHER_STONE, "Orders: Gather Stone");
	displayNames.insert(INTERFACEKEY_ORDERS_GATHER_WOOD, "Orders: Gather Wood");
	displayNames.insert(INTERFACEKEY_ORDERS_ALL_HARVEST, "Orders: All Harvest");
	displayNames.insert(INTERFACEKEY_ORDERS_SAMEPILE, "Orders: Piles Same");
	displayNames.insert(INTERFACEKEY_ORDERS_MIXFOODS, "Orders: Mix Foods");
	displayNames.insert(INTERFACEKEY_ORDERS_EXCEPTIONS, "Orders: Exceptions");
	displayNames.insert(INTERFACEKEY_ORDERS_LOOM, "Orders: Loom");
	displayNames.insert(INTERFACEKEY_ORDERS_DYED_CLOTH, "Orders: Dyed Cloth");
	displayNames.insert(INTERFACEKEY_ORDERS_WORKSHOP, "Orders: Workshop");
	displayNames.insert(INTERFACEKEY_ORDERS_COLLECT_WEB, "Orders: Auto-Collect Web");
	displayNames.insert(INTERFACEKEY_ORDERS_SLAUGHTER, "Orders: Auto-Slaughter");
	displayNames.insert(INTERFACEKEY_ORDERS_BUTCHER, "Orders: Auto-Butcher");
	displayNames.insert(INTERFACEKEY_ORDERS_TAN, "Orders: Auto-Tan");
	displayNames.insert(INTERFACEKEY_ORDERS_AUTO_FISHERY, "Orders: Auto-Fishery");
	displayNames.insert(INTERFACEKEY_ORDERS_AUTO_KITCHEN, "Orders: Auto-Kitchen");
	displayNames.insert(INTERFACEKEY_ORDERS_AUTO_KILN, "Orders: Auto-Kiln");
	displayNames.insert(INTERFACEKEY_ORDERS_AUTO_SMELTER, "Orders: Auto-Smelter");
	displayNames.insert(INTERFACEKEY_ORDERS_AUTO_OTHER, "Orders: Auto-Other");
	displayNames.insert(INTERFACEKEY_ORDERS_ZONE, "Orders: Zone");
	displayNames.insert(INTERFACEKEY_ORDERS_ZONE_DRINKING, "Orders: Zone, Drinking");
	displayNames.insert(INTERFACEKEY_ORDERS_ZONE_FISHING, "Orders: Zone, Fishing");
	displayNames.insert(INTERFACEKEY_DESTROYBUILDING, "Destroy Building");
	displayNames.insert(INTERFACEKEY_SUSPENDBUILDING, "Suspend Building");
	displayNames.insert(INTERFACEKEY_MENU_CONFIRM, "Menu Confirm");
	displayNames.insert(INTERFACEKEY_SAVE_BINDINGS, "Save Bindings");
	displayNames.insert(INTERFACEKEY_LOAD_BINDINGS, "Load Bindings");
	displayNames.insert(INTERFACEKEY_KEYBINDING_COMPLETE, "Complete Binding");
	displayNames.insert(INTERFACEKEY_ZOOM_IN, "Zoom In");
	displayNames.insert(INTERFACEKEY_ZOOM_OUT, "Zoom Out");
	displayNames.insert(INTERFACEKEY_ZOOM_TOGGLE, "Toggle Zoom");
	displayNames.insert(INTERFACEKEY_ZOOM_RESET, "Reset Zoom");
	displayNames.insert(INTERFACEKEY_MACRO_BREAK, "Macro, Break");
	displayNames.insert(INTERFACEKEY_RECORD_MACRO, "Macro, Record");
	displayNames.insert(INTERFACEKEY_PLAY_MACRO, "Macro, Play");
	displayNames.insert(INTERFACEKEY_SAVE_MACRO, "Macro, Save");
	displayNames.insert(INTERFACEKEY_LOAD_MACRO, "Macro, Load");
	displayNames.insert(INTERFACEKEY_HOTKEY_ALCHEMIST_SOAP, "Hotkey: Alchemist, Soap");
	displayNames.insert(INTERFACEKEY_HOTKEY_STILL_BREW, "Hotkey: Still, Brew");
	displayNames.insert(INTERFACEKEY_HOTKEY_STILL_EXTRACT, "Hotkey: Still, Extract");
	displayNames.insert(INTERFACEKEY_HOTKEY_LOOM_COLLECT_SILK, "Hotkey: Loom, Collect Silk");
	displayNames.insert(INTERFACEKEY_HOTKEY_LOOM_WEAVE_CLOTH, "Hotkey: Loom, Weave Cloth");
	displayNames.insert(INTERFACEKEY_HOTKEY_LOOM_WEAVE_SILK, "Hotkey: Loom, Weave Silk");
	displayNames.insert(INTERFACEKEY_HOTKEY_LOOM_WEAVE_YARN, "Hotkey: Loom, Weave Yarn");
	displayNames.insert(INTERFACEKEY_HOTKEY_LOOM_WEAVE_METAL, "Hotkey: Loom, Metal");
	displayNames.insert(INTERFACEKEY_HOTKEY_KITCHEN_COOK_2, "Hotkey: Kitchen, Meal 1");
	displayNames.insert(INTERFACEKEY_HOTKEY_KITCHEN_COOK_3, "Hotkey: Kitchen, Meal 2");
	displayNames.insert(INTERFACEKEY_HOTKEY_KITCHEN_COOK_4, "Hotkey: Kitchen, Meal 3");
	displayNames.insert(INTERFACEKEY_HOTKEY_KITCHEN_RENDER_FAT, "Hotkey: Kitchen, Render Fat");
	displayNames.insert(INTERFACEKEY_HOTKEY_FARMER_PROCESS, "Hotkey: Farmer, Process");
	displayNames.insert(INTERFACEKEY_HOTKEY_FARMER_PROCESS_VIAL, "Hotkey: Farmer, Vial");
	displayNames.insert(INTERFACEKEY_HOTKEY_FARMER_PROCESS_BAG, "Hotkey: Farmer, Bag");
	displayNames.insert(INTERFACEKEY_HOTKEY_FARMER_PROCESS_BARREL, "Hotkey: Farmer, Barrel");
	displayNames.insert(INTERFACEKEY_HOTKEY_FARMER_CHEESE, "Hotkey: Farmer, Cheese");
	displayNames.insert(INTERFACEKEY_HOTKEY_FARMER_MILK, "Hotkey: Farmer, Milk");
	displayNames.insert(INTERFACEKEY_HOTKEY_FARMER_SHEAR_CREATURE, "Hotkey: Farmer, Shear");
	displayNames.insert(INTERFACEKEY_HOTKEY_FARMER_SPIN_THREAD, "Hotkey: Farmer, Spin");
	displayNames.insert(INTERFACEKEY_HOTKEY_MILL_MILL, "Hotkey: Mill, Mill");
	displayNames.insert(INTERFACEKEY_HOTKEY_KENNEL_CATCH_VERMIN, "Hotkey: Kennel, Catch");
	displayNames.insert(INTERFACEKEY_HOTKEY_KENNEL_TAME_VERMIN, "Hotkey: Kennel, Tame Small");
	displayNames.insert(INTERFACEKEY_HOTKEY_FISHERY_PROCESS, "Hotkey: Fishery, Process");
	displayNames.insert(INTERFACEKEY_HOTKEY_FISHERY_EXTRACT, "Hotkey: Fishery, Extract");
	displayNames.insert(INTERFACEKEY_HOTKEY_FISHERY_CATCH, "Hotkey: Fishery, Catch");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUTCHER_BUTCHER, "Hotkey: Butcher, Butcher");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUTCHER_EXTRACT, "Hotkey: Butcher, Extract");
	displayNames.insert(INTERFACEKEY_HOTKEY_BUTCHER_CATCH, "Hotkey: Butcher, Catch");
	displayNames.insert(INTERFACEKEY_HOTKEY_TANNER_TAN, "Hotkey: Tanner, Tan");
	displayNames.insert(INTERFACEKEY_HOTKEY_DYER_THREAD, "Hotkey: Dyer, Thread");
	displayNames.insert(INTERFACEKEY_HOTKEY_DYER_CLOTH, "Hotkey: Dyer, Cloth");
	displayNames.insert(INTERFACEKEY_HOTKEY_JEWELER_FURNITURE, "Hotkey: Jeweler, Furniture");
	displayNames.insert(INTERFACEKEY_HOTKEY_JEWELER_FINISHED, "Hotkey: Jeweler, Finished");
	displayNames.insert(INTERFACEKEY_HOTKEY_JEWELER_AMMO, "Hotkey: Jeweler, Ammo");
	displayNames.insert(INTERFACEKEY_HOTKEY_JEWELER_CUT, "Hotkey: Jeweler, Cut");
	displayNames.insert(INTERFACEKEY_HOTKEY_JEWELER_ENCRUST, "Hotkey: Jeweler, Encrust");
	displayNames.insert(INTERFACEKEY_HOTKEY_MECHANIC_PARTS, "Hotkey: Mechanic, Mechanisms");
	displayNames.insert(INTERFACEKEY_HOTKEY_MECHANIC_TRACTION_BENCH, "Hotkey: Mechanic, Traction Bench");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_ARMORSTAND, "Hotkey: Mason, Armorstand");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_BLOCKS, "Hotkey: Mason, Blocks");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_CHAIR, "Hotkey: Mason, Chair");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_COFFIN, "Hotkey: Mason, Coffin");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_DOOR, "Hotkey: Mason, Door");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_FLOODGATE, "Hotkey: Mason, Floodgate");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_HATCH_COVER, "Hotkey: Mason, Hatch Cover");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_GRATE, "Hotkey: Mason, Grate");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_CABINET, "Hotkey: Mason, Cabinet");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_BOX, "Hotkey: Mason, Box");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_STATUE, "Hotkey: Mason, Statue");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_QUERN, "Hotkey: Mason, Quern");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_MILLSTONE, "Hotkey: Mason, Millstone");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_TABLE, "Hotkey: Mason, Table");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_WEAPONRACK, "Hotkey: Mason, Weaponrack");
	displayNames.insert(INTERFACEKEY_HOTKEY_MASON_SLAB, "Hotkey: Mason, Slab");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_BRIDGE, "Hotkey: Trap, Bridge");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_GEAR_ASSEMBLY, "Hotkey: Trap, Gear Assembly");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_DOOR, "Hotkey: Trap, Door");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_FLOODGATE, "Hotkey: Trap, Floodgate");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_SPIKE, "Hotkey: Trap, Spike");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_HATCH, "Hotkey: Trap, Hatch");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_GRATE_WALL, "Hotkey: Trap, Wall Grate");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_GRATE_FLOOR, "Hotkey: Trap, Floor Grate");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_BARS_VERTICAL, "Hotkey: Trap, Vertical Bars");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_BARS_FLOOR, "Hotkey: Trap, Floor Bars");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_SUPPORT, "Hotkey: Trap, Support");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_CHAIN, "Hotkey: Trap, Chain");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_CAGE, "Hotkey: Trap, Cage");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_PULL_LEVER, "Hotkey: Trap, Lever");
	displayNames.insert(INTERFACEKEY_HOTKEY_TRAP_TRACK_STOP, "Hotkey: Trap, Track Stop");
	displayNames.insert(INTERFACEKEY_BUILDJOB_ADD, "Buildjob: Add");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CANCEL, "Buildjob: Cancel");
	displayNames.insert(INTERFACEKEY_BUILDJOB_PROMOTE, "Buildjob: Promote");
	displayNames.insert(INTERFACEKEY_BUILDJOB_REPEAT, "Buildjob: Repeat");
	displayNames.insert(INTERFACEKEY_BUILDJOB_SUSPEND, "Buildjob: Suspend");
	displayNames.insert(INTERFACEKEY_BUILDJOB_WORKSHOP_PROFILE, "Buildjob: Workshop Profile");
	displayNames.insert(INTERFACEKEY_BUILDJOB_WELL_FREE, "Buildjob: Well, Free");
	displayNames.insert(INTERFACEKEY_BUILDJOB_WELL_SIZE, "Buildjob: Well, Size");
	displayNames.insert(INTERFACEKEY_BUILDJOB_TARGET_FREE, "Buildjob: Target, Free");
	displayNames.insert(INTERFACEKEY_BUILDJOB_TARGET_SIZE, "Buildjob: Target, Size");
	displayNames.insert(INTERFACEKEY_BUILDJOB_TARGET_DOWN, "Buildjob: Target, Down");
	displayNames.insert(INTERFACEKEY_BUILDJOB_TARGET_UP, "Buildjob: Target, Up");
	displayNames.insert(INTERFACEKEY_BUILDJOB_TARGET_RIGHT, "Buildjob: Target, Right");
	displayNames.insert(INTERFACEKEY_BUILDJOB_TARGET_LEFT, "Buildjob: Target, Left");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STATUE_ASSIGN, "Buildjob: Statue, Assign");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STATUE_FREE, "Buildjob: Statue, Free");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STATUE_SIZE, "Buildjob: Statue, Size");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CAGE_JUSTICE, "Buildjob: Cage, Justice");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CAGE_FREE, "Buildjob: Cage, Free");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CAGE_SIZE, "Buildjob: Cage, Size");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CAGE_ASSIGN_OCC, "Buildjob: Cage, Assign Occ");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CAGE_WATER, "Buildjob: Cage, Water");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CAGE_ASSIGN, "Buildjob: Cage, Assign Owner");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN_OCC, "Buildjob: Chain, Assign Occ");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_JUSTICE, "Buildjob: Chain, Justice");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN, "Buildjob: Chain, Assign Owner");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_FREE, "Buildjob: Chain, Free");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CHAIN_SIZE, "Buildjob: Chain, Size");
	displayNames.insert(INTERFACEKEY_BUILDJOB_SIEGE_FIRING, "Buildjob: Siege, Fire");
	displayNames.insert(INTERFACEKEY_BUILDJOB_SIEGE_ORIENT, "Buildjob: Siege, Orient");
	displayNames.insert(INTERFACEKEY_BUILDJOB_DOOR_INTERNAL, "Buildjob: Door, Internal");
	displayNames.insert(INTERFACEKEY_BUILDJOB_DOOR_LOCK, "Buildjob: Door, Forbid");
	displayNames.insert(INTERFACEKEY_BUILDJOB_DOOR_AJAR, "Buildjob: Door, Pet-passable");
	displayNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_ASSIGN, "Buildjob: Coffin, Assign");
	displayNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_FREE, "Buildjob: Coffin, Free");
	displayNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_SIZE, "Buildjob: Coffin, Size");
	displayNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_BURIAL, "Buildjob: Coffin, Gen. Burial");
	displayNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_CIV, "Buildjob: Coffing, Allow Citizens");
	displayNames.insert(INTERFACEKEY_BUILDJOB_COFFIN_PET, "Buildjob: Coffing, Allow Pets");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CHAIR_ASSIGN, "Buildjob: Chair, Assign");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CHAIR_FREE, "Buildjob: Chair, Free");
	displayNames.insert(INTERFACEKEY_BUILDJOB_CHAIR_SIZE, "Buildjob: Chair, Size");
	displayNames.insert(INTERFACEKEY_BUILDJOB_TABLE_ASSIGN, "Buildjob: Table, Assign");
	displayNames.insert(INTERFACEKEY_BUILDJOB_TABLE_HALL, "Buildjob: Table, Hall");
	displayNames.insert(INTERFACEKEY_BUILDJOB_TABLE_FREE, "Buildjob: Table, Free");
	displayNames.insert(INTERFACEKEY_BUILDJOB_TABLE_SIZE, "Buildjob: Table, Size");
	displayNames.insert(INTERFACEKEY_BUILDJOB_BED_ASSIGN, "Buildjob: Bed, Assign");
	displayNames.insert(INTERFACEKEY_BUILDJOB_BED_FREE, "Buildjob: Bed, Free");
	displayNames.insert(INTERFACEKEY_BUILDJOB_BED_BARRACKS, "Buildjob: Bed, Barracks");
	displayNames.insert(INTERFACEKEY_BUILDJOB_BED_DORMITORY, "Buildjob: Bed, Dormitory");
	displayNames.insert(INTERFACEKEY_BUILDJOB_BED_RENT, "Buildjob: Bed, Rent");
	displayNames.insert(INTERFACEKEY_BUILDJOB_BED_SIZE, "Buildjob: Bed, Size");
	displayNames.insert(INTERFACEKEY_BUILDJOB_BED_NAME, "Buildjob: Bed, Name");
	displayNames.insert(INTERFACEKEY_BUILDJOB_BED_SLEEP, "Buildjob: Bed, Sleep");
	displayNames.insert(INTERFACEKEY_BUILDJOB_BED_TRAIN, "Buildjob: Bed, Train");
	displayNames.insert(INTERFACEKEY_BUILDJOB_BED_INDIV_EQ, "Buildjob: Bed, Indiv Eq");
	displayNames.insert(INTERFACEKEY_BUILDJOB_BED_SQUAD_EQ, "Buildjob: Bed, Squad Eq");
	displayNames.insert(INTERFACEKEY_BUILDJOB_BED_POSITION, "Buildjob: Bed, Position");
	displayNames.insert(INTERFACEKEY_BUILDJOB_DEPOT_BRING, "Buildjob: Depot, Bring");
	displayNames.insert(INTERFACEKEY_BUILDJOB_DEPOT_TRADE, "Buildjob: Depot, Trade");
	displayNames.insert(INTERFACEKEY_BUILDJOB_DEPOT_REQUEST_TRADER, "Buildjob: Depot, Request Trader");
	displayNames.insert(INTERFACEKEY_BUILDJOB_DEPOT_BROKER_ONLY, "Buildjob: Depot, Broker Only");
	displayNames.insert(INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_NONE, "Buildjob: Animal Trap, No Bait");
	displayNames.insert(INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_MEAT, "Buildjob: Animal Trap, Meat Bait");
	displayNames.insert(INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_FISH, "Buildjob: Animal Trap, Fish Bait");
	displayNames.insert(INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_GEM, "Buildjob: Animal Trap, Gem Bait");
	displayNames.insert(INTERFACEKEY_BUILDJOB_FARM_FALLOW, "Buildjob: Farm, Fallow");
	displayNames.insert(INTERFACEKEY_BUILDJOB_FARM_FERTILIZE, "Buildjob: Farm, Fertilize");
	displayNames.insert(INTERFACEKEY_BUILDJOB_FARM_SEASFERT, "Buildjob: Farm, Seas Fert");
	displayNames.insert(INTERFACEKEY_BUILDJOB_FARM_SPRING, "Buildjob: Farm, Spring");
	displayNames.insert(INTERFACEKEY_BUILDJOB_FARM_SUMMER, "Buildjob: Farm, Summer");
	displayNames.insert(INTERFACEKEY_BUILDJOB_FARM_AUTUMN, "Buildjob: Farm, Autumn");
	displayNames.insert(INTERFACEKEY_BUILDJOB_FARM_WINTER, "Buildjob: Farm, Winter");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_MASTER, "Buildjob: Stockpile, Master");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_LINK_ANYWHERE, "Buildjob: Stockpile, Link/Anywhere");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_GIVE_TO, "Buildjob: Stockpile, Give To");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_WHEELBARROW, "Buildjob: Stockpile, Wheelbarrow");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_DELETE_CHILD, "Buildjob: Stockpile, Delete Child");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_SETTINGS, "Buildjob: Stockpile, Settings");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_UP, "Buildjob: Stockpile, Barrel Up");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_DOWN, "Buildjob: Stockpile, Barrel Down");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_ZERO, "Buildjob: Stockpile, Barrel Zero");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_MAX, "Buildjob: Stockpile, Barrel Max");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_UP, "Buildjob: Stockpile, Bin Up");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_DOWN, "Buildjob: Stockpile, Bin Down");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_ZERO, "Buildjob: Stockpile, Bin Zero");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_MAX, "Buildjob: Stockpile, Bin Max");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_BONE, "Buildjob: Rack, Mat, Bone");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_BRONZE, "Buildjob: Rack, Mat, Bronze");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_COPPER, "Buildjob: Rack, Mat, Copper");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_IRON, "Buildjob: Rack, Mat, Iron");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_STEEL, "Buildjob: Rack, Mat, Steel");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_WOOD, "Buildjob: Rack, Mat, Wood");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACK_MAT_METAL, "Buildjob: Rack, Mat, Special Metal");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_BONE, "Buildjob: Stand, Mat, Bone");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_LEATHER, "Buildjob: Stand, Mat, Leather");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_COPPER, "Buildjob: Stand, Mat, Copper");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_BRONZE, "Buildjob: Stand, Mat, Bronze");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_STEEL, "Buildjob: Stand, Mat, Steel");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_IRON, "Buildjob: Stand, Mat, Iron");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_WOOD, "Buildjob: Stand, Mat, Wood");
	displayNames.insert(INTERFACEKEY_BUILDJOB_STAND_MAT_METAL, "Buildjob: Stand, Mat, Special Metal");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_ASSIGN, "Buildjob: Rackstand, Assign");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_FREE, "Buildjob: Rackstand, Free");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_SIZE, "Buildjob: Rackstand, Size");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_ITEM, "Buildjob: Rackstand, Item");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_MAT, "Buildjob: Rackstand, Mat");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS1, "Buildjob: Rackstand, All Items");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_KILL1, "Buildjob: Rackstand, No Items");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS2, "Buildjob: Rackstand, All Mats");
	displayNames.insert(INTERFACEKEY_BUILDJOB_RACKSTAND_KILL2, "Buildjob: Rackstand, No Mats");
	displayNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_ENABLE, "Stockpile Settings: Enable");
	displayNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_DISABLE, "Stockpile Settings: Disable");
	displayNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_ALL, "Stockpile Settings: Permit All");
	displayNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_ALL, "Stockpile Settings: Forbid All");
	displayNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_SUB, "Stockpile Settings: Permit Sub");
	displayNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_SUB, "Stockpile Settings: Forbit Sub");
	displayNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC1, "Stockpile Settings: Specific 1");
	displayNames.insert(INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC2, "Stockpile Settings: Specific 2");
	displayNames.insert(INTERFACEKEY_MOVIE_RECORD, "Movie: Record");
	displayNames.insert(INTERFACEKEY_MOVIE_PLAY, "Movie: Play");
	displayNames.insert(INTERFACEKEY_MOVIE_SAVE, "Movie: Save");
	displayNames.insert(INTERFACEKEY_MOVIE_LOAD, "Movie: Load");
	displayNames.insert(INTERFACEKEY_ASSIGNTRADE_VIEW, "Assign Trade: View");
	displayNames.insert(INTERFACEKEY_ASSIGNTRADE_STRING, "Assign Trade: String");
	displayNames.insert(INTERFACEKEY_ASSIGNTRADE_EXCLUDE_PROHIBITED, "Assign Trade: Exclude Prohibited");
	displayNames.insert(INTERFACEKEY_ASSIGNTRADE_PENDING, "Assign Trade: Pending");
	displayNames.insert(INTERFACEKEY_ASSIGNTRADE_SORT, "Assign Trade: Sort");
	displayNames.insert(INTERFACEKEY_NOBLELIST_REPLACE, "Noble List: Replace");
	displayNames.insert(INTERFACEKEY_NOBLELIST_SETTINGS, "Noble List: Settings");
	displayNames.insert(INTERFACEKEY_NOBLELIST_CAPITAL, "Noble List: Capital");
	displayNames.insert(INTERFACEKEY_NOBLELIST_VIEW_CANDIDATE, "Noble List: View Candidate");
	displayNames.insert(INTERFACEKEY_A_BARTER_VIEW, "Adventure: Barter, View");
	displayNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_1, "Adventure: Barter, Currency 1");
	displayNames.insert(INTERFACEKEY_A_BARTER_CURRENCY_2, "Adventure: Barter, Currency 2");
	displayNames.insert(INTERFACEKEY_A_BARTER_TRADE, "Adventure: Barter, Trade");
	displayNames.insert(INTERFACEKEY_TRADE_VIEW, "Trade, View");
	displayNames.insert(INTERFACEKEY_TRADE_TRADE, "Trade, Trade");
	displayNames.insert(INTERFACEKEY_TRADE_OFFER, "Trade, Offer");
	displayNames.insert(INTERFACEKEY_TRADE_SEIZE, "Trade, Seize");
	displayNames.insert(INTERFACEKEY_STORES_VIEW, "Stores, View");
	displayNames.insert(INTERFACEKEY_STORES_FORBID, "Stores, Forbid");
	displayNames.insert(INTERFACEKEY_STORES_MELT, "Stores, Melt");
	displayNames.insert(INTERFACEKEY_STORES_DUMP, "Stores, Dump");
	displayNames.insert(INTERFACEKEY_STORES_ZOOM, "Stores, Zoom");
	displayNames.insert(INTERFACEKEY_STORES_HIDE, "Stores, Hide");
	displayNames.insert(INTERFACEKEY_MILITARY_ACTIVATE, "Military, Activate");
	displayNames.insert(INTERFACEKEY_MILITARY_VIEW, "Military, View");
	displayNames.insert(INTERFACEKEY_MILITARY_WEAPON, "Military, Weapon");
	displayNames.insert(INTERFACEKEY_MILITARY_ZOOM, "Military, Zoom");
	displayNames.insert(INTERFACEKEY_ANNOUNCE_ZOOM, "Announcements, Zoom");
	displayNames.insert(INTERFACEKEY_UNITJOB_REMOVE_CRE, "Unitjob, Remove Unit");
	displayNames.insert(INTERFACEKEY_UNITJOB_ZOOM_CRE, "Unitjob, Zoom Unit");
	displayNames.insert(INTERFACEKEY_UNITJOB_ZOOM_BUILD, "Unitjob, Zoom Building");
	displayNames.insert(INTERFACEKEY_UNITJOB_VIEW, "Unitjob, View");
	displayNames.insert(INTERFACEKEY_UNITJOB_MANAGER, "Unitjob, Manager");
	displayNames.insert(INTERFACEKEY_MANAGER_NEW_ORDER, "Manager, New Order");
	displayNames.insert(INTERFACEKEY_MANAGER_REMOVE, "Manager, Remove");
	displayNames.insert(INTERFACEKEY_MANAGER_PROMOTE, "Manager, Promote");
	displayNames.insert(INTERFACEKEY_MANAGER_MAX, "Manager, Max");
	displayNames.insert(INTERFACEKEY_MANAGER_WAGES, "Manager, Wages");
	displayNames.insert(INTERFACEKEY_PET_BUTCHER, "Animals, Slaughter");
	bindingNames.insert(INTERFACEKEY_ANIMAL_SELECT_TRAINER, "Animals, Trainer");
	bindingNames.insert(INTERFACEKEY_ANIMAL_WAR_TRAINING, "Animals, War Training");
	bindingNames.insert(INTERFACEKEY_ANIMAL_HUNTING_TRAINING, "Animals, Hunting Training");
	displayNames.insert(INTERFACEKEY_KITCHEN_COOK, "Kitchen, Cook");
	displayNames.insert(INTERFACEKEY_KITCHEN_BREW, "Kitchen, Brew");
	displayNames.insert(INTERFACEKEY_SETUPGAME_NEW, "Setup, New");
	displayNames.insert(INTERFACEKEY_SETUPGAME_VIEW, "Setup, View");
	displayNames.insert(INTERFACEKEY_SETUPGAME_CUSTOMIZE_UNIT, "Setup, Customize Unit");
	displayNames.insert(INTERFACEKEY_SETUPGAME_SAVE_PROFILE, "Setup, Save Profile");
	displayNames.insert(INTERFACEKEY_SETUPGAME_SAVE_PROFILE_ABORT, "Setup, Save Profile, Abort");
	displayNames.insert(INTERFACEKEY_SETUPGAME_SAVE_PROFILE_GO, "Setup, Save Profile, Go");
	displayNames.insert(INTERFACEKEY_SETUPGAME_VIEW_PROFILE_PROBLEMS, "Setup, View Profile Problems");
	displayNames.insert(INTERFACEKEY_CIVZONE_REMOVE, "Main: Activity Zone, Remove");
	displayNames.insert(INTERFACEKEY_CIVZONE_REMOVE_ZONE, "Main: Activity Zone, Remove Zone");
	displayNames.insert(INTERFACEKEY_CIVZONE_SHAPE, "Main: Activity Zone, Shape");
	displayNames.insert(INTERFACEKEY_CIVZONE_NEXT, "Main: Activity Zone, Next");
	displayNames.insert(INTERFACEKEY_CIVZONE_WATER_SOURCE, "Main: Activity Zone, Water Source");
	displayNames.insert(INTERFACEKEY_CIVZONE_DUMP, "Main: Activity Zone, Garbage Dump");
	displayNames.insert(INTERFACEKEY_CIVZONE_POND, "Main: Activity Zone, Pond");
	displayNames.insert(INTERFACEKEY_CIVZONE_HOSPITAL, "Main: Activity Zone, Hospital");
	displayNames.insert(INTERFACEKEY_CIVZONE_SAND_COLLECT, "Main: Activity Zone, Sand Collect");
	displayNames.insert(INTERFACEKEY_CIVZONE_CLAY_COLLECT, "Main: Activity Zone, Clay Collect");
	displayNames.insert(INTERFACEKEY_CIVZONE_ACTIVE, "Main: Activity Zone, Active");
	displayNames.insert(INTERFACEKEY_CIVZONE_FISH, "Main: Activity Zone, Fish");
	displayNames.insert(INTERFACEKEY_CIVZONE_MEETING, "Main: Activity Zone, Meeting");
	displayNames.insert(INTERFACEKEY_CIVZONE_ANIMAL_TRAINING, "Main: Activity Zone, Animal Training");
	displayNames.insert(INTERFACEKEY_CIVZONE_POND_OPTIONS, "Main: Activity Zone, Pond Options");
	displayNames.insert(INTERFACEKEY_CIVZONE_POND_WATER, "Main: Activity Zone: Pond, Water");
	displayNames.insert(INTERFACEKEY_CIVZONE_HOSPITAL_OPTIONS, "Main: Activity Zone, Hospital Options");
	displayNames.insert(INTERFACEKEY_CIVZONE_PEN, "Main: Activity Zone, Pen");
	displayNames.insert(INTERFACEKEY_CIVZONE_PEN_OPTIONS, "Main: Activity Zone, Pen Options");
	displayNames.insert(INTERFACEKEY_STOCKPILE_ANIMAL, "Stockpile, Animal");
	displayNames.insert(INTERFACEKEY_STOCKPILE_FOOD, "Stockpile, Food");
	displayNames.insert(INTERFACEKEY_STOCKPILE_WEAPON, "Stockpile, Weapon");
	displayNames.insert(INTERFACEKEY_STOCKPILE_ARMOR, "Stockpile, Armor");
	displayNames.insert(INTERFACEKEY_STOCKPILE_CUSTOM, "Stockpile, Custom");
	displayNames.insert(INTERFACEKEY_STOCKPILE_CUSTOM_SETTINGS, "Stockpile, Custom Settings");
	displayNames.insert(INTERFACEKEY_STOCKPILE_FURNITURE, "Stockpile, Furniture");
	displayNames.insert(INTERFACEKEY_STOCKPILE_GRAVEYARD, "Stockpile, Corpse");
	displayNames.insert(INTERFACEKEY_STOCKPILE_REFUSE, "Stockpile, Refuse");
	displayNames.insert(INTERFACEKEY_STOCKPILE_WOOD, "Stockpile, Wood");
	displayNames.insert(INTERFACEKEY_STOCKPILE_STONE, "Stockpile, Stone");
	displayNames.insert(INTERFACEKEY_STOCKPILE_GEM, "Stockpile, Gem");
	displayNames.insert(INTERFACEKEY_STOCKPILE_BARBLOCK, "Stockpile, Bar/Block");
	displayNames.insert(INTERFACEKEY_STOCKPILE_CLOTH, "Stockpile, Cloth");
	displayNames.insert(INTERFACEKEY_STOCKPILE_LEATHER, "Stockpile, Leather");
	displayNames.insert(INTERFACEKEY_STOCKPILE_AMMO, "Stockpile, Ammo");
	displayNames.insert(INTERFACEKEY_STOCKPILE_COINS, "Stockpile, Coins");
	displayNames.insert(INTERFACEKEY_STOCKPILE_FINISHED, "Stockpile, Finished");
	displayNames.insert(INTERFACEKEY_STOCKPILE_NONE, "Stockpile, None");
	displayNames.insert(INTERFACEKEY_DESIGNATE_BITEM, "Designate, Building/Item");
	displayNames.insert(INTERFACEKEY_DESIGNATE_CLAIM, "Designate, Reclaim");
	displayNames.insert(INTERFACEKEY_DESIGNATE_UNCLAIM, "Designate, Forbid");
	displayNames.insert(INTERFACEKEY_DESIGNATE_MELT, "Designate, Melt");
	displayNames.insert(INTERFACEKEY_DESIGNATE_NO_MELT, "Designate, No Melt");
	displayNames.insert(INTERFACEKEY_DESIGNATE_DUMP, "Designate, Dump");
	displayNames.insert(INTERFACEKEY_DESIGNATE_NO_DUMP, "Designate, No Dump");
	displayNames.insert(INTERFACEKEY_DESIGNATE_HIDE, "Designate, Hide");
	displayNames.insert(INTERFACEKEY_DESIGNATE_NO_HIDE, "Designate, No Hide");
	displayNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC, "Designate, Traffic");
	displayNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_HIGH, "Designate, High Traffic");
	displayNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_NORMAL, "Designate, Normal Traffic");
	displayNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_LOW, "Designate, Low Traffic");
	displayNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_RESTRICTED, "Designate, Restricted Traffic");
	displayNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT, "Designate, Increase Weight");
	displayNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT, "Designate, Decrease Weight");
	displayNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT_MORE, "Designate, Increase Weight More");
	displayNames.insert(INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT_MORE, "Designate, Decrease Weight More");
	displayNames.insert(INTERFACEKEY_DESIGNATE_DIG, "Designate, Dig");
	displayNames.insert(INTERFACEKEY_DESIGNATE_DIG_REMOVE_STAIRS_RAMPS, "Designate, Dig Remove Stairs Ramps");
	displayNames.insert(INTERFACEKEY_DESIGNATE_STAIR_UP, "Designate, U Stair");
	displayNames.insert(INTERFACEKEY_DESIGNATE_STAIR_DOWN, "Designate, D Stair");
	displayNames.insert(INTERFACEKEY_DESIGNATE_STAIR_UPDOWN, "Designate, UD Stair");
	displayNames.insert(INTERFACEKEY_DESIGNATE_RAMP, "Designate, Ramp");
	displayNames.insert(INTERFACEKEY_DESIGNATE_CHANNEL, "Designate, Channel");
	displayNames.insert(INTERFACEKEY_DESIGNATE_CHOP, "Designate, Chop");
	displayNames.insert(INTERFACEKEY_DESIGNATE_PLANTS, "Designate, Plants");
	displayNames.insert(INTERFACEKEY_DESIGNATE_SMOOTH, "Designate, Smooth");
	displayNames.insert(INTERFACEKEY_DESIGNATE_ENGRAVE, "Designate, Engrave");
	displayNames.insert(INTERFACEKEY_DESIGNATE_FORTIFY, "Designate, Fortify");
	displayNames.insert(INTERFACEKEY_DESIGNATE_TRACK, "Designate, Carve Track");
	displayNames.insert(INTERFACEKEY_DESIGNATE_TOGGLE_ENGRAVING, "Designate, Toggle Engraving");
	displayNames.insert(INTERFACEKEY_DESIGNATE_UNDO, "Designate, Undo");
	displayNames.insert(INTERFACEKEY_DESIGNATE_REMOVE_CONSTRUCTION, "Designate, Remove Construction");
	displayNames.insert(INTERFACEKEY_BUILDING_DIM_Y_UP, "Building, Change Height +");
	displayNames.insert(INTERFACEKEY_BUILDING_DIM_Y_DOWN, "Building, Change Height -");
	displayNames.insert(INTERFACEKEY_BUILDING_DIM_X_UP, "Building, Change Width +");
	displayNames.insert(INTERFACEKEY_BUILDING_DIM_X_DOWN, "Building, Change Width -");
	displayNames.insert(INTERFACEKEY_BUILDING_ORIENT_UP, "Building, Orient Up");
	displayNames.insert(INTERFACEKEY_BUILDING_ORIENT_LEFT, "Building, Orient Left");
	displayNames.insert(INTERFACEKEY_BUILDING_ORIENT_RIGHT, "Building, Orient Right");
	displayNames.insert(INTERFACEKEY_BUILDING_ORIENT_DOWN, "Building, Orient Down");
	displayNames.insert(INTERFACEKEY_BUILDING_ORIENT_NONE, "Building, Orient None");
	displayNames.insert(INTERFACEKEY_BUILDING_VIEW_ITEM, "Building, View Item");
	displayNames.insert(INTERFACEKEY_BUILDING_ADVANCE_STAGE, "Building, Done Selecting");
	displayNames.insert(INTERFACEKEY_BUILDING_EXPAND_CONTRACT, "Building, Expand/Contract");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_WATER, "Building, Trigger, Enable Water");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_UP, "Building, Trigger, Min Water Up");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_DOWN, "Building, Trigger, Min Water Down");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_UP, "Building, Trigger, Max Water Up");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_DOWN, "Building, Trigger, Max Water Down");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_MAGMA, "Building, Trigger, Enabler Magma");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_UP, "Building, Trigger, Min Magma Up");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_DOWN, "Building, Trigger, Min Magma Down");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_UP, "Building, Trigger, Max Magma Up");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_DOWN, "Building, Trigger, Max Magma Down");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_TRACK_CART, "Building, Trigger, Enable Cart");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_TRACK_CART_DOWN, "Building, Trigger, Min Cart Down");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_TRACK_CART_UP, "Building, Trigger, Min Cart Up");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_TRACK_CART_DOWN, "Building, Trigger, Max Cart Down");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_TRACK_CART_UP, "Building, Trigger, Max Cart Up");
	displayNames.insert(INTERFACEKEY_BUILDING_ROLLERS_SPEED_UP, "Building, Rollers, Speed Up");
	displayNames.insert(INTERFACEKEY_BUILDING_ROLLERS_SPEED_DOWN, "Building, Rollers, Speed Down");
	displayNames.insert(INTERFACEKEY_BUILDING_TRACK_STOP_FRICTION_UP, "Building, Track Stop, Friction Up");
	displayNames.insert(INTERFACEKEY_BUILDING_TRACK_STOP_FRICTION_DOWN, "Building, Track Stop, Friction Down");
	displayNames.insert(INTERFACEKEY_BUILDING_TRACK_STOP_DUMP, "Building, Track Stop, Dump");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_CREATURE, "Building, Trigger, Enable Creature");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_ENABLE_LOCALS, "Building, Trigger, Enable Locals");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_RESETS, "Building, Trigger, Resets");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_UP, "Building, Trigger, Min Size Up");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_DOWN, "Building, Trigger, Min Size Down");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_UP, "Building, Trigger, Max Size Up");
	displayNames.insert(INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_DOWN, "Building, Trigger, Max Size Down");
	displayNames.insert(INTERFACEKEY_UNITVIEW_GEN, "Unitview, General");
	displayNames.insert(INTERFACEKEY_UNITVIEW_INV, "Unitview, Inventory");
	displayNames.insert(INTERFACEKEY_UNITVIEW_PRF, "Unitview, Prefs");
	displayNames.insert(INTERFACEKEY_UNITVIEW_WND, "Unitview, Wounds");
	displayNames.insert(INTERFACEKEY_UNITVIEW_NEXT, "Unitview, Next Unit");
	displayNames.insert(INTERFACEKEY_UNITVIEW_FOLLOW, "Unitview, Follow");
	displayNames.insert(INTERFACEKEY_UNITVIEW_SLAUGHTER, "Unitview, Slaughter");
	displayNames.insert(INTERFACEKEY_UNITVIEW_GEN_COMBAT, "Unitview, General, Combat");
	displayNames.insert(INTERFACEKEY_UNITVIEW_GEN_LABOR, "Unitview, General, Labor");
	displayNames.insert(INTERFACEKEY_UNITVIEW_GEN_MISC, "Unitview, General, Misc");
	displayNames.insert(INTERFACEKEY_UNITVIEW_PRF_PROF, "Unitview, Prefs, Labor");
	displayNames.insert(INTERFACEKEY_UNITVIEW_PRF_PET, "Unitview, Prefs, Pets");
	displayNames.insert(INTERFACEKEY_UNITVIEW_PRF_VIEW, "Unitview, Prefs, Profile");
	displayNames.insert(INTERFACEKEY_UNITVIEW_PRF_NEW_SQUAD, "Unitview, Prefs, New Squad");
	displayNames.insert(INTERFACEKEY_UNITVIEW_PRF_REMOVE_FROM_SQUAD, "Unitview, Prefs, Remove From Squad");
	displayNames.insert(INTERFACEKEY_UNITVIEW_PRF_NAME_CURRENT_SQUAD, "Unitview, Prefs, Name Current Squad");
	displayNames.insert(INTERFACEKEY_UNITVIEW_PRF_NAME_SELECTED_SQUAD, "Unitview, Prefs, Name Selected Squad");

	displayNames.insert(INTERFACEKEY_STRING_A000, "String: Backspace");
	displayNames.insert(INTERFACEKEY_STRING_A001, "String: Character 001");
	displayNames.insert(INTERFACEKEY_STRING_A002, "String: Character 002");
	displayNames.insert(INTERFACEKEY_STRING_A003, "String: Character 003");
	displayNames.insert(INTERFACEKEY_STRING_A004, "String: Character 004");
	displayNames.insert(INTERFACEKEY_STRING_A005, "String: Character 005");
	displayNames.insert(INTERFACEKEY_STRING_A006, "String: Character 006");
	displayNames.insert(INTERFACEKEY_STRING_A007, "String: Character 007");
	displayNames.insert(INTERFACEKEY_STRING_A008, "String: Character 008");
	displayNames.insert(INTERFACEKEY_STRING_A009, "String: Character 009");
	displayNames.insert(INTERFACEKEY_STRING_A010, "String: Character 010");
	displayNames.insert(INTERFACEKEY_STRING_A011, "String: Character 011");
	displayNames.insert(INTERFACEKEY_STRING_A012, "String: Character 012");
	displayNames.insert(INTERFACEKEY_STRING_A013, "String: Character 013");
	displayNames.insert(INTERFACEKEY_STRING_A014, "String: Character 014");
	displayNames.insert(INTERFACEKEY_STRING_A015, "String: Character 015");
	displayNames.insert(INTERFACEKEY_STRING_A016, "String: Character 016");
	displayNames.insert(INTERFACEKEY_STRING_A017, "String: Character 017");
	displayNames.insert(INTERFACEKEY_STRING_A018, "String: Character 018");
	displayNames.insert(INTERFACEKEY_STRING_A019, "String: Character 019");
	displayNames.insert(INTERFACEKEY_STRING_A020, "String: Character 020");
	displayNames.insert(INTERFACEKEY_STRING_A021, "String: Character 021");
	displayNames.insert(INTERFACEKEY_STRING_A022, "String: Character 022");
	displayNames.insert(INTERFACEKEY_STRING_A023, "String: Character 023");
	displayNames.insert(INTERFACEKEY_STRING_A024, "String: Character 024");
	displayNames.insert(INTERFACEKEY_STRING_A025, "String: Character 025");
	displayNames.insert(INTERFACEKEY_STRING_A026, "String: Character 026");
	displayNames.insert(INTERFACEKEY_STRING_A027, "String: Character 027");
	displayNames.insert(INTERFACEKEY_STRING_A028, "String: Character 028");
	displayNames.insert(INTERFACEKEY_STRING_A029, "String: Character 029");
	displayNames.insert(INTERFACEKEY_STRING_A030, "String: Character 030");
	displayNames.insert(INTERFACEKEY_STRING_A031, "String: Character 031");
	displayNames.insert(INTERFACEKEY_STRING_A032, "String: Character 032");
	displayNames.insert(INTERFACEKEY_STRING_A033, "String: Character 033");
	displayNames.insert(INTERFACEKEY_STRING_A034, "String: Character 034");
	displayNames.insert(INTERFACEKEY_STRING_A035, "String: Character 035");
	displayNames.insert(INTERFACEKEY_STRING_A036, "String: Character 036");
	displayNames.insert(INTERFACEKEY_STRING_A037, "String: Character 037");
	displayNames.insert(INTERFACEKEY_STRING_A038, "String: Character 038");
	displayNames.insert(INTERFACEKEY_STRING_A039, "String: Character 039");
	displayNames.insert(INTERFACEKEY_STRING_A040, "String: Character 040");
	displayNames.insert(INTERFACEKEY_STRING_A041, "String: Character 041");
	displayNames.insert(INTERFACEKEY_STRING_A042, "String: Character 042");
	displayNames.insert(INTERFACEKEY_STRING_A043, "String: Character 043");
	displayNames.insert(INTERFACEKEY_STRING_A044, "String: Character 044");
	displayNames.insert(INTERFACEKEY_STRING_A045, "String: Character 045");
	displayNames.insert(INTERFACEKEY_STRING_A046, "String: Character 046");
	displayNames.insert(INTERFACEKEY_STRING_A047, "String: Character 047");
	displayNames.insert(INTERFACEKEY_STRING_A048, "String: Character 048");
	displayNames.insert(INTERFACEKEY_STRING_A049, "String: Character 049");
	displayNames.insert(INTERFACEKEY_STRING_A050, "String: Character 050");
	displayNames.insert(INTERFACEKEY_STRING_A051, "String: Character 051");
	displayNames.insert(INTERFACEKEY_STRING_A052, "String: Character 052");
	displayNames.insert(INTERFACEKEY_STRING_A053, "String: Character 053");
	displayNames.insert(INTERFACEKEY_STRING_A054, "String: Character 054");
	displayNames.insert(INTERFACEKEY_STRING_A055, "String: Character 055");
	displayNames.insert(INTERFACEKEY_STRING_A056, "String: Character 056");
	displayNames.insert(INTERFACEKEY_STRING_A057, "String: Character 057");
	displayNames.insert(INTERFACEKEY_STRING_A058, "String: Character 058");
	displayNames.insert(INTERFACEKEY_STRING_A059, "String: Character 059");
	displayNames.insert(INTERFACEKEY_STRING_A060, "String: Character 060");
	displayNames.insert(INTERFACEKEY_STRING_A061, "String: Character 061");
	displayNames.insert(INTERFACEKEY_STRING_A062, "String: Character 062");
	displayNames.insert(INTERFACEKEY_STRING_A063, "String: Character 063");
	displayNames.insert(INTERFACEKEY_STRING_A064, "String: Character 064");
	displayNames.insert(INTERFACEKEY_STRING_A065, "String: Character 065");
	displayNames.insert(INTERFACEKEY_STRING_A066, "String: Character 066");
	displayNames.insert(INTERFACEKEY_STRING_A067, "String: Character 067");
	displayNames.insert(INTERFACEKEY_STRING_A068, "String: Character 068");
	displayNames.insert(INTERFACEKEY_STRING_A069, "String: Character 069");
	displayNames.insert(INTERFACEKEY_STRING_A070, "String: Character 070");
	displayNames.insert(INTERFACEKEY_STRING_A071, "String: Character 071");
	displayNames.insert(INTERFACEKEY_STRING_A072, "String: Character 072");
	displayNames.insert(INTERFACEKEY_STRING_A073, "String: Character 073");
	displayNames.insert(INTERFACEKEY_STRING_A074, "String: Character 074");
	displayNames.insert(INTERFACEKEY_STRING_A075, "String: Character 075");
	displayNames.insert(INTERFACEKEY_STRING_A076, "String: Character 076");
	displayNames.insert(INTERFACEKEY_STRING_A077, "String: Character 077");
	displayNames.insert(INTERFACEKEY_STRING_A078, "String: Character 078");
	displayNames.insert(INTERFACEKEY_STRING_A079, "String: Character 079");
	displayNames.insert(INTERFACEKEY_STRING_A080, "String: Character 080");
	displayNames.insert(INTERFACEKEY_STRING_A081, "String: Character 081");
	displayNames.insert(INTERFACEKEY_STRING_A082, "String: Character 082");
	displayNames.insert(INTERFACEKEY_STRING_A083, "String: Character 083");
	displayNames.insert(INTERFACEKEY_STRING_A084, "String: Character 084");
	displayNames.insert(INTERFACEKEY_STRING_A085, "String: Character 085");
	displayNames.insert(INTERFACEKEY_STRING_A086, "String: Character 086");
	displayNames.insert(INTERFACEKEY_STRING_A087, "String: Character 087");
	displayNames.insert(INTERFACEKEY_STRING_A088, "String: Character 088");
	displayNames.insert(INTERFACEKEY_STRING_A089, "String: Character 089");
	displayNames.insert(INTERFACEKEY_STRING_A090, "String: Character 090");
	displayNames.insert(INTERFACEKEY_STRING_A091, "String: Character 091");
	displayNames.insert(INTERFACEKEY_STRING_A092, "String: Character 092");
	displayNames.insert(INTERFACEKEY_STRING_A093, "String: Character 093");
	displayNames.insert(INTERFACEKEY_STRING_A094, "String: Character 094");
	displayNames.insert(INTERFACEKEY_STRING_A095, "String: Character 095");
	displayNames.insert(INTERFACEKEY_STRING_A096, "String: Character 096");
	displayNames.insert(INTERFACEKEY_STRING_A097, "String: Character 097");
	displayNames.insert(INTERFACEKEY_STRING_A098, "String: Character 098");
	displayNames.insert(INTERFACEKEY_STRING_A099, "String: Character 099");
	displayNames.insert(INTERFACEKEY_STRING_A100, "String: Character 100");
	displayNames.insert(INTERFACEKEY_STRING_A101, "String: Character 101");
	displayNames.insert(INTERFACEKEY_STRING_A102, "String: Character 102");
	displayNames.insert(INTERFACEKEY_STRING_A103, "String: Character 103");
	displayNames.insert(INTERFACEKEY_STRING_A104, "String: Character 104");
	displayNames.insert(INTERFACEKEY_STRING_A105, "String: Character 105");
	displayNames.insert(INTERFACEKEY_STRING_A106, "String: Character 106");
	displayNames.insert(INTERFACEKEY_STRING_A107, "String: Character 107");
	displayNames.insert(INTERFACEKEY_STRING_A108, "String: Character 108");
	displayNames.insert(INTERFACEKEY_STRING_A109, "String: Character 109");
	displayNames.insert(INTERFACEKEY_STRING_A110, "String: Character 110");
	displayNames.insert(INTERFACEKEY_STRING_A111, "String: Character 111");
	displayNames.insert(INTERFACEKEY_STRING_A112, "String: Character 112");
	displayNames.insert(INTERFACEKEY_STRING_A113, "String: Character 113");
	displayNames.insert(INTERFACEKEY_STRING_A114, "String: Character 114");
	displayNames.insert(INTERFACEKEY_STRING_A115, "String: Character 115");
	displayNames.insert(INTERFACEKEY_STRING_A116, "String: Character 116");
	displayNames.insert(INTERFACEKEY_STRING_A117, "String: Character 117");
	displayNames.insert(INTERFACEKEY_STRING_A118, "String: Character 118");
	displayNames.insert(INTERFACEKEY_STRING_A119, "String: Character 119");
	displayNames.insert(INTERFACEKEY_STRING_A120, "String: Character 120");
	displayNames.insert(INTERFACEKEY_STRING_A121, "String: Character 121");
	displayNames.insert(INTERFACEKEY_STRING_A122, "String: Character 122");
	displayNames.insert(INTERFACEKEY_STRING_A123, "String: Character 123");
	displayNames.insert(INTERFACEKEY_STRING_A124, "String: Character 124");
	displayNames.insert(INTERFACEKEY_STRING_A125, "String: Character 125");
	displayNames.insert(INTERFACEKEY_STRING_A126, "String: Character 126");
	displayNames.insert(INTERFACEKEY_STRING_A127, "String: Character 127");
	displayNames.insert(INTERFACEKEY_STRING_A128, "String: Character 128");
	displayNames.insert(INTERFACEKEY_STRING_A129, "String: Character 129");
	displayNames.insert(INTERFACEKEY_STRING_A130, "String: Character 130");
	displayNames.insert(INTERFACEKEY_STRING_A131, "String: Character 131");
	displayNames.insert(INTERFACEKEY_STRING_A132, "String: Character 132");
	displayNames.insert(INTERFACEKEY_STRING_A133, "String: Character 133");
	displayNames.insert(INTERFACEKEY_STRING_A134, "String: Character 134");
	displayNames.insert(INTERFACEKEY_STRING_A135, "String: Character 135");
	displayNames.insert(INTERFACEKEY_STRING_A136, "String: Character 136");
	displayNames.insert(INTERFACEKEY_STRING_A137, "String: Character 137");
	displayNames.insert(INTERFACEKEY_STRING_A138, "String: Character 138");
	displayNames.insert(INTERFACEKEY_STRING_A139, "String: Character 139");
	displayNames.insert(INTERFACEKEY_STRING_A140, "String: Character 140");
	displayNames.insert(INTERFACEKEY_STRING_A141, "String: Character 141");
	displayNames.insert(INTERFACEKEY_STRING_A142, "String: Character 142");
	displayNames.insert(INTERFACEKEY_STRING_A143, "String: Character 143");
	displayNames.insert(INTERFACEKEY_STRING_A144, "String: Character 144");
	displayNames.insert(INTERFACEKEY_STRING_A145, "String: Character 145");
	displayNames.insert(INTERFACEKEY_STRING_A146, "String: Character 146");
	displayNames.insert(INTERFACEKEY_STRING_A147, "String: Character 147");
	displayNames.insert(INTERFACEKEY_STRING_A148, "String: Character 148");
	displayNames.insert(INTERFACEKEY_STRING_A149, "String: Character 149");
	displayNames.insert(INTERFACEKEY_STRING_A150, "String: Character 150");
	displayNames.insert(INTERFACEKEY_STRING_A151, "String: Character 151");
	displayNames.insert(INTERFACEKEY_STRING_A152, "String: Character 152");
	displayNames.insert(INTERFACEKEY_STRING_A153, "String: Character 153");
	displayNames.insert(INTERFACEKEY_STRING_A154, "String: Character 154");
	displayNames.insert(INTERFACEKEY_STRING_A155, "String: Character 155");
	displayNames.insert(INTERFACEKEY_STRING_A156, "String: Character 156");
	displayNames.insert(INTERFACEKEY_STRING_A157, "String: Character 157");
	displayNames.insert(INTERFACEKEY_STRING_A158, "String: Character 158");
	displayNames.insert(INTERFACEKEY_STRING_A159, "String: Character 159");
	displayNames.insert(INTERFACEKEY_STRING_A160, "String: Character 160");
	displayNames.insert(INTERFACEKEY_STRING_A161, "String: Character 161");
	displayNames.insert(INTERFACEKEY_STRING_A162, "String: Character 162");
	displayNames.insert(INTERFACEKEY_STRING_A163, "String: Character 163");
	displayNames.insert(INTERFACEKEY_STRING_A164, "String: Character 164");
	displayNames.insert(INTERFACEKEY_STRING_A165, "String: Character 165");
	displayNames.insert(INTERFACEKEY_STRING_A166, "String: Character 166");
	displayNames.insert(INTERFACEKEY_STRING_A167, "String: Character 167");
	displayNames.insert(INTERFACEKEY_STRING_A168, "String: Character 168");
	displayNames.insert(INTERFACEKEY_STRING_A169, "String: Character 169");
	displayNames.insert(INTERFACEKEY_STRING_A170, "String: Character 170");
	displayNames.insert(INTERFACEKEY_STRING_A171, "String: Character 171");
	displayNames.insert(INTERFACEKEY_STRING_A172, "String: Character 172");
	displayNames.insert(INTERFACEKEY_STRING_A173, "String: Character 173");
	displayNames.insert(INTERFACEKEY_STRING_A174, "String: Character 174");
	displayNames.insert(INTERFACEKEY_STRING_A175, "String: Character 175");
	displayNames.insert(INTERFACEKEY_STRING_A176, "String: Character 176");
	displayNames.insert(INTERFACEKEY_STRING_A177, "String: Character 177");
	displayNames.insert(INTERFACEKEY_STRING_A178, "String: Character 178");
	displayNames.insert(INTERFACEKEY_STRING_A179, "String: Character 179");
	displayNames.insert(INTERFACEKEY_STRING_A180, "String: Character 180");
	displayNames.insert(INTERFACEKEY_STRING_A181, "String: Character 181");
	displayNames.insert(INTERFACEKEY_STRING_A182, "String: Character 182");
	displayNames.insert(INTERFACEKEY_STRING_A183, "String: Character 183");
	displayNames.insert(INTERFACEKEY_STRING_A184, "String: Character 184");
	displayNames.insert(INTERFACEKEY_STRING_A185, "String: Character 185");
	displayNames.insert(INTERFACEKEY_STRING_A186, "String: Character 186");
	displayNames.insert(INTERFACEKEY_STRING_A187, "String: Character 187");
	displayNames.insert(INTERFACEKEY_STRING_A188, "String: Character 188");
	displayNames.insert(INTERFACEKEY_STRING_A189, "String: Character 189");
	displayNames.insert(INTERFACEKEY_STRING_A190, "String: Character 190");
	displayNames.insert(INTERFACEKEY_STRING_A191, "String: Character 191");
	displayNames.insert(INTERFACEKEY_STRING_A192, "String: Character 192");
	displayNames.insert(INTERFACEKEY_STRING_A193, "String: Character 193");
	displayNames.insert(INTERFACEKEY_STRING_A194, "String: Character 194");
	displayNames.insert(INTERFACEKEY_STRING_A195, "String: Character 195");
	displayNames.insert(INTERFACEKEY_STRING_A196, "String: Character 196");
	displayNames.insert(INTERFACEKEY_STRING_A197, "String: Character 197");
	displayNames.insert(INTERFACEKEY_STRING_A198, "String: Character 198");
	displayNames.insert(INTERFACEKEY_STRING_A199, "String: Character 199");
	displayNames.insert(INTERFACEKEY_STRING_A200, "String: Character 200");
	displayNames.insert(INTERFACEKEY_STRING_A201, "String: Character 201");
	displayNames.insert(INTERFACEKEY_STRING_A202, "String: Character 202");
	displayNames.insert(INTERFACEKEY_STRING_A203, "String: Character 203");
	displayNames.insert(INTERFACEKEY_STRING_A204, "String: Character 204");
	displayNames.insert(INTERFACEKEY_STRING_A205, "String: Character 205");
	displayNames.insert(INTERFACEKEY_STRING_A206, "String: Character 206");
	displayNames.insert(INTERFACEKEY_STRING_A207, "String: Character 207");
	displayNames.insert(INTERFACEKEY_STRING_A208, "String: Character 208");
	displayNames.insert(INTERFACEKEY_STRING_A209, "String: Character 209");
	displayNames.insert(INTERFACEKEY_STRING_A210, "String: Character 210");
	displayNames.insert(INTERFACEKEY_STRING_A211, "String: Character 211");
	displayNames.insert(INTERFACEKEY_STRING_A212, "String: Character 212");
	displayNames.insert(INTERFACEKEY_STRING_A213, "String: Character 213");
	displayNames.insert(INTERFACEKEY_STRING_A214, "String: Character 214");
	displayNames.insert(INTERFACEKEY_STRING_A215, "String: Character 215");
	displayNames.insert(INTERFACEKEY_STRING_A216, "String: Character 216");
	displayNames.insert(INTERFACEKEY_STRING_A217, "String: Character 217");
	displayNames.insert(INTERFACEKEY_STRING_A218, "String: Character 218");
	displayNames.insert(INTERFACEKEY_STRING_A219, "String: Character 219");
	displayNames.insert(INTERFACEKEY_STRING_A220, "String: Character 220");
	displayNames.insert(INTERFACEKEY_STRING_A221, "String: Character 221");
	displayNames.insert(INTERFACEKEY_STRING_A222, "String: Character 222");
	displayNames.insert(INTERFACEKEY_STRING_A223, "String: Character 223");
	displayNames.insert(INTERFACEKEY_STRING_A224, "String: Character 224");
	displayNames.insert(INTERFACEKEY_STRING_A225, "String: Character 225");
	displayNames.insert(INTERFACEKEY_STRING_A226, "String: Character 226");
	displayNames.insert(INTERFACEKEY_STRING_A227, "String: Character 227");
	displayNames.insert(INTERFACEKEY_STRING_A228, "String: Character 228");
	displayNames.insert(INTERFACEKEY_STRING_A229, "String: Character 229");
	displayNames.insert(INTERFACEKEY_STRING_A230, "String: Character 230");
	displayNames.insert(INTERFACEKEY_STRING_A231, "String: Character 231");
	displayNames.insert(INTERFACEKEY_STRING_A232, "String: Character 232");
	displayNames.insert(INTERFACEKEY_STRING_A233, "String: Character 233");
	displayNames.insert(INTERFACEKEY_STRING_A234, "String: Character 234");
	displayNames.insert(INTERFACEKEY_STRING_A235, "String: Character 235");
	displayNames.insert(INTERFACEKEY_STRING_A236, "String: Character 236");
	displayNames.insert(INTERFACEKEY_STRING_A237, "String: Character 237");
	displayNames.insert(INTERFACEKEY_STRING_A238, "String: Character 238");
	displayNames.insert(INTERFACEKEY_STRING_A239, "String: Character 239");
	displayNames.insert(INTERFACEKEY_STRING_A240, "String: Character 240");
	displayNames.insert(INTERFACEKEY_STRING_A241, "String: Character 241");
	displayNames.insert(INTERFACEKEY_STRING_A242, "String: Character 242");
	displayNames.insert(INTERFACEKEY_STRING_A243, "String: Character 243");
	displayNames.insert(INTERFACEKEY_STRING_A244, "String: Character 244");
	displayNames.insert(INTERFACEKEY_STRING_A245, "String: Character 245");
	displayNames.insert(INTERFACEKEY_STRING_A246, "String: Character 246");
	displayNames.insert(INTERFACEKEY_STRING_A247, "String: Character 247");
	displayNames.insert(INTERFACEKEY_STRING_A248, "String: Character 248");
	displayNames.insert(INTERFACEKEY_STRING_A249, "String: Character 249");
	displayNames.insert(INTERFACEKEY_STRING_A250, "String: Character 250");
	displayNames.insert(INTERFACEKEY_STRING_A251, "String: Character 251");
	displayNames.insert(INTERFACEKEY_STRING_A252, "String: Character 252");
	displayNames.insert(INTERFACEKEY_STRING_A253, "String: Character 253");
	displayNames.insert(INTERFACEKEY_STRING_A254, "String: Character 254");
	displayNames.insert(INTERFACEKEY_STRING_A255, "String: Character 255");
	displayNames.insert(INTERFACEKEY_CUSTOM_A, "Custom: A");
	displayNames.insert(INTERFACEKEY_CUSTOM_B, "Custom: B");
	displayNames.insert(INTERFACEKEY_CUSTOM_C, "Custom: C");
	displayNames.insert(INTERFACEKEY_CUSTOM_D, "Custom: D");
	displayNames.insert(INTERFACEKEY_CUSTOM_E, "Custom: E");
	displayNames.insert(INTERFACEKEY_CUSTOM_F, "Custom: F");
	displayNames.insert(INTERFACEKEY_CUSTOM_G, "Custom: G");
	displayNames.insert(INTERFACEKEY_CUSTOM_H, "Custom: H");
	displayNames.insert(INTERFACEKEY_CUSTOM_I, "Custom: I");
	displayNames.insert(INTERFACEKEY_CUSTOM_J, "Custom: J");
	displayNames.insert(INTERFACEKEY_CUSTOM_K, "Custom: K");
	displayNames.insert(INTERFACEKEY_CUSTOM_L, "Custom: L");
	displayNames.insert(INTERFACEKEY_CUSTOM_M, "Custom: M");
	displayNames.insert(INTERFACEKEY_CUSTOM_N, "Custom: N");
	displayNames.insert(INTERFACEKEY_CUSTOM_O, "Custom: O");
	displayNames.insert(INTERFACEKEY_CUSTOM_P, "Custom: P");
	displayNames.insert(INTERFACEKEY_CUSTOM_Q, "Custom: Q");
	displayNames.insert(INTERFACEKEY_CUSTOM_R, "Custom: R");
	displayNames.insert(INTERFACEKEY_CUSTOM_S, "Custom: S");
	displayNames.insert(INTERFACEKEY_CUSTOM_T, "Custom: T");
	displayNames.insert(INTERFACEKEY_CUSTOM_U, "Custom: U");
	displayNames.insert(INTERFACEKEY_CUSTOM_V, "Custom: V");
	displayNames.insert(INTERFACEKEY_CUSTOM_W, "Custom: W");
	displayNames.insert(INTERFACEKEY_CUSTOM_X, "Custom: X");
	displayNames.insert(INTERFACEKEY_CUSTOM_Y, "Custom: Y");
	displayNames.insert(INTERFACEKEY_CUSTOM_Z, "Custom: Z");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_A, "Custom: Shift + A");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_B, "Custom: Shift + B");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_C, "Custom: Shift + C");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_D, "Custom: Shift + D");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_E, "Custom: Shift + E");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_F, "Custom: Shift + F");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_G, "Custom: Shift + G");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_H, "Custom: Shift + H");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_I, "Custom: Shift + I");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_J, "Custom: Shift + J");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_K, "Custom: Shift + K");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_L, "Custom: Shift + L");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_M, "Custom: Shift + M");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_N, "Custom: Shift + N");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_O, "Custom: Shift + O");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_P, "Custom: Shift + P");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_Q, "Custom: Shift + Q");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_R, "Custom: Shift + R");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_S, "Custom: Shift + S");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_T, "Custom: Shift + T");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_U, "Custom: Shift + U");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_V, "Custom: Shift + V");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_W, "Custom: Shift + W");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_X, "Custom: Shift + X");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_Y, "Custom: Shift + Y");
	displayNames.insert(INTERFACEKEY_CUSTOM_SHIFT_Z, "Custom: Shift + Z");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_A, "Custom: Ctrl + A");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_B, "Custom: Ctrl + B");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_C, "Custom: Ctrl + C");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_D, "Custom: Ctrl + D");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_E, "Custom: Ctrl + E");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_F, "Custom: Ctrl + F");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_G, "Custom: Ctrl + G");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_H, "Custom: Ctrl + H");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_I, "Custom: Ctrl + I");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_J, "Custom: Ctrl + J");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_K, "Custom: Ctrl + K");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_L, "Custom: Ctrl + L");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_M, "Custom: Ctrl + M");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_N, "Custom: Ctrl + N");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_O, "Custom: Ctrl + O");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_P, "Custom: Ctrl + P");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_Q, "Custom: Ctrl + Q");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_R, "Custom: Ctrl + R");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_S, "Custom: Ctrl + S");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_T, "Custom: Ctrl + T");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_U, "Custom: Ctrl + U");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_V, "Custom: Ctrl + V");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_W, "Custom: Ctrl + W");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_X, "Custom: Ctrl + X");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_Y, "Custom: Ctrl + Y");
	displayNames.insert(INTERFACEKEY_CUSTOM_CTRL_Z, "Custom: Ctrl + Z");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_A, "Custom: Alt + A");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_B, "Custom: Alt + B");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_C, "Custom: Alt + C");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_D, "Custom: Alt + D");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_E, "Custom: Alt + E");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_F, "Custom: Alt + F");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_G, "Custom: Alt + G");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_H, "Custom: Alt + H");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_I, "Custom: Alt + I");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_J, "Custom: Alt + J");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_K, "Custom: Alt + K");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_L, "Custom: Alt + L");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_M, "Custom: Alt + M");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_N, "Custom: Alt + N");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_O, "Custom: Alt + O");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_P, "Custom: Alt + P");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_Q, "Custom: Alt + Q");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_R, "Custom: Alt + R");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_S, "Custom: Alt + S");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_T, "Custom: Alt + T");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_U, "Custom: Alt + U");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_V, "Custom: Alt + V");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_W, "Custom: Alt + W");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_X, "Custom: Alt + X");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_Y, "Custom: Alt + Y");
	displayNames.insert(INTERFACEKEY_CUSTOM_ALT_Z, "Custom: Alt + Z");
	displayNames.insert(INTERFACEKEY_FPS_UP, "Increase FPS limit");
	displayNames.insert(INTERFACEKEY_FPS_DOWN, "Decrease FPS limit");
	displayNames.insert(INTERFACEKEY_TOGGLE_TTF, "Toggle Truetype rendering");
	displayNames.insert(INTERFACEKEY_PREFIX, "Command repeat prefix-key");
        

  sdlNames.insert(SDLK_BACKSPACE, "Backspace");
  sdlNames.insert(SDLK_TAB, "Tab");
  sdlNames.insert(SDLK_CLEAR, "Clear");
  sdlNames.insert(SDLK_RETURN, "Enter");
  sdlNames.insert(SDLK_PAUSE, "Pause");
  sdlNames.insert(SDLK_ESCAPE, "ESC");
  sdlNames.insert(SDLK_SPACE, "Space");
  sdlNames.insert(SDLK_EXCLAIM, "Exclaim");
  sdlNames.insert(SDLK_QUOTEDBL, "Quotedbl");
  sdlNames.insert(SDLK_HASH, "Hash");
  sdlNames.insert(SDLK_DOLLAR, "Dollar");
  sdlNames.insert(SDLK_AMPERSAND, "Ampersand");
  sdlNames.insert(SDLK_QUOTE, "Quote");
  sdlNames.insert(SDLK_LEFTPAREN, "Leftparen");
  sdlNames.insert(SDLK_RIGHTPAREN, "Rightparen");
  sdlNames.insert(SDLK_ASTERISK, "Asterisk");
  sdlNames.insert(SDLK_PLUS, "Plus");
  sdlNames.insert(SDLK_COMMA, "Comma");
  sdlNames.insert(SDLK_MINUS, "Minus");
  sdlNames.insert(SDLK_PERIOD, "Period");
  sdlNames.insert(SDLK_SLASH, "Slash");
  sdlNames.insert(SDLK_0, "0");
  sdlNames.insert(SDLK_1, "1");
  sdlNames.insert(SDLK_2, "2");
  sdlNames.insert(SDLK_3, "3");
  sdlNames.insert(SDLK_4, "4");
  sdlNames.insert(SDLK_5, "5");
  sdlNames.insert(SDLK_6, "6");
  sdlNames.insert(SDLK_7, "7");
  sdlNames.insert(SDLK_8, "8");
  sdlNames.insert(SDLK_9, "9");
  sdlNames.insert(SDLK_COLON, "Colon");
  sdlNames.insert(SDLK_SEMICOLON, "Semicolon");
  sdlNames.insert(SDLK_LESS, "Less");
  sdlNames.insert(SDLK_EQUALS, "Equals");
  sdlNames.insert(SDLK_GREATER, "Greater");
  sdlNames.insert(SDLK_QUESTION, "Question");
  sdlNames.insert(SDLK_AT, "At");
  sdlNames.insert(SDLK_LEFTBRACKET, "Leftbracket");
  sdlNames.insert(SDLK_BACKSLASH, "Backslash");
  sdlNames.insert(SDLK_RIGHTBRACKET, "Rightbracket");
  sdlNames.insert(SDLK_CARET, "Caret");
  sdlNames.insert(SDLK_UNDERSCORE, "Underscore");
  sdlNames.insert(SDLK_BACKQUOTE, "Backquote");
  sdlNames.insert(SDLK_a, "a");
  sdlNames.insert(SDLK_b, "b");
  sdlNames.insert(SDLK_c, "c");
  sdlNames.insert(SDLK_d, "d");
  sdlNames.insert(SDLK_e, "e");
  sdlNames.insert(SDLK_f, "f");
  sdlNames.insert(SDLK_g, "g");
  sdlNames.insert(SDLK_h, "h");
  sdlNames.insert(SDLK_i, "i");
  sdlNames.insert(SDLK_j, "j");
  sdlNames.insert(SDLK_k, "k");
  sdlNames.insert(SDLK_l, "l");
  sdlNames.insert(SDLK_m, "m");
  sdlNames.insert(SDLK_n, "n");
  sdlNames.insert(SDLK_o, "o");
  sdlNames.insert(SDLK_p, "p");
  sdlNames.insert(SDLK_q, "q");
  sdlNames.insert(SDLK_r, "r");
  sdlNames.insert(SDLK_s, "s");
  sdlNames.insert(SDLK_t, "t");
  sdlNames.insert(SDLK_u, "u");
  sdlNames.insert(SDLK_v, "v");
  sdlNames.insert(SDLK_w, "w");
  sdlNames.insert(SDLK_x, "x");
  sdlNames.insert(SDLK_y, "y");
  sdlNames.insert(SDLK_z, "z");
  sdlNames.insert(SDLK_DELETE, "Delete");
  sdlNames.insert(SDLK_KP0, "Numpad 0");
  sdlNames.insert(SDLK_KP1, "Numpad 1");
  sdlNames.insert(SDLK_KP2, "Numpad 2");
  sdlNames.insert(SDLK_KP3, "Numpad 3");
  sdlNames.insert(SDLK_KP4, "Numpad 4");
  sdlNames.insert(SDLK_KP5, "Numpad 5");
  sdlNames.insert(SDLK_KP6, "Numpad 6");
  sdlNames.insert(SDLK_KP7, "Numpad 7");
  sdlNames.insert(SDLK_KP8, "Numpad 8");
  sdlNames.insert(SDLK_KP9, "Numpad 9");
  sdlNames.insert(SDLK_KP_PERIOD, "Numpad Period");
  sdlNames.insert(SDLK_KP_DIVIDE, "Numpad Divide");
  sdlNames.insert(SDLK_KP_MULTIPLY, "Numpad Multiply");
  sdlNames.insert(SDLK_KP_PLUS, "Numpad Plus");
  sdlNames.insert(SDLK_KP_MINUS, "Numpad Minus");
  sdlNames.insert(SDLK_KP_ENTER, "Numpad Enter");
  sdlNames.insert(SDLK_KP_EQUALS, "Numpad Equals");
  sdlNames.insert(SDLK_UP, "Up");
  sdlNames.insert(SDLK_DOWN, "Down");
  sdlNames.insert(SDLK_RIGHT, "Right");
  sdlNames.insert(SDLK_LEFT, "Left");
  sdlNames.insert(SDLK_INSERT, "Insert");
  sdlNames.insert(SDLK_HOME, "Home");
  sdlNames.insert(SDLK_END, "End");
  sdlNames.insert(SDLK_PAGEUP, "Page Up");
  sdlNames.insert(SDLK_PAGEDOWN, "Page Down");
  sdlNames.insert(SDLK_F1, "F1");
  sdlNames.insert(SDLK_F2, "F2");
  sdlNames.insert(SDLK_F3, "F3");
  sdlNames.insert(SDLK_F4, "F4");
  sdlNames.insert(SDLK_F5, "F5");
  sdlNames.insert(SDLK_F6, "F6");
  sdlNames.insert(SDLK_F7, "F7");
  sdlNames.insert(SDLK_F8, "F8");
  sdlNames.insert(SDLK_F9, "F9");
  sdlNames.insert(SDLK_F10, "F10");
  sdlNames.insert(SDLK_F11, "F11");
  sdlNames.insert(SDLK_F12, "F12");
  sdlNames.insert(SDLK_F13, "F13");
  sdlNames.insert(SDLK_F14, "F14");
  sdlNames.insert(SDLK_F15, "F15");
  sdlNames.insert(SDLK_NUMLOCK, "Numlock");
  sdlNames.insert(SDLK_CAPSLOCK, "Capslock");
  sdlNames.insert(SDLK_SCROLLOCK, "Scrollock");
  sdlNames.insert(SDLK_RSHIFT, "Rshift");
  sdlNames.insert(SDLK_LSHIFT, "Lshift");
  sdlNames.insert(SDLK_RCTRL, "Rctrl");
  sdlNames.insert(SDLK_LCTRL, "Lctrl");
  sdlNames.insert(SDLK_RALT, "Ralt");
  sdlNames.insert(SDLK_LALT, "Lalt");
  sdlNames.insert(SDLK_RMETA, "Rmeta");
  sdlNames.insert(SDLK_LMETA, "Lmeta");
  sdlNames.insert(SDLK_LSUPER, "Lsuper");
  sdlNames.insert(SDLK_RSUPER, "Rsuper");
  sdlNames.insert(SDLK_MODE, "Mode");
  sdlNames.insert(SDLK_COMPOSE, "Compose");
  sdlNames.insert(SDLK_HELP, "Help");
  sdlNames.insert(SDLK_PRINT, "Print");
  sdlNames.insert(SDLK_SYSREQ, "Sysreq");
  sdlNames.insert(SDLK_BREAK, "Break");
  sdlNames.insert(SDLK_MENU, "Menu");
  sdlNames.insert(SDLK_POWER, "Power");
  sdlNames.insert(SDLK_EURO, "Euro");
  sdlNames.insert(SDLK_UNDO, "Undo");
}
