/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.behavior;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.action.Action;
import com.group_finity.mascot.action.ActionBase;
import com.group_finity.mascot.behavior.Behavior;
import com.group_finity.mascot.config.Configuration;
import com.group_finity.mascot.environment.MascotEnvironment;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.CantBeAliveException;
import com.group_finity.mascot.exception.LostGroundException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.hotspot.Hotspot;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class UserBehavior
implements Behavior {
    private static final Logger log = Logger.getLogger(UserBehavior.class.getName());
    public static final String BEHAVIOURNAME_FALL = "Fall";
    public static final String BEHAVIOURNAME_DRAGGED = "Dragged";
    public static final String BEHAVIOURNAME_THROWN = "Thrown";
    private final String name;
    private final Configuration configuration;
    private final Action action;
    private Mascot mascot;
    private boolean hidden;

    public UserBehavior(String name, Action action, Configuration configuration, boolean hidden) {
        this.name = name;
        this.configuration = configuration;
        this.action = action;
        this.hidden = hidden;
    }

    public String toString() {
        return "Behavior(" + this.getName() + ")";
    }

    @Override
    public synchronized void init(Mascot mascot) throws CantBeAliveException {
        block4: {
            this.setMascot(mascot);
            log.log(Level.INFO, "Default Behavior({0},{1})", new Object[]{this.getMascot(), this});
            try {
                this.getAction().init(mascot);
                if (this.getAction().hasNext()) break block4;
                try {
                    mascot.setBehavior(this.getConfiguration().buildBehavior(this.getName(), mascot));
                }
                catch (BehaviorInstantiationException e) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedInitialiseFollowingBehaviourErrorMessage"), e);
                }
            }
            catch (VariableException e) {
                throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("VariableEvaluationErrorMessage"), e);
            }
        }
    }

    private Configuration getConfiguration() {
        return this.configuration;
    }

    private Action getAction() {
        return this.action;
    }

    private String getName() {
        return this.name;
    }

    @Override
    public synchronized void mousePressed(MouseEvent event) throws CantBeAliveException {
        if (SwingUtilities.isLeftMouseButton(event)) {
            boolean handled = false;
            if (!this.mascot.getHotspots().isEmpty()) {
                for (Hotspot hotspot : this.mascot.getHotspots()) {
                    if (!hotspot.contains(this.mascot, event.getPoint())) continue;
                    handled = true;
                    try {
                        this.getMascot().setCursorPosition(event.getPoint());
                        this.getMascot().setBehavior(this.configuration.buildBehavior(hotspot.getBehaviour()));
                        break;
                    }
                    catch (BehaviorInstantiationException e) {
                        throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedInitialiseFollowingBehaviourErrorMessage") + " " + hotspot.getBehaviour(), e);
                    }
                }
            }
            if (!handled && this.action != null && this.action instanceof ActionBase) {
                try {
                    handled = ((ActionBase)this.action).isDraggable() == false;
                }
                catch (VariableException ex) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedDragActionInitialiseErrorMessage"), ex);
                }
            }
            if (!handled) {
                try {
                    this.getMascot().setBehavior(this.configuration.buildBehavior(this.configuration.getSchema().getString(BEHAVIOURNAME_DRAGGED)));
                }
                catch (BehaviorInstantiationException e) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedDragActionInitialiseErrorMessage"), e);
                }
            }
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent event) throws CantBeAliveException {
        if (SwingUtilities.isLeftMouseButton(event)) {
            if (this.getMascot().isHotspotClicked()) {
                this.getMascot().setCursorPosition(null);
            }
            if (this.getMascot().isDragging()) {
                try {
                    this.getMascot().setDragging(false);
                    this.getMascot().setBehavior(this.configuration.buildBehavior(this.configuration.getSchema().getString(BEHAVIOURNAME_THROWN)));
                }
                catch (BehaviorInstantiationException e) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedDropActionInitialiseErrorMessage"), e);
                }
            }
        }
    }

    @Override
    public synchronized void next() throws CantBeAliveException {
        block19: {
            try {
                if (this.getAction().hasNext()) {
                    this.getAction().next();
                }
                boolean hotspotIsActive = false;
                if (this.getMascot().isHotspotClicked()) {
                    if (!this.mascot.getHotspots().isEmpty()) {
                        for (Hotspot hotspot : this.mascot.getHotspots()) {
                            if (!hotspot.contains(this.mascot, this.mascot.getCursorPosition())) continue;
                            hotspotIsActive = true;
                            try {
                                this.getMascot().setBehavior(this.configuration.buildBehavior(hotspot.getBehaviour()));
                                break;
                            }
                            catch (BehaviorInstantiationException e) {
                                throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedInitialiseFollowingBehaviourErrorMessage") + " " + hotspot.getBehaviour(), e);
                            }
                        }
                    }
                    if (!hotspotIsActive) {
                        this.getMascot().setCursorPosition(null);
                    }
                }
                if (hotspotIsActive) break block19;
                if (this.getAction().hasNext()) {
                    if (!(this.getMascot().getBounds().getX() + this.getMascot().getBounds().getWidth() <= (double)this.getEnvironment().getScreen().getLeft()) && !((double)this.getEnvironment().getScreen().getRight() <= this.getMascot().getBounds().getX()) && !((double)this.getEnvironment().getScreen().getBottom() <= this.getMascot().getBounds().getY())) break block19;
                    log.log(Level.INFO, "Out of the screen bounds({0},{1})", new Object[]{this.getMascot(), this});
                    if (Boolean.parseBoolean(Main.getInstance().getProperties().getProperty("Multiscreen", "true"))) {
                        this.getMascot().setAnchor(new Point((int)(Math.random() * (double)(this.getEnvironment().getScreen().getRight() - this.getEnvironment().getScreen().getLeft())) + this.getEnvironment().getScreen().getLeft(), this.getEnvironment().getScreen().getTop() - 256));
                    } else {
                        this.getMascot().setAnchor(new Point((int)(Math.random() * (double)(this.getEnvironment().getWorkArea().getRight() - this.getEnvironment().getWorkArea().getLeft())) + this.getEnvironment().getWorkArea().getLeft(), this.getEnvironment().getWorkArea().getTop() - 256));
                    }
                    try {
                        this.getMascot().setBehavior(this.getConfiguration().buildBehavior(this.configuration.getSchema().getString(BEHAVIOURNAME_FALL)));
                        break block19;
                    }
                    catch (BehaviorInstantiationException e) {
                        throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedFallingActionInitialiseErrorMessage"), e);
                    }
                }
                log.log(Level.INFO, "Completed Behavior ({0},{1})", new Object[]{this.getMascot(), this});
                try {
                    this.getMascot().setBehavior(this.getConfiguration().buildBehavior(this.getName(), this.getMascot()));
                }
                catch (BehaviorInstantiationException e) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedInitialiseFollowingActionsErrorMessage"), e);
                }
            }
            catch (LostGroundException e) {
                log.log(Level.INFO, "Lost Ground ({0},{1})", new Object[]{this.getMascot(), this});
                try {
                    this.getMascot().setCursorPosition(null);
                    this.getMascot().setDragging(false);
                    this.getMascot().setBehavior(this.configuration.buildBehavior(this.configuration.getSchema().getString(BEHAVIOURNAME_FALL)));
                }
                catch (BehaviorInstantiationException ex) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedFallingActionInitialiseErrorMessage"), e);
                }
            }
            catch (VariableException e) {
                throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("VariableEvaluationErrorMessage"), e);
            }
        }
    }

    private void setMascot(Mascot mascot) {
        this.mascot = mascot;
    }

    private Mascot getMascot() {
        return this.mascot;
    }

    protected MascotEnvironment getEnvironment() {
        return this.getMascot().getEnvironment();
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }
}

