/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.virtual;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.environment.Area;
import com.group_finity.mascot.environment.Environment;
import com.group_finity.mascot.virtual.VirtualContentPanel;
import com.group_finity.mascot.virtual.VirtualTranslucentPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

class VirtualEnvironment
extends Environment {
    private final JFrame display = new JFrame();
    private final Area activeIE = new Area();

    VirtualEnvironment() {
    }

    @Override
    public Area getWorkArea() {
        return this.getScreen();
    }

    @Override
    public Area getActiveIE() {
        return this.activeIE;
    }

    @Override
    public String getActiveIETitle() {
        return null;
    }

    @Override
    public void moveActiveIE(Point point) {
    }

    @Override
    public void restoreIE() {
    }

    @Override
    public void refreshCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (!this.display.isVisible()) {
            this.display.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    Main.getInstance().exit();
                }

                @Override
                public void windowClosed(WindowEvent e) {
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowActivated(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }
            });
            this.display.setAutoRequestFocus(false);
            this.display.setTitle(Main.getInstance().getLanguageBundle().getString("ShimejiEE"));
            String[] windowArray = Main.getInstance().getProperties().getProperty("WindowSize", "600x500").split("x");
            BufferedImage image = null;
            try {
                if (!Main.getInstance().getProperties().getProperty("BackgroundImage", "").isEmpty()) {
                    image = ImageIO.read(new File(Main.getInstance().getProperties().getProperty("BackgroundImage", "")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.display.setContentPane(new VirtualContentPanel(new Dimension(Integer.parseInt(windowArray[0]), Integer.parseInt(windowArray[1])), Color.decode(Main.getInstance().getProperties().getProperty("Background", "#00FF00")), image, Main.getInstance().getProperties().getProperty("BackgroundMode", "centre")));
            this.display.setBackground(this.display.getContentPane().getBackground());
            BufferedImage icon = null;
            try {
                icon = ImageIO.read(Main.class.getResource("/icon.png"));
            }
            catch (Exception exception) {
            }
            finally {
                if (icon == null) {
                    icon = new BufferedImage(16, 16, 1);
                }
            }
            this.display.setIconImage(icon);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VirtualEnvironment.this.display.pack();
                    VirtualEnvironment.this.display.setVisible(true);
                    VirtualEnvironment.this.display.toFront();
                }
            });
            this.activeIE.set(new Rectangle(-500, -500, 0, 0));
            screenRect.setBounds(this.display.getContentPane().getBounds());
        }
        this.tick();
    }

    @Override
    public void tick() {
        if (this.display.isVisible()) {
            screenRect.setBounds(this.display.getContentPane().getBounds());
            this.screen.set(screenRect);
        }
        PointerInfo info = MouseInfo.getPointerInfo();
        Point point = new Point(0, 0);
        if (info != null && this.display.isVisible()) {
            point = info.getLocation();
            SwingUtilities.convertPointFromScreen(point, this.display.getContentPane());
        }
        this.cursor.set(point);
    }

    @Override
    public void dispose() {
        if (this.display != null) {
            this.display.dispose();
        }
    }

    public void addShimeji(final VirtualTranslucentPanel shimeji) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (((VirtualEnvironment)VirtualEnvironment.this).display.getContentPane().getSize().width > 0 && ((VirtualEnvironment)VirtualEnvironment.this).display.getContentPane().getSize().height > 0) {
                    VirtualEnvironment.this.display.setPreferredSize(VirtualEnvironment.this.display.getSize());
                    VirtualEnvironment.this.display.getRootPane().setPreferredSize(VirtualEnvironment.this.display.getRootPane().getSize());
                    VirtualEnvironment.this.display.getContentPane().setPreferredSize(VirtualEnvironment.this.display.getContentPane().getSize());
                }
                shimeji.setOpaque(false);
                VirtualEnvironment.this.display.getContentPane().add(shimeji);
            }
        });
    }
}

