import { Mark } from 'prosemirror-model'
import { EditorState, Transaction } from 'prosemirror-state'

import { schema } from './schema'
import { mergeTransactionSteps } from './util'

export const updateOriginMarks = (tr: Transaction, state: EditorState): Transaction => {
    const mergedSteps = mergeTransactionSteps(tr, [])
    for (const step of mergedSteps) {
        let replacedIsEdit = false
        step.getMap().forEach((oldStart, oldEnd, newStart, newEnd) => {
            state.doc.nodesBetween(oldStart, oldEnd, (node, pos, parent) => {
                // check if replaced text is ai or edited text
                if (replacedIsEdit) return false
                if (
                    node.marks.some(
                        (mark) =>
                            mark.eq(schema.mark(schema.marks.ai_text)) || mark.eq(schema.mark(schema.marks.edit_text))
                    )
                ) {
                    replacedIsEdit = true
                }
                if (!parent) return true
                // only descend one level into the tree
                return parent.type.name === 'paragraph' ? false : true
            })
            // check if change touches ai or edit to the left
            let prevIsEdit = false
            if (oldStart > 0) {
                let prevNodeMarks = [] as readonly Mark[]
                state.doc.nodesBetween(oldStart - 1, oldStart, (node, pos, parent) => {
                    prevNodeMarks = node.marks
                    if (!parent) return true
                    return parent.type.name === 'paragraph' ? false : true
                })
                prevIsEdit = prevNodeMarks.some(
                    (mark) => mark.eq(schema.mark(schema.marks.edit_text)) || mark.eq(schema.mark(schema.marks.ai_text))
                )
            }
            // check if change touches ai or edit to the right
            let nextIsEdit = false
            if (oldEnd < state.doc.content.size) {
                let nextNodeMarks = [] as readonly Mark[]
                state.doc.nodesBetween(oldEnd, oldEnd + 1, (node, pos, parent) => {
                    nextNodeMarks = node.marks
                    if (!parent) return true
                    return parent.type.name === 'paragraph' ? false : true
                })
                nextIsEdit = nextNodeMarks.some(
                    (mark) => mark.eq(schema.mark(schema.marks.edit_text)) || mark.eq(schema.mark(schema.marks.ai_text))
                )
            }
            if ((replacedIsEdit && prevIsEdit) || (replacedIsEdit && nextIsEdit)) {
                tr.addMark(newStart, newEnd, schema.mark(schema.marks.edit_text))
                return
            } else if (prevIsEdit && nextIsEdit) {
                tr.addMark(newStart, newEnd, schema.mark(schema.marks.edit_text))
            } else {
                tr.addMark(newStart, newEnd, schema.mark(schema.marks.user_text))
            }
        })
    }
    return tr
}
