
const dir = './groups'
const adventureDir = './textAdventure'
const fs = require('fs')

async function format(dir, filename) {
    console.log(`Formatting files in '${dir}'`)
    const authors = fs.readdirSync(dir)
    for (const author of authors) {
        const scenarios = fs.readdirSync(dir + '/' + author)
        for (const scenario of scenarios) {
            const subScenarios = fs.readdirSync(dir + '/' + author + '/' + scenario)
            for (const subScenario of subScenarios) {
                const scenarioFiles = fs.readdirSync(dir + '/' + author + '/' + scenario + '/' + subScenario)
                for (const file of scenarioFiles) {
                    const filecontents = fs.readFileSync(dir + '/' + author + '/' + scenario + '/' + subScenario + '/' + file, 'utf-8')
                    fs.writeFileSync(dir + '/' + author + '/' + scenario + '/' + subScenario + '/' + file, JSON.stringify(JSON.parse(filecontents), undefined, '  '))
                }
            }
        }
    }
}

format(dir)
format(adventureDir)
