﻿import { Theme } from '../../shared/styles/themes/theme'

const pat = new RegExp('[^",]*(?=("?$)|("?,))')

export function sanitizeTheme(theme: Theme): Theme {
    let newFonts = theme.fonts
    for (let [key, value] of Object.entries(newFonts)) {
        const match = value.match(pat) ?? ['']
        newFonts = { ...newFonts, [key]: match[0] }
    }
    const newTheme = { ...theme, fonts: { ...newFonts } }
    return newTheme
}

export function getInternalFontName(name: string, bold: boolean, italic: boolean): string {
    name = name.replace(/\s/g, '').toLowerCase()
    if (bold) name = name + '_bold'
    if (italic) name = name + '_italic'
    return name
}
