﻿import { Platform } from 'react-native'
import AsyncStorage from '@react-native-async-storage/async-storage';

export async function getLocalStorage(name: string): Promise<string | null> {
    try {
        return await AsyncStorage.getItem(name) ?? null
    } catch {
        return null
    }
}

export async function setLocalStorage(name: string, value: string): Promise<void> {
    try {
        return await AsyncStorage.setItem(name, value)
    } catch {
        return
    }
}

export async function removeLocalStorage(name: string): Promise<void> {
    try {
        return await AsyncStorage.removeItem(name)
    } catch {
        return
    }
}

export function getSessionStorage(name: string): string | null {
    return null
}

export function setSessionStorage(name: string, value: string): void {
    return
}

export function removeSessionStorage(name: string): void {
    return
}
