﻿import { serialize } from 'serializr'
import { v4 as uuid } from 'uuid'
import { LoreEntry, isRegexKey } from '../../shared/data/ai/loreentry'
import { LorebookCategory } from '../../shared/data/story/lorebook'
import { StoryContent } from '../../shared/data/story/storycontainer'

export function createLorebookEntry(currentStoryContent?: StoryContent, categoryId: string = ''): LoreEntry {
    if (!currentStoryContent) {
        return new LoreEntry()
    }

    let newEntry = LoreEntry.deserialize(
        JSON.stringify(serialize(LoreEntry, currentStoryContent.contextDefaults.loreDefaults[0]))
    )
    if (categoryId !== '') {
        const category = currentStoryContent.lorebook.categories.find((c: LorebookCategory) => {
            return c.id === categoryId
        })
        if (category !== undefined) {
            newEntry = LoreEntry.deserialize(JSON.stringify(serialize(LoreEntry, category.categoryDefaults)))
        }
    }

    newEntry.id = uuid()
    newEntry.category = categoryId
    newEntry.lastUpdatedAt = new Date()
    return newEntry
}

export const addKeyToEntry = (
    key: string,
    entry: LoreEntry,
    save: () => void,
    setDisplayName: (name: string) => void
): void => {
    if (key.length > 250) {
        key = key.slice(0, 250)
    }
    if (!entry.keys.includes(key) && key !== '') {
        if (isRegexKey(key).isRegex) {
            entry.keys.push(key)
        } else {
            const keys = key.split(/, ?/)
            for (const key of keys) {
                if (entry.displayName === 'New Lorebook Entry') {
                    entry.displayName = key.trim()
                    setDisplayName(key.trim())
                }
                const trimmedKey = key.trim().toLocaleLowerCase()
                if (!entry.keys.includes(trimmedKey)) {
                    entry.keys.push(key.trim())
                }
            }
        }

        entry.lastUpdatedAt = new Date()
        save()
    }
}
