import { logError } from '../../shared/util/browser'
import Encoder, { EncoderType, loadEncoder } from './encoder'
import { getTokenizerExtraTokens, getTokenizerFileUrl } from './util'

const GlobalEncoders = new Map<EncoderType, Encoder>()

export async function prepareGlobalEncoder(tokenizer: EncoderType): Promise<void> {
    const encoder = GlobalEncoders.get(tokenizer)
    if (!encoder) {
        const newEncoder = await loadEncoder(
            getTokenizerFileUrl(tokenizer),
            getTokenizerExtraTokens(tokenizer)
        )
        GlobalEncoders.set(tokenizer, newEncoder)
    }
}

export function getGlobalEncoder(tokenizer: EncoderType): Encoder {
    const encoder = GlobalEncoders.get(tokenizer)
    if (!encoder) throw 'GlobalEncoder called without prepare being called'
    return encoder
}

export class WorkerInterface {
    async encode(text: string, encoderType: EncoderType): Promise<number[]> {
        await prepareGlobalEncoder(encoderType)
        const encoder = getGlobalEncoder(encoderType)
        return encoder.encode(text)
    }

    async decode(tokens: any[], encoderType: EncoderType, timeout: number = 20000): Promise<string> {
        await prepareGlobalEncoder(encoderType)
        const encoder = getGlobalEncoder(encoderType)
        return encoder.decode(tokens)
    }
}
