﻿import styled from 'styled-components/native'
import { InkIcon } from '../common/icons'
import { BodyLarge600M, HeadingMedium600M, HeadingSmall700M } from '../../styles/fonts'
import { ModalCloseButton } from './common'

export const UsageContainer = styled.View`
    background-color: ${(props) => props.theme.colors.textHeadings};
    padding: 17px 20px 15px;
`

export const UsageTopRow = styled.View`
    flex-direction: row;
    justify-content: space-between;
    align-items: center;
`

export const UsageBarOuter = styled.View`
    background-color: ${(props) => props.theme.colors.bg0};
    margin-top: 8px;
    padding: 5px;
`

export const UsageBarInner = styled.View<{ width: number }>`
    background-color: ${(props) => props.theme.colors.textHeadings};
    height: 10px;
`

export const UsageTitle = styled.Text`
    ${HeadingSmall700M}
    color: ${(props) => props.theme.colors.bg0};
`

export const UsageText = styled.Text`
    ${BodyLarge600M};
    color: ${(props) => props.theme.colors.bg0};
`

export const StyledModalCloseButton = styled(ModalCloseButton)`
    position: absolute;
    right: 10px;
    top: 10px;
    padding: 10px;
`

export const BigInkwell = styled(InkIcon).attrs((props) => ({
    primary: props.theme.colors.textHeadings,
    height: 50,
    width: 50,
}))`
    margin-top: 30px;
    margin-bottom: 20px;
`

export const ModalHeading = styled.Text`
    ${HeadingMedium600M}
    color: ${(props) => props.theme.colors.textHeadings};
`
