﻿import React from 'react'
import { Modal, ModalProps, StyleProp, TextStyle, ViewStyle } from 'react-native'
import { HeadingLarge600 } from '../../styles/fonts'
import { ModalView, InnerView, TitleRow, CloseButton, CloseButtonCross } from './common.style'

export function ModalTitleRow(props: {
    title: string
    onClose: () => void
    titleStyle?: StyleProp<TextStyle>
    transparent?: boolean
}): JSX.Element {
    return (
        <TitleRow transparent={props.transparent ?? false}>
            <HeadingLarge600 style={props.titleStyle}>{props.title}</HeadingLarge600>
            <ModalCloseButton onClose={props.onClose} />
        </TitleRow>
    )
}

export function ModalCloseButton(props: { onClose: () => void; style?: StyleProp<ViewStyle> }): JSX.Element {
    return (
        <CloseButton onPress={props.onClose} style={props.style}>
            <CloseButtonCross />
        </CloseButton>
    )
}

export function HoverModal(props: { innerStyle?: StyleProp<ViewStyle> } & ModalProps): JSX.Element {
    return (
        <Modal transparent={true} animationType={'fade'} {...props}>
            <ModalView onPress={props.onRequestClose}>
                <InnerView style={props.innerStyle}>{props.children}</InnerView>
            </ModalView>
        </Modal>
    )
}
