﻿import styled, { css } from 'styled-components/native'
import Icon from 'react-native-vector-icons/MaterialIcons'
import {
    HeartEnabledIcon,
    HeartDisabledIcon,
    FolderIcon,
    TrashIcon,
    CopyIcon,
    ExportIcon,
    PenWritingIcon,
    LibraryIcon,
} from '../common/icons'
import { HeadingMedium500M, BodyMedium400M, SoftFade } from '../../styles/fonts'
import { TextHighlight } from '../util/texthighlight'

export const Story = styled.Pressable<{ selected: boolean; focused: boolean }>`
    cursor: pointer;
    padding: 10px 20px 20px;
    position: relative;

    transition: ${(props) => props.theme.transitions.interactive};
    background: ${(props) => (props.selected || props.focused ? props.theme.colors.bg2 : 'transparent')};
    ${(props) =>
        props.selected && !props.focused && false //disabled because it looks dumb
            ? css`
                  border-width: 1px;
                  border: 1px solid ${props.theme.colors.bg3};
                  border-radius: 3px;
                  padding: 4px 14px 14px;
                  margin: 5px;
              `
            : 'padding: 10px 20px 20px;'}
`

export const StoryTitle = styled(TextHighlight).attrs(() => ({ lines: 1 }))`
    ${HeadingMedium500M};
    ${SoftFade}
    padding-right: 35px;
`

export const StoryContent = styled.View.attrs(() => ({
    numberOfLines: 1,
}))`
    ${BodyMedium400M};
    ${SoftFade}
    transition: opacity ${(props) => props.theme.transitions.interactive};
    overflow: hidden;
`

export const StoryMetadataInfo = styled.Text`
    ${BodyMedium400M};
    margin-top: 10px;
    opacity: 0.35;
`

export const StoryFavorite = styled.Pressable`
    position: absolute;
    right: -10px;
    margin-top: 5px;
`

export const HeartEnabled = styled(HeartEnabledIcon).attrs((props) => ({
    primary: props.theme.colors.textHeadings,
    height: 20,
    width: 20,
}))``

export const HeartDisabled = styled(HeartDisabledIcon).attrs((props) => ({
    primary: props.theme.colors.textHeadings,
    height: 20,
    width: 20,
}))``

export const ParentView = styled.View`
    flex-direction: row;
`

export const Folder = styled(FolderIcon).attrs((props) => ({
    primary: props.theme.colors.textMain,
    height: 16,
    width: 16,
}))`
    margin-top: 10px;
    margin-right: 5px;
    margin-left: 1px;
`

export const StoryRemoteDone = styled(Icon).attrs(() => ({
    name: 'cloud-done',
    size: 20,
}))`
    color: ${(props) => props.theme.colors.textMain};
    position: absolute;
    right: 10px;
    opacity: 0.2;
    bottom: 20px;
`
export const StoryRemoteUpload = styled(Icon).attrs(() => ({
    name: 'cloud-upload',
    size: 20,
}))`
    color: ${(props) => props.theme.colors.textMain};
    position: absolute;
    right: 10px;
    opacity: 0.2;
    bottom: 20px;
`

export const StoryTags = styled.View<{ maxFontSizeMultiplier?: 0.8 }>`
    margin-top: 15px;
    display: flex;
    flex-wrap: wrap;
    background: ${(props) => props.theme.colors.bg0};
    padding: 10px;
    margin-right: 10px;
`

export const ButtonsRow = styled.View`
    flex-direction: row;
    margin-top: 10px;
`

export const ButtonView = styled.TouchableHighlight.attrs((props) => ({
    underlayColor: props.theme.colors.bg0,
}))`
    background-color: ${(props) => props.theme.colors.bg3};
    margin-right: 7px;
    padding: 12px;
`

export const Delete = styled(TrashIcon).attrs((props) => ({
    primary: props.theme.colors.textMain,
}))`
    padding: 8px;
`

export const Duplicate = styled(CopyIcon).attrs((props) => ({
    primary: props.theme.colors.textMain,
}))`
    padding: 8px;
`

export const Download = styled(ExportIcon).attrs((props) => ({
    primary: props.theme.colors.textMain,
}))`
    padding: 8px;
`

export const Edit = styled(PenWritingIcon).attrs((props) => ({
    primary: props.theme.colors.textMain,
    height: 16,
    width: 16,
}))``

export const StyledShelfElement = styled.Pressable<{ selected: boolean }>`
    background-color: ${(props) => (props.selected ? props.theme.colors.bg2 : props.theme.colors.bg1)};
    border: 1px solid ${(props) => props.theme.colors.bg3};
    border-radius: 3px;
    opacity: ${(props) => (props.selected ? '1.0' : '0.7')};
    padding: 5px 15px 15px;
    margin: 5px;
`

export const ShelfButtonsRow = styled.View`
    flex-direction: row;
    position: absolute;
    right: 10px;
    top: 0;
    margin: 5px 0px;
`

export const ShelfButtonView = styled.TouchableHighlight.attrs((props) => ({
    underlayColor: props.theme.colors.bg0,
}))`
    background-color: ${(props) => props.theme.colors.bg3};
    margin-left: 7px;
    padding: 10px;
`

export const ShelfTitleRow = styled.View`
    flex-direction: row;
`

export const ShelfIcon = styled(FolderIcon).attrs((props) => ({
    fill: props.theme.colors.textMain,
}))`
    margin-top: 4px;
    margin-right: 5px;
    margin-left: 1px;
`

export const BottomSpacer = styled.View`
    height: 25px;
`

export const StyledStoryListPlaceholder = styled.View`
    flex: 1;
    justify-content: center;
    align-items: center;
    padding: 10px;
`

export const LargeLookingGlassIcon = styled(Icon).attrs(() => ({
    name: 'search-off',
    size: 100,
}))`
    color: ${(props) => props.theme.colors.textMain};
    opacity: 0.2;
`

export const Library = styled(LibraryIcon).attrs((props) => ({
    primary: props.theme.colors.textMain,
    width: 100,
    height: 100,
}))`
    margin: -20px;
`
