﻿import styled from 'styled-components/native'
import background from '../../assets/images/landing/background.svg'
import { HeadingMedium600M, HeadingLarge600M, BodyMedium600M, BodyXL600M } from '../../styles/fonts'
import LeftArrow from '../../assets/images/left-arrow.svg'

export const StyledBar = styled.View`
    width: 100%;
`

export const ContentView = styled.View`
    padding: 30px;
    width: 100%;
    height: 100%;
`

export const BackgroundSplash = styled(background).attrs((props) => ({
    height: '100%',
    width: '100%',
    fill: props.theme.colors.bg3,
}))`
    background-color: ${(props) => props.theme.colors.bg2};
    position: absolute;
    z-index: -1;
    elevation: -1;
`

export const BackButton = styled.TouchableOpacity`
    width: 100px;
    flex-direction: row;
    align-items: center;
    padding: 4px 4px 4px 0px;
`

export const BackText = styled.Text`
    ${HeadingMedium600M};
    margin: 1px 0px -1px 10px;
`

export const BackArrow = styled(LeftArrow).attrs((props) => ({
    fill: props.theme.colors.textMain,
    width: 9,
    height: 19,
}))``

export const OtherScreenButton = styled.TouchableOpacity`
    width: 100px;
    position: absolute;
    right: 0px;
    padding: 4px;
    align-items: flex-end;
`

export const FieldView = styled.View`
    margin: 5px 0px;
`

export const FieldInput = styled.TextInput`
    background-color: ${(props) => props.theme.colors.bg0}
    margin: 11px 0px;
    padding: 10px;
    ${BodyMedium600M};
`

export const GreetingText = styled.Text`
    ${HeadingLarge600M};
    font-size: 32px;
    line-height: 57px;
`

export const TopGreetingText = styled.Text`
    ${BodyXL600M};
    color: ${(props) => props.theme.colors.textHeadings};
    margin-top: 50px;
`
