# next-pwa - custom worker example

[TOC]

This example demonstrates how to use `next-pwa` plugin to turn a `next.js` based web application into a progressive web application easily. It demonstrates how to add custom worker code to the service worker generated by workbox.

## New Method

Simply create a `worker/index.js` and start implementing your service worker. `next-pwa` will detect this file automatically, and bundle the file into `dest` as `worker-*.js` using `webpack`. It's also automatically injected into `sw.js` generated.

In this way, you get benefit of code splitting and size minimization automatically. Yes! `require` modules works! Yes! you can share codes between web app and the service worker!

> - Typescript support for `worker/index.ts` current not supported.
>
> - In dev mode, `worker/index.js` is not watch, so it will not hot reload.

### Custom Worker Directory

You can customize the directory of your custom worker file by setting the `customWorkerDir` relative to the `basedir` in the `pwa` section of your `next.config.js`:


``` javascript
const withPWA = require('next-pwa')

module.exports = withPWA({
  pwa: {
    customWorkerDir: 'serviceworker'
    ...
  }
})
```

In this example, `next-pwa` would look for `serviceworker/index.js`.


## Old Method (Still Works)

Basically you need to create a file such as `worker.js` in `public` folder, then add an option `importScripts` to `pwa` object in `next.config.js`:

``` javascript
const withPWA = require('next-pwa')

module.exports = withPWA({
  pwa: {
    dest: 'public',
    importScripts: ['/worker.js']
  }
})
```

Then service worker generated will automatically import your code and run it before other workbox code.

## Usage

[![Open in Gitpod](https://img.shields.io/badge/Open%20In-Gitpod.io-%231966D2?style=for-the-badge&logo=gitpod)](https://gitpod.io/#https://github.com/shadowwalker/next-pwa/)

``` bash
cd examples/custom-server
yarn install
yarn build
yarn start
```

## Recommend `.gitignore`

```
**/public/workbox-*.js
**/public/sw.js
**/public/worker-*.js
```



