import random
from concurrent.futures import ThreadPoolExecutor
from pathlib import Path

from scraper.log import root_logger
from scraper.webring.download import webring_download_card

logger = root_logger.get_child('WEBRING.IMGUR')


def download_from_imgur(url_list, output_path, download_threads):
    url_list = list(url_list)
    random.shuffle(url_list)
    num_valid = 0

    def process_url(webring_domain, img_url):
        valid_card, _, file_name, error = webring_download_card(Path(output_path, webring_domain), img_url, ignore_429=True)
        logger.debug(img_url)
        if valid_card:
            return True, img_url, file_name
        else:
            return False, img_url, None, error

    with ThreadPoolExecutor(max_workers=download_threads) as executor:
        for valid_card, img_url, file_name, error in executor.map(lambda x: process_url(*x), url_list):
            if valid_card:
                logger.info(f'YES - {img_url} - "{file_name}"')
                num_valid += 1
            else:
                logger.info(f'NO - {img_url} - {error}')

    return num_valid
