from scraper import http_queue
from scraper.catbox.download import generic_download
from scraper.webring.insert import insert_webring_character


def webring_download_card(author_site, hashed_data_path, image_url, ignore_429=False):
    r = http_queue.add(image_url, method='HEAD', suicide_on_429=(not ignore_429))
    if not r:
        return False, image_url, 'Connection failed'
    elif r.status_code == 429:
        return False, image_url, '429 error'
    if r.headers.get('Content-Type', 'image/png') != 'image/png':
        return False, image_url, None  # 'Bad filetype'

    card_raw, card_parsed, img_bytes, _, err = generic_download(image_url, hashed_data_path, allow_non_catbox=True, specific_source='webring')
    if card_raw is None or card_parsed is None or img_bytes is None or err is not None:
        return False, image_url, err

    is_new_item = insert_webring_character(card_parsed, img_bytes, card_raw, source_url=None, author=author_site)
    return is_new_item, image_url, None
