def sort_dict(d):
    if isinstance(d, dict):
        return {k: sort_dict(v) for k, v in sorted(d.items())}
    elif isinstance(d, list):
        return sorted([sort_dict(x) if isinstance(x, (dict, list)) else x for x in d], key=str)
    else:
        return d
