from concurrent.futures import ThreadPoolExecutor, as_completed
from datetime import datetime
from typing import List

from scraper.log import root_logger
from scraper.risuai.user_process import process_risuai_user
from scraper.stop_event import global_stop_event
from scraper.time import calculate_elapsed_time

logger = root_logger.get_child('RISUAI.USER_RUNNER')


def run_risuai_user_scrape(users: List[str], threads: int):
    start = datetime.now()
    processed_count = 0
    new_users = 0

    with (ThreadPoolExecutor(max_workers=threads) as executor):
        futures = {executor.submit(process_risuai_user, url) for url in users}
        for future in as_completed(futures):
            result = future.result()
            if result is None:
                # The downloader had an error?
                continue
            if global_stop_event.is_set():
                return

            username, is_new_node = result
            if not username:
                # The downloader skipped this item
                continue

            mod_str = ''
            if is_new_node:
                mod_str = '(new)'
                new_users += 1
            processed_count += 1
            logger.info(f'{username} {mod_str}')

    time_str = calculate_elapsed_time(start)
    logger.info(f'-- Users scraping completed in {time_str} --'.upper())
    return processed_count, new_users
