import traceback

from scraper.log import root_logger
from scraper.risuai.fetch import get_risuai_user
from scraper.risuai.user_insert import insert_risuai_user

_logger = root_logger.get_child('RISUAI.USER_PROCESS')


def process_risuai_user(username: str):
    try:
        if username == 'Anonymous':
            return None
        user = get_risuai_user(username)
        if not user:
            _logger.error(f'Failed to fetch user for {username}')
            return None
        new_user = insert_risuai_user(user)
        return username, new_user
    except:
        _logger.error(f'Exception in process_risuai_user for {username} -- {traceback.format_exc()}')
        return None
