from datetime import timezone, datetime

from psycopg2.extras import RealDictCursor

from scraper.database.connection import CursorFromConnectionFromPool
from scraper.log import root_logger
from scraper.risuai.types import RisuaiUser

_logger = root_logger.get_child('CHUB.CHAR.INSERT')


def insert_risuai_user(user: RisuaiUser) -> bool:
    with CursorFromConnectionFromPool(cursor_factory=RealDictCursor) as cursor:
        cursor.execute(
            """
            INSERT INTO risuai_user (username, description, updated)
            VALUES (%s, %s, %s)
            ON CONFLICT (username) DO UPDATE
            SET description = EXCLUDED.description, updated = EXCLUDED.updated
            RETURNING (xmax = 0) AS new_user;
            """,
            (
                user.name, user.description, datetime.now(timezone.utc)
            )
        )
        result = cursor.fetchone()
        return result['new_user']
