from typing import List, Any, Optional, Union

from pydantic import BaseModel, field_validator

from scraper.risuai.stuff import convert_str_to_num


class RisuaiNode(BaseModel):
    name: str
    desc: str
    download: int
    id: str
    img: str
    tags: List[str]
    viewScreen: Any
    hasLore: Optional[bool] = False
    hasEmotion: Optional[bool] = False
    hasAsset: Optional[bool] = False
    creator: str
    authorname: Optional[Union[str]] = 'Anonymous'
    license: str
    hidden: int
    commentopen: Optional[bool] = False
    shared: Optional[Union[bool, int]] = False
    date: int
    original: Any
    type: str
    is_charx: bool

    class Config:
        validate_assignment = True

    @property
    def img_url(self):
        return f'https://sv.risuai.xyz/resource/{self.img}'

    @field_validator('authorname', mode='before')
    def set_authorname(cls, v):
        if v is None or v == '':
            return 'Anonymous'
        else:
            return v

    @field_validator('download', mode='before')
    @classmethod
    def parse_date(cls, v):
        return convert_str_to_num(v)


class RisuaiUser(BaseModel):
    name: str
    description: str
