from scraper.download import download_file, fetch_json
from scraper.globals import GLOBALS


def get_risuai_def(node_id: str):
    return fetch_json(f'https://realm.risuai.net/api/v1/download/json-v3/{node_id}')


def get_risuai_avatar(img_url: str) -> bytes | None:
    return download_file(img_url, ignore_404=True, timeout=GLOBALS.request_timeout_longer)
