import multiprocessing
import threading
import traceback
from multiprocessing.managers import BaseManager
from queue import Empty

from .log import root_logger
from .proxied_http import handle_request

logger = root_logger.get_child('REQUEST_WORKER')


def worker_process(job_queue, counter, stop_event: threading.Event, worker_id: int):
    # logger.debug(f'Worker #{worker_id} started!')
    while True:
        if stop_event.is_set():
            return

        try:
            job, result_queue = job_queue.get(timeout=1)  # Block for at most 1 second
        except Empty:
            continue
        except multiprocessing.managers.RemoteError:
            logger.error('RequestQueue worker failed to read the queue, meaning it was likely GC-ed. If you are using blocking=False, make sure you store the output of RequestQueue.add()')
            continue

        try:
            result = handle_request(*job)
            if result:
                result_queue.put(result)
        except:
            traceback.print_exc()
            continue

        with counter.get_lock():
            counter.value += 1
    # logger.debug(f'Worker #{worker_id} stopped!')
