import requests


class ProxyHeaderAwareHTTPAdapter(requests.adapters.HTTPAdapter):
    def __init__(self, proxy_headers):
        self.proxy_headers_dict = proxy_headers
        super().__init__()

    def proxy_headers(self, proxy):
        return self.proxy_headers_dict


def request_with_proxy_headers(method, url, proxy, headers=None, proxy_headers=None, post_data=None, **kwargs):
    s = requests.Session()
    s.mount('http://', ProxyHeaderAwareHTTPAdapter(proxy_headers))
    s.mount('https://', ProxyHeaderAwareHTTPAdapter(proxy_headers))

    if method.lower() == 'get':
        return s.get(url, proxies={"http": proxy, "https": proxy}, headers=headers, **kwargs)
    elif method.lower() == 'post':
        return s.post(url, proxies={"http": proxy, "https": proxy}, headers=headers, data=post_data, **kwargs)
    else:
        raise ValueError(f"Invalid method: {method}")

# Usage:
# proxy_headers = ['ProxyHeader1: SomeValue', 'ProxyHeaderN: OtherValue']
# request_with_proxy_headers('get', 'http://example.com', 'http://proxy.that.needs.header:8080/', proxy_headers=proxy_headers)
