from pathlib import Path
from typing import Union


def create_directory(*path: Union[str, Path]) -> Path:
    """
    Create a new directory. Accepts a path such as `'home', 'bob', 'Documents'` or
    a string used to create a `Path()` object.
    :param path:
    :return:
    """
    if isinstance(path, (list, tuple)):
        p = resolve_path(*path)
        p.mkdir(parents=True, exist_ok=True)
    elif isinstance(path, str):
        p = resolve_path(path)
        p.mkdir(parents=True, exist_ok=True)
    elif isinstance(path, Path):
        p = resolve_path(path)
        p.mkdir(parents=True, exist_ok=True)
    else:
        raise TypeError
    return p


def resolve_path(*p: Union[str, Path]):
    """
    Preform `Path().expanduser().resolve().absolute()`.
    If a string is passed, create a new path object as well.
    :param p:
    :return:
    """
    if isinstance(p, str):
        p = Path(p)
    elif isinstance(p, (list, tuple)):
        p = Path(*p)
    return p.expanduser().resolve().absolute()
